#include	<defs.h>

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<stdarg.h>


#include	"telnet.h"
#include	"ksocket.h"
#include	"menu.h"
#include "menufsm.h"
#include	"dialout.h"

#include <incall.h>
#include <cfgmgr.h>

extern int verifying_remu_pwd;
extern int modify_config_visited ;
extern int udb_deinit_flag;
extern int edit_usr;
extern enum UDB_MODIFY udb_deinitialize () ;
extern void terminate_telnet_client (TELNET_CLIENT_CLASS *client_info_ptr);
extern int 	strnicmp (char *c1, char *c2, int size);
extern int toupper (int);


/****************************************************************************
	Routine		: get_free_client_entry
	Input			: Nil					  	
	Synopsis		: Returns the ptr of a free TELNET structure for the new
						connection.
****************************************************************************/

TELNET_CLIENT_CLASS *get_free_client_entry(void)
{
	int i;
	TELNET_CLIENT_CLASS *ptr_clients_info = telnet.clients_info;


	for (i = 0; i < telnet.max_telnet_connections; i++, ptr_clients_info++) 
	{
		if (ptr_clients_info->in_use == FALSE) 
		{
			return (ptr_clients_info);
		}
	}

	return (NULL);
}


/*************************************************************************/
void tel_printf (enum TELNET_PRINTF_GROUPS printf_group,const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format);

	if (telnet.telnet_printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case TELNET_RXTX:
			print_string = telnet.rxtx_printing_enabled;
			break;
		case TELNET_ALARM:
			print_string = telnet.alarm_printing_enabled;
			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format,argptr);
		}

	va_end (argptr);
}


/*************************************************************************/
void enable_or_disable_telnet_printing (enum BOOLEAN enable_or_disable)
{
	telnet.telnet_printing_enabled = enable_or_disable;
}


/*************************************************************************/
void enable_or_disable_telnet_group_printing (enum BOOLEAN enable_or_disable,enum TELNET_PRINTF_GROUPS printf_group)
{
	switch (printf_group)
		{
		case TELNET_RXTX:
			telnet.rxtx_printing_enabled = enable_or_disable;
			break;
		case TELNET_ALARM:
			telnet.alarm_printing_enabled = enable_or_disable;
			break;
		}
}


/****************************************************************************/
void turn_telnet_printing_on (char *cptr_start_of_configuration_string)
{
	enum BOOLEAN printing_enabled;

	printing_enabled = is_parameter_enabled (cptr_start_of_configuration_string);

	enable_or_disable_telnet_printing (printing_enabled);
}


/****************************************************************************/
void turn_telnet_subgroup_printing_on (char *cptr_start_of_configuration_string,ULONG printf_type)
{
	enum BOOLEAN printing_enabled;

	printing_enabled = is_parameter_enabled (cptr_start_of_configuration_string);

	enable_or_disable_telnet_group_printing (printing_enabled,(enum TELNET_PRINTF_GROUPS) printf_type);
}
/****************************************************************************/
void do_telnet_receives()
{
	int	index, in_len;
	ULONG socket_error;
	TELNET_CLIENT_CLASS	*connection_ptr;

	if (!telnet.enabled)		/* Sanjay calls it from foreground */
		return;

	connection_ptr = telnet.clients_info;
	for (index = 0; index < telnet.max_telnet_connections; index++, connection_ptr++) 
	{
      if (connection_ptr->dumbtty)
      {
         cm_keep_alive_configuration_manager(CM_OWNED_BY_DTTY);	
         continue;
      }


		if (connection_ptr->in_use == FALSE || connection_ptr->force_close == TRUE)
			continue;

	   if ((connection_ptr->in_use_by_terminal_server) &&
          (connection_ptr->client_state != CONNECTED_TO_SERVER))
				continue;

/* sudhir new change */		
		if (connection_ptr->connect_to_ourself == TRUE )
         continue ;

/*		if (connection_ptr->menustate == TMS_DIALOUT_MODEM_INIT ||
				connection_ptr->menustate == TMS_DIALOUT_MODEM_HUP)
			continue; */	/* Do no socket send or receive in such states */

/* sudhir 16/6/97 */
      if (connection_ptr->menustate == TMS_DIALOUT_MODEM_HUP)
         continue;

		if (connection_ptr->bytes_in_char_buffer != 0 && connection_ptr->menustate == TMS_DIALOUT_CHAT)
		{
			/* A previous socket read was not able to send the packet out onto
			** the serial side. So do no further socket reads until the old
			** read packet is sent out.
			*/

			if (is_socket_closed (connection_ptr->socket_num) == 0)
			{
				printf ("Serial Transmit buffer full, Telnet socket still in connected state\n") ;
				continue ;
			}
			else
				printf ("Serial Transmit buffer full, Telnet socket closed\n") ;

		}

		/* Read and react to the packet read */
/* sudhir 12/5/97 */
/*      cm_keep_alive_configuration_manager(CM_OWNED_BY_TELNET);	 */

		if ((in_len = recv(connection_ptr->socket_num, telnet.recv_buffer, MAX_TCP_PKT, 0)) <= 0) 
		{
			/* get the error number */
			lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
			if (socket_error != WOULD_BLOCK_ERROR )
			{
				tel_printf (TELNET_ALARM,"TELNET: Socket read error, closing connection\n");

/* sudhir 16/6/97 */
				if (connection_ptr->menustate == TMS_DIALOUT_CHAT || connection_ptr->menustate == TMS_DIALOUT_MODEM_INIT)
				{
					connection_ptr->force_close = TRUE;
					dialout_chat_hdlr(connection_ptr, NULL);
				}
				else
				{
               if ((connection_ptr->in_use_by_terminal_server) &&
                   (connection_ptr->client_state == CONNECTED_TO_SERVER))
               {
                  terminate_telnet_client (connection_ptr) ;
               }
   /* sudhir */
               else
               {
                  if (connection_ptr->modify_config_entered)   
							cm_deinitialize_configuration_manager (CM_OWNED_BY_TELNET);

						connection_ptr->modify_config_entered = 0;
						modify_config_visited = 0;
						verifying_remu_pwd = 0;

					   if (udb_deinit_flag)
					   {
						   udb_deinitialize();
						   udb_deinit_flag = 0;
					   }
					   edit_usr = 0;
	   				close_connection(connection_ptr);
               }
			   }
		   }
	   } 
	   else 
	   {
	      cm_keep_alive_configuration_manager(CM_OWNED_BY_TELNET);	 
		   tel_printf(TELNET_RXTX,"TELNET: Received a packet from a client.\n");
		   socket_in(connection_ptr, telnet.recv_buffer, in_len);

   /* sudhir 19/2/97 */
         if (connection_ptr->in_use_by_terminal_server == TRUE)
            telnet.term_server_port[connection_ptr->port_used_by_client].number_of_lan_pkts_rcvd++;
	   }
   }
}

void initialize_replystr()
{
	USHORT i=0;

	for ( i=0; i< 20; i++)
		ReplyStrs[i].ReplyStr[0] = 0;

	return;
}


enum BOOLEAN is_term_server_enabled (USHORT port_number)
{
   if (telnet.terminal_server_enabled &&telnet.term_server_port[port_number].termser_enabled)
      return TRUE;
   else
      return FALSE;
}


enum BOOLEAN is_dtty_enabled ()
{
   if (telnet.dumb_tty_enabled)
      return TRUE;
   else
      return FALSE;
}
   
#if 0
/* sudhir 31/3/97 */
void delete_string_from_linked_list(BYTE *str_to_delete, PARA_STR *start_addr)
{
	PARA_STR *ptr_to_config, *ptr_to_next;

	ptr_to_config = start_addr;

	while ((ptr_to_config->parameter[0] != '[') && (ptr_to_config != NULL))
	{
		if (strstr (ptr_to_config->parameter, str_to_delete) != NULL)
		{
			printf ("deleted one string of %s\n", ptr_to_config->parameter); 
			ptr_to_next = ptr_to_config->next;
			ptr_to_config->previous->next = ptr_to_config->next;
			ptr_to_config->next->previous = ptr_to_config->previous;
			free (ptr_to_config);
			ptr_to_config = ptr_to_next;
/*			return ; */
		}
		else
			ptr_to_config = ptr_to_config->next;
	 	if (ptr_to_config == NULL)
			break;
	}
	printf ("String was not found for deletion \n"); 
	return;
}

void modify_string_in_linked_list(BYTE *str_to_modify, ULONG OldPortNo, ULONG NewPortNo, PARA_STR *start_addr)
{
	PARA_STR *ptr_to_config;
	char StoreTempValue[100], *ch, *ch1, RemPart[25];
	int length;

	ptr_to_config = start_addr;

	sprintf (StoreTempValue, "%s %02d", str_to_modify, OldPortNo);
	length = strlen (StoreTempValue);
	while ((ptr_to_config->parameter[0] != '[') && (ptr_to_config != NULL))
	{
		if (!strnicmp (ptr_to_config->parameter, StoreTempValue, length))
		{
/*			printf ("found a string to change\n"); */
			ch = strchr (&ptr_to_config->parameter[0], '=');
			if (ch != NULL)
			{
				ch1 = strchr (ch, ',');
				strcpy (RemPart, ch1);
				*ch = '\0';
				strcpy (StoreTempValue, ptr_to_config->parameter);
				sprintf (ptr_to_config->parameter, "%s= %02d%s",
								StoreTempValue, NewPortNo, RemPart);
			}
			printf ("string %s mod to %s\n", StoreTempValue, ptr_to_config->parameter); 
			return ; 
		}
		else
			ptr_to_config = ptr_to_config->next;
	}
	printf ("%s String was not found for modification \n", StoreTempValue); 
	return;
}

void force_write_string_with_port_num (BYTE *ptr_to_string, ULONG port_no,
														BYTE *new_rhs, PARA_STR *start_addr)
{
	PARA_STR *ptr_to_first_string, *ptr_to_insert;
	BYTE temp[5] ;

	ptr_to_first_string = start_addr;;

/*	printf ("ptr_to_string %s\n",ptr_to_string); 
	printf ("section_name %s\n", section_name);   
	printf ("port number %d\n",port_no);
	printf ("new_rhs %s\n",new_rhs); */
	while ((ptr_to_first_string->parameter[0] != '[') &&
			 (ptr_to_first_string->next != NULL))
		ptr_to_first_string = ptr_to_first_string->next;
	if (ptr_to_first_string->next != NULL)
		ptr_to_first_string = ptr_to_first_string->previous;

	ptr_to_insert = (PARA_STR *) malloc (sizeof (ULONG) * 2 + 200) ;
	if (ptr_to_insert == NULL)
	{
		printf("Not Enough memory\n");
		return ;
	}
/*	printf ("Allocated memory\n");  */

	ptr_to_first_string->next->previous = ptr_to_insert;
	ptr_to_insert->next = ptr_to_first_string->next;
	ptr_to_insert->previous = ptr_to_first_string;
	ptr_to_first_string->next = ptr_to_insert;

	strcpy (ptr_to_insert->parameter, ptr_to_string);
	strcat (ptr_to_insert->parameter, " = ");
	if (port_no <= 16)
		sprintf (temp, "%02lu,", port_no - 1);
	else
		sprintf (temp, "%04lu,", port_no - 1);

	if (port_no != NOT_PORT_PARAMETER)
		strcat (ptr_to_insert->parameter, temp);
	strcat (ptr_to_insert->parameter, new_rhs);
	strcat (ptr_to_insert->parameter, "\n");
	printf ("inserted string is %s\n",ptr_to_insert->parameter);
	return;
}

BYTE *get_rhs_from_linked_list(BYTE *lhs_para_str, ULONG PortNo, PARA_STR *starting_addr)
{
	PARA_STR *ptr_to_config;
	BYTE temp_bfr[100], PortNoinchar[10], *ch;

	ptr_to_config = starting_addr;
	strcpy (temp_bfr, lhs_para_str);
	if (PortNo != NOT_PORT_PARAMETER)
	{
		if (PortNo >= 16)
			sprintf (PortNoinchar, " %04d,", PortNo - 1);
		else
			sprintf (PortNoinchar, " %02d,", PortNo - 1);
		strcat (temp_bfr, PortNoinchar);
	}
	else
		strcat (temp_bfr, " ");

	while ((ptr_to_config->parameter[0] != '[') && (ptr_to_config != NULL ))
	{
		if (strstr (&ptr_to_config->parameter[0], &temp_bfr[0]) != NULL)
		{
			ch = &ptr_to_config->parameter[0] + strlen (temp_bfr);
			strcpy (Buffer, ch);
			Buffer[strlen(Buffer) - 1] = '\0';
			ch = Buffer;
			printf ("got one string of %s with rhs %s\n", temp_bfr, ch); 
			return (ch);
		}
		else
			ptr_to_config = ptr_to_config->next;
	} 
	printf ("could not get string of %s ", temp_bfr); 
	return NULL;
}

BYTE *get_rhs_for_disp (ULONG offset, CONFIGURATION_TABLE configuration_table, ULONG PortNo, PARA_STR *starting_addr)
{
	ULONG i = 0;
	PARA_STR *ptr_to_config;
	BYTE temp_bfr[100], PortNoinchar[10], *ch;
	BYTE lhs_para_str[255];

	while (1)
	{
		if (configuration_table.function[i].cptr_parameter_string == NULL)
		{
			printf ("end of ll given offset %8x is not found\n", offset);
			return (NULL);
		}
		if (configuration_table.function[i].parameter_1 ==	offset)
		{
			strcpy (lhs_para_str, configuration_table.function[i].cptr_parameter_string);
			break;
		}
		i++;
	}

	ptr_to_config = starting_addr;
	strcpy (temp_bfr, lhs_para_str);
	if (PortNo != NOT_PORT_PARAMETER)
	{
		if (PortNo >= 16)
			sprintf (PortNoinchar, " %04d,", PortNo - 1);
		else
			sprintf (PortNoinchar, " %02d,", PortNo - 1); 
		strcat (temp_bfr, PortNoinchar);
	}
	else
		strcat (temp_bfr, " ");

/*	printf ("value of temp_bfr is %s\n", temp_bfr); */

	while ((ptr_to_config != NULL) && (ptr_to_config->parameter[0] != '['))
	{
		if (!strnicmp (&ptr_to_config->parameter[0], temp_bfr, strlen(temp_bfr)))
		{
			ch = &ptr_to_config->parameter[0] + strlen (temp_bfr);
			strcpy (Buffer, ch);
			Buffer[strlen(Buffer) - 1] = '\0';
			ch = Buffer;
			printf ("got one string of %s with rhs %s\n", temp_bfr, ch);
			return (ch);
		}
		else
			ptr_to_config = ptr_to_config->next;
	}
	printf ("lhs string was not found in linked list\n");
	return NULL;
}

void set_rhs_in_link_list (ULONG offset, CONFIGURATION_TABLE configuration_table,
										ULONG PortNo, PARA_STR *starting_addr, BYTE *new_rhs)
{
	ULONG i = 0;
	PARA_STR *ptr_to_config;
	BYTE temp_bfr[100], PortNoinchar[10], *ch;
	BYTE *lhs_para_str;


   lhs_para_str = malloc (255);
   if (lhs_para_str == NULL)
   {
      printf ("Not enough memory\n");
      return;
   }
	
/*	printf ("The offset is %8x\n", offset);  */
	while (1)
	{
		if (configuration_table.function[i].cptr_parameter_string == NULL)
		{
			printf ("end of linked list given parameter is not found" );
         free (lhs_para_str);
			return;
		}
		if (configuration_table.function[i].parameter_1 ==	offset)
		{
			strcpy (lhs_para_str, configuration_table.function[i].cptr_parameter_string);
			break;
		}
		i++;
	}

	ptr_to_config = starting_addr;
	strcpy (temp_bfr, lhs_para_str);
	if (PortNo != NOT_PORT_PARAMETER)
	{
		if (PortNo >= 16)
			sprintf (PortNoinchar, " %04d,", PortNo - 1);
		else
			sprintf (PortNoinchar, " %02d,", PortNo - 1);
/*		sprintf (PortNoinchar, " %02d,", PortNo);  */
		strcat (temp_bfr, PortNoinchar);
	}
   else
      strcat (temp_bfr, " ");

/*	printf ("value of temp_bfr is %s\n", temp_bfr); */

	while ((ptr_to_config != NULL) && (ptr_to_config->parameter[0] != '['))
	{
		if (!strnicmp (&ptr_to_config->parameter[0], temp_bfr, strlen(temp_bfr)))
		{
			ch = &ptr_to_config->parameter[0] + strlen (temp_bfr);
			strcpy (ch, new_rhs);
			strcat (ch, "\n");
			printf ("set string %s with rhs %s\n", &ptr_to_config->parameter[0], ch);
         free (lhs_para_str);
			return ;
		}
		else
			ptr_to_config = ptr_to_config->next;
	}
	printf ("lhs string for modifying was not found in linked list\n");
   free (lhs_para_str);
	return;
}

PARA_STR *search_for_string (BYTE *lhs_para_str, BYTE *rhs_string, PARA_STR *start_addr)
{
	PARA_STR *ptr_to_config;
	int length;

	ptr_to_config = start_addr;

	length = strlen (lhs_para_str);
	while (ptr_to_config != NULL)
	{
		if (ptr_to_config->parameter[0] == '[')
			return NULL; 
		if (!strnicmp (&ptr_to_config->parameter[0], lhs_para_str, length))
		{
			strcpy (rhs_string, &ptr_to_config->parameter[0] + length + 3);
/*			printf ("got %s with ret %s\n", ptr_to_config->parameter, rhs_string); */
			ptr_to_config = ptr_to_config->next;
			return (ptr_to_config);
		}
		else
			ptr_to_config = ptr_to_config->next;
	}
	printf ("%s string is not found\n", lhs_para_str); 
	return NULL;
}

ULONG check_if_mapped (int Flag, int DLCI_value_to_check)
{
	PARA_STR *store_address_temp1, *store_address_temp2;
	BYTE store_value[20], string_to_search[75], *ch, conv_DLCI_value[10];
	int j;

	switch (Flag)
	{
		case 1: sprintf (string_to_search, FR_VP_DLCI, "IP");
					break;
		case 2: sprintf (string_to_search, FR_VP_DLCI, "IPX");
					break;
		case 3: sprintf (string_to_search, FR_VP_DLCI, "STP");
					break;
	}

	store_address_temp1 = Pointers_SectHdr.ptrs[6];
	sprintf (conv_DLCI_value, "%04lu", DLCI_value_to_check);

	for (j = 0; j < Total_No_of_DLCIs; j++)
	{
		store_address_temp2 = search_for_string (string_to_search,
										&store_value[0], store_address_temp1);
		if (store_address_temp2 == NULL)
			return (NOT_PORT_PARAMETER);

/*		printf ("value obtained is %s\n", store_value); */
		ch = strchr (&store_value[0], ','); 
		if (ch != NULL)
		{
/*			printf ("Port number is %s, dlci %d\n", store_value, DLCI_value_to_check);
			printf ("comparing string %s with %s\n", ch, conv_DLCI_value); */
			if (!strnicmp(ch + 1, conv_DLCI_value, 4))
			{
				*ch = '\0';
				printf ("DLCI %s mapped to port %s", conv_DLCI_value, store_value);
				return (atoi (store_value));
			}
		}
		store_address_temp1 = store_address_temp2;
	}
/*	printf ("Dlci %d not mapped to %d flag port\n", DLCI_value_to_check, Flag); */
	return (NOT_PORT_PARAMETER);
}

int strnicmp (char *c1, char *c2, int size)
{
	int i;
/*	ULONG Idle;
	printf ("string1 is %s\n", c1);
	printf ("string2 is %s\n", c2);
	printf ("size is %d\n", size);  
	for (Idle = 0; Idle < 0xFFFF; Idle ++); */

	for (i = 0; i < size; i++)
		if (toupper( (int) *c1) != toupper ( (int) *c2))
			return 1;
		else
		{
			c1 ++;
			c2 ++;
		}
	return 0;
}

BYTE *copy_to_temp_struct(BYTE *buffer, BYTE *char_array)
{
	strcpy (buffer, char_array);
	return (buffer);
}
#endif



   


      
      

         

