#include	<defs.h>
#include	<stdio.h>

#include	"telnet.h"

/* Response for unsupported options */

/****************************************************************************
	Routine		: do_notsup
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option received.					  	
	Synopsis		: Responds with a DONT for unsupported WILL option request.
****************************************************************************/

USHORT	do_notsup(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	telnet.tx_buffer[i++] = TCIAC;
	telnet.tx_buffer[i++] = TCDONT;
	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));
}


/****************************************************************************
	Routine		: will_notsup
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option received.					  	
	Synopsis		: Responds with a WONT for unsupported DO option requests.
****************************************************************************/

USHORT	will_notsup(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	telnet.tx_buffer[i++] = TCIAC;
	telnet.tx_buffer[i++] = TCWONT;
	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));
}


