#include	<defs.h>
#include	<string.h>
#include	<stdio.h>

#include <kstart.h>

#include	"telnet.h"
#include	"vmenu.h"

#if 0
#include "..\..\include\udb.h"
#include	"..\..\lsl\klsl.h"
#include	"..\..\lsl\vbufstr.h"
#include	"..\..\lsl\vlslstr.h"
#include	"..\..\lsl\vlsl.h"
#include "..\..\store\boot.h"
#endif


#include <incall.h>
#include <cfgmgr.h>

/****************************************************************************
	Routine		: verify_password
	Input			: Index to TELNET structure corresponding to this connection.
	Synopsis		: Asks the user for a login name and then the Password.
						If the password matches, user is allowed to proceed. 
****************************************************************************/
const BYTE	PasswordStr[] = "\n\rEnter Password : ";
const BYTE	RetryPwd[] = "\n\r\n\rInvalid Password. \n\r";
const BYTE	CloseCnx[] = "\n\rClosing Connection.\n\r";
extern void encrypt (char *src, char *dest) ;
extern BYTE *to_upper_string (BYTE*);
extern BYTE Insufficient_memory[];

extern int udb_init_flag;
extern int udb_deinit_flag;
extern int call_from_main;

USHORT	verify_password(TELNET_CLIENT_CLASS *client_info_ptr)
{
	char encrypted_password[TELNET_NAME_SIZE] ;

	encrypt ((to_upper_string(client_info_ptr->recv_buffer)), encrypted_password) ;
	if (strcmp(encrypted_password, telnet.password)) {
		if (++client_info_ptr->pwd_attempts > MAX_PASSWORD_TRIES) 
		{
			if (client_info_ptr->dumbtty == 1)
			{
				send_telnet_packet(client_info_ptr, CloseCnx, strlen(CloseCnx), 0);
				close_dumbtty_connection (client_info_ptr);
				return  0;
			}
			else
			{
				send_telnet_packet(client_info_ptr, CloseCnx, strlen(CloseCnx), 0);
	         cm_deinitialize_configuration_manager (CM_OWNED_BY_TELNET);
				close_connection(client_info_ptr);
				return 0;
			}
		} 
		else 
		{
			send_telnet_packet(client_info_ptr, RetryPwd, strlen(RetryPwd), 0);
			return (send_telnet_packet(client_info_ptr, PasswordStr, strlen(PasswordStr), 0));
		}
	} 
	else 
	{
		if (client_info_ptr->menustate == TMS_REMOTE_UDB)
		{
			udb_deinit_flag = 1;
			udb_init_flag = 1;
			call_from_main = 1;
			if (udb_initialize() == INIT_NO_MEMORY)
			{
		 		strcpy (telnet.tx_buffer, Insufficient_memory);
				send_telnet_packet(client_info_ptr, telnet.tx_buffer, strlen(telnet.tx_buffer), 0);
			}
		}
/*		return (welcome_to_telnet(client_info_ptr)); */

      client_info_ptr->verifying_pwd = FALSE;
      return (menu_state_machine(client_info_ptr, NULL));

	}
}
	

USHORT 	welcome_to_telnet(TELNET_CLIENT_CLASS *client_info_ptr)
{
	HeaderType		*CodeHeader = (HeaderType *)FL_CODE_HDR;

	client_info_ptr->verifying_pwd = FALSE;
	sprintf(telnet.tx_buffer, CopyrightMsg, CodeHeader->Version); 
	send_telnet_packet(client_info_ptr, telnet.tx_buffer, strlen(telnet.tx_buffer), 0);
	return (menu_state_machine(client_info_ptr, NULL));
}

