#include <defs.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>   

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>


#include	"telnet.h"
#include	"vmenu.h"


#include <incall.h>
#include <cfgmgr.h>


BYTE Prostatgeninfo[] =
"\n\r\
\n\r\
              << Proxy server statistics>>\n\r\
\n\r\
[1] Number of calls          : %lu\n\r\
[2] Uptime                   : %s\n\r\
[3] Packets Received         : %s\n\r\
[4] Packets Sent             : %s\n\r\
[5] Bytes Sent               : %s\n\r\
[6] Bytes Received           : %s\n\r\
[7] Port Information\n\r\
\n\r\
Enter your choice (7, exit , R: Refresh, Esc to previous menu) : ";


BYTE ProPortstatus[] =
"\n\r\
\n\r\
                 << Proxy Statistics for port %d>>\n\r\
\n\r\
[ 1] User Name                : %s\n\r\
[ 2] Modem Type               : %s\n\r\
[ 3] Modem Connect            : %s\n\r\
[ 4] Local IP address         : %s\n\r\
[ 5] Remote IP address        : %s\n\r\
[ 6] Subnet Mask              : %s\n\r\
[ 7] Uptime                   : %s\n\r\
[ 8] Packets Sent             : %s\n\r\
[ 9] Packets Received         : %s\n\r\
[10] Bytes Sent               : %s\n\r\
[11] Bytes Received           : %s\n\r\
[12] Total Uptime             : %s\n\r\
[13] Total Packets received   : %s\n\r\
[14] Total Packets sent       : %s\n\r\
[15] Total Bytes sent         : %s\n\r\
[16] Total Bytes received     : %s\n\r\
\n\r\
Enter choice (R: Refresh, exit, Esc to previous menu) : ";

BYTE Proxyportstat[] =
"[%d] Port%d  %-25s                     %lu\n\r\
";




#if 0
BYTE *get_port_status_from_id (USHORT index)
{
	switch (index)
	{
		case  IDLE:
			return ("Idle");

	   case OFFLINE:
			return ("Offline");

	   case WAN_LINK_UP:
			return ("WAN Link Up");

		case LCP_UP:
			return ("LCP up");

	   case PPP_CLIENT_UP:
			return ("PPP Client Up");

		case MLPPP_CLIENT_UP:
			return ("MLPPP client up");

	   case SEND_INIT_COMMAND:
			return ("Send modem init command");
		
	   case WAIT_FOR_OK:
			return ("Wait for ok");
		
	   case DIAL_NUMBER:
			return ("Dial number");

	   case WAIT_FOR_CONNECT:
			return ("Wait for connect");

	   case SLIP_CLIENT_UP:
			return ("SLIP client up");

		case DISABLED:
			return ("Disabled");

		default:
			return ("Unknown");
	}
}
#endif

char* convert_uptime_to_seconds (ULONG seconds, char* time_str)
{
	int	days, hours, minutes;

	days = seconds / 86400;
	seconds %= 86400;

	hours = seconds / 3600;
	seconds %= 3600;

	minutes = seconds / 60;
	seconds %= 60;

	sprintf(time_str, "%03d:%02d:%02d:%02d\0", days, hours, minutes, seconds);

	return time_str;
}

extern BYTE *get_port_status_from_id (USHORT index);


BYTE *display_port_status_and_option (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE temp_buffer[500];
	USHORT port_status=0, port_number=0;
	
	client_info_ptr->stati_update_timeout = 1200;

	if (!buffer)
	{
		strcpy (telnet.tx_buffer, "\n\r\n\r\t<< Proxy Port Information>>\n\r\n\r");
		strcat (telnet.tx_buffer, "\t   status                                       BaudRate\n\r");
		strcat (telnet.tx_buffer, "\t   ------                                       --------\n\r");

/*		for (port_number=0; port_number <  NUMBER_OF_WAN_PORTS; port_number++) */
		for (port_number=0; port_number <  (telnet.number_of_ports-1); port_number++) 
		{
			port_status = get_port_status (port_number) ;

			sprintf (temp_buffer, Proxyportstat,
				port_number+1,
				port_number+1,
				get_port_status_from_id (port_status),
				get_baud_rate (port_number));					

			strcat (telnet.tx_buffer, temp_buffer);
		}
		sprintf(temp_buffer,"\n\rEnter Your choice (1 to %d, exit, R: Refresh Esc to previous menu): ",
			(telnet.number_of_ports-1));
		strcat (telnet.tx_buffer, temp_buffer);

		return telnet.tx_buffer;
	}

	client_info_ptr->menu_selected_port = atoi (buffer);

	if (client_info_ptr->menu_selected_port >= 1 &&
		client_info_ptr->menu_selected_port <= (telnet.number_of_ports-1))
	{
		client_info_ptr->menustate = TMS_PROXY_PORT_STAT_INFO; 
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else if ((*buffer == 'R' || *buffer == 'r') && strlen(buffer) == 1)
	{
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}


BYTE *send_proxy_server_general_statistics (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG total_calls=0, total_time=0, total_pkts_rxed=0, total_pkts_sent=0, total_bytes_sent=0, total_bytes_rxed=0;
	USHORT option=0, port_number=0;
	
	client_info_ptr->stati_update_timeout = 1200;

	if (!buffer)
	{
		
/*		for (port_number=0; port_number < NUMBER_OF_WAN_PORTS; port_number++) */
		for (port_number=0; port_number < (telnet.number_of_ports-1); port_number++)
		{
			total_calls +=	get_number_of_calls (port_number);
			total_time += get_aggregate_connection_time(port_number);
			total_pkts_rxed += get_aggregate_rx_packet_count(port_number);
			total_pkts_sent += get_aggregate_tx_packet_count(port_number);
			total_bytes_sent += get_aggregate_tx_count(port_number);
			total_bytes_rxed += get_aggregate_rx_count(port_number);
		}

		sprintf (telnet.tx_buffer, Prostatgeninfo,
			total_calls, 
			convert_uptime_to_seconds (total_time, &ReplyStrs[0].ReplyStr[0]), 
			MakePunctNumStr( &ReplyStrs[1].ReplyStr[0],total_pkts_rxed), 
			MakePunctNumStr( &ReplyStrs[2].ReplyStr[0],total_pkts_sent),
			MakePunctNumStr( &ReplyStrs[3].ReplyStr[0],total_bytes_rxed),
			MakePunctNumStr( &ReplyStrs[4].ReplyStr[0],total_bytes_sent));
		
		return (telnet.tx_buffer);
	}

	option = atoi (buffer);

	if (option == 7)
	{
		client_info_ptr->menustate = TMS_DISPLAY_PORT_STATUS;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else if ((*buffer == 'R' || *buffer == 'r') && strlen(buffer) == 1)
	{
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}




BYTE *send_proxy_server_port_statstics (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT port_number=client_info_ptr->menu_selected_port-1;
	BYTE ppp_user_name[60], modem_init_string[50],modem_connect_message[50];
	ULONG proxy_port_subnetmask, proxy_local_ip, proxy_remote_ip, up_time, total_up_time; 


	client_info_ptr->stati_update_timeout = 1200;
	
	if (!buffer)
	{
		get_ppp_user_name (port_number, ppp_user_name, 60);
		get_modem_name (port_number, modem_init_string, 40);
		process_back_slash (modem_init_string);
		get_modem_connect_message (port_number, modem_connect_message, 40);
		proxy_port_subnetmask = proxy_get_subnet_mask (port_number);
		proxy_local_ip = proxy_get_local_ip_address (port_number);		
		proxy_remote_ip = proxy_get_remote_ip_address (port_number);
		up_time = get_connection_up_time (port_number);
		total_up_time = get_aggregate_connection_time (port_number);

		sprintf (telnet.tx_buffer, ProPortstatus,
			client_info_ptr->menu_selected_port, ppp_user_name, 
			modem_init_string, modem_connect_message,
			convert_ip_address_to_dot_format (&ReplyStrs[0].ReplyStr[0], proxy_local_ip),
			convert_ip_address_to_dot_format (&ReplyStrs[1].ReplyStr[0], proxy_remote_ip),
			convert_ip_address_to_dot_format (&ReplyStrs[2].ReplyStr[0], proxy_port_subnetmask),
			convert_uptime_to_seconds (up_time, &ReplyStrs[3].ReplyStr[0]),
			MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], get_connection_tx_packet_count (port_number)),
			MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], get_connection_rx_packet_count (port_number)),
			MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], get_connection_tx_count (port_number)),	
			MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], get_connection_rx_count (port_number)),
			convert_uptime_to_seconds (total_up_time, &ReplyStrs[8].ReplyStr[0]),
			MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], get_aggregate_rx_packet_count (port_number)), 
			MakePunctNumStr( &ReplyStrs[10].ReplyStr[0], get_aggregate_tx_packet_count (port_number)),
			MakePunctNumStr( &ReplyStrs[11].ReplyStr[0], get_aggregate_tx_count (port_number)), 
			MakePunctNumStr( &ReplyStrs[12].ReplyStr[0], get_aggregate_tx_count (port_number)));

		return telnet.tx_buffer;
	}

	if ((*buffer == 'R' || *buffer == 'r') && strlen(buffer) == 1)
	{
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}




			
