#include	<defs.h>
#include	"telnet.h"

/****************************************************************************
	Routine		: will_echo
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option.
	Synopsis		: Generates Response for ECHO option. 
****************************************************************************/

USHORT	will_echo(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	if (client_info_ptr->echoing) {
		if (client_info_ptr->option_cmd == TCDO)
			return 1;
	} else
		if (client_info_ptr->option_cmd == TCDONT)
			return 1;

/* 13/2/96 */
	client_info_ptr->was_echoing = client_info_ptr->echoing;
/* 13/2/96 */

	client_info_ptr->echoing = !client_info_ptr->echoing;

	telnet.tx_buffer[i++] = TCIAC;

	if (client_info_ptr->echoing)
		telnet.tx_buffer[i++] = TCWILL;
	else
		telnet.tx_buffer[i++] = TCWONT;

	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));
}
	

/****************************************************************************
	Routine		: will_temp_echo
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option.
	Synopsis		: Server generates request to ECHO. This is useful while 
						checking Passwords etc, so that local echo at the client
						can be turned off.
****************************************************************************/

void	will_temp_echo(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	if (client_info_ptr->echoing)
	{
/* 13/2/96 */
		client_info_ptr->was_echoing = TRUE;
/* 13/2/96 */
		return;
	}

/* 13/2/96 */
	client_info_ptr->was_echoing = FALSE;
/* 13/2/96 */

	client_info_ptr->echoing = TRUE;
	telnet.tx_buffer[i++] = TCIAC;
	telnet.tx_buffer[i++] = TCWILL;
	telnet.tx_buffer[i++] = character;
	send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0);
}

USHORT	do_echo(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	if (client_info_ptr->echoing)
	{
		if (client_info_ptr->option_cmd == TCWILL)
			return 1;
	}
	
	client_info_ptr->echoing = TRUE;
	telnet.tx_buffer[i++] = TCIAC;
	telnet.tx_buffer[i++] = TCDO;
	telnet.tx_buffer[i++] = character;

	send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0);
	return 1;
}
