#include <stdlib.h>
#include <stdio.h>
#include "tftp.h"
#include "..\..\store\boot.h"
#ifdef RAS
#include <flashmgr.h>
#endif

#if 0
	extern void print_header_info() ;
#endif


enum TEST initialize_tftp (ULONG clock_ticks_per_second)
{
	int i, j, file_length ;
	ULONG tftp_retransmission_timer ;

	tftp.timer_class.clock_ticks_per_second = clock_ticks_per_second ;

	tftp_connection_abort_time = 0 ;
	tftp_retransmission_timer = tftp.timeout_period * clock_ticks_per_second ;
	for (i = 0 ; i < tftp.number_of_retransmissions ; i++)
	{
		tftp_connection_abort_time += tftp_retransmission_timer ;
		tftp_retransmission_timer *= 2 ;
	}
	tftp_connection_abort_time *= MULTIPLE ;

	if (tftp.enabled == FALSE)
	{
		return (PASS) ;
	}

	if (register_tftp() == FAIL)
	{
		return (FAIL) ;
	}
	else
	{
		tftp.timer_class.timer_enabled = TRUE ;

#ifdef __LSL__
		lsl_control (REGISTER_LSL_TRAP_FUNCTION,
		             (void (*) (USHORT real_port_number, enum DEVICE_CONTROL_OPERATION control_command)) tftp_lsl_trap_function) ;
#endif

		if (tftp.socket_interface_initialized == FALSE)
		{
			initialize_tftp_socket_interface() ;
		}

		/* Now initialize the file_info_list[], etc */

		file_info_list[0].file_address = (BYTE *) FL_CFG_HDR ;
		file_info_list[1].file_address = (BYTE *) FL_CODE_HDR ;

		file_info_list[0].write_lock = LOCK_STATUS_OFF ;
		file_info_list[1].write_lock = LOCK_STATUS_OFF ;

      file_info_list[2].file_address = malloc (MAX_FILES * 20) ;
      if (file_info_list[2].file_address != NULL)
      {
         i = 0 ;
         file_length = 0 ;
         while (file_info_list[i].file_address != NULL)
         {
            j = 0 ;
            while (file_info_list[i].file_name[j])
            {
               file_info_list[2].file_address[file_length++] = file_info_list[i].file_name[j] ;
               j++ ;
            }
            file_info_list[2].file_address[file_length++] = '\r' ;
            file_info_list[2].file_address[file_length++] = '\n' ;
            i++ ;
         }
         file_info_list[2].file_length = file_length ;
      }

/* sudhir 16-12-96  Removed calculate_crc_table from here */
#if 0
		/* Now this is being called from rtrware.c */
		calculate_crc_table () ;
		init_flash_write_scheduler () ;
#endif

#if 0
		print_header_info() ;
#endif

		print_tftp_init_info () ;
		return (PASS) ;
	}
}



enum TEST deinitialize_tftp(void)
{
	/* add code to release all the buffers, close socket, etc. */

	return PASS ;
}



enum TEST register_tftp (void)
{
#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "TFTP", TFTP_APPLICATION, tftp_timer, tftp_control, &tftp.application_id) == FAIL)
	{
		return (FAIL) ;
	}

	return (PASS) ;
#else
	return (FAIL) ;
#endif
}



enum TEST tftp_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	PARAMETER_NOT_USED (parameter_0) ;
	PARAMETER_NOT_USED (parameter_1) ;

	switch (command)
	{
		case START_APPLICATION :

			break ;

		case TERMINATE_APPLICATION :

			deinitialize_tftp() ;

		case READ_DATA_FROM_SOCKET :

			break ;

		case IS_APPLICATION_ENABLED :

			*((enum BOOLEAN *) parameter_1) = tftp.enabled ;
			break ;
	}
	return (PASS) ;
}

enum BOOLEAN is_tftp_enabled ()
{
	return (tftp.enabled) ;
}
