/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\datatran.h"
#include "apputil.h"

void   GenericSimpleFreeState( OperationStatus_t *operation_status)
{
free(operation_status->handle) ; 
}



void DoFreeParameter(void *parameter, DataTransferStatus_t *data_transfer)
{
free(parameter) ; 

data_transfer->nof_buffers = 0 ;

}



DataTransferStatus_t *get_initialized_data_transfer()
{
DataTransferStatus_t *data_transfer ; 

data_transfer = malloc(sizeof(DataTransferStatus_t) ) ; 

InitDataTransferStatus(data_transfer) ; 

return data_transfer ; 
}


void deallocate_data_transfer(DataTransferStatus_t *data_transfer)
{
free(data_transfer); 
}



void SetUnchanged(Request_t *request)
{
  request->header_info.status = NOT_CHANGED ; 
  request->response_entity_function = NULL ; 
  request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
}


void SetNeverChangingEntity(Request_t *request,
			   int *end_of_request_processing)
{

if (!test_if_date_is_null(&request->params.if_modified_since) )
  {
    copy_date_struct(&request->params.if_modified_since, 
		 &request->header_info.last_modified);
    SetUnchanged(request) ; 
    *end_of_request_processing = TRUE ; 
  }
else
  {
    get_current_date(&request->header_info.last_modified ) ;  
    *end_of_request_processing = FALSE ; 
  }
    
}



void SetEntityDate(Request_t *request, 
		   HttpDate_t *local_date_last_modified,
		   int *end_of_request_processing)
/*** note: this is the local time, not GMT ****/
{
HttpDate_t gmt_last_modified ; 

copy_date_struct(local_date_last_modified, 
		 &request->header_info.last_modified);



if (!test_if_date_is_null(&request->params.if_modified_since) )
  {
    
    convert_timedate_to_GMT_timedate(local_date_last_modified, 
				     &gmt_last_modified ) ; 
    
    

    if (compare_dates(&request->params.if_modified_since,
		      &gmt_last_modified ) )
      {
	SetUnchanged(request) ; 
	*end_of_request_processing = TRUE ; 
	return ; 
      }

  }
*end_of_request_processing = FALSE ; 
}



void SetClientPull(Request_t *request, 
		   int nof_seconds, 
		   char *new_url) /*** NULL is the same URL is to be loaded**/
{
request->header_info.refresh =  nof_seconds;
if (new_url != NULL )
  {
    strncpy(request->header_info.refresh_url, new_url, MAX_REFRESH_URL);
  }


}



void get_unparsed_parts_of_uri(char *string, int string_size, 
			       Request_t *request)
{
int bytes_to_copy ; 

bytes_to_copy =request->params.uri_length - request->params.pos_uri_processing;

if (bytes_to_copy > string_size -1 )
  {
    bytes_to_copy =  string_size -1;
  }

memcpy(string , request->params.uri + request->params.pos_uri_processing , 
       (size_t)bytes_to_copy ); 

string[bytes_to_copy ]=0;

}


