/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\datatran.h"
#include "..\..\sysdep\src\tcprw.h" 


typedef struct {
  char *buffer; 
  int buffer_size ; 
  Socket_t socket; 
  int should_read_first_time_info ; 
  char *first_time_info ; 
  int first_time_info_length ; 
} ContinuousSocketInputState_t ; 

void ContinuousSocketInput(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
ContinuousSocketInputState_t *input_state ; 

int nof_bytes_read ; 

int client_closed_socket ; 
int error;

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

input_state = (ContinuousSocketInputState_t *) operation_status->handle ; 

transfer_status->nof_buffers = 0  ; 


if (input_state->should_read_first_time_info )
  {
    input_state->should_read_first_time_info = FALSE ; 

    AddBuffer( transfer_status,  input_state->first_time_info , 
               input_state->first_time_info_length ) ; 
  }


#ifndef BLOCKING_IO_ONLY

read_available_data_from_socket(input_state->socket , 
       input_state->buffer , input_state->buffer_size , 
       &nof_bytes_read, &client_closed_socket, &error) ; 
#else

read_data_from_socket_until_delimiter(input_state->socket , 
       input_state->buffer , 
       input_state->buffer_size , 
       &nof_bytes_read, &client_closed_socket, &error, '\n' ) ; 
/**** used in multipart mime encoding *****/

#endif

if ( (error != 0 ) || client_closed_socket )
  {
    transfer_status->end_of_processing = TRUE  ; 
    transfer_status->socket_should_be_closed = TRUE ; 
    operation_status->status = END_OPERATION ; 
    return ; 
  }


#if 0 
if (nof_bytes_read == 0  )
  {
    operation_status->status = IN_OPERATION ; 
    return ; 
  }
#endif


AddBuffer( transfer_status,  input_state->buffer , nof_bytes_read ) ; 
operation_status->status = END_OPERATION ; 
}



void  FreeContinuousSocketInput( OperationStatus_t *operation_status)
{
ContinuousSocketInputState_t *input_state ; 

input_state = (ContinuousSocketInputState_t *) operation_status->handle ; 

free(input_state->buffer ) ; 
free(input_state) ; 
}



void InitContinuousSocketInput(Request_t *request  , 
			       int buffer_size , 
			 OperationStatus_t *operation_status)
{

ContinuousSocketInputState_t *input_state ; 

if (request->params.method != POST_METHOD)
  {
    HTTP_REPORT_ERROR("Doing Continous Entity Input on non post method!"); 
  }


operation_status->do_operation = ContinuousSocketInput ; 
operation_status->handle = input_state = 
      malloc(sizeof(ContinuousSocketInputState_t)) ; 

input_state->socket = request->socket ; 
input_state->buffer = malloc( buffer_size ) ; 
input_state->buffer_size = buffer_size ; 

input_state->should_read_first_time_info = 
      (request->status.nof_chars_in_header != 
                 request->status.total_bytes_read_for_header ) ; 

if (input_state->should_read_first_time_info)
  {
    input_state->first_time_info = request->status.header_data + 
      request->status.nof_chars_in_header  ; 
    input_state->first_time_info_length = 
           request->status.total_bytes_read_for_header  - 
                request->status.nof_chars_in_header ; 
  }
operation_status->close_operation = FreeContinuousSocketInput ; 

}




typedef struct {
  char *buffer; 
  char *end_of_data_in_buffer ; 
  int buffer_size ; 
  Socket_t socket; 
  int should_read_first_time_info ; 
  char *first_time_info ; 
  int first_time_info_length ; 
  int content_length ; 
  int number_of_bytes_read_so_far ; 
} GetFixedSizeSocketInputState_t ; 

void GetFixedSizeSocketInput(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
GetFixedSizeSocketInputState_t *input_state ; 

int nof_bytes_read ; 

int client_closed_socket ; 
int error;
int nof_bytes_in_buffer ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

input_state = (GetFixedSizeSocketInputState_t *) operation_status->handle ; 

transfer_status->nof_buffers = 0  ; 


if (input_state->should_read_first_time_info )
  {
    input_state->should_read_first_time_info = FALSE ; 

    input_state->number_of_bytes_read_so_far += 
                       input_state->first_time_info_length ;
  }

if (input_state->number_of_bytes_read_so_far < 
    input_state->content_length )
  {

#ifndef BLOCKING_IO_ONLY

    read_available_data_from_socket(input_state->socket , 
				    input_state->end_of_data_in_buffer  , 
				    input_state->content_length - input_state->number_of_bytes_read_so_far,
				    &nof_bytes_read, &client_closed_socket, &error) ; 
#else

    read_data_from_socket_until_delimiter(input_state->socket , 
					  input_state->end_of_data_in_buffer  , 
					  input_state->content_length - input_state->number_of_bytes_read_so_far,
					  &nof_bytes_read, &client_closed_socket, &error, '\n' ) ; 
    /**** used in multipart mime encoding *****/

#endif

    if ( (error != 0 ) || client_closed_socket )
      {
	transfer_status->end_of_processing = TRUE  ; 
	transfer_status->socket_should_be_closed = TRUE ; 
	operation_status->status = END_OPERATION ; 
	return ; 
      }

    input_state->number_of_bytes_read_so_far += nof_bytes_read ; 
    input_state->end_of_data_in_buffer += nof_bytes_read ; 


    if (input_state->number_of_bytes_read_so_far < 
	input_state->content_length )
      {
	operation_status->status = IN_OPERATION ; 
	return ; 
      }
   
  }

/*** if we are here then number_of_bytes_read_so_far>=
     input_state->content_length
*****/


/***** this code will eliminate the \r\n Netscape is putting
******* adfter posted data IN ADDITION TO THE CONTENT LENGTH ****
****/

nof_bytes_in_buffer =  input_state->end_of_data_in_buffer -
                    input_state->buffer ; 

if ( input_state->first_time_info_length == 0 )
  {
    AddBuffer( transfer_status,  input_state->buffer , 
	      input_state->content_length ) ; 
  }
else
  {
    if ( input_state->first_time_info_length >=   input_state->content_length)
      {
	AddBuffer( transfer_status,  input_state->first_time_info , 
		  input_state->content_length ) ; 
      }
    else
      {
	AddBuffer( transfer_status,  input_state->first_time_info , 
		  input_state->first_time_info_length ) ; 
	
	AddBuffer( transfer_status,  input_state->buffer , 
           input_state->content_length - input_state->first_time_info_length); 
      }
  }

operation_status->status = END_OPERATION ; 
}



void  FreeFixedSizeSocketInput( OperationStatus_t *operation_status)
{
GetFixedSizeSocketInputState_t *input_state ; 

input_state = (GetFixedSizeSocketInputState_t *) operation_status->handle ; 

free(input_state->buffer ) ; 
free(input_state) ; 
}



void InitFixedSizeSocketInput(Request_t *request  , 
			       int buffer_size , 
			 OperationStatus_t *operation_status)
{

GetFixedSizeSocketInputState_t *input_state ; 

if (request->params.method != POST_METHOD)
  {
    HTTP_REPORT_ERROR("Doing Fixed size Entity Input on non post method!"); 
  }


operation_status->do_operation =  GetFixedSizeSocketInput ; 
operation_status->handle = input_state = 
      malloc(sizeof( GetFixedSizeSocketInputState_t)) ; 

input_state->socket = request->socket ; 
input_state->buffer = malloc( buffer_size ) ; 
input_state->buffer_size = buffer_size ; 

input_state->end_of_data_in_buffer = input_state->buffer ;
input_state->content_length =  buffer_size ;
input_state->number_of_bytes_read_so_far = 0 ; 

input_state->should_read_first_time_info = 
      (request->status.nof_chars_in_header != 
                 request->status.total_bytes_read_for_header ) ; 

if (input_state->should_read_first_time_info)
  {
    input_state->first_time_info = request->status.header_data + 
      request->status.nof_chars_in_header  + 1  ; 
    input_state->first_time_info_length = 
           request->status.total_bytes_read_for_header  - 
                request->status.nof_chars_in_header ; 
  }
operation_status->close_operation = FreeFixedSizeSocketInput ; 

}










