/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/

#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "upload.h"

#include "..\..\htmlform\src\streamfl.h"

typedef struct {
void *form_handle ; 
void *file_handle ; 
OpenUploadFunction_t open_upload_stream ; 
WriteDataToUploadFunction_t write_data_to_upload_stream ; 
CloseUploadFunction_t close_upload_stream  ; 
CleanupUploadFunction_t cleanup_dump_upload ; 
int stream_is_open ; 
int current_buffer_number ; 
int current_message_in_buffer ; 
} UploadState_t ; 



void do_upload_operation(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{

/**** BLOCKING CODE !!! ****/

DataTransferStatus_t *transfer_status;

OutputStreamMessage_t *stream_message_vec, *current_message  ; 

int was_done ; 

UploadState_t *state  ; 

state = (UploadState_t *) operation_status->handle ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

if (operation_status->status == START_OPERATION )
  {
    state->current_message_in_buffer = 0 ;
    state->current_buffer_number = 0 ; 
  }


for(  ;  
    state->current_buffer_number < transfer_status->nof_buffers ; 
    state->current_buffer_number++, state->current_message_in_buffer = 0 )
  {
    stream_message_vec  = 
         (OutputStreamMessage_t  *) transfer_status->data_buffers[
                                         state->current_buffer_number ];

    for( ; 
	 state->current_message_in_buffer < 
                       transfer_status->buffer_sizes[
                                 state->current_buffer_number] ; 
	 state->current_message_in_buffer++ )
      {
	current_message =  stream_message_vec +
	                        state->current_message_in_buffer ; 

	switch( current_message->message_type ) {
	case OPEN_STREAM_MESSAGE: {
	  if (state->stream_is_open)
	    {
	      HTTP_REPORT_ERROR(" file open message with no file close ") ; 
	    }


	  was_done = TRUE ; 
	  state->file_handle =  
             *current_message->stream_handle = 
              (*state->open_upload_stream)
	               (state->form_handle, 
			current_message->file_name,
			current_message->field_name ,
			&was_done ) ; 
	 
	   
	  if (!was_done)
	    {
	      operation_status->status = IN_OPERATION ; 
	      return ; 
	    }

	  state->stream_is_open = TRUE ; 
	  break ; 
	}
	case CLOSE_STREAM_MESSAGE:
	  {
	  if (!state->stream_is_open)
	    {
	      HTTP_REPORT_ERROR(" trying to close uploaded file with no open "); 
	    }
	  (*state->close_upload_stream)(state->form_handle,state->file_handle,
					&was_done ) ; 

	  if (!was_done)
	    {
	      operation_status->status = IN_OPERATION ; 
	      return ; 
	    }

	  state->stream_is_open = FALSE ; 
	  break ; 
	  }
	case ADD_DATA_MESSAGE:
	  {
	  if (!state->stream_is_open)
	    {
	      HTTP_REPORT_ERROR("trying to write to uploaded file with no open");
	    }
	  else
	    {

	      (*state->write_data_to_upload_stream)
                     (state->form_handle, 
		      state->file_handle, 
		      current_message->data  , 
		      current_message->nof_bytes,
		      &was_done ) ; 

	      if (!was_done)
		{
		  operation_status->status = IN_OPERATION ; 
		  return ; 
		}

	    }

	  break ; 
	  }
	default: 
	  {
	    HTTP_REPORT_ERROR("wrong file upload message code") ; 
	    break ; 
	  }

	}
      }
  }




operation_status->status = END_OPERATION ; 


}




void   close_upload( OperationStatus_t *operation_status)
{
UploadState_t *state ; 



state = (UploadState_t *) operation_status->handle ; 

if (state->stream_is_open)
  {
    HTTP_REPORT_ERROR(" write stream ended with no close file message ! ") ; 
  }

if (state->cleanup_dump_upload != NULL )
  {
    (*state->cleanup_dump_upload )(state->form_handle) ; 
  }

free(state) ; 
}



void InitDumpUpload(OperationStatus_t *operation_status,
		    void *handle, 
		    OpenUploadFunction_t open_upload_stream, 
		    WriteDataToUploadFunction_t write_data_to_upload_stream,
		    CloseUploadFunction_t close_upload_stream , 
		    CleanupUploadFunction_t cleanup_dump_upload)
{
UploadState_t *state ; 


state = malloc(sizeof(UploadState_t) ) ; 

operation_status->do_operation = do_upload_operation ; 
operation_status->handle = state ; 
operation_status->close_operation = close_upload ; 

state->form_handle = handle ; 
state->open_upload_stream =  open_upload_stream ; 
state->write_data_to_upload_stream = write_data_to_upload_stream  ; 
state->close_upload_stream = close_upload_stream ; 
state->cleanup_dump_upload = cleanup_dump_upload ; 
state->stream_is_open = FALSE ; 
}



