/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef FORMPARS_H
#define FORMPARS_H

#include "..\..\prochttp\src\util.h"

void init_hex_to_number(void); 


void copy_field(char **pos_in_input_param, 
		char *end_of_input, 
		char **pos_in_output_param, 
		char *end_of_output, 
		char delimiter ) ;


void parse_form_fields(char *input_data , 
		      int data_length, 
		      char *output_buffer, 
		      int output_buffer_length, 
		      char **field_names, 
		      char **field_values , 
		      int *nof_fields );

#define HTML_FIELD_VALUE_WAS_NOT_SENT -2 

#define MAX_FIELD_NAME  128 
#define MAX_FIELD_VALUE  4096 
#define MAX_UPLOAD_FILE_NAME 256 

typedef struct {
int x,y ; 
int was_clicked ; 
} HtmlImageCoordinate_t ;

typedef struct {
enum { HTML_TEXT_FIELD   , 
       HTML_BOOLEAN_FIELD  , 
       HTML_ONE_OF_MANY_FIELD , 
       HTML_MANY_OF_MANY_FIELD , 
       HTML_IMAGE_POINT_FIELD,
       HTML_STREAM_FIELD } field_type ; 

int address_offset_of_field; /*** offset between base address
                             **** of data strict to the field address 
                             ***/
              
WordList_t *values_dictionary ; /*** for ONE_OF_MANY or MANY_OF_MANY ****/

} ParseHtmlFieldDescription_t ; 

typedef struct {
WordList_t field_names ; 
ParseHtmlFieldDescription_t *parse_html_field_description  ; 
int nof_fields ; 
int struct_size ; 
} HtmlFormDesc_t ; 

typedef struct {
char *text_buffer ; 
int text_buffer_size ; 
int nof_chars_used_in_text_buffer ; 
void *form_data_struct_ptr ; 
HtmlFormDesc_t *form_description ; 
} HtmlOutputFields_t ; 


void update_html_field(
		       char *field_name,  
		       int field_name_length,
		       char *field_value ,  
		       int field_value_length,
		       HtmlFormDesc_t *html_form_description, 
		       HtmlOutputFields_t *html_output_fields);


void analyze_url_encoded_form_fields(char *input_data, 
			int input_length , 
			HtmlFormDesc_t *html_form_description, 
			HtmlOutputFields_t *html_output_fields);




void init_all_form_fields(
			HtmlFormDesc_t *html_form_description, 
			HtmlOutputFields_t *html_output_fields);



void InitHtmlOutputs(HtmlOutputFields_t *html_outputs,
		     HtmlFormDesc_t *form_description, 
		     void *form_data_base_address , 
		     char *text_buffer,  
		     int size_of_text_buffer ) ; 


char *address_of_field(ParseHtmlFieldDescription_t *field_description,
			   HtmlOutputFields_t *html_output_fields);


int  compute_text_buffer_size 
                        ( HtmlFormDesc_t *form_description,
                          int content_length ) ; 


#endif /*** FORMARS_H ***/


