/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"
#include "multiprt.h"
#include "..\..\prochttp\src\datatran.h"
#include "formpars.h"


void init_multipart_analyze_state(MultipartAnalyzeState_t *multipart_state,
                                  char *http_header_boundary, 
                                  int boundary_length,
				  int content_length,
				  int stream_buffer_size )
{

char tmp_boundary[ MAX_BOUNDARY_SIZE ] ; 

multipart_state->done = FALSE ; 
multipart_state->state =  MULTIPART_BEFORE_FIRST_BOUNDARY ; 
multipart_state->position_in_boundary_string =  0 ; 

if (boundary_length + 2 > MAX_BOUNDARY_SIZE )
  {
    HTTP_REPORT_ERROR(" Too big boundary ") ; 
  }

tmp_boundary[0] = '-' ; 
tmp_boundary[1] = '-' ; 
strncpy(tmp_boundary+2, http_header_boundary, boundary_length ) ; 

init_string_search(&multipart_state->boundary_string_search, 
		   tmp_boundary, boundary_length+2 );

tmp_boundary[0] = '\r' ; 
tmp_boundary[1] = '\n' ; 
tmp_boundary[2] = '-' ; 
tmp_boundary[3] = '-' ; 
strncpy(tmp_boundary+4, http_header_boundary, boundary_length ) ; 

init_string_search(&multipart_state->boundary_with_endline_string_search, 
		   tmp_boundary, boundary_length+4 );


multipart_state->nof_bytes_yet_to_read = content_length ; 

multipart_state->current_field_is_stream = FALSE; 

multipart_state->stream_buffer_size = stream_buffer_size ; 
multipart_state->stream_buffer = malloc(multipart_state->stream_buffer_size);


}

enum { MIME_FIELD_CONTENT_DISPOSITION,  MIME_FIELD_FROM_DATA,
	 MIME_ATTRIBUTE_NAME, MIME_ATTRIBUTE_FILE_NAME }; 

Word_t mime_field_names[] = {
  { "Content-Disposition", 19 , MIME_FIELD_CONTENT_DISPOSITION } , 
}; 

WordList_t mime_field_name_dict = {  mime_field_names, 1 } ; 

Word_t mime_field_values[] = {
  { "form-data", 9 , MIME_FIELD_FROM_DATA } , 
  { "name", 4 , MIME_ATTRIBUTE_NAME } , 
  { "filename", 8 , MIME_ATTRIBUTE_FILE_NAME } , 
}; 
WordList_t mime_field_value_dict = {  mime_field_values, 3 } ; 


void  add_part_char(char c , 
                    MultipartAnalyzeState_t *multipart_state )
{
int  start_line_index;
int line_length ; 
char *field_name; 
int field_name_length ; 
char *field_value; 
int field_value_length ; 
char *attributes[5];
int attributes_length[5];
char *values[5];
int values_length[5];
int nof_attribute_values_pairs;
int i_pair ; 
int mime_field_name_id ;
int mime_field_value_id ;

int mime_attribute_id ; 
int field_index ; 

char *copy_of_field_name;
char *copy_of_file_name; 

void **stream_handle ; 


if (multipart_state->within_part_state ==  INPART_BODY)
  {
    if (!multipart_state->current_field_is_stream)
      {
	multipart_state->field_value_buffer[
            multipart_state->nof_chars_in_field_value_buffer] = c ;
	multipart_state->nof_chars_in_field_value_buffer++ ; 

      }
    else
      {
	multipart_state->stream_buffer[
            multipart_state->nof_chars_in_stream_buffer] = c ;
	multipart_state->nof_chars_in_stream_buffer++ ; 

      }	


  }
else
  {
    multipart_state->mime_header[multipart_state->nof_chars_in_mime_header]= c;
    multipart_state->nof_chars_in_mime_header++ ; 

    switch(c) {
    case '\r':
      {
	switch(multipart_state->within_part_state) {
	case  INPART_MIME_HEADER :
	  {
	    multipart_state->within_part_state =  INPART_MIME_HEADER_AFTER_CR;
	    break ; 
	  }
	case  INPART_MIME_HEADER_AFTER_CR_LF :
	  {
	    multipart_state->within_part_state =  
	      INPART_MIME_HEADER_AFTER_CR_LF_CR ;
	    break ; 
	  }
	default: {} ; /** to avoid warnings ***/
	} /*** end swicth state ***/
	break ; 
      } /*** end \r case ****/
    case '\n':
      {
	switch(multipart_state->within_part_state) {
	case  INPART_MIME_HEADER_AFTER_CR :
	  {
	    multipart_state->within_part_state =  
	              INPART_MIME_HEADER_AFTER_CR_LF;
	    break ; 
	  }
	case  INPART_MIME_HEADER_AFTER_CR_LF_CR :
	  {
	    multipart_state->within_part_state =  INPART_BODY ;

	    multipart_state->field_name[0] = 0 ; 
	    multipart_state->field_name_index = -1 ; 
	    multipart_state->upload_file_name[0] = 0 ; 

	    start_line_index = 0 ; 
	    while ( ( (multipart_state->mime_header
		       [start_line_index] == '\r' ) ||
		     (multipart_state->mime_header
		      [start_line_index] == '\n' ) ) &&
		   (start_line_index < 
		    multipart_state->nof_chars_in_mime_header)
		   )
	      {
		start_line_index++ ; 
	      }


	    while (start_line_index < 
                                multipart_state->nof_chars_in_mime_header)
	      {
		line_length = 0 ; 
		while ( (multipart_state->mime_header
                             [start_line_index+line_length] != '\r' ) &&
		       (multipart_state->mime_header
                             [start_line_index+line_length] != '\n' ) &&
		       (start_line_index+line_length < 
                                multipart_state->nof_chars_in_mime_header)
		       )
		  {
		    line_length++ ; 
		  }

		parse_mime_header_type_line
		 (multipart_state->mime_header + start_line_index, 
		  line_length,
		  &field_name, &field_name_length, 
                  &field_value, &field_value_length, 
                  5, 
                  attributes, attributes_length, 
                  values, values_length , 
                  &nof_attribute_values_pairs ) ;

		mime_field_name_id = find_word_case_insensitive
                      (field_name,  field_name_length, &mime_field_name_dict);


		mime_field_value_id = find_word_case_insensitive
                    (field_value,  field_value_length, &mime_field_value_dict);


/*
		HTTP_TRACE("multipart", sprintf(tmp_trace, "name %d  val %d\n",
						mime_field_name_id, 
						mime_field_value_id ) ) ; 
*/

		if ((mime_field_name_id == MIME_FIELD_CONTENT_DISPOSITION) &&
		    (mime_field_value_id ==  MIME_FIELD_FROM_DATA) )
		  {
		    for(i_pair = 0 ; i_pair < nof_attribute_values_pairs;
			i_pair++ ) 
		      {
			mime_attribute_id = find_word_case_insensitive
			  (attributes[i_pair],  attributes_length[i_pair], 
			   &mime_field_value_dict);
			switch(mime_attribute_id) {
			case  MIME_ATTRIBUTE_NAME:
			  {
			    memcpy(multipart_state->field_name, 
				   values[i_pair], 
				   (size_t)values_length[i_pair] ) ; 
			    multipart_state->field_name[
                                       values_length[i_pair]] = 0;

			    break;
			  }
			case MIME_ATTRIBUTE_FILE_NAME:
			  {
			    memcpy(multipart_state->upload_file_name, 
				   values[i_pair], 
				   (size_t)values_length[i_pair] ) ; 
			    multipart_state->upload_file_name[
                                       values_length[i_pair]] = 0;
			    break;
			  }
			default:{}
			}

		      }
		  }

	      
		    
		start_line_index += line_length ; 



		while ( ( (multipart_state->mime_header
                             [start_line_index] == '\r' ) ||
		       (multipart_state->mime_header
                             [start_line_index] == '\n' ) ) &&
		       (start_line_index < 
                                multipart_state->nof_chars_in_mime_header)
		       )
		  {
		    start_line_index++ ; 
		  }

	      }
			       
		
	    multipart_state->nof_chars_in_field_value_buffer = 0 ; 


	    field_index = 
	      find_word_case_insensitive
		(multipart_state->field_name , 
		 strlen(multipart_state->field_name ), 
		 &multipart_state->html_form_description->field_names );



	    multipart_state->current_field_is_stream = FALSE ; 

	    if  (field_index !=  NOT_FOUND_IN_WORD_LIST)
	      {
		if (multipart_state->html_form_description->
		      parse_html_field_description[field_index].field_type == 
		    HTML_STREAM_FIELD)
		  {
		    multipart_state->current_field_is_stream = TRUE ; 

		    copy_of_field_name = multipart_state->stream_buffer + 
		      multipart_state->nof_chars_in_stream_buffer;
	
		    strcpy( copy_of_field_name, multipart_state->field_name) ; 
		    multipart_state->nof_chars_in_stream_buffer += 
		      (strlen( copy_of_field_name ) + 1 ) ; 

		    copy_of_file_name = multipart_state->stream_buffer + 
		      multipart_state->nof_chars_in_stream_buffer;
	
		    strcpy(copy_of_file_name,multipart_state->upload_file_name); 
		    multipart_state->nof_chars_in_stream_buffer += 
		      (strlen( copy_of_file_name ) + 1 ) ; 


		    stream_handle = (void **)address_of_field(
			&multipart_state->html_form_description->
                          	   parse_html_field_description[field_index],
			multipart_state->html_output_fields ); 

		    set_open_stream_message(
                           &multipart_state->stream_field_messages[
                                 multipart_state->nof_stream_field_messages],
					    copy_of_field_name, 
					    copy_of_file_name, 
					    stream_handle ) ; 


		    multipart_state->nof_stream_field_messages++ ; 
		    multipart_state->beginning_of_current_stream = 
		      multipart_state->nof_chars_in_stream_buffer ; 
		  }
	      }

	    break ; 
	  }
	default: {} ; /** to avoid warnings ***/
	} /*** end swicth state ***/
	break ; 
      } /*** end \n case ****/
    default: { /** not cr and not lf ***/
      multipart_state->within_part_state = INPART_MIME_HEADER  ;
      break ;
    }

    } /*** end switch on char ***/

  }
}


void send_buf_to_stream( MultipartAnalyzeState_t *multipart_state)
{
  set_add_data_to_stream
      (&multipart_state->stream_field_messages[
			  multipart_state->nof_stream_field_messages],
       multipart_state->stream_buffer + 
			   multipart_state->beginning_of_current_stream,
       multipart_state->nof_chars_in_stream_buffer - 
			   multipart_state->beginning_of_current_stream );

  multipart_state->nof_stream_field_messages++ ; 
}


void analyze_multipart_encoded_form_fields(
                        DataTransferStatus_t *input_data, 
                        MultipartAnalyzeState_t *multipart_state, 
			HtmlFormDesc_t *html_form_description, 
			HtmlOutputFields_t *html_output_fields)
{

int curr_buf ; 
int curr_char ; 
int boundary_was_found ; 
int prev_position ; 
int i_char ; 

curr_buf = 0 ; 
curr_char = 0 ; 


multipart_state->nof_chars_in_stream_buffer = 0  ; 

multipart_state->nof_stream_field_messages = 0 ; 

multipart_state->beginning_of_current_stream = 0 ; 

while ( (curr_char == input_data->buffer_sizes[curr_buf] ) &&
       (curr_buf < input_data->nof_buffers ) )
  {
    curr_char = 0 ; 
    curr_buf++ ; 
  }





while ( (multipart_state->state ==  MULTIPART_BEFORE_FIRST_BOUNDARY) &&
       (curr_buf <  input_data->nof_buffers ) )
  {
    one_more_char(&multipart_state->boundary_string_search,
		  &multipart_state->position_in_boundary_string,
		  ((char *)input_data->data_buffers[curr_buf])[curr_char],
		  &boundary_was_found ); 
    
    if (boundary_was_found)
      {
	multipart_state->state =  MULTIPART_JUST_AFTER_BOUNDARY ; 
      }
    
    curr_char++ ; 
    while ( (curr_char == input_data->buffer_sizes[curr_buf] ) &&
       (curr_buf < input_data->nof_buffers ) )
      {
	curr_char = 0 ; 
	curr_buf++ ; 
      }
  }



while( (curr_buf <  input_data->nof_buffers) && (!multipart_state->done ) ) {

if (multipart_state->state ==  MULTIPART_JUST_AFTER_BOUNDARY )
  {
    if ( ( (char *)input_data->data_buffers[curr_buf])[curr_char] == '-' )
      {
	multipart_state->state =   MULTIPART_AFTER_BOUNDARY_ONE_HYPHEN;

	curr_char++ ; 
	while ( (curr_char == input_data->buffer_sizes[curr_buf] ) &&
	       (curr_buf < input_data->nof_buffers ) )
	  {
	    curr_char = 0 ; 
	    curr_buf++ ; 
	  }

	if (curr_buf == input_data->nof_buffers )
	  {
	    break  ; 
	  }
      }
    else
      {
	multipart_state->state =     MULTIPART_READING ;
      }

  }


if (multipart_state->state ==    MULTIPART_AFTER_BOUNDARY_ONE_HYPHEN )
  {
    if ( ( (char *)input_data->data_buffers[curr_buf])[curr_char] == '-' )
      {
   	multipart_state->state =  MULTIPART_AFTER_LAST ;
	multipart_state->done = TRUE ; 
/*	HTTP_TRACE_MSG("form", "multipart done"); */
	break  ; 
      }
    else
      {
	multipart_state->state =     MULTIPART_READING ;
      }

  }

while (multipart_state->state ==  MULTIPART_READING )
  {

    prev_position = multipart_state->position_in_boundary_string ; 

    one_more_char(&multipart_state->boundary_with_endline_string_search,
		  &multipart_state->position_in_boundary_string,
		  ( (char *)input_data->data_buffers[curr_buf])[curr_char],
		  &boundary_was_found ); 

    if (!boundary_was_found)
      {
	if (multipart_state->position_in_boundary_string == 0 )
	  {
	    if (prev_position != 0 )
	      /*** if not needed but more efficient ****/
	      {
		for(i_char = 0 ; i_char <  prev_position ; i_char++ )
		  {
		    add_part_char( multipart_state->
                                 boundary_with_endline_string_search.
	    		            string_to_match[i_char],
				  multipart_state ) ; 
		  }
	      }
	    add_part_char(
		((char *)input_data->data_buffers[curr_buf])[curr_char],
		multipart_state);
 
	  }
	else
	  {
	    if (multipart_state->position_in_boundary_string < 
		prev_position + 1 )
	      /*** more elegant but less efficient nesting possible ****/
	      {
		for(i_char = 0 ; 
		    i_char <  prev_position + 1 - 
		    multipart_state->position_in_boundary_string ; 
		    i_char++ )
		  {
		    add_part_char( 
                       multipart_state->boundary_with_endline_string_search.
			     string_to_match[i_char],
                       multipart_state ) ; 
		  }
	      }
	  }
      }      
    
    if (boundary_was_found)
      {
/*	HTTP_TRACE_MSG("multipart", "!!!!!!!BOUNDARY!!!!!" ) ; */

	if (!multipart_state->current_field_is_stream)
	  {
	    update_html_field(
		       multipart_state->field_name,  
		       strlen( multipart_state->field_name ) , 
		       multipart_state->field_value_buffer ,  
		       multipart_state->nof_chars_in_field_value_buffer,
		       html_form_description, 
		       html_output_fields);
	  }
	else /** stream field ****/
	  {
	    send_buf_to_stream(multipart_state);

	    set_close_stream_message(&multipart_state->stream_field_messages[
				 multipart_state->nof_stream_field_messages] );
	    multipart_state->nof_stream_field_messages++ ; 

	    multipart_state->current_field_is_stream = FALSE ; 
 	  }
	
	multipart_state->state =  MULTIPART_JUST_AFTER_BOUNDARY ; 
	multipart_state->within_part_state = INPART_MIME_HEADER ; 
	multipart_state->nof_chars_in_mime_header = 0 ; 
      }

    curr_char++ ; 
    while ( (curr_char == input_data->buffer_sizes[curr_buf] )  &&
       (curr_buf < input_data->nof_buffers ) )
      {
	curr_char = 0 ; 
	curr_buf++ ; 
      }

    if (curr_buf == input_data->nof_buffers )
      {
	if (multipart_state->current_field_is_stream)
	  {
	    send_buf_to_stream(multipart_state ) ; 
	  }
	break ; 
      }



  }

}


input_data->nof_buffers = 0 ; 
AddBuffer(input_data, multipart_state->stream_field_messages,
	  multipart_state->nof_stream_field_messages ) ; 

}


void destroy_multipart_analyze_state(MultipartAnalyzeState_t *multipart_state)
{
destroy_string_search(&multipart_state->boundary_string_search); 
destroy_string_search(&multipart_state->boundary_with_endline_string_search); 

free(multipart_state->stream_buffer) ; 

}



typedef struct {
MultipartAnalyzeState_t analyze_state ; 
HtmlFormDesc_t *html_form_description ; 
HtmlOutputFields_t *html_output_fields ; 
} ProcMultiPartState_t ; 


void  multi_part_parse_proc (void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
ProcMultiPartState_t *input_state ; 


transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

input_state = (ProcMultiPartState_t *) operation_status->handle ; 


if (input_state->analyze_state.done )
  {
    transfer_status->end_of_processing = TRUE ; 
    transfer_status->socket_should_be_closed = TRUE ; 
    operation_status->status = END_OPERATION ; 
    return ; 
  }


analyze_multipart_encoded_form_fields(
		transfer_status_input, 
		&input_state->analyze_state, 
		input_state->html_form_description, 
		input_state->html_output_fields ) ; 



operation_status->status = END_OPERATION ; 
}

void  FreeMultiPartState( OperationStatus_t *operation_status)
{
ProcMultiPartState_t *input_state ; 

input_state = (ProcMultiPartState_t *) operation_status->handle ; 
destroy_multipart_analyze_state(&input_state->analyze_state) ; 

free(input_state) ; 
}


void InitProcMultiPartParse(Request_t *request, 
			    int stream_buffer_size, 
			    HtmlFormDesc_t *html_form_description, 
			    HtmlOutputFields_t *html_output_fields,
			    OperationStatus_t *operation_status
			    )
{
ProcMultiPartState_t *input_state ; 

operation_status->do_operation = multi_part_parse_proc  ; 
operation_status->handle = input_state = 
              malloc(sizeof( ProcMultiPartState_t)) ; 


init_multipart_analyze_state(&input_state->analyze_state, 
			     request->params.boundary, 
			     request->params.boundary_length, 
			     request->params.content_length,
			     stream_buffer_size ); 
			     
input_state->analyze_state.html_form_description = html_form_description; 
input_state->analyze_state.html_output_fields = html_output_fields ; 

input_state->html_form_description = html_form_description ; 
input_state->html_output_fields = html_output_fields  ; 


operation_status->close_operation = FreeMultiPartState ; 

init_all_form_fields(html_form_description, 
		     html_output_fields);



}


