/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"
#include "streamfl.h"
#include "..\..\prochttp\src\datatran.h"





void set_open_stream_message(OutputStreamMessage_t *stream_message, 
			     char *field_name , 
			     char *file_name,
			     void **stream_handle)
{
stream_message->message_type =  OPEN_STREAM_MESSAGE ; 
stream_message->file_name = file_name ; 
stream_message->field_name = field_name ; 
stream_message->stream_handle = stream_handle ; 
}

void set_add_data_to_stream(OutputStreamMessage_t *stream_message, 
			    void *data,
			    int nof_bytes )
{
stream_message->message_type =  ADD_DATA_MESSAGE ; 
stream_message->data = data ; 
stream_message->nof_bytes = nof_bytes ; 
}



void set_close_stream_message(OutputStreamMessage_t *stream_message)
{
stream_message->message_type =  CLOSE_STREAM_MESSAGE  ; 
}


void dump_stream_operation(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{

DataTransferStatus_t *transfer_status;

OutputStreamMessage_t *stream_message_vec ; 
int i_buf ; 
int i_message ; 
int i_char ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

for(i_buf = 0 ; i_buf < transfer_status->nof_buffers ; i_buf++ )
  {
    stream_message_vec  = 
         (OutputStreamMessage_t  *) transfer_status->data_buffers[i_buf];
    for(i_message = 0 ; i_message < transfer_status->buffer_sizes[i_buf] ; 
	i_message++ )
      {
	switch( stream_message_vec[i_message].message_type ) {
	case OPEN_STREAM_MESSAGE: {
#ifndef WINDOWS_VC
	  printf(" open file %s field %s pointer %p \n", 
		  stream_message_vec[i_message].file_name, 
		  stream_message_vec[i_message].field_name, 
		  stream_message_vec[i_message].stream_handle ) ; 
#endif
	  break ; 
	}
	case CLOSE_STREAM_MESSAGE:
	  {
#ifndef WINDOWS_VC
	    printf("\nCLOSE\n" ) ; 
#endif
	    break ; 
	  }
	case ADD_DATA_MESSAGE:
	  {
	    for(i_char = 0 ; i_char <  stream_message_vec[i_message].nof_bytes;
		i_char++ )
	      {
#ifndef WINDOWS_VC
		printf("%c", ( (char *)  stream_message_vec[i_message].data )
                                     [i_char] ) ; 
#endif
	      }
	    break ; 
	  }
	default: 
	  {
#ifndef WINDOWS_VC
	    printf(" WHAT ????") ; 
#endif
	    break ; 
	  }

	}
      }
  }




operation_status->status = END_OPERATION ; 


}





void InitDumpStream(OperationStatus_t *operation_status)
{
operation_status->do_operation = dump_stream_operation ; 
operation_status->handle = NULL ; 
operation_status->close_operation = NULL  ; 


}












