/* Author : Jyothi
   Date   : 5/3/98
   Description : Contains routines to handle IP Destnation Filter, 
                  IP Source Filter, MAC Address Filter, DNS Filter & Application Filters */

#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"

#include "psfltmnu.h"
#include "ipdst.h"
#include "ipsrc.h"
#include "appl.h"
#include "mac.h"
#include "domain.h"
#include "addflt.h"
#include "addfltfm.h"
#include "addappl.h"
#include "addappfm.h"
#include "adddns.h"
#include "adddnsfm.h"
#include "delflt.h"
#include "delfltfm.h"
#include "delappl.h"
#include "delappfm.h"
#include "deldns.h"
#include "deldnsfm.h"
#include "vdflt.h"
#include "vdappl.h"
#include "portlist.h"
#include "polstfm.h"

#if 0
/* sudha 23 Aug 1999 */
#include "tcplist.h"
#include "tcplstfm.h" 
#endif

#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg) ;
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at) ;
extern void    display_framed_or_standard_main_page(Request_t* request) ;
extern BYTE    is_valid_mac_address(BYTE* string_ptr) ;
extern void    format_the_mac_address(BYTE* string_ptr) ;
extern BYTE    is_valid_dns_address(BYTE* string_ptr) ;
extern void get_ftp_port_numbers(USHORT *ctrl_port, USHORT *data_port);

#define	IP_DEST_FILTER		     0		/* forbidden sites */
#define	IP_SOURCE_FILTER	     1		/* restricted clients */
#define	MAC_ADDRESS_FILTER	  2		/* restricted mac addresses */
#define	DOMAIN_NAME_FILTER	  3		/* restricted domain names */
#define	APPLICATION_FILTER	  4		/* restricted domain names */

#define	TCP		     0		
#define	UDP		     1		
#define  ADD_ENTRY     1

#define	SIZEOF_DNS_TEMPLATE  5
int filtering_action ;
/*...Extern Decleration*/

/* Local ProtoType ...*/

void display_proxy_server_main_filter_menu(Request_t* request) ;
void display_destination_filter_menu(Request_t* request) ;
void display_source_filter_menu(Request_t* request) ;
void display_mac_filter_menu(Request_t* request) ;
void display_domain_filter_menu(Request_t* request) ;
void display_application_filter_menu(Request_t* request) ;
void display_add_proxy_server_filter_form (Request_t* request) ;
void display_add_application_filter_form (Request_t* request) ;
void display_vd_proxy_server_filters_page(Request_t* request) ;
void add_proxy_server_filter(Request_t* request) ;
void add_application_filter(Request_t* request) ;
void delete_the_proxy_server_filter(Request_t* request) ;
void display_proxy_server_filter_for_deleting(Request_t* request, STRUCT_PROXY_FILTER* proxy_server_filter) ;
void display_application_filter_for_deleting(Request_t* request, STRUCT_PROXY_ENTRY* application_filter) ;
void display_add_DNS_filter_form (Request_t* request) ;
USHORT get_the_number_of_proxy_filters() ;
USHORT get_the_number_of_application_filters() ;
void check_for_filtering_type_to_replace_template(char filter_name[25]) ;

void display_ten_proxy_filters_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page) ;
void display_prev_filters(Request_t* request) ;
void display_next_ten_proxy_filters(Request_t* request) ;
/*void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node) ;*/
USHORT modify_proxy_server_filter_template(BYTE* buffer, STRUCT_PROXY_FILTER* proxy_filter, USHORT search_to_start_at) ;
USHORT modify_application_filter_template(BYTE* buffer, STRUCT_PROXY_ENTRY* application_filter, USHORT search_to_start_at) ;
USHORT hide_remaining_hyper_links_on_which_there_is_no_proxy_filter_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer) ;

BYTE save_the_number_of_proxy_filter_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save) ;
BYTE save_whether_next_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save) ;
BYTE save_whether_prev_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save) ;
PARAMETER_NODE* next_proxy_filter_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save) ;
void remove_a_particular_proxy_filter(USHORT index) ;
PARAMETER_NODE* first_proxy_filter_of_the_current_page(PARAMETER_NODE* new_value, BYTE is_required_to_save) ;
void match_port_number_to_name(USHORT port_number, BYTE* name) ;
void select_the_port_from_port_list(Request_t* request) ;
void display_the_list_for_port(Request_t* request) ;
BYTE is_numeric_value(BYTE* buffer) ;

/* ... Local ProtoType*/

/*Extern Decleration ... */
/* sudha 23 Aug 1999 */
extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);
extern char *get_port_type (char *port_type_string, USHORT, USHORT protocol_port_number);
/*...Extern Decleration*/


BYTE* filter_section_ptr[5] =
{                          
   "Proxy Destination Filter",
   "Proxy Source Filter",
   "Proxy MAC Filter",
   "Proxy DNS Filter",
   "Proxy Application Filter"
};

/* sudha 23 Aug 1999 */
#if 0
typedef struct
{
   BYTE name[70]; 
   USHORT port_number;
}STRUCT_PORT_NAME_LIB;

STRUCT_PORT_NAME_LIB port_names_lib[] = 
{
  {"CHAT", 531},
  {"DNS", 53},
   {"ECHO", 7},
   {"FINGER", 79},
   {"FTP20", 20},
   {"FTP21", 21},
   {"GOPHER", 70},
   {"HTTPS", 443},
   {"IMAP", 143},
   {"IMAP3", 220},
   {"IRC", 194},
   {"MIRC", 6667},
   {"MS-STREAMING", 1755},
   {"NAMESERVER", 42},
   {"NEWS", 144},
   {"NNTP", 119},
   {"POP3", 110},
   {"READNEWS", 532},
   {"REALAUDIO/VIDEO1090", 1090},
   {"REALAUDIO/VIDEO7070", 7070},
   {"RLOGIN", 513},
   {"SMTP", 25},
   {"SNMP", 161},
   {"SNMP-TRAP", 162},
   {"SSL-FTP989", 989},
   {"SSL-FTP990", 990},
   {"SSL-IRC", 994},
   {"SSL-IMAP4", 993},
   {"SSL-NNTP", 563},
   {"SSL-POP3", 995},
   {"SSL-SMTP", 465},
   {"SSL-TELNET", 992},
   {"TELNET", 23},
   {"TFTP", 69},
   {"VXTREME", 8000},
   {"WWW-HTTP", 80},
	{"AOL", 5190},
	{"Q931ch1", 900},
	{"Q931ch2", 902},
	{"RTP5004", 5004},
	{"RTP5006", 5006},
	{"RTCP5005", 5005},
	{"RTCP5007", 5007},
   {NULL, 0}
};
#endif

PARAMETER_NODE* ptr_to_start_of_filters[5], *ptr_to_first_filter_of_current_page[5] ;
USHORT proxy_server_filters_till_current_page[5] = 0 , total_number_of_proxy_server_filters[5] = 0 ;
STRUCT_PROXY_FILTER contents_of_proxy_server_filter_page[NUMBER_OF_ROUTES_PER_PAGE] ;
STRUCT_PROXY_ENTRY contents_of_application_filter_page[NUMBER_OF_ROUTES_PER_PAGE] ;
char filter_name[25] ;

void display_proxy_server_main_filter_menu(Request_t* request)
{
	
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_destination_filter_menu(Request_t* request)
{
	STRUCT_PROXY_FILTER temp_proxy_filter_struct ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
   filtering_action = IP_DEST_FILTER ;
	ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_proxy_filter_struct) ;
	proxy_server_filters_till_current_page[filtering_action] = 0 ;
	if (ptr_to_start_of_filters[filtering_action])
		total_number_of_proxy_server_filters[filtering_action] = get_the_number_of_proxy_filters() ;
	InitReturnBuffer(request, IP_DESTINATION_ADDRESS_FILTER_MENU_data_ptr, strlen(IP_DESTINATION_ADDRESS_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void display_source_filter_menu(Request_t* request)
{
	STRUCT_PROXY_FILTER temp_proxy_filter_struct ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
   filtering_action = IP_SOURCE_FILTER ;
	ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_proxy_filter_struct) ;
	proxy_server_filters_till_current_page[filtering_action] = 0 ;
	if (ptr_to_start_of_filters[filtering_action])
		total_number_of_proxy_server_filters[filtering_action] = get_the_number_of_proxy_filters() ;
	InitReturnBuffer(request, IP_SOURCE_ADDRESS_FILTER_MENU_data_ptr, strlen(IP_SOURCE_ADDRESS_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void display_mac_filter_menu(Request_t* request)
{
	STRUCT_PROXY_FILTER temp_proxy_filter_struct ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
   filtering_action = MAC_ADDRESS_FILTER ;
	ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_proxy_filter_struct) ;
	proxy_server_filters_till_current_page[filtering_action] = 0 ;
	if (ptr_to_start_of_filters[filtering_action])
		total_number_of_proxy_server_filters[filtering_action] = get_the_number_of_proxy_filters() ;
	InitReturnBuffer(request, MAC_ADDRESS_FILTER_MENU_data_ptr, strlen(MAC_ADDRESS_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void display_domain_filter_menu(Request_t* request)
{
	STRUCT_PROXY_FILTER temp_proxy_filter_struct ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
   filtering_action = DOMAIN_NAME_FILTER ;
	ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_proxy_filter_struct) ;
	proxy_server_filters_till_current_page[filtering_action] = 0 ;
	if (ptr_to_start_of_filters[filtering_action])
		total_number_of_proxy_server_filters[filtering_action] = get_the_number_of_proxy_filters() ;
	InitReturnBuffer(request, DOMAIN_NAME_FILTER_MENU_data_ptr, strlen(DOMAIN_NAME_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void display_application_filter_menu(Request_t* request)
{
	STRUCT_PROXY_ENTRY temp_proxy_filter_struct ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
   filtering_action = APPLICATION_FILTER ;
	ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_proxy_filter_struct) ;
	proxy_server_filters_till_current_page[filtering_action] = 0 ;
	if (ptr_to_start_of_filters[filtering_action])
		total_number_of_proxy_server_filters[filtering_action] = get_the_number_of_proxy_filters() ;
	InitReturnBuffer(request, APPLICATION_FILTER_MENU_data_ptr, strlen(APPLICATION_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void display_add_proxy_server_filter_form (Request_t* request)
{
    BYTE* buffer ;
    USHORT search_to_start_at ;
    if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	buffer = (BYTE*)malloc(strlen(ADD_PROXY_SERVER_FILTER_data_ptr)) ;
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display ADD Proxy Server Filter Page\n") ;
		display_framed_or_standard_main_page(request) ;
		return ;
	} 	
	strcpy(buffer, ADD_PROXY_SERVER_FILTER_data_ptr) ;
   check_for_filtering_type_to_replace_template(filter_name) ;
   search_to_start_at = search_and_replace("#____#____#____#_____#", filter_name, buffer, TRUE, 0) ; 
	InitReturnBuffer(request, buffer, strlen(ADD_PROXY_SERVER_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
   free (buffer) ;
}

void display_add_application_filter_form (Request_t* request)
{
    BYTE* buffer ;
    USHORT search_to_start_at ;
    if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	buffer = (BYTE*)malloc(strlen(ADD_APPLICATION_FILTER_data_ptr)) ;
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display ADD Application Filter Page\n") ;
		display_framed_or_standard_main_page(request) ;
		return ;
	} 	
	strcpy(buffer, ADD_APPLICATION_FILTER_data_ptr) ;
   search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, 0);
	InitReturnBuffer(request, buffer, strlen(ADD_APPLICATION_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
   free (buffer) ;
}

void display_add_DNS_filter_form (Request_t* request)
{
    BYTE* buffer ;

    if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	buffer = (BYTE*)malloc(strlen(ADD_DNS_FILTER_data_ptr)) ;
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display ADD DNS Filter Page\n") ;
		display_framed_or_standard_main_page(request) ;
		return ;
	} 	
	strcpy(buffer, ADD_DNS_FILTER_data_ptr) ;
	InitReturnBuffer(request, buffer, strlen(ADD_DNS_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
   free (buffer) ;
}

void display_vd_proxy_server_filters_page(Request_t* request)
{
	STRUCT_PROXY_FILTER temp_proxy_struct ;
	STRUCT_PROXY_ENTRY temp_appl_struct ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	if (filtering_action == APPLICATION_FILTER)
	   ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = cm_get_first_entry(CM_PROXY_SECTION, "Proxy Application Filter", (void*)&temp_appl_struct) ;
   else
      ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_proxy_struct) ;
      
	if (ptr_to_start_of_filters[filtering_action])
   {
    	if (filtering_action == APPLICATION_FILTER)
         total_number_of_proxy_server_filters[filtering_action] = get_the_number_of_application_filters() ;
      else
         total_number_of_proxy_server_filters[filtering_action] = get_the_number_of_proxy_filters() ;
   }
   else
   {
		InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;	
   }
	if (!total_number_of_proxy_server_filters[filtering_action])
	{
		InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;	
	}

	proxy_server_filters_till_current_page[filtering_action] = 0 ;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE) ;
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE) ;
	next_proxy_filter_from_where_display_is_reqd_to_continue(ptr_to_start_of_filters[filtering_action], TRUE) ;
	display_next_ten_proxy_filters(request) ;
}

void add_proxy_server_filter(Request_t* request)
{
	PARAMETER_NODE* new_node ;
	ADD_PROXY_SERVER_FILTER_form_output_type* proxy_server_filter_to_add ;
	ADD_DNS_FILTER_form_output_type* DNS_filter_to_add ;
	STRUCT_PROXY_FILTER proxy_server_filter ;
   BYTE address_string[] = "0.0.0.0" ;
   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
   if (filtering_action == DOMAIN_NAME_FILTER)
   {
      DNS_filter_to_add = (ADD_DNS_FILTER_form_output_type*) form_data_of_request(request) ;
      if ((strcmp (address_string, DNS_filter_to_add->filter_address) == 0) || (!(is_valid_dns_address (DNS_filter_to_add->filter_address))))
      {
          printf("Invalid Address\n") ;
		    InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
          return ;
      }
      else
      	strcpy (proxy_server_filter.addr, DNS_filter_to_add->filter_address) ;
   }
   else
   {
      proxy_server_filter_to_add = (ADD_PROXY_SERVER_FILTER_form_output_type*) form_data_of_request(request) ;
      if (strcmp (address_string, proxy_server_filter_to_add->filter_address) == 0)
      {
         printf("Invalid Address\n") ;
		   InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
         return ;
       }
       if (filtering_action == MAC_ADDRESS_FILTER)
       {
           format_the_mac_address (proxy_server_filter_to_add->filter_address) ;
           if ((strlen (proxy_server_filter_to_add->filter_address) > 12) || (!is_valid_mac_address (proxy_server_filter_to_add->filter_address)))
           {
               printf("Invalid Address\n") ;
         		InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
               return ;
           }
           else
           {
              strcpy (proxy_server_filter.addr, proxy_server_filter_to_add->filter_address) ;
           }
       }   
       else
          strcpy (proxy_server_filter.addr, proxy_server_filter_to_add->filter_address) ;
       
   }
	new_node = cm_insert_string(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&proxy_server_filter) ;
	if (new_node == NULL)
	{
		printf("Failed to Insert the Proxy server Filter\n") ;
		InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}
	if (ptr_to_start_of_filters[filtering_action] == NULL)
		ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = new_node ;
	total_number_of_proxy_server_filters[filtering_action] ++ ;
   InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void add_application_filter(Request_t* request)
{
	PARAMETER_NODE* new_node ;
	ADD_APPLICATION_FILTER_form_output_type* application_filter_to_add ;
	STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	application_filter_to_add = (ADD_APPLICATION_FILTER_form_output_type*) form_data_of_request(request) ;
   if (!strcmpi(application_filter_to_add->choose, "Choose From List..."))
   {
      display_the_list_for_port(request);
      return;
   }
   if (!is_numeric_value(application_filter_to_add->port))
   {
      printf("Invalid Port Number Failed to add Port Entry\n");
   	InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      return;
   }

	application_filter.protocol = application_filter_to_add->protocol ;
	application_filter.port =  atoi (application_filter_to_add->port) ;
	new_node = cm_insert_string(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&application_filter) ;
	if (new_node == NULL)
	{
		printf("Failed to Insert the Application Filter\n") ;
		InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}

	if (ptr_to_start_of_filters[filtering_action] == NULL)
		ptr_to_first_filter_of_current_page[filtering_action] = ptr_to_start_of_filters[filtering_action] = new_node ;
	total_number_of_proxy_server_filters[filtering_action] ++ ;
   InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void display_the_list_for_port(Request_t* request)
{
	USHORT ctrl_port = 0, data_port = 0;
	char c_port[10], d_port[10];

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

/* sudha 23 Aug 1999 */
	get_ftp_port_numbers(&ctrl_port, &data_port);
	sprintf(c_port,"%d", ctrl_port);
	sprintf(d_port,"%d", data_port);

	search_and_replace("#CTRL#", c_port, PORT_LIST_data_ptr, TRUE, 0);
	search_and_replace("#DATA#", d_port, PORT_LIST_data_ptr, TRUE, 0);

/*   InitReturnBuffer(request, TCP_LIST_data_ptr, strlen(TCP_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE);*/
   InitReturnBuffer(request, PORT_LIST_data_ptr, strlen(PORT_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE); 
}

void select_the_port_from_port_list(Request_t* request)
{
   PORT_LIST_form_output_type* selected_port; 
/*   TCP_LIST_form_output_type* selected_port; */
   BYTE name[80] ;
   BYTE *buffer;
   USHORT search_to_start_at, reserved_port_number = 0;
	USHORT def_protocol = 0x0006; /* TCP_PROTOCOL */


	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   selected_port = (PORT_LIST_form_output_type*)form_data_of_request(request); 
/*   selected_port = (TCP_LIST_form_output_type*)form_data_of_request(request);*/
   
/* sudha 23 Aug 1999 */
  	reserved_port_number = get_protocol_port_number(def_protocol, selected_port->port+1);
   sprintf(name, "%d", reserved_port_number);
/*   sprintf(name, "%d", port_names_lib[selected_port->port].port_number); */
   	
   buffer = malloc(strlen(ADD_APPLICATION_FILTER_data_ptr));

	if (buffer == NULL)
	{
		printf("Out Of memory to display page for Application Entry \n");
		return;
	}
 	strcpy(buffer, ADD_APPLICATION_FILTER_data_ptr);

   search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, 0);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void delete_the_proxy_server_filter(Request_t* request)
{
	BYTE index ;
	PARAMETER_NODE* node, *prev_first_node_of_the_page ;
	STRUCT_PROXY_FILTER proxy_filter ;
	STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	index = save_the_number_of_proxy_filter_being_edited(NULL, FALSE) ;
	if (index == 1)
	{
		prev_first_node_of_the_page = first_proxy_filter_of_the_current_page(NULL, FALSE) ;
		
    	if (filtering_action == APPLICATION_FILTER)
	    	node =  cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&application_filter) ;
      else
	    	node =  cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&proxy_filter) ;
		while (node != prev_first_node_of_the_page)
		{
    	   if (filtering_action == APPLICATION_FILTER)
	    	   node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&application_filter) ;
         else
	       	node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&proxy_filter) ;
		}
    	if (filtering_action == APPLICATION_FILTER)
	      node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&application_filter) ;
      else
	    	node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&proxy_filter) ;

		if (node)
			first_proxy_filter_of_the_current_page(node, TRUE) ;
	}
	remove_a_particular_proxy_filter(index) ;
	if (total_number_of_proxy_server_filters[filtering_action] == 0)
	{
		InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}
	InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void remove_a_particular_proxy_filter(USHORT index)
{
	STRUCT_PROXY_FILTER proxy_filter ;
	STRUCT_PROXY_ENTRY application_filter ;
	PARAMETER_NODE* last_displayed_proxy_server_filter ;

  	if (filtering_action == APPLICATION_FILTER)
   {    
     	application_filter = contents_of_application_filter_page[index-1] ;
      if (contents_of_application_filter_page[index-1].protocol == 6)
          application_filter.protocol = 0 ;
      else
          application_filter.protocol = 1 ;

	   if (cm_remove_string(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&application_filter) != CM_REMOVING_STRING_SUCCESSFUL)
	   {
		   printf("Failed to remove the Application Filter \n") ;
		   return ;
	   }
   }
   else
   {
      proxy_filter = contents_of_proxy_server_filter_page[index-1] ;
	   if (cm_remove_string(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&proxy_filter) != CM_REMOVING_STRING_SUCCESSFUL)
	   {
		   printf("Failed to remove the Proxy server Filter \n") ;
		   return ;
	   }
   }

	last_displayed_proxy_server_filter = next_proxy_filter_from_where_display_is_reqd_to_continue(NULL, FALSE) ;
	if (index == 10)
	{
		if (proxy_server_filters_till_current_page[filtering_action] == total_number_of_proxy_server_filters[filtering_action])
		{
			last_displayed_proxy_server_filter = last_displayed_proxy_server_filter->previous ;
			proxy_server_filters_till_current_page[filtering_action] -- ;
		}
		else
		{
			last_displayed_proxy_server_filter = last_displayed_proxy_server_filter->next ;
		}
	}
	else
	if (index == total_number_of_proxy_server_filters[filtering_action])
	{
			last_displayed_proxy_server_filter = last_displayed_proxy_server_filter->previous ;
			proxy_server_filters_till_current_page[filtering_action] -- ;
	}
	else
	if(proxy_server_filters_till_current_page[filtering_action] < 10)
	{
			proxy_server_filters_till_current_page[filtering_action] -- ;
	}
	next_proxy_filter_from_where_display_is_reqd_to_continue(last_displayed_proxy_server_filter, TRUE) ;
	total_number_of_proxy_server_filters[filtering_action] -- ;

	/* if the first node is deleted take care */
	if (total_number_of_proxy_server_filters[filtering_action] == 0)
	{
		ptr_to_start_of_filters[filtering_action] = NULL ;	
		return ;
	}
	if (proxy_server_filters_till_current_page[filtering_action]  <= 10 && index == 1)
	{
		 ptr_to_start_of_filters[filtering_action] = ptr_to_start_of_filters->next ;
	}
}

void display_proxy_server_filter_for_deleting(Request_t* request, STRUCT_PROXY_FILTER* proxy_server_filter)
{
	BYTE* buffer, i ;
	USHORT search_to_start_at ;
	USHORT dns_search_to_start_at ;

   if (filtering_action == DOMAIN_NAME_FILTER)
      buffer = malloc(strlen(DELETE_DNS_FILTER_data_ptr) + strlen (proxy_server_filter->addr)) ;
   else
    	buffer = malloc(strlen(DELETE_PROXY_SERVER_FILTER_data_ptr)) ;
   
	if (buffer == NULL)
	{
		printf("Out Of memory to display filter for deleting\n") ;
		return ;
	}
   if (filtering_action == DOMAIN_NAME_FILTER)
	{
     dns_search_to_start_at = search_and_replace ("#DNS#", " ", DELETE_DNS_FILTER_data_ptr, FALSE, 0) ;
     buffer[0] = 0 ;
     strncpy (buffer, DELETE_DNS_FILTER_data_ptr, dns_search_to_start_at) ;
     buffer[dns_search_to_start_at] = 0 ;
     strcat (buffer, proxy_server_filter->addr) ;
     strcat (buffer, (DELETE_DNS_FILTER_data_ptr + dns_search_to_start_at + SIZEOF_DNS_TEMPLATE)) ;
   }
   else
	{
      strcpy(buffer, DELETE_PROXY_SERVER_FILTER_data_ptr) ;
      check_for_filtering_type_to_replace_template(filter_name) ;
      search_to_start_at = search_and_replace("#____#____#____#_____#", filter_name, buffer, TRUE, 0) ; 
      search_to_start_at = search_and_replace("#___ADDRESS___#", proxy_server_filter->addr, buffer, TRUE, search_to_start_at) ; 
   }
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
	free(buffer) ;
}

void display_application_filter_for_deleting(Request_t* request, STRUCT_PROXY_ENTRY* application_filter)
{
	BYTE* buffer, i ;
	USHORT search_to_start_at ;
   char* protocol_string ;
   BYTE temp_buffer[100], app_type[50];

	buffer = malloc(strlen(DELETE_APPLICATION_FILTER_data_ptr)) ;
	if (buffer == NULL)
	{
		printf("Out Of memory to display a DELETE_APPLICATION_FILTER filter for deleting\n") ;
		return ;
	}
	strcpy(buffer, DELETE_APPLICATION_FILTER_data_ptr) ;

   if (application_filter->protocol == 0x0006)
      strcpy(temp_buffer, "TCP");
   else
      strcpy(temp_buffer, "UDP");

   search_to_start_at = search_and_replace("#___#", temp_buffer, buffer, TRUE, 0);

/* sudha 23 Aug 1999 */
	strcpy(app_type, get_port_type(app_type,application_filter->protocol,application_filter->port));
	sprintf(temp_buffer, "%s(%d)", app_type, application_filter->port);

   /* match_port_number_to_name(application_filter->port, temp_buffer);*/
	search_to_start_at = search_and_replace("#____#____#____PORT____#____#", temp_buffer, buffer, TRUE, search_to_start_at);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
	free(buffer) ;
}

void display_delete_proxy_server_filter_1(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[0] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[0] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(1, TRUE) ;
}

void display_delete_proxy_server_filter_2(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[1] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[1] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(2, TRUE) ;
}

void display_delete_proxy_server_filter_3(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[2] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[2] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(3, TRUE) ;
}

void display_delete_proxy_server_filter_4(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[3] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[3] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(4, TRUE) ;
}

void display_delete_proxy_server_filter_5(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[4] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[4] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(5, TRUE) ;
}

void display_delete_proxy_server_filter_6(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[5] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[5] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(6, TRUE) ;
}

void display_delete_proxy_server_filter_7(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[6] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[6] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(7, TRUE) ;
}

void display_delete_proxy_server_filter_8(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[7] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[7] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(8, TRUE) ;
}

void display_delete_proxy_server_filter_9(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[8] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[8] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(9, TRUE) ;
}

void display_delete_proxy_server_filter_10(Request_t* request)
{
	STRUCT_PROXY_FILTER  proxy_server_filter ;
   STRUCT_PROXY_ENTRY application_filter ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	if (filtering_action == APPLICATION_FILTER)
	{
      application_filter = contents_of_application_filter_page[9] ;
	   display_application_filter_for_deleting(request, &application_filter) ;
   }
   else
   {
      proxy_server_filter = contents_of_proxy_server_filter_page[9] ;
	   display_proxy_server_filter_for_deleting(request, &proxy_server_filter) ;
   }
	save_the_number_of_proxy_filter_being_edited(10, TRUE) ;
}

void display_next_ten_proxy_filters(Request_t* request)
{
	PARAMETER_NODE* temp_ptr ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	temp_ptr = next_proxy_filter_from_where_display_is_reqd_to_continue(NULL, FALSE) ;
	display_ten_proxy_filters_from(request, temp_ptr, TRUE) ;
}

void display_ten_proxy_filters_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page ;
	USHORT i, search_to_start_at = 0 ;
	STRUCT_PROXY_FILTER temp_proxy_server_filter ;
	STRUCT_PROXY_ENTRY application_filter ;
	PARAMETER_NODE* node, *prev_node ;
   static BYTE number_of_entries_read_in_the_current_node = 0 ;

	first_proxy_filter_of_the_current_page(starting_from, TRUE) ;

	if(proxy_server_filters_till_current_page[filtering_action] == total_number_of_proxy_server_filters[filtering_action])
	{
		InitReturnBuffer(request, PROXY_SERVER_FILTER_MENU_data_ptr, strlen(PROXY_SERVER_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
		return ;
	}

   if (filtering_action == APPLICATION_FILTER)
    	temp_page = malloc(strlen(VIEW_DELETE_APPLICATION_FILTER_data_ptr)) ;
   else
    	temp_page = malloc(strlen(VIEW_DELETE_PROXY_SERVER_FILTER_data_ptr)) ;

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display Filter list.\n") ;
		return ;
	}

   if (filtering_action == APPLICATION_FILTER)
	{
      strcpy(temp_page, VIEW_DELETE_APPLICATION_FILTER_data_ptr) ;
	   node =  cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&application_filter) ;
   }
   else
	{
      strcpy(temp_page, VIEW_DELETE_PROXY_SERVER_FILTER_data_ptr) ;
	   node =  cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_proxy_server_filter) ;
   }
	if (node == starting_from)
		number_of_entries_read_in_the_current_node = 0 ;
	while (node != starting_from)
	{
      if (filtering_action == APPLICATION_FILTER)
        node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&application_filter) ;
	   else	
         node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_server_filter) ;
	}
	if (number_of_entries_read_in_the_current_node)
	{
	  	for(i = 0 ; i < number_of_entries_read_in_the_current_node ; ++i)
		{
			if (!node)
				return ;
         if (filtering_action == APPLICATION_FILTER)
           node =  cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&application_filter) ;
          else
			     node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_server_filter) ;
		}
	}
	number_of_entries_read_in_the_current_node = 0 ;
	prev_node = starting_from ;

	for(i = 0 ; i < NUMBER_OF_ROUTES_PER_PAGE ; ++i)
	{
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at) ;
      if (filtering_action == APPLICATION_FILTER)
   	{
         search_to_start_at = modify_application_filter_template(temp_page, &application_filter, search_to_start_at) ;
         contents_of_application_filter_page[i] = application_filter ;
      }
      else
      {
         search_to_start_at = modify_proxy_server_filter_template(temp_page, &temp_proxy_server_filter, search_to_start_at) ;
		   contents_of_proxy_server_filter_page[i] =  temp_proxy_server_filter ;
      }
		proxy_server_filters_till_current_page[filtering_action]++ ;
		if ((proxy_server_filters_till_current_page[filtering_action] == total_number_of_proxy_server_filters[filtering_action] && is_displaying_next_page)
		    || (proxy_server_filters_till_current_page[filtering_action] == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_proxy_filter_from_where_display_is_reqd_to_continue(starting_from, TRUE) ;

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_proxy_filter_to_display(i+1, search_to_start_at, temp_page) ;
			if (is_displaying_next_page)
				search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
			else
			{
				/* while displaying if we each first page just remove back link */

				/* While displaying if reach first page if there are some more pages enable forward link else remove forward link */
				if (total_number_of_proxy_server_filters[filtering_action] > NUMBER_OF_ROUTES_PER_PAGE)
					enable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
				else
					disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
			}
			InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
			free(temp_page) ;
			return ;
		}
		if (is_displaying_next_page)
		{
      	if (filtering_action == APPLICATION_FILTER)
		     	starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&application_filter) ;
         else
		     	starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&temp_proxy_server_filter) ;
		}
		else
		{
  		   starting_from = cm_get_previous_entry(CM_PROXY_SECTION, starting_from, NULL) ;
  			proxy_server_filters_till_current_page[filtering_action]-- ;
		}
		if (prev_node == starting_from)
			number_of_entries_read_in_the_current_node ++ ;
		else
		{
         number_of_entries_read_in_the_current_node = 0 ;
         prev_node = starting_from ;
      }
		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_proxy_filter_to_display(i+1, search_to_start_at, temp_page) ;
			InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
			free(temp_page) ;
			return ;
		}
	}
      
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at) ;

	/* Save the lastly displayed node */
	next_proxy_filter_from_where_display_is_reqd_to_continue(starting_from, TRUE) ;

	/* Check if back link is required or not */
	/* Check if forward link is required or not */
	if (total_number_of_proxy_server_filters[filtering_action] > proxy_server_filters_till_current_page[filtering_action])
		search_to_start_at = enable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
	else
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;

	InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
	free(temp_page) ;
}

USHORT modify_proxy_server_filter_template(BYTE* buffer, STRUCT_PROXY_FILTER* proxy_filter, USHORT search_to_start_at)
{
     USHORT temp_loc ; 
	  int i,j ;
     BYTE* temp_buffer ;
     
     check_for_filtering_type_to_replace_template(filter_name) ;
     temp_loc = search_and_replace("#____#____#____#_____#", filter_name, buffer, TRUE, 0) ; 

     if (strlen (proxy_filter->addr) < 16)
     { 
       search_to_start_at = search_and_replace("#___ADDRESS___#", proxy_filter->addr, buffer, TRUE, search_to_start_at) ;
     }
     else
     {
        search_to_start_at = search_and_replace("#___ADDRESS___#", proxy_filter->addr, buffer, FALSE, search_to_start_at) ;
        for (i = 0; i < 6; i++)
          buffer[search_to_start_at++] = proxy_filter->addr[i] ;
        buffer[search_to_start_at] = 0 ;
        strcat (buffer, "...") ;
        search_to_start_at += 3 ; 
        j = strlen (proxy_filter->addr) ;
        for (i = 0; i < 6; i++)
          buffer[search_to_start_at++] = proxy_filter->addr[j - 6 + i] ; 
     }
      return (search_to_start_at) ;
}

USHORT modify_application_filter_template(BYTE* buffer, STRUCT_PROXY_ENTRY* application_filter, USHORT search_to_start_at)
{
   BYTE temp_buffer[100], app_type[50];

   if (application_filter->protocol == 0x0006) 
      strcpy(temp_buffer, "TCP");
   else
      strcpy(temp_buffer, "UDP");
     
   search_to_start_at = search_and_replace("#___#", temp_buffer, buffer, TRUE, search_to_start_at);

/* sudha 23 Aug 1999 */
	strcpy(app_type, get_port_type(app_type, application_filter->protocol,application_filter->port));
	sprintf(temp_buffer, "%s(%d)", app_type, application_filter->port);

/*     match_port_number_to_name(application_filter->port, temp_buffer); */
	search_to_start_at = search_and_replace("#____#____#____PORT____#____#", temp_buffer, buffer, TRUE, search_to_start_at) ;
   return (search_to_start_at) ;
}

USHORT get_the_number_of_proxy_filters()
{
	USHORT count = 0 ;
	PARAMETER_NODE* node ;
	STRUCT_PROXY_FILTER temp_proxy_server_filter ;

	node = cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_proxy_server_filter) ;
	while (node)
	{
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_server_filter) ;
		count ++ ;	
	}
	return count ;
}

USHORT get_the_number_of_application_filters()
{
	USHORT count = 0 ;
	PARAMETER_NODE* node ;
	STRUCT_PROXY_ENTRY temp_application_filter ;

	node = cm_get_first_entry(CM_PROXY_SECTION, filter_section_ptr[filtering_action], (void*)&temp_application_filter) ;
	while (node)
	{
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_application_filter) ;
		count ++ ;	                     
	}
	return count ;
}

void match_port_number_to_name(USHORT port_number, BYTE* name)
{
   BYTE i = 0;
/* sudha 23 Aug 1999 */
#if 0
   while (port_names_lib[i].port_number != 0)
   {
      if (port_number == port_names_lib[i].port_number)
      {
         sprintf(name, "%s(%d)", port_names_lib[i].name, port_names_lib[i].port_number);
         return;
      }
      i++;
   }
   sprintf(name, "%d", port_number);
#endif
}


USHORT hide_remaining_hyper_links_on_which_there_is_no_proxy_filter_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i ;
	BYTE comment_opened = FALSE ;
	for(i=0 ;i < NUMBER_OF_ROUTES_PER_PAGE - disable_starting_from ;++i)
	{
		comment_opened = TRUE ;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at) ;
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at) ;
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at) ;
		
	return search_to_start_at ;
}

BYTE save_the_number_of_proxy_filter_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte ;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte ;
	else
		return saved_byte ;
}

BYTE is_numeric_value(BYTE* buffer)
{
   BYTE i;
   for (i=0 ; i<strlen(buffer) ; ++i)
   {
      if (buffer[i] < '0' || buffer[i] > '9')
         return FALSE;
   }
   return TRUE;   
}

#if 0
BYTE is_valid_mac_hex_address(BYTE* string_ptr)
{
	BYTE i;

   if ( (strlen(string_ptr) < 1 ) || (strlen(string_ptr) > 12 ))
      return FALSE;
   if ( !strcmp(string_ptr,"000000000000"))
      return FALSE;
  	for(i=0;i<strlen(string_ptr);++i)
   {
	   if (string_ptr[i] < '0' || (string_ptr[i] > '9' && string_ptr[i] < 'A') || (string_ptr[i] > 'F' && string_ptr[i] < 'a') || string_ptr[i] > 'f')
  		{
   		return FALSE;
	   }
  	}
   return TRUE;
}

void format_mac_address_for_adding(BYTE* string_ptr)
{
	int string_length, i;
	char temp_buff[200] ;
	int number_of_zeros_to_be_inserted ;
	
	string_length = strlen(string_ptr);
	if (string_length == 12)
		return;
	memset (&temp_buff[0], '0', 200) ;

	number_of_zeros_to_be_inserted = 12 - string_length;

	for (i = number_of_zeros_to_be_inserted ; i < 12 ; i++)
		temp_buff[i] = string_ptr[i-number_of_zeros_to_be_inserted] ;
	temp_buff[12] = 0 ;

	strcpy(string_ptr, temp_buff);
}

BYTE check_if_is_valid_dns_address(BYTE* string_ptr)
{
   char *token;
   char temp_str[256];
   char delim = '.';
   int length = 0;
   
   if ((strlen(string_ptr) < 1) || (strlen(string_ptr) > 255))
      return FALSE;

   strcpy(temp_str,string_ptr);
   token = strtok ( temp_str,delim );
   while ( token != NULL )
   {
      if ( strlen(token) > 64 )
         return FALSE;
      else
      {
         length = length + strlen ( token ) + 1;
         token = strtok(&temp_str[length],delim);
      }
   }
   return TRUE;
}
#endif

void check_for_filtering_type_to_replace_template(char filter_name[25]) 
{
  switch(filtering_action)
  {
    case  IP_DEST_FILTER : strcpy(filter_name, "Destination IP Address") ;
                           break ;
    case  IP_SOURCE_FILTER : strcpy(filter_name, "Source IP Address") ;
                              break ;
    case  MAC_ADDRESS_FILTER : strcpy(filter_name, "MAC Address") ;
                               break ;
    case  DOMAIN_NAME_FILTER : strcpy(filter_name, "Domain Name") ;
                               break ;
    case  APPLICATION_FILTER : strcpy(filter_name, "Proxy Application Filter") ;
                               break ;

  }
}

PARAMETER_NODE* next_proxy_filter_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node ;

	if (is_required_to_save)
		saved_node = last_node ;
	else
		return saved_node ;
} 

PARAMETER_NODE* first_proxy_filter_of_the_current_page(PARAMETER_NODE* new_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node ;

	if (is_required_to_save)
		saved_node = new_node ;
	else
		return saved_node ;
}

