#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"


#if 0
#include "addstat.h"
#include "editstat.h"
#include "vedstat.h"
/*#include "vedsrfm.h"*/
#include "statrout.h"
#include "edstatfm.h"
#include "addsrfm.h"
#endif

#include "statrtm.h"
#include "statrt.h"
#include "edtstat.h"
#include "vstatrt.h"
#include "strtfm.h"
#include "edtstfm.h"
#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern BYTE*   templates[];
/*...Extern Decleration*/

/* Local ProtoType ...*/
void display_the_static_route_for_editing(Request_t* request, STRUCT_STATIC_ROUTE* static_route);
void display_ten_static_routes_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page);
void display_prev_ten_static_routes(Request_t* request);
void display_next_ten_static_routes(Request_t* request);
void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node);
USHORT modify_the_template(BYTE* buffer, STRUCT_STATIC_ROUTE* static_route, USHORT search_to_start_at);
/*PARAMETER_NODE* get_the_pointer_to_start_of_static_routes();*/
USHORT get_the_number_of_static_routes();
void change_the_edited_static_route(Request_t* request);
USHORT hide_remaining_hyper_links_on_which_there_is_no_static_route_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer);

void go_back_to_static_route_listing_page(Request_t* request);
BYTE save_the_number_of_static_route_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save);
USHORT enable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT enable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
BYTE save_whether_next_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
BYTE save_whether_prev_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
PARAMETER_NODE* next_static_route_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save);
void remove_a_perticular_static_route(USHORT index);





/* ... Local ProtoType*/

PARAMETER_NODE* ptr_to_start_of_static_routes, *ptr_to_first_static_route_of_current_page;
USHORT static_routes_till_current_page = 0, total_static_routes = 0;
STRUCT_STATIC_ROUTE contents_of_page[NUMBER_OF_ROUTES_PER_PAGE];

extern BYTE *get_physical_port(USHORT port_number);

void display_static_route_menu(Request_t* request)
{
	BYTE rhs_string[200];  
	

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	ptr_to_first_static_route_of_current_page = ptr_to_start_of_static_routes = cm_get_first_entry(CM_IP_SECTION, "IP Static Route Table Entries", NULL);
	static_routes_till_current_page = 0;
	if (ptr_to_start_of_static_routes)
		total_static_routes = get_the_number_of_static_routes();
	InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_add_static_route_form (Request_t* request)
{
   byte* buffer ;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	buffer = (BYTE*)malloc(strlen(ADD_STATIC_ROUTE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Add Static Routes Page\n");
		return;
	} 	
	strcpy(buffer, ADD_STATIC_ROUTE_data_ptr);


   if((web.model_number == 5) || (web.model_number == 6))
	{
	  search_and_replace("S1", "<!--", buffer, TRUE, 0);
	  search_and_replace("E1", "-->", buffer, TRUE, 0);

	}
   else
	{
	  search_and_replace("S1", "", buffer, TRUE, 0);
	  search_and_replace("E1", "", buffer, TRUE, 0);

	}

   if((web.model_number == 5) || (web.model_number == 6) || (web.model_number == 7))
	{
	  search_and_replace("S2", "<!--", buffer, TRUE, 0);
	  search_and_replace("E2", "-->", buffer, TRUE, 0);
	}
   else
	{
	  search_and_replace("S2", "", buffer, TRUE, 0);
	  search_and_replace("E2", "", buffer, TRUE, 0);
	}

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

void display_ved_static_routes_page(Request_t* request)
{
      
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (!total_static_routes)
	{
		InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;	
	}
	static_routes_till_current_page = 0;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE);
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE);
	next_static_route_from_where_display_is_reqd_to_continue(ptr_to_start_of_static_routes, TRUE);
	display_next_ten_static_routes(request);
}

void add_the_static_route(Request_t* request)
{
	PARAMETER_NODE* new_node;
	ADD_STATIC_ROUTE_form_output_type*  static_route_to_add;
	BYTE temp_string[200];
	STRUCT_STATIC_ROUTE static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route_to_add = (ADD_STATIC_ROUTE_form_output_type*) form_data_of_request(request);

	strcpy(static_route.ip_address, static_route_to_add->ip_address);
	strcpy(static_route.gateway_address, static_route_to_add->gateway_address);
	strcpy(static_route.address_mask, static_route_to_add->ip_address_mask);
	strcpy(static_route.metric, static_route_to_add->metric);
	static_route.port = (USHORT) static_route_to_add->port;

	new_node = cm_insert_string(CM_IP_SECTION, "IP Static Route Table Entries", (void*)&static_route);
	if (new_node == NULL)
	{
		printf("Failed to Insert the Static Route\n");
		InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if (ptr_to_start_of_static_routes == NULL)
		ptr_to_first_static_route_of_current_page = ptr_to_start_of_static_routes = new_node;
	total_static_routes++;
	InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void delete_the_static_route(Request_t* request)
{
	BYTE index;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	index = save_the_number_of_static_route_being_edited(NULL, FALSE);
	remove_a_perticular_static_route(index);
	if (total_static_routes == 0)
	{
		InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
/* sudha 01 Sep 1999 */
	/* go_back_to_static_route_listing_page(request);*/
	InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void remove_a_perticular_static_route(USHORT index)
{
	BYTE buffer[200];
	STRUCT_STATIC_ROUTE static_route;
	PARAMETER_NODE* last_displayed_static_route;

	static_route = contents_of_page[index-1];
	if (cm_remove_string(CM_IP_SECTION, "IP Static Route Table Entries", (void*)&static_route) != CM_REMOVING_STRING_SUCCESSFUL)
	{
		printf("Failed to remove the static route\n");
		return;
	}

	last_displayed_static_route = next_static_route_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (index == 10)
	{
		if (static_routes_till_current_page == total_static_routes)
		{
			last_displayed_static_route = last_displayed_static_route->previous;
			static_routes_till_current_page --;
		}
		else
		{
			last_displayed_static_route = last_displayed_static_route->next;
		}
	}
	else
	if (index == total_static_routes)
	{
			last_displayed_static_route = last_displayed_static_route->previous;
			static_routes_till_current_page --;
	}
	else
	if(static_routes_till_current_page < 10)
	{
			static_routes_till_current_page --;
	}
	next_static_route_from_where_display_is_reqd_to_continue(last_displayed_static_route, TRUE);
	total_static_routes --;

	/* if the first node is deleted take care */
	if (total_static_routes == 0)
	{
		ptr_to_start_of_static_routes = NULL;	
		return;
	}
	if (static_routes_till_current_page  <= 10 && index == 1)
	{
		 ptr_to_start_of_static_routes = ptr_to_start_of_static_routes->next;
	}
}

void delete_selected_static_routes(Request_t* request)
{
#if 0
	PARAMETER_NODE* temp_node;
	USHORT i;
	BYTE is_next_node_deleted = FALSE;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if(static_routes_to_delete->check_box_10)
	{
		 remove_a_perticular_static_route(10);
	}
	if(static_routes_to_delete->check_box_9)
	{
		 remove_a_perticular_static_route(9);
	}
	if(static_routes_to_delete->check_box_8)
	{
		 remove_a_perticular_static_route(8);
	}
	if(static_routes_to_delete->check_box_7)
	{
		 remove_a_perticular_static_route(7);
	}
	if(static_routes_to_delete->check_box_6)
	{				  
		 remove_a_perticular_static_route(6);
	}
	if(static_routes_to_delete->check_box_5)
	{
		 remove_a_perticular_static_route(5);
	}
	if(static_routes_to_delete->check_box_4)
	{
		 remove_a_perticular_static_route(4);
	}
	if(static_routes_to_delete->check_box_3)
	{
		 remove_a_perticular_static_route(3);
	}
	if(static_routes_to_delete->check_box_2)
	{
		 remove_a_perticular_static_route(2);
	}
	if(static_routes_to_delete->check_box_1)
	{
		 remove_a_perticular_static_route(1);
	}
	InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);*/
#endif
}

void delete_the_node_from_linked_list()
{
#if 0
  PARAMETER_NODE* temp_node, *node_to_delete;

	temp_node = ptr_to_first_static_route_of_current_page;
	for(i=0;i<static_route_index_in_the_page;++i)
		temp_node = temp_node->next;
	node_to_delete = temp_node;
	temp_node = temp_node->next;
	if(ptr_to_first_static_route_of_current_page == NULL)
	{
		temp_node->previous->next = NULL;
		ptr_to_first_static_route_of_current_page = ptr_to_first_static_route_of_current_page->previous;
	}
	else
	{
		temp_node->previous->next = ptr_to_first_static_route_of_current_page;
		ptr_to_first_static_route_of_current_page->previous = temp_node->previous;
	}
	free(temp_node);
	total_static_routes--;
	is_next_node_deleted = TRUE;
#endif
}

void display_the_static_route_for_editing(Request_t* request, STRUCT_STATIC_ROUTE* static_route)
{
	BYTE* buffer;
	USHORT search_to_start_at = 0;
	int index;
   USHORT temp;

	buffer = malloc(strlen(EDIT_STATIC_ROUTE_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display a static route for editing\n");
		return;
	}
	strcpy(buffer, EDIT_STATIC_ROUTE_data_ptr);

   if((web.model_number == 5) || (web.model_number == 6))
	{
	  search_and_replace("S1", "<!--", buffer, TRUE, 0);
	  search_and_replace("E1", "-->", buffer, TRUE, 0);
	}
   else
	{
	  search_and_replace("S1", "", buffer, TRUE, 0);
	  search_and_replace("E1", "", buffer, TRUE, 0);
	}
   
	if((web.model_number == 5) || (web.model_number == 6) || (web.model_number == 7))
	{
	  search_and_replace("S2", "<!--", buffer, TRUE, 0);
	  search_and_replace("E2", "-->", buffer, TRUE, 0);
	}
   else
	{
	  search_and_replace("S2", "", buffer, TRUE, 0);
	  search_and_replace("E2", "", buffer, TRUE, 0);
	}

   for(index=0;index < static_route->port; ++index)
   {
   	temp = search_and_replace(templates[ENUM_MENU], " ", buffer, FALSE, search_to_start_at);
   	search_to_start_at = temp;
   }
	search_to_start_at = search_and_replace(templates[ENUM_MENU], "selected", buffer, TRUE, search_to_start_at);
	
	search_to_start_at = search_and_replace(templates[ENUM_STATIC_IP_ADDRESS], static_route->ip_address, buffer, TRUE, 0);
	search_to_start_at = search_and_replace(templates[ENUM_ADDRESS_MASK], static_route->address_mask, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(templates[ENUM_GATEWAY_ADDRESS], static_route->gateway_address, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(templates[ENUM_METRIC], static_route->metric, buffer, TRUE, search_to_start_at);

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_edit_static_route_1(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;
	int index;
   USHORT temp;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[0];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(1, TRUE);
}

void display_edit_static_route_2(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[1];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(2, TRUE);
}

void display_edit_static_route_3(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[2];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(3, TRUE);
}

void display_edit_static_route_4(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[3];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(4, TRUE);
}

void display_edit_static_route_5(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[4];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(5, TRUE);
}

void display_edit_static_route_6(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[5];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(6, TRUE);
}

void display_edit_static_route_7(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[6];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(7, TRUE);
}

void display_edit_static_route_8(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[7];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(8, TRUE);
}

void display_edit_static_route_9(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[8];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(9, TRUE);
}

void display_edit_static_route_10(Request_t* request)
{
	STRUCT_STATIC_ROUTE  static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	static_route = contents_of_page[9];
	display_the_static_route_for_editing(request, &static_route);
	save_the_number_of_static_route_being_edited(10, TRUE);
}

void display_next_ten_static_routes(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;
	USHORT i;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_static_route_from_where_display_is_reqd_to_continue(NULL, FALSE);
	display_ten_static_routes_from(request, temp_ptr, TRUE);
}

void display_prev_ten_static_routes(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;
	USHORT i;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_static_route_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (static_routes_till_current_page <= 2*NUMBER_OF_ROUTES_PER_PAGE)
	{
		for(i=1;i<static_routes_till_current_page;++i)
		{
			temp_ptr = cm_get_previous_entry(CM_IP_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		static_routes_till_current_page = 0;
	}
	else
	{
		for(i=1;i<NUMBER_OF_ROUTES_PER_PAGE+(static_routes_till_current_page%NUMBER_OF_ROUTES_PER_PAGE?static_routes_till_current_page:NUMBER_OF_ROUTES_PER_PAGE);++i)
		{
			temp_ptr = cm_get_previous_entry(CM_IP_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		static_routes_till_current_page -= (NUMBER_OF_ROUTES_PER_PAGE+(static_routes_till_current_page%NUMBER_OF_ROUTES_PER_PAGE?static_routes_till_current_page:NUMBER_OF_ROUTES_PER_PAGE));
	}
	display_ten_static_routes_from(request, temp_ptr, TRUE);
}

void display_ten_static_routes_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page, buffer[100];
	USHORT i, j, k, search_to_start_at = 0;
	STRUCT_STATIC_ROUTE temp_ip_struct;
	BYTE port[10];

	if(static_routes_till_current_page  == total_static_routes)
	{
		InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	temp_page = malloc(strlen(VIEW_EDIT_DEL_STATIC_ROUTE_data_ptr));

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display static routes list.\n");
		return;
	}

	strcpy(temp_page, VIEW_EDIT_DEL_STATIC_ROUTE_data_ptr);
	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE;++i)
	{
		get_rhs_string(buffer, starting_from);

		j = k = 0;
		while(buffer[j] != ',')
		{
			temp_ip_struct.ip_address[k++] = buffer[j++];
		}
		temp_ip_struct.ip_address[k] = 0;

		k = 0;
		j++;
		while(buffer[j] != ',')
		{
			temp_ip_struct.gateway_address[k++] = buffer[j++];
		}
		temp_ip_struct.gateway_address[k] = 0;

		k = 0;
		j++;
		while(buffer[j] != ',')
		{
			temp_ip_struct.address_mask[k++] = buffer[j++];
		}
		temp_ip_struct.address_mask[k] = 0;

		k = 0;
		j++;
		while(buffer[j] != ',')
		{
			temp_ip_struct.metric[k++] = buffer[j++];
		}
		temp_ip_struct.metric[k] = 0;

		k = 0;
		j++;
		while(buffer[j] != '\0' && buffer[j] != ';')
		{
			port[k++] = buffer[j++];
		}
		port[k] = 0;

		temp_ip_struct.port = (USHORT) atoi (port);

		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
		search_to_start_at = modify_the_template(temp_page, &temp_ip_struct, search_to_start_at);
		contents_of_page[i] =  temp_ip_struct;
/*		if (i == 0)
			static_routes_till_current_page = 1;*/

		static_routes_till_current_page++;
		if ((static_routes_till_current_page  == total_static_routes && is_displaying_next_page)
		    || (static_routes_till_current_page  == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_static_route_from_where_display_is_reqd_to_continue(starting_from, TRUE);

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_static_route_to_display(i+1, search_to_start_at, temp_page);
			if (is_displaying_next_page)
			{
#if 0
				/* if some static routes in the previous page enable the link hence disable */
				if (static_routes_till_current_page > NUMBER_OF_ROUTES_PER_PAGE)
/*					enable_the_link_to_display_prev_10(temp_page, search_to_start_at);*/
				{
					search_to_start_at = search_and_replace("<A", "     ", temp_page, FALSE, search_to_start_at);
				}
				else
					search_to_start_at = disable_the_link_to_display_prev_10(temp_page, search_to_start_at);
#endif
	         search_to_start_at = disable_the_link_to_display_prev_10(temp_page, search_to_start_at);

				/* No More static routes are there hence remove the link */
				search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			else
			{
				/* while displaying if we each first page just remove back link */
				disable_the_link_to_display_prev_10(temp_page, search_to_start_at);
				/* While displaying if reach first page if there are some more pages enable forward link else remove forward link */
				if (total_static_routes > NUMBER_OF_ROUTES_PER_PAGE)
					enable_the_link_to_display_next_10(temp_page, search_to_start_at);
				else
					disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_STATIC_ROUTE_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
		if (is_displaying_next_page)
		{
			starting_from = cm_get_next_entry(CM_IP_SECTION, starting_from, NULL);
/*			static_routes_till_current_page++;*/
		}
		else
		{
			starting_from = cm_get_previous_entry(CM_IP_SECTION, starting_from, NULL);
			static_routes_till_current_page--;
		}
		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_static_route_to_display(i+1, search_to_start_at, temp_page);
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_STATIC_ROUTE_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
	}
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at);

	/* Save the lastly displayed node */
	next_static_route_from_where_display_is_reqd_to_continue(starting_from, TRUE);

	search_to_start_at = disable_the_link_to_display_prev_10(temp_page, search_to_start_at);
#if 0
	/* Check if back link is required or not */
	if (static_routes_till_current_page <= NUMBER_OF_ROUTES_PER_PAGE)
		search_to_start_at = disable_the_link_to_display_prev_10(temp_page, search_to_start_at);
	else
		search_to_start_at = search_and_replace("<A", "     ", temp_page, FALSE, search_to_start_at);
#endif

	/* Check if forward link is required or not */
	if (total_static_routes > static_routes_till_current_page)
		search_to_start_at = enable_the_link_to_display_next_10(temp_page, search_to_start_at);
	else
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);

	InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_STATIC_ROUTE_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(temp_page);
}

void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node)
{
	USHORT i=0, j=0;

	if (node == NULL)
	{
		buffer[0] = 0;
		return;
	}

	while(node->parameter[i] != '=')
	{
		++i;
	}
  	i+=2;
	while(node->parameter[i] != '\0' &&	node->parameter[i] != '\n' && node->parameter[i] != '\r')
		buffer[j++] = node->parameter[i++];
  buffer[j] = 0;
}

USHORT modify_the_template(BYTE* buffer, STRUCT_STATIC_ROUTE* static_route, USHORT search_to_start_at)
{
	BYTE port[10], ip_address[20], gateway_address[20];

	strcpy(port,get_physical_port(static_route->port));
	if (static_route->port != 0) /* Other than LAN port */
	{
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, static_route->port, CM_STRING_FORMAT, (void*)ip_address, 20);
		if (strcmp(ip_address, "0.0.0.0") == 0)
			strcpy(static_route->gateway_address, "ISP_Assigned");
	}

	search_to_start_at = search_and_replace(templates[ENUM_STATIC_IP_ADDRESS], static_route->ip_address, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(templates[ENUM_ADDRESS_MASK], static_route->address_mask, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(templates[ENUM_GATEWAY_ADDRESS], static_route->gateway_address, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(templates[ENUM_METRIC], static_route->metric, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#_P__", port, buffer, TRUE, search_to_start_at);

	return (search_to_start_at);
}

#if 0
PARAMETER_NODE* get_the_pointer_to_start_of_static_routes()
{
	PARAMETER_NODE* node, *start_of_ipx_section;
	USHORT i = 0;
	BYTE lhs_string[100];

	start_of_ipx_section = node = sptr_to_ptr_to_sections[IPX_SECTION];
	node = node->previous;
	while (node <= sptr_to_ptr_to_sections[IP_SECTION])
	{
		i = 0;
		while(node->parameter[i] != '=')
		{
		  lhs_string[i] = node->parameter[i];
		  ++i;
		}
		lhs_string[i-1] = 0;
		if (!strcmp(lhs_string, "IP Port BOOTP"))
		{
			if (node->next == start_of_ipx_section)
			{
				return(NULL);
			}
			return(node->next);
		}
		node = node->previous;
	}
}
#endif

USHORT get_the_number_of_static_routes()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	BYTE rhs_string[200];
	node = cm_get_first_entry(CM_IP_SECTION, "IP Static Route Table Entries", NULL);
	while (node)
	{
		node = cm_get_next_entry(CM_IP_SECTION, node, NULL);
		count ++;	
	}
	return count;
}

void change_the_edited_static_route(Request_t* request)
{
	CHANGE_THE_STATIC_ROUTE_form_output_type* edited_static_route;
	BYTE edited_static_route_index, previous_rhs[200], new_rhs[200];
	enum CM_EDIT_STRING_RESULTS result;
	STRUCT_STATIC_ROUTE new_static_route, old_static_route;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	edited_static_route = (CHANGE_THE_STATIC_ROUTE_form_output_type*)form_data_of_request(request);

	if (!strcmp(edited_static_route->delete_entry, "Delete"))
	{
		delete_the_static_route(request);
		return;
	}
	edited_static_route_index = save_the_number_of_static_route_being_edited(NULL, FALSE);
	old_static_route = contents_of_page[edited_static_route_index-1];
	strcpy(previous_rhs, contents_of_page[edited_static_route_index-1].ip_address);
	strcat(previous_rhs, ",");
	strcat(previous_rhs, contents_of_page[edited_static_route_index-1].gateway_address);
	strcat(previous_rhs, ",");
	strcat(previous_rhs, contents_of_page[edited_static_route_index-1].address_mask);
	strcat(previous_rhs, ",");
	strcat(previous_rhs, contents_of_page[edited_static_route_index-1].metric);
	strcat(previous_rhs, ",");
	strcat(previous_rhs, contents_of_page[edited_static_route_index-1].port);
								  
	strcpy(new_static_route.ip_address, edited_static_route->ip_address);
	strcpy(new_static_route.gateway_address, edited_static_route->gateway_address);
	strcpy(new_static_route.address_mask, edited_static_route->ip_address_mask);
	strcpy(new_static_route.metric, edited_static_route->metric);
	new_static_route.port = (USHORT) edited_static_route->port;

    result = cm_edit_string(CM_IP_SECTION, "IP Static Route Table Entries", (void*)&old_static_route, (void*)&new_static_route);
	 if (result != CM_STRING_EDIT_SUCCESSFUL)
	 {
	 	printf("Configuration manager refused to make the changes \n");
	 }
/*	 go_back_to_static_route_listing_page(request); */
	InitReturnBuffer(request, STATIC_ROUTE_MENU_data_ptr, strlen(STATIC_ROUTE_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);

}

USHORT hide_remaining_hyper_links_on_which_there_is_no_static_route_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i;
	BYTE comment_opened = FALSE;
	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE - disable_starting_from;++i)
	{
		comment_opened = TRUE;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at);
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at);
		
	return search_to_start_at;
}

BYTE save_the_number_of_static_route_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte;
	else
		return saved_byte;
}

void go_back_to_static_route_listing_page(Request_t* request)
{
	PARAMETER_NODE* temp_node;
	BYTE i, temp, index;
	temp_node = next_static_route_from_where_display_is_reqd_to_continue(NULL, FALSE);

	index = (static_routes_till_current_page%10)?static_routes_till_current_page:NUMBER_OF_ROUTES_PER_PAGE;
	for(i=1;i<index;++i)
		temp_node = temp_node->previous;

	static_routes_till_current_page -= ((static_routes_till_current_page%10)?static_routes_till_current_page:NUMBER_OF_ROUTES_PER_PAGE);
		
	next_static_route_from_where_display_is_reqd_to_continue(temp_node, TRUE);
	display_next_ten_static_routes(request);
}



PARAMETER_NODE* next_static_route_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = last_node;
	else
		return saved_node;
} 
