#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/


#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"


#include "\rtrware\store\boot.h"
extern WEB_CLASS web;

/* Jyothi : 19/2/98 */
#include "\rtrware\include\udb.h"
#include "pppudb.h"
#include "\rtrware\rwutils\log.h"
#include "\rtrware\include\logif.h"
/* Jyothi : 19/2/98 */

ParseResults_t error_return = 
  { ATTACH_PROCESS_FUNCTION,  InitReturnUrlWasNotFound  , NULL } ;

/* Jyothi */
#include "weburl.h"
#include "welcome.h"
#include "blank.h"
#include "blpage.h"
#include "mainpage.h"
#include "display.h"
#include "frames.h"
#include "logpage.h"
/* Jyothi */

#include "advanppp.h"
#include "mlpppmsg.h"

#include "ip.h"
#include "advanip.h"

/* #include "ipx.h"
#include "advanipx.h"
#include "spantree.h" */

#include "wan.h"

#include "editisdn.h"
#include "edisdnfm.h"


#include "applicat.h"
#include "ppp.h"
#include "filtmenu.h"
#include "backlogo.h"
#include "mtslogo.h"
#include "mtrlogo.h"

#include "adnpppfm.h"
#include "ipfm.h"
#include "advnipfm.h"

/* #include "ipxfm.h"
#include "adipxfm.h"
#include "spatrefm.h" */
 
#include "wanfm.h"
/* #include "snmpfm.h" */
#include "appfm.h"
#include "pppfm.h"

#include "wanmsg.h" /* sudha 03 June 1999 */

#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"



/* Extern declerations ...*/
extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern void		free_linked_list(PARAMETER_NODE* root);
extern void 	initialize_ip_params();
extern void 	get_the_values_for_the_port(BYTE port_number, struct_ip_config* port_values);

extern void  	initialize_spantree_params();
extern void  	initialize_wan_params();
extern void  	initialize_snmp_params();
extern void  	initialize_app_params();
extern USHORT 	get_value_and_handle_error_1(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_2(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_3(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_4(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_5(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_6(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_7(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_8(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_9(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_10(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_11(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_12(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
extern USHORT  get_value_and_handle_error_13(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
/* Imran, 10/2/99 */
extern USHORT get_value_and_handle_error_14(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);
/* sudha 31 May 1999 */
extern USHORT get_value_and_handle_error_15(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, BYTE* string, USHORT search_to_start_at, BYTE* buffer);

extern void    set_value_and_handle_error_1(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, void* new_value, BYTE* string);
extern void    set_value_and_handle_error_2(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, void* new_value, BYTE* string);
extern void    set_value_and_handle_error_3(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, void* new_value, BYTE* string);
extern void    set_value_and_handle_error_4(enum CM_SECTIONS section_ID, BYTE* parameter_ID, BYTE port_number, void* new_value, BYTE* string);
extern void    set_value_and_handle_error_5(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, void* new_value, BYTE* string);
extern void    set_value_and_handle_error_6(enum CM_SECTIONS section_ID, void* parameter_ID, BYTE port_number, void* new_value, BYTE* string);

extern enum CM_WRITE_RESULTS cm_write_configuration();
extern void cm_deinitialize_configuration_manager(enum CM_AGENT_TYPE agent_type);
extern void decrypt (char *src, char *dest) ;
extern void encrypt (char *src, char *dest) ;
extern BYTE *to_upper_string (BYTE*);
extern void append_quotes(BYTE* buffer);

/* Jyothi : functions that support user database */

extern enum TEST initialize_user_database () ;
extern void clean_udb () ;
extern enum UDB_MODIFY udb_initialize () ;

extern enum BOOLEAN user_database_updated ;
extern enum BOOLEAN udb_handler_inited ;

/* Jyothi : functions that support log event */

extern int open_log(void) ;
extern int read_log(int log_descriptor, char *buffer, int count) ;
extern int close_log(int log_descriptor) ;
extern int get_info_log(int *approx_total_size, int *approx_number_of_msgs) ;
extern void set_ftp_port_numbers_during_init(); /* sudha 19 Aug 1999 */


/* ... Extern Declerations*/

/* Local Prototypes ... */

void     display_welcome_page(Request_t* request) ;
void     display_standard_main_page(Request_t* request) ;
void     display_framed_or_standard_main_page(Request_t* request) ;
void     display_main_page(Request_t* request) ;
void     display_framed_main_page(Request_t* request) ;
void     display_log_page(Request_t* request) ;
void     display_blank_page(Request_t * request) ;
void     display_frames_blank_page(Request_t * request) ;

void 		fill_the_ip_form_with_appropriate_values(char* outputbuffer, BYTE port_number);
int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
void 		revert_back_form(char* buffer);
void 		replace_string_starting_from_index(BYTE* search_string, USHORT search_string_starting_index, char* replace_string, char* buffer);
USHORT 	disable_hyperlink_and_change_text_colour(USHORT port_type, BYTE* buffer);
void 		display_ip_page(Request_t* request, BYTE* buffer, BYTE port_number);
void 		check_for_need_and_hide_irrelevent_fields();
void 		show_the_hidden_fields();
void 		enable_hyperlink(USHORT replaced_anchor_index_in_the_buffer, BYTE* buffer);
void		make_changes_to_corresponding_port(enum ip_port_types config_port, void* ip_changed_params);
void 		display_advanced_ip_page(Request_t* request);
void 		send_advanced_ip_page(Request_t* request, BYTE* buffer);
void 		fill_the_advanced_ip_form_with_appropriate_values(BYTE* buffer);
void	   make_changes_to_corresponding_port(enum ip_port_types config_port, CHANGE_IP_PARAMS_form_output_type* ip_changed_params);
void 		make_changes_to_advanced_config(CHANGE_ADVANCED_IP_PARAMS_form_output_type* advanced_ip_changed_params);
void 		save_the_value_from_ip_form(CHANGE_IP_PARAMS_form_output_type* ip_changed_params, BYTE port_number);


void		fill_the_wan_form_with_appropriate_values(BYTE* buffer, BYTE port_number );
void		make_changes_to_corresponding_wan_port(enum wan_port_types wan_config_port, CHANGE_WAN_PARAMS_form_output_type* wan_changed_params);
void  	save_the_values_from_wan_form(CHANGE_WAN_PARAMS_form_output_type* wan_changed_params, BYTE port_number);

void display_isdn_page(Request_t* request) ;
void	fill_the_isdn_form_with_appropriate_values(BYTE* buffer, BYTE wan_port_number) ;
void change_isdn_parameters(Request_t* request) ;
void save_the_value_from_isdn_form(CHANGE_ISDN_PARAMS_form_output_type* isdn_changed_params) ;

void 		fill_the_application_form_with_appropriate_values(BYTE* buffer);
void 		make_changes_to_corresponding_app_port(CHANGE_APPLICATION_PARAMS_form_output_type* app_changed_params);
void 		display_wan_page(Request_t* request, BYTE* buffer, BYTE port_number);
void 		convert_to_lower_case(BYTE* the_string);
void 		display_filter_menu(Request_t* request);

PARAMETER_NODE* read_setup_and_build_linked_list_for_each_line(BYTE* start_of_cfg);
void  display_ppp_cfg_page_for_wan1(Request_t* request);
void  display_ppp_cfg_page_for_wan2(Request_t* request);
void  display_ppp_cfg_page_for_wan3(Request_t* request);
void 	display_ppp_page(Request_t* request, BYTE* buffer, BYTE port_number);
void 	fill_the_ppp_form_with_appropriate_values(BYTE* buffer, BYTE port_number);
void 	change_the_ppp_parameters(Request_t* request);
void 	make_changes_to_corresponding_ppp_port(enum wan_port_types ppp_config_port, CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params);
void  save_the_values_from_ppp_form(CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params, BYTE port_number);
void	display_ppp_advanced_page(Request_t* request);
void	send_advanced_ppp_page(Request_t* request, BYTE* buffer);
void	fill_the_advanced_ppp_form_with_appropriate_values(BYTE* buffer);
void  display_mlppp_message(Request_t* request) ;
void 	change_advanced_ppp_parameters(Request_t* request);
void 	make_changes_to_advanced_ppp_config(CHANGE_ADVAN_PPP_CONFIG_PAGE_form_output_type* advanced_ppp_changed_params);
void	old_default_route(BYTE* ip_address, BYTE* metric, BYTE is_to_save);
BYTE  local_ip_address_and_remote_ip_address_belong_to_the_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* local_mask, BYTE* remote_mask) ;
void  check_for_model_number_and_replace (BYTE* buffer) ;
void  check_for_model_number_and_replace_link_control(BYTE* buffer, BYTE port_number) ;
BYTE  check_if_is_numeric_value(BYTE* buffer) ;
BYTE  get_wan_port_number()  ;

void display_wan_ras_message(Request_t* request) ;

/* ... Local Prototypes */

BYTE current_process_is_reading_setup;

/* ... End of Global Variable Decleration which will interact with forms*/

BYTE ip_node_address[15];
int  if_standard_or_frames=0 ;
SAVE_INDEX_STRUCT  		saved_indices[50];
USHORT             		number_of_saved_indices; 
enum ip_port_types		ip_config_port;
enum wan_port_types 		wan_config_port;
enum wan_port_types		ppp_config_port;

BYTE* templates[] = {"#__CBOX", "#___TEXT___#___", "#___STATIC_TEXT","#_SELECT", "#__CBOX", "#___IP__ADDRESS", "#___GATEWAY_ADD", "#___IP_ADD_MASK", "#_M_", "###___###___###___###___###___$", "#___TEXT___#___#___TEXT___#___#___TEXT___#___", "#___TEXT___#___#___TEXT___#___#___TEXT___#___TEXT___#___TEXT___#"};

PARAMETER_NODE* sptr_to_ptr_to_sections[20];
					
BYTE index_to_sections;
#define BUFFER_SIZE     1024 
#define SIZEOF_TEMPLATE 9 
#define EXTRA_MSG_SIZE  25
#define NUMBER_OF_BYTES_IN_IP_ADDRESS  15

BYTE wan_port_number ;
int USType = 0 ;


BYTE check_whether_user_is_authenticated_or_not(Request_t* request)
{
	enum CM_INIT_RESULTS  init_result;
	BYTE encrypted_password[50], buffer[20], temp_password[50];
	BYTE bptr_not_enough_memory[] = "Not enough Memory to Initialize Configuration Manager \n";
	BYTE bptr_owned_by_other[200];
   BYTE notification[] = "Configuration manager deinitialized after expiry of idle timer. You must restart ...";
          
	if( request->params.authorization.scheme == BASIC_AUTHORIZATION ) 
	{
      strcpy(temp_password, request->params.authorization.password);
		encrypt(to_upper_string(temp_password), encrypted_password);
		if(strcmpi(request->params.authorization.user_name, "supervisor") == 0 && (strcmpi(encrypted_password, telnet.password) == 0)) 
		{
         if (web.configuration_manager_deinitialized == TRUE && (web.address_in_the_process_of_configuring == request->client_address.sin_addr.s_addr))
         {
            InitReturnBuffer(request, notification, strlen(notification), HTML_CONTENT_TYPE, TRUE);
            web.address_in_the_process_of_configuring = 0;
            return FALSE;  
         }

         if (web.configuration_manager_deinitialized == TRUE)
         {
            web.address_in_the_process_of_configuring = 0;
         }

         if (web.configuration_manager_deinitialized == FALSE && (web.address_in_the_process_of_configuring == request->client_address.sin_addr.s_addr))
         {
            /* This user is authenticated already he can proceed */
            return TRUE;
         }

       	init_result = cm_initialize_configuration_manager(CM_OWNED_BY_HTTP);
       	if (init_result == CM_INIT_FAILED_NOT_ENOUGH_MEMORY)
       	{
       		InitReturnBuffer(request, bptr_not_enough_memory, strlen(bptr_not_enough_memory),HTML_CONTENT_TYPE, TRUE);
       		return FALSE;
       	}
			strcpy(bptr_owned_by_other,"Could not Initialize Configuration Manager - Manager Owned by");
       	if (init_result != CM_INIT_SUCCESSFUL)
       	{
				switch (init_result)
				{
					case CM_MANAGER_IS_SNMP:
						strcat(bptr_owned_by_other, " SNMP Module");
						break;
					case CM_MANAGER_IS_TELNET:
						strcat(bptr_owned_by_other, " Telnet Module");
						break;
					case CM_MANAGER_IS_HTTP:
                  sprintf(buffer, "%d\0", (web.http_idle_timeout)/20);
						strcat(bptr_owned_by_other, " Some Web client or Configuration Manager is in the process of Deinitialization. Retry after ");
                  strcat(bptr_owned_by_other,buffer);
                  strcat(bptr_owned_by_other, " seconds...");
						break;
					case CM_MANAGER_IS_UIM:
						strcat(bptr_owned_by_other, " Management Port");
						break;
					case CM_MANAGER_IS_DTTY:
						strcat(bptr_owned_by_other, " Dumb TTY Module");
						break;
					default:;
				}

       		InitReturnBuffer(request, bptr_owned_by_other, strlen(bptr_owned_by_other),HTML_CONTENT_TYPE, TRUE);
       		return FALSE;
       	}
		 	web.http_timer = web.http_idle_timeout;
         web.address_in_the_process_of_configuring = request->client_address.sin_addr.s_addr;
       	printf("WEB:Configuration Manager Initialization Successful.\n");
      	web.configuration_manager_deinitialized = FALSE;
		 	request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
/* sudha 23 Aug 1999 */
			set_ftp_port_numbers_during_init(); 
		 	 return(TRUE);
		}
	}

	web.configuration_manager_deinitialized = FALSE;
   InitReturnUnauthorized(request, "Basic real=\" ",
      		"<head><title>401 Unauthorized</title></head><body><h2>401 Unauthorized Access: Incorrect user/password.</h2><p></body>", 
				FALSE ); 
	request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
   web.address_in_the_process_of_configuring = 0;
   return (FALSE);
}

char* initialize_request(Request_t *request)
{
	char* buffer;
	if ((buffer = malloc( (size_t)MAX_BUFFER_SIZE )) == NULL)
		return NULL;
	buffer[0] = '\0';
	return(buffer);
}


void display_welcome_page(Request_t * request)
{
	InitReturnBuffer(request, WELCOME_PAGE_data_ptr, strlen(WELCOME_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}


/* Jyothi */

void display_blank_page(Request_t * request)
{
	InitReturnBuffer(request, BLANK_PAGE_data_ptr, strlen(BLANK_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

void display_frames_blank_page(Request_t * request)
{
	InitReturnBuffer(request, FRAMES_BLANK_PAGE_data_ptr, strlen(FRAMES_BLANK_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

void display_framed_or_standard_main_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
   if(if_standard_or_frames)
     display_main_statistics_page(request) ;
   else
     display_standard_main_page(request) ;
}

void display_standard_main_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   if_standard_or_frames = 0 ;
	InitReturnBuffer(request, MAIN_PAGE_data_ptr, strlen(MAIN_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

void display_main_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	InitReturnBuffer(request, DISPLAY_PAGE_data_ptr, strlen(DISPLAY_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

void display_framed_main_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   if_standard_or_frames = 1 ;
	InitReturnBuffer(request, FRAMES_PAGE_data_ptr, strlen(FRAMES_PAGE_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

void display_log_page(Request_t* request)
{
	char *temp_page ;
   char *ptr_buffer_to_read_into ;
   int log_id, return_count, return_value, approx_number_of_msgs, approx_total_size, start_copying_from ; 

   USHORT log_search_to_start_at = 0 ;
   
   if(!check_whether_user_is_authenticated_or_not(request))
		return ;
   
   if (log_enabled == FALSE)
   {
      printf("log not enabled\n") ;
      return ;
   }

   log_id = open_log() ;
   if (log_id < 0)
   {
     if (log_id == LOG_NOT_LOGGING)
       printf("Error : Log not logging\n") ;
     else
       printf("Error : Maximum logs already open\n") ;
     return ;
   }

   ptr_buffer_to_read_into = malloc (BUFFER_SIZE) ;
   if (ptr_buffer_to_read_into == NULL)
   {
      log_id = close_log (log_id) ;
      return ;
   }  

   return_value = get_info_log (&approx_total_size, &approx_number_of_msgs) ;
   if (return_value == LOG_NOT_LOGGING)
   {
      log_id = close_log (log_id) ;
      free (ptr_buffer_to_read_into) ;
      return ;
   }
   temp_page = malloc (strlen(LOG_PAGE_data_ptr) + (approx_total_size + BUFFER_SIZE /2 ) ) ; 
   if (temp_page == NULL)
   {
      printf ("Memory allocation failed to display temp_page\n") ;
      log_id = close_log (log_id) ;
      free (ptr_buffer_to_read_into) ;
      return ;
   }

   temp_page[0] = 0 ;
   log_search_to_start_at = search_and_replace ("#__LOG__#", " ", LOG_PAGE_data_ptr, FALSE, 0) ;
   strncpy (temp_page, LOG_PAGE_data_ptr, log_search_to_start_at) ;
   temp_page[log_search_to_start_at] = 0 ;
   start_copying_from = log_search_to_start_at ;
   do 
   {
       return_count = read_log (log_id, ptr_buffer_to_read_into, BUFFER_SIZE) ;

       if (return_count < 0)
       {
          printf("Error : read not successful\n") ;
          log_id = close_log (log_id) ;
          if (log_id == LOG_NOT_LOGGING)
             printf("Error : log not closed\n") ;
          free (temp_page) ;
          free (ptr_buffer_to_read_into) ;
          return ;
       }
       if (return_count != 0)
       {
          ptr_buffer_to_read_into[return_count] = 0 ;
          strncat (temp_page + start_copying_from, ptr_buffer_to_read_into, return_count + 1) ;
          start_copying_from += return_count + 1 ;
       }
   }while (return_count > 0) ;

   strcat (temp_page + start_copying_from, (LOG_PAGE_data_ptr + log_search_to_start_at + SIZEOF_TEMPLATE)) ;


   InitReturnBuffer(request, temp_page, strlen (temp_page), HTML_CONTENT_TYPE, TRUE);
   
   free (temp_page) ;
   free(ptr_buffer_to_read_into) ;

   log_id = close_log (log_id) ;
   if (log_id == LOG_NOT_LOGGING)
     printf("Error : log not closed\n") ;
}

/* Jyothi */

/* ------------------- IP Configuration -------------------------------- */

void display_ip_page_for_ethernet(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
	BYTE* buffer;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying Ethernet IP Page ...\n");

	buffer = (BYTE*)malloc(strlen(IP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, IP_CONFIG_PAGE_data_ptr);
	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)ETHERNET_PORT, buffer);
	check_for_need_and_hide_irrelevent_fields(ETHERNET_PORT);
	search_and_replace("%##$###%", "Ethernet", buffer, TRUE, 0);
   /* We should not show ISP Assigned IP Address CHECKBOX for ethernet port 
	   hence comment that part */
	search_and_replace("#START_OF_COMMENT", "<!--", buffer, TRUE, 0);
	search_and_replace("#END_OF_COMMENT", "-->", buffer, TRUE, 0);
#if 0
	search_and_replace("#SRA#", "<!--", buffer, TRUE, 0);
	search_and_replace("#ERA#", "-->", buffer, TRUE, 0);
#endif
	search_and_replace("#SIPRA#", "<!--", buffer, TRUE, 0);
	search_and_replace("#EIPRA#", "-->", buffer, TRUE, 0);

   display_ip_page(request, buffer, 0);
	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ip_config_port = ETHERNET_PORT;
	free(buffer);
}

void display_ip_page_for_wan1(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
	BYTE* buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying IP Configuration Page of WAN1...\n");

	buffer = (BYTE*)malloc(strlen(IP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, IP_CONFIG_PAGE_data_ptr);
	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_1, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_1);
   if((web.model_number == 5) || (web.model_number == 6))
	  search_and_replace("%##$###%", "WAN", buffer, TRUE, 0);
   else
	  search_and_replace("%##$###%", "WAN1", buffer, TRUE, 0);
	search_and_replace("#START_OF_COMMENT", "", buffer, TRUE, 0);
	search_and_replace("#END_OF_COMMENT", "", buffer, TRUE, 0);
#if 0
	search_and_replace("#SRA#", "<!--", buffer, TRUE, 0);
	search_and_replace("#ERA#", "-->", buffer, TRUE, 0);
	search_and_replace("#SIPRA#", "", buffer, TRUE, 0);
	search_and_replace("#EIPRA#", "", buffer, TRUE, 0);
#endif

   display_ip_page(request, buffer, 1);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ip_config_port = WAN_PORT_1;
	free(buffer);
}

void display_ip_page_for_wan2(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
	BYTE* buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 2))
	{
		return;
	}

	printf("Displaying IP Configuration Page for WAN2...\n");
	buffer = (BYTE*)malloc(strlen(IP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, IP_CONFIG_PAGE_data_ptr);

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_2, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_2);

	search_and_replace("%##$###%", "WAN2", buffer, TRUE, 0);
	search_and_replace("#START_OF_COMMENT", "", buffer, TRUE, 0);
	search_and_replace("#END_OF_COMMENT", "", buffer, TRUE, 0);
#if 0
	search_and_replace("#SRA#", "<!--", buffer, TRUE, 0);
	search_and_replace("#ERA#", "-->", buffer, TRUE, 0);
	search_and_replace("#SIPRA#", "", buffer, TRUE, 0);
	search_and_replace("#EIPRA#", "", buffer, TRUE, 0);
#endif

	display_ip_page(request, buffer, 2);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ip_config_port = WAN_PORT_2;
	free(buffer);
}

void display_ip_page_for_wan3(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
	BYTE* buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 3))
	{
		return;
	}

	printf("Displaying IP Configuration Page for WAN3...\n");
	buffer = (BYTE*)malloc(strlen(IP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, IP_CONFIG_PAGE_data_ptr);

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT_3, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT_3);

	search_and_replace("%##$###%", "WAN3", buffer, TRUE, 0);
	search_and_replace("#START_OF_COMMENT", "", buffer, TRUE, 0);
	search_and_replace("#END_OF_COMMENT", "", buffer, TRUE, 0);
#if 0
	search_and_replace("#SRA#", "<!--", buffer, TRUE, 0);
	search_and_replace("#ERA#", "-->", buffer, TRUE, 0);
	search_and_replace("#SIPRA#", "", buffer, TRUE, 0);
	search_and_replace("#EIPRA#", "", buffer, TRUE, 0);
#endif

	display_ip_page(request, buffer, 3);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ip_config_port = WAN_PORT_3;
	free(buffer);
}

void display_ip_page(Request_t* request, BYTE* buffer, BYTE port_number)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   check_for_model_number_and_replace (buffer) ;
	fill_the_ip_form_with_appropriate_values(buffer, port_number);
/* sudha 09 Aug 1999.Removing "Client Side Internet Parameters" from ip page */
	search_and_replace("#SCSP#", "<!--", buffer, TRUE, 0);
	search_and_replace("#ECSP#", "-->", buffer, TRUE, 0);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
}

void change_ip_parameters(Request_t* request)
{
	CHANGE_IP_PARAMS_form_output_type* ip_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ip_changed_params = (CHANGE_IP_PARAMS_form_output_type*)form_data_of_request(request);
	if (ip_changed_params == NULL)
	{
/*		printf("IP - Attention: form_data_of_request failing to give the form data\n");*/
		return;
	}
	make_changes_to_corresponding_port(ip_config_port, ip_changed_params);
   display_framed_or_standard_main_page(request);
}

void	make_changes_to_corresponding_port(enum ip_port_types config_port, CHANGE_IP_PARAMS_form_output_type* ip_changed_params)
{
	switch(config_port)
	{
	case ETHERNET_PORT:
		save_the_value_from_ip_form(ip_changed_params, 0);
		break;
	case WAN_PORT_1:
		save_the_value_from_ip_form(ip_changed_params, 1);
		break;
	case WAN_PORT_2:
		save_the_value_from_ip_form(ip_changed_params, 2);
		break;
	case WAN_PORT_3:
		save_the_value_from_ip_form(ip_changed_params, 3);
		break;
	default:
#ifdef _NAVDEBUG_
	   for (i=0;i <= 100; ++i)
			printf("make_changes_to_corresponding_port None of the case are matching *\n");
#endif
	  	break;
	}
}

void save_the_value_from_ip_form(CHANGE_IP_PARAMS_form_output_type* ip_changed_params, BYTE port_number)
{
   BYTE ip_address[] = "0.0.0.0", temp_string[20], flag , disabled_value = 0, enabled_value = 1 ;
   BYTE ip_lan_mask_string[20], ip_lan_addr_string[20] ;
   BYTE lan_addr[16], lan_mask[16], ras_enabled ;

   get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].client_only, port_number - 1, CM_INDEX_FORMAT, (void *)&ras_enabled, 10) ;

   if (ip_changed_params->isp_address && port_number > 0 )
      set_parameter_by_name(CM_IP_SECTION, "IP Port Address", port_number, CM_STRING_FORMAT, (void*)(ip_address));
   else
   {
     if (strcmp (ip_changed_params->ip_address, ip_address) != 0)
         set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, (void*)(ip_changed_params->ip_address), "IP Port Address");
     else
        printf ("Enter Valid IP Address for Port %d\n", port_number) ;
   }
#if 0 /* sudha 02 June 1999 */
     /* remote access enabled */
   if (port_number > 0)
   {
     if (ip_changed_params->remote_access)
     {
/*       set_parameter (CM_IP_SECTION, (void*)&ip.port[0].config.configured_remote_access_enabled, port_number, CM_INDEX_FORMAT, (void*)&enabled_value) ; */
       set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].client_only, port_number - 1, CM_INDEX_FORMAT, (void*)&enabled_value) ;
     }
     else
     {
/*       set_parameter (CM_IP_SECTION, (void*)&ip.port[0].config.configured_remote_access_enabled, port_number, CM_INDEX_FORMAT, (void*)&disabled_value) ; */
       set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].client_only, port_number - 1, CM_INDEX_FORMAT, (void*)&disabled_value) ;
     }
   }
#endif

   get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address, 0, CM_STRING_FORMAT, (void *)&ip_lan_addr_string[0], 20) ;
   get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.subnetmask, 0, CM_STRING_FORMAT, (void *)&ip_lan_mask_string[0], 20) ;

   flag = local_ip_address_and_remote_ip_address_belong_to_the_same_network(&ip_lan_addr_string, ip_changed_params->remote_address, &ip_lan_mask_string, ip_changed_params->net_mask) ;

   /* remote access address */
   if ((ras_enabled) && (port_number > 0 ))
   {
      if (ip_changed_params->remote_address)
      {
			if ((check_if_ras_address_is_valid_and_unique(ip_changed_params->remote_address, port_number) == TRUE)
				&& (flag))
             set_parameter (CM_IP_SECTION, (void*)&ip.port[0].config.point_to_point_remote_ip_address, port_number, CM_STRING_FORMAT, (void*)ip_changed_params->remote_address) ;
          else
          {
            flag = local_ip_address_and_remote_ip_address_belong_to_the_same_network(&ip_lan_addr_string, ip_changed_params->dhcp_server_ip_address, &ip_lan_mask_string, ip_changed_params->net_mask) ;
            if ((ip_changed_params->dhcp_client) && (is_an_ip_address(ip_changed_params->dhcp_server_ip_address)) && (flag) && (strcmp (ip_changed_params->dhcp_server_ip_address,ip_address) != 0))
               set_parameter (CM_IP_SECTION, (void*)&ip.port[0].config.point_to_point_remote_ip_address, port_number, CM_STRING_FORMAT, (void*)ip_changed_params->dhcp_server_ip_address) ;
            else 
                printf ("Enter Valid Remote IP Address or Valid DHCP Address\n") ;
          }
      }   
      else
      {
         flag = local_ip_address_and_remote_ip_address_belong_to_the_same_network(&ip_lan_addr_string, ip_changed_params->dhcp_server_ip_address, &ip_lan_mask_string, ip_changed_params->net_mask) ;
         if ((ip_changed_params->dhcp_client) && (is_an_ip_address(ip_changed_params->dhcp_server_ip_address)) && (flag) && (strcmp (ip_changed_params->dhcp_server_ip_address,ip_address) != 0))
             set_parameter (CM_IP_SECTION, (void*)&ip.port[0].config.point_to_point_remote_ip_address, port_number, CM_STRING_FORMAT, (void*)ip_changed_params->dhcp_server_ip_address) ;
         else
           printf ("Enter Valid Remote IP Address or Valid DHCP Address\n") ;
      }
   }
   set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, (void*)(ip_changed_params->net_mask), "SubNetMask");

   port_number = CM_NO_PORT_PARAMETER_PRESENT;

   /* DHCP Client */

   if ((ip_changed_params->dhcp_client) && (strcmp (ip_changed_params->dhcp_server_ip_address, ip_address) != 0))
      set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.bootp_enabled, 0, CM_INDEX_FORMAT, (void*)&enabled_value) ;
   else
      set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.bootp_enabled, 0, CM_INDEX_FORMAT, (void*)&disabled_value) ;

   /* DHCP Server IP Address */
   if (ip_changed_params->dhcp_client)
   {
      if (is_an_ip_address(ip_changed_params->dhcp_server_ip_address) && (strcmp (ip_changed_params->dhcp_server_ip_address, ip_address) != 0))
         set_parameter (CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)ip_changed_params->dhcp_server_ip_address) ;
   }
   else
     printf("DHCP Client is not enabled\n") ;

   strcpy (temp_string, ip_changed_params->gateway_address) ;
   strcat (temp_string, ",1") ;

   get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.subnetmask, 0, CM_STRING_FORMAT, &lan_mask[0], 16) ;				

   get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address, 0, CM_STRING_FORMAT, &lan_addr[0], 16) ;	 


#if 0 /* sudha 09 Aug 1999 */
   if (( local_ip_address_and_remote_ip_address_on_same_network(lan_addr, ip_changed_params->gateway_address, lan_mask) == FALSE ) || (strcmp (lan_addr, ip_changed_params->gateway_address) == 0))
      printf ("Invalid Gateway address. LAN & Gateway address should belong to the same net.\n") ;
   else
      set_parameter_by_name (CM_IP_SECTION, "IP Default Route", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, temp_string) ;

/*   set_value_and_handle_error_4(CM_IP_SECTION, "IP Default Route", port_number, (void*)ip_changed_params->gateway_address, "Gateway address") ;*/

	/*Default TTL*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipDefaultTTL, port_number, (void*)ip_changed_params->time_to_live, "Default TTL");

	/*Reassambly Timeout*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipReasmTimeout, port_number, (void*)ip_changed_params->reassembly_time_out, "Reassembly Timeout");
#endif

   /* DNS Primary Address */
   if (is_an_ip_address(ip_changed_params->local_server_address) && (strcmp (ip_changed_params->local_server_address, ip_address) != 0))
      set_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)ip_changed_params->local_server_address) ;
   else
      printf ("Enter Valid Primary Server Address\n") ;

   /* DNS Secondary Address */
   if (is_an_ip_address(ip_changed_params->root_server_address) && (strcmp (ip_changed_params->root_server_address, ip_address) != 0))
      set_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address2", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)ip_changed_params->root_server_address) ;
   else
      printf ("Enter Valid Secondary Server Address\n") ;
}

void fill_the_ip_form_with_appropriate_values(char* buffer, BYTE port_number)
{
	USHORT search_to_start_at = 0, length ;
   BYTE ip_addr_string[20], ip_address[20], isp_enabled, temp_string[20], temp_enabled ;
	BYTE ras_enabled;

	number_of_saved_indices = 0;
          
   get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].client_only, port_number - 1, CM_INDEX_FORMAT, (void *)&ras_enabled, 10) ;

	/* ISP Enable*/
   if (port_number > 0)
   {
      /* Check if ip address is '0.0.0.0' or not. if it is then ISP is enabled
         else ISP is not enabled */
      if (get_parameter(CM_IP_SECTION, 
                        (void*)&ip.port[0].config.ip_address, 
                        port_number, 
                        CM_STRING_FORMAT,
                        (void*)ip_address, 
                        20) == CM_GET_SUCCESSFUL)
      {
         if (!strcmpi(ip_address, "0.0.0.0"))
         {
            isp_enabled = TRUE;
         }
         else
         {
            isp_enabled = FALSE;
         }
      }
      else
      {
         isp_enabled = FALSE;
      }

      if (isp_enabled)
      {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
      }
      else
      {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "       ", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
      }
   }
   else
   {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "       ", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
   }

#if 0
   /* remote access enabled */
   if (port_number > 0)
   {
      get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].client_only, port_number - 1, CM_INDEX_FORMAT, (void *)&temp_enabled, 10) ;
      if (temp_enabled)
          search_to_start_at = search_and_replace ("#__CBOX", "checked", buffer, TRUE, search_to_start_at) ;
      else
          search_to_start_at = search_and_replace ("#__CBOX", "       ", buffer, TRUE, search_to_start_at) ;
   }
   else
        search_to_start_at = search_and_replace ("#__CBOX", "       ", buffer, TRUE, search_to_start_at) ;
#endif

	/*IP Address*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, port_number, "IP Address", search_to_start_at, buffer);

	/* Net Mask*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, port_number, "IP Mask", search_to_start_at, buffer);

	if (ras_enabled == 0)
		search_and_replace("#SIPRA#", "<!--", buffer, TRUE, 0);
	else		
		search_and_replace("#SIPRA#", "", buffer, TRUE, 0);

   /* remote access address */
   if (port_number > 0)
   {
      get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.point_to_point_remote_ip_address, port_number, CM_STRING_FORMAT, (void *)&ip_addr_string[0], 20) ;
      search_to_start_at = search_and_replace ("#___TEXT___#___", ip_addr_string, buffer, TRUE, search_to_start_at) ;
   }
   else
      search_to_start_at = search_and_replace ("#___TEXT___#___", "", buffer, TRUE, search_to_start_at) ;

	if (ras_enabled == 0)
		search_and_replace("#EIPRA#", "-->", buffer, TRUE, 0);
	else
		search_and_replace("#EIPRA#", "", buffer, TRUE, 0);
			
   port_number = CM_NO_PORT_PARAMETER_PRESENT;

   /* DHCP Client */

   get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.bootp_enabled, 0, CM_INDEX_FORMAT, (void *)&temp_enabled, 10) ;

   if (temp_enabled)
      search_to_start_at = search_and_replace ("#__CBOX", "checked", buffer, TRUE, search_to_start_at) ;
   else
      search_to_start_at = search_and_replace ("#__CBOX", "       ", buffer, TRUE, search_to_start_at) ;
 
   /* DHCP Server IP Address */
   get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.server_ip_address, CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void *)&ip_addr_string[0], 20) ;
   search_to_start_at = search_and_replace ("#___TEXT___#___", ip_addr_string, buffer, TRUE, search_to_start_at) ;  


	/* Gateway Address*/
#if 0
   if (get_parameter_by_name(CM_IP_SECTION, "IP Default Route", port_number, CM_STRING_FORMAT, (void*)temp_string, 20 ) == CM_GET_SUCCESSFUL)
   {
       saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], temp_string, buffer, TRUE, search_to_start_at);
	    search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
   	 saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
   }
   else
   {
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
   }
#endif

   if (get_parameter_by_name(CM_IP_SECTION, "IP Default Route", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)temp_string, 20 ) == CM_GET_SUCCESSFUL)
   {
      length = strlen (temp_string) ;
      temp_string[length - 2] = 0 ;
      search_and_replace ("#___TEXT___#___", temp_string, buffer, TRUE, search_to_start_at) ;
   }
   else
      search_and_replace ("#___TEXT___#___", "", buffer, TRUE, search_to_start_at) ;

/*Default TTL*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipDefaultTTL, port_number, "Default TTL", search_to_start_at, buffer);

	/*Reassambly Timeout*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipReasmTimeout, port_number, "Reassembly Timeout", search_to_start_at, buffer);

   /* DNS Primary Address */

   get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void *)&ip_addr_string[0], 20) ;
   search_to_start_at = search_and_replace ("#___TEXT___#___", ip_addr_string, buffer, TRUE, search_to_start_at) ; 

   /* DNS Secondary Address */

   get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address2", CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void *)&ip_addr_string[0], 20) ;
   search_to_start_at = search_and_replace ("#___TEXT___#___", ip_addr_string, buffer, TRUE, search_to_start_at) ; 
      
	number_of_saved_indices --;	/* Very Important statement */
}

#if 0 /* Not Reqd for Proxy ...*/
/* ------------------ Advanced IP Configuraton --------------------------- */

void display_advanced_ip_page(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying Advanced IP Page...\n");

	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)ADVANCED_CONFIG, ADVANCED_IP_CONFIG_PAGE_data_ptr);
	check_for_need_and_hide_irrelevent_fields(ADVANCED_CONFIG);

	send_advanced_ip_page(request, ADVANCED_IP_CONFIG_PAGE_data_ptr);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, ADVANCED_IP_CONFIG_PAGE_data_ptr);
	show_the_hidden_fields();
	ip_config_port = ADVANCED_CONFIG;
}

void send_advanced_ip_page(Request_t* request, BYTE* buffer)
{
	fill_the_advanced_ip_form_with_appropriate_values(buffer);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(buffer);
}

void fill_the_advanced_ip_form_with_appropriate_values(BYTE* buffer)
{
	USHORT search_to_start_at = 0;
   BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT;
	enum CM_GET_RESULTS get_result;
	BYTE returned_string[STRING_LENGTH_FOR_GET];
	BYTE main_index, sub_index, default_route[IP_ADDRES_LENGTH], default_route_metric[METRIC_LENGTH];
	number_of_saved_indices = 0;
	
	/* IP Routing Enable*/
	search_to_start_at = get_value_and_handle_error_3(CM_IP_SECTION, "IP", port_number, "IP Port Enable", search_to_start_at, buffer);

	/*IP Node Address*/
	search_to_start_at = get_value_and_handle_error_8(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 0, "IP Node Address", search_to_start_at, buffer);

	/*Default TTL*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipDefaultTTL, port_number, "Default TTL", search_to_start_at, buffer);

	/*RIP Response TimeOut*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.rip.config.update_time_interval, port_number, "RIP Response Timeout", search_to_start_at, buffer);

	/*Reassambly Timeout*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipReasmTimeout, port_number, "Reassembly Timeout", search_to_start_at, buffer);
		
	/*RIP route aging time*/
	search_to_start_at = get_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.rip.config.route_aging_timeout_value, port_number, "Rip route Aging Time", search_to_start_at, buffer);

	/*DHCP Client*/
	search_to_start_at = get_value_and_handle_error_1(CM_IP_SECTION, (void*)&ip.port[0].config.bootp_enabled, 0, "DHCP Client", search_to_start_at, buffer);

	 /*DHCP Relay Agent*/	
	search_to_start_at = get_value_and_handle_error_1(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, port_number, "DHCP Relay Agent", search_to_start_at, buffer);

	 /*DHCP Server IP Address*/
	search_to_start_at = get_value_and_handle_error_2(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, port_number, "DHCP Server IP Address", search_to_start_at, buffer);

   /* Default Route and Metric */
	get_result = get_parameter_by_name(CM_IP_SECTION, "IP Default Route", port_number, CM_STRING_FORMAT, (void*)returned_string, STRING_LENGTH_FOR_GET);

	if (get_result == CM_LHS_STRING_NOT_FOUND_WHILE_GET)
	{	
		printf("String for IP Default Route not found\n");
	}
	else
	if (get_result == CM_RHS_STRING_NOT_FOUND_WHILE_GET)
	{
		printf("String for IP Default Route not found\n");
	}
	else
	if (get_result == CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA)
	{
		printf("NonNumeric Data found for IP Default Route\n");
	}
	else
	if(get_result != CM_GET_SUCCESSFUL)
	{
		printf("Result returned is unknown for IP Default Route\n");
	}
	if(get_result == CM_GET_SUCCESSFUL && returned_string)
	{
		main_index = 0;
		sub_index = 0;
		default_route[0] = 0;
		while(main_index < strlen(returned_string) && returned_string[main_index] != ',')
		{
			default_route[sub_index++] = returned_string[main_index++];
		}
		default_route[sub_index] = 0;
		sub_index = 0;
		main_index ++; /* Skip ','*/
		default_route_metric[0] = 0;
		if (main_index < strlen(returned_string))
		{
			while(main_index < strlen(returned_string))
			{
		 		default_route_metric[sub_index++] = returned_string[main_index++];
			}
			default_route_metric[sub_index] = 0;
		}
		old_default_route(default_route, default_route_metric, TRUE);
	}
	else
	{
	 	strcpy(default_route, "0.0.0.0");
		strcpy(default_route_metric, "0");
		old_default_route(default_route, default_route_metric, TRUE);
	}

	if(get_result == CM_GET_SUCCESSFUL && returned_string != NULL)
	{
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], default_route, buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
	}
	else
	{
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
	}

	if(get_result == CM_GET_SUCCESSFUL && returned_string != NULL)
	{
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], default_route_metric, buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
	}
	else
	{
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_TEXT_BOX;
	}

	number_of_saved_indices--;
}

void	old_default_route(BYTE* string1, BYTE* string2, BYTE is_to_save)
{
	static BYTE ip_address[20], metric[5];

	if (is_to_save)
	{
		strcpy(ip_address, string1);
		strcpy(metric, string2);
	}
	else
	{
		strcpy(string1, ip_address);
		strcpy(string2, metric);
	}
}


void change_advanced_ip_parameters(Request_t* request)
{
	CHANGE_ADVANCED_IP_PARAMS_form_output_type* ip_changed_params;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ip_changed_params = (CHANGE_ADVANCED_IP_PARAMS_form_output_type*)form_data_of_request(request);
	if (ip_changed_params == NULL)
	{
		return;
	}
	make_changes_to_advanced_config(ip_changed_params);
   display_framed_or_standard_main_page(request);
}

void make_changes_to_advanced_config(CHANGE_ADVANCED_IP_PARAMS_form_output_type* advanced_ip_changed_params)
{
   BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT;
	USHORT search_to_start_at = 0, value;
   BYTE i, number_of_ports, buffer[50], buffer1[20], buffer2[10], temp_buffer[20];
	number_of_saved_indices = 0;

	/* IP Routing Enable*/
	set_value_and_handle_error_3(CM_IP_SECTION, "IP", port_number, (void*)&advanced_ip_changed_params->ip_routing_enable, "IP Routing Enable");

	/*Default TTL*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipDefaultTTL, port_number, (void*)advanced_ip_changed_params->default_ttl, "Default TTL");

	/*RIP Response TimeOut*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.rip.config.update_time_interval, port_number, (void*)advanced_ip_changed_params->rip_response_time, "IP Address");

	/*Reassambly Timeout*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.mib.ipReasmTimeout, port_number, (void*)advanced_ip_changed_params->reassembly_timeout, "Reassembly Timeout");
		
	/*RIP route aging time*/
	set_value_and_handle_error_2(CM_IP_SECTION, (void*)&ip.rip.config.route_aging_timeout_value, port_number, (void*)advanced_ip_changed_params->rip_route_aging_time,"RIP routing Aging Time");

	/*DHCP Client*/
  	set_value_and_handle_error_1(CM_IP_SECTION, (void*)&ip.port[0].config.bootp_enabled, 0, (void*)&advanced_ip_changed_params->dhcp_client, "DHCP Client 0");
	 /*DHCP Server IP Address*/
	set_value_and_handle_error_2(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, port_number, (void*)advanced_ip_changed_params->dhcp_server_ip_address, "DHCP IP Address");

	 /*DHCP Relay Agent*/	
	get_parameter(CM_DHCP_SECTION, (void*)&dhcp.config.server_ip_address, port_number, CM_STRING_FORMAT, (void*)buffer, 20);
	if (is_an_ip_address(buffer))
		set_value_and_handle_error_1(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, port_number, (void*)&advanced_ip_changed_params->dhcp_relay_agent, "DHCP Relay Agent");
	else
	{
		advanced_ip_changed_params->dhcp_relay_agent = FALSE;
		set_value_and_handle_error_1(CM_DHCP_SECTION, (void*)&dhcp.config.relay_agent_enabled, port_number, (void*)&advanced_ip_changed_params->dhcp_relay_agent, "DHCP Relay Agent");
	}

	/*Default Route*/
	if (is_a_default_ip_address(advanced_ip_changed_params->default_route_ip_address))
		strcpy(buffer1, advanced_ip_changed_params->default_route_ip_address);
	else
	{
		old_default_route(buffer1, temp_buffer, FALSE);
	}
	
	value = atoi(advanced_ip_changed_params->metric);
	if (strlen(advanced_ip_changed_params->metric) > 0  && is_valid_string_to_read_data(advanced_ip_changed_params->metric) && value > 0 && value < 16) 
		strcpy(buffer2, advanced_ip_changed_params->metric);
	else
	{
		old_default_route(temp_buffer, buffer2, FALSE);
	}
	strcpy(buffer, buffer1);
	strcat(buffer, ",");
	strcat(buffer, buffer2);
	set_value_and_handle_error_4(CM_IP_SECTION, "IP Default Route", CM_NO_PORT_PARAMETER_PRESENT, buffer, "Default Route");
}
#endif /* ... Not Reqd for Proxy */
/*--------------------     WAN Configuration --------------------------*/


void display_wan_page_for_port1(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
   byte* buffer ;
   if(!check_whether_user_is_authenticated_or_not(request))
		return;
   wan_port_number = 0 ;
	buffer = (BYTE*)malloc(strlen(WAN_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, WAN_CONFIG_PAGE_data_ptr);

	printf("Displaying Configuration Page for WAN1...\n");
	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT1, buffer);
   if((web.model_number == 5) || (web.model_number == 6))
	  search_and_replace("%##$###%", "WAN", buffer, TRUE, 0);
   else
	  search_and_replace("%##$###%", "WAN1", buffer, TRUE, 0);
	display_wan_page(request, buffer , 0);
	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	wan_config_port = WAN_PORT1;
   free(buffer);
}

void display_wan_page_for_port2(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
   byte* buffer ;

   wan_port_number = 1 ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 2))
	{
		return;
	}
	buffer = (BYTE*)malloc(strlen(WAN_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, WAN_CONFIG_PAGE_data_ptr);

	printf("Displaying Configuration Page for WAN2...\n");
	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT2, buffer);
	search_and_replace("%##$###%", "WAN2", buffer, TRUE, 0);
	display_wan_page(request, buffer , 1);
	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	wan_config_port = WAN_PORT2;
   free(buffer);
}

void display_wan_page_for_port3(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
   byte* buffer ;

   wan_port_number = 2 ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

	if(!this_port_present_in_the_current_router(request, 3))
	{
		return;
	}
	buffer = (BYTE*)malloc(strlen(WAN_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, WAN_CONFIG_PAGE_data_ptr);

	printf("Displaying Configuration Page for WAN3...\n");
	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT3, buffer);
	search_and_replace("%##$###%", "WAN3", buffer, TRUE, 0);
	display_wan_page(request, buffer , 2);
	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	wan_config_port = WAN_PORT3;
   free(buffer) ;
}

void display_wan_page(Request_t* request, BYTE* buffer, BYTE port_number)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   check_for_model_number_and_replace (buffer) ;
   check_for_model_number_and_replace_link_control(buffer, port_number) ;

   fill_the_wan_form_with_appropriate_values(buffer, port_number);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
}

void	fill_the_wan_form_with_appropriate_values(BYTE* buffer, BYTE port_number)
{
   char wan_ini_string[50], temp_string[15];      
	USHORT search_to_start_at = 0;
	int flag = 0, flag0 = 0, value = 0 ;
   number_of_saved_indices = 0;

 /* Port Enable*/
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].enabled, port_number, "WAN Port Enable", search_to_start_at, buffer);

  /* Script Enabled */
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].script_enabled, port_number, "WAN Port Script Enable", search_to_start_at, buffer);

  /* Restart script on failure */
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].restart_script_on_comm_failure, port_number, "WAN Port Script Restart on Failure", search_to_start_at, buffer);

 /* Async Mode / Sync Mode */
	search_to_start_at = get_value_and_handle_error_6(CM_WAN_SECTION, (void*)&wan.port[0].asyncport, port_number, "Async/Sync", search_to_start_at, buffer);

 /* Baud Rate*/
	search_to_start_at = get_value_and_handle_error_7(CM_WAN_SECTION, (void*)&wan.port[0].port_speed, port_number, "Baud", search_to_start_at, buffer);
      
 /* External/Internal Clock */
	search_to_start_at = get_value_and_handle_error_10(CM_WAN_SECTION, (void*)&wan.port[0].InternalClk, port_number, "External/Internal clock", search_to_start_at, buffer);

 /* Clock Speed*/
	search_to_start_at = get_value_and_handle_error_7(CM_WAN_SECTION, (void*)&wan.port[0].sync_port_speed, port_number, "Clock Speed", search_to_start_at, buffer);

 /* Send Idle Flag*/
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].sync_xmit_idle_flags, port_number, "Send Idle Flag", search_to_start_at, buffer);

   flag0 =  ((web.model_number == MODEL_MTSR3_200) ||  (web.model_number == MODEL_MTSR1_202ST) || (web.model_number == MODEL_MTSR1_202NT) || ((web.model_number == MODEL_MTSR2_201) && (wan_port_number == 0))) ;
   flag =  ((web.model_number == MODEL_MTSR3_200) || ((web.model_number == MODEL_MTSR2_201) && (wan_port_number == 0))) ;

   if (flag0)
      search_to_start_at = search_and_replace ("#SDC#", "<!--", buffer, TRUE, search_to_start_at) ;
   else
      search_to_start_at = search_and_replace ("#SDC#", "", buffer, TRUE, search_to_start_at) ;

 /* Direct Connection */
	search_to_start_at = get_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].direct_connect_enabled, port_number, "Direct Connection", search_to_start_at, buffer) ;

   if (flag0)
      search_to_start_at = search_and_replace ("#EDC#", "-->", buffer, TRUE, search_to_start_at) ;
   else
      search_to_start_at = search_and_replace ("#EDC#", "", buffer, TRUE, search_to_start_at) ;

   if (flag0)
      search_to_start_at = search_and_replace ("#SMI#", "<!--", buffer, TRUE, search_to_start_at) ;
   else
      search_to_start_at = search_and_replace ("#SMI#", "", buffer, TRUE, search_to_start_at) ;

/* Modem/ISDN */
   search_to_start_at = get_value_and_handle_error_6(CM_WAN_SECTION, (void*)&wan.port[0].isdn_ta_enabled, port_number, "Modem/ISDN", search_to_start_at, buffer);

   if (flag0)
      search_to_start_at = search_and_replace ("#EMI#", "-->", buffer, TRUE, search_to_start_at) ;
   else
      search_to_start_at = search_and_replace ("#EMI#", "", buffer, TRUE, search_to_start_at) ;

   /*	temp_loc = search_to_start_at; */

/* sudha 29 May 1999 */
/* Dial Out/Dial In/Dial Out In */
	search_to_start_at = get_value_and_handle_error_14(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.dial_in_out_type, port_number, "Dial Out/In", search_to_start_at, buffer);

/* Proxy/AG/RAS */
	search_to_start_at = get_value_and_handle_error_15(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.port_function_type, port_number, "Proxy/AG/Ras", search_to_start_at, buffer);

   if (flag)
   {
      search_to_start_at = search_and_replace ("#SEI#", "<!--", buffer, TRUE, search_to_start_at) ;
      search_to_start_at = search_and_replace ("#EEI#", "-->", buffer, TRUE, search_to_start_at) ;
   }
   else
   {
      search_to_start_at = search_and_replace ("#SEI#", "", buffer, TRUE, search_to_start_at) ;
      search_to_start_at = search_and_replace ("#EEI#", "", buffer, TRUE, search_to_start_at) ;
   }
/*	search_to_start_at = temp_loc;   */
 /* Modem Type */
	search_to_start_at = get_value_and_handle_error_11(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.strings.modem_type, port_number, "Modem Type ", search_to_start_at, buffer);


   /*Dial On Demand Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand, port_number, "Dial On Demand Enabled", search_to_start_at, buffer);


  /*Hangup*/
/* Jo	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout,port_number, "Hangup", search_to_start_at, buffer);*/

   get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout, port_number, CM_STRING_FORMAT, (void*)&temp_string[0], 10) ;
   value = atoi (temp_string) ;
   value = value / 60 ;
   sprintf (temp_string, "%d", value) ;

	search_to_start_at = search_and_replace(templates[ENUM_TEXT_BOX], temp_string, buffer, TRUE, search_to_start_at) ;

   wan_ini_string[0] = 0 ;
   get_parameter (CM_PROXY_SECTION, (void*)&proxy_server.port[0].maximum_number_of_connections_to_dial,
	   	port_number + 1, CM_STRING_FORMAT, &wan_ini_string[0], 10);

	search_to_start_at = search_and_replace("#AC#", wan_ini_string, buffer, TRUE, 0) ;

   wan_ini_string[0] = 0 ;

   get_parameter (CM_PROXY_SECTION, (void*)&proxy_server.port[0].maximum_number_of_hosts_to_dial,
	   	port_number + 1, CM_STRING_FORMAT, &wan_ini_string[0], 10);

	search_to_start_at = search_and_replace("#IP#", wan_ini_string, buffer, TRUE, search_to_start_at) ;

 /*General Name */
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.general_name, port_number, "General Name", search_to_start_at, buffer);

 /*Specific Name */
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.specific_name, port_number, "Specific Name", search_to_start_at, buffer);

 /*Port Inactivity Timeout*/
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.idle_time, port_number, "Port Idle Time", search_to_start_at, buffer);

	number_of_saved_indices--;
}

void change_wan_parameters(Request_t* request)
{
	BYTE port_function_type;
	int index, ras_enabled = 0, wan_ports = 0;
	CHANGE_WAN_PARAMS_form_output_type* wan_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	wan_changed_params = (CHANGE_WAN_PARAMS_form_output_type*)form_data_of_request(request);
	if (wan_changed_params == NULL)
	{
		return;
	}
	make_changes_to_corresponding_wan_port(wan_config_port, wan_changed_params);
/* sudha 03 June 1999 */
	wan_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS);
	if (web.model_number == MODEL_MTSR2_201)
		wan_ports = 2;
	for ( index = 0;index < wan_ports; index++)
	{
	   get_parameter (CM_WAN_SECTION, (void*)&wan.port[0].modem_info.port_function_type,
	   	index, CM_BYTE_FORMAT, &port_function_type, 10);
/* printf("\n\rPort Function Type of port %d is %d", index, port_function_type);*/
		/* Check whether ras is enabled.... */
		ras_enabled = port_function_type & 0x04;
		if (ras_enabled == 0x04)
		{
/*			printf("\n\rType is %d",ras_enabled);*/
			break;
		}
	}

	if(ras_enabled)
		display_wan_ras_message(request);
	else
	   display_framed_or_standard_main_page(request);
}

void make_changes_to_corresponding_wan_port(enum wan_port_types wan_config_port, CHANGE_WAN_PARAMS_form_output_type* wan_changed_params)
{
	switch(wan_config_port)
	{
	  case WAN_PORT1:
	  save_the_values_from_wan_form(wan_changed_params, 0);
	  break;

	  case WAN_PORT2:
	  save_the_values_from_wan_form(wan_changed_params, 1);
	  break;

	  case WAN_PORT3:
	  save_the_values_from_wan_form(wan_changed_params, 2);
	  break;

	};
}

void  save_the_values_from_wan_form(CHANGE_WAN_PARAMS_form_output_type* wan_changed_params, BYTE port_number)
{
   BYTE ip_address[] = "0.0.0.0" ;
   STRUCT_HOST_ENTRY host_address ;
   BYTE  disabled_value = 0, enabled_value = 1, port_function_type;
	BYTE answer = 0;
   int value = 0, proxy_enabled = 0, ras_enabled = 0, ag_enabled = 0; 

   wan_changed_params->mode = !(wan_changed_params->mode);
/*   wan_changed_params->connection = !(wan_changed_params->connection); */

	if ((strlen (wan_changed_params->general_name) > 9) || 
				(validate_alpha_numeric_underscore_name_and_convert_to_upper_case(wan_changed_params->general_name) == FALSE))
		printf("\n\r\Enter general name of length 9 ('A'-'Z', 'a'-'z', 0-9,_) : ");
	else
	   set_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.general_name, port_number, (void*)wan_changed_params->general_name, "General Name");

	if ((strlen (wan_changed_params->specific_name) > 14) || 
				(validate_alpha_numeric_underscore_name_and_convert_to_upper_case(wan_changed_params->specific_name) == FALSE))
		printf("\n\r\Enter specific name of length 14 ('A'-'Z', 'a'-'z', 0-9,_) : ");
	else
	   set_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.specific_name, port_number, (void*)wan_changed_params->specific_name, "Specific Name");

	value = atoi(wan_changed_params->port_inactivity_timeout);
	if ((value > 60) || (value < 0))
		printf("\n\r\Enter port idle time (0 - 60 minutes) : ");
	else
	   set_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.line_info_array[0].line_vars.idle_time, port_number, (void*)wan_changed_params->port_inactivity_timeout, "Port Inactivity TimeOut");

/* sudha 29 May 1999 */
	if (wan_changed_params->proxy_enabled == 1)
		proxy_enabled = 1;

	if (wan_changed_params->ras_enabled == 1)
		ras_enabled = 4;

	if (wan_changed_params->ag_enabled == 1)
		ag_enabled = 2;
	
	port_function_type = proxy_enabled | ag_enabled | ras_enabled;
/*	printf("\n\rPort function type is %d", port_function_type);*/

	if (port_number > 0)
	{
	   if (check_if_is_numeric_value (wan_changed_params->active_connections))
   	   set_parameter (CM_PROXY_SECTION, (void*)&proxy_server.port[0].maximum_number_of_connections_to_dial,
	   	port_number + 1, CM_STRING_FORMAT, wan_changed_params->active_connections) ;
	   else
   	   printf ("Enter valid number for number of active connections\n") ; 

	   if (check_if_is_numeric_value (wan_changed_params->active_ip_address))
   	   set_parameter (CM_PROXY_SECTION, (void*)&proxy_server.port[0].maximum_number_of_hosts_to_dial,
   	  	   port_number + 1, CM_STRING_FORMAT, wan_changed_params->active_ip_address) ;
	   else
   	   printf ("Enter valid number for number of active IP host machines\n") ; 
	}

   set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].enabled, port_number, (void*)&wan_changed_params->wan_port_enable, "Port Enable");
   if ((wan_changed_params->mode == 0) || (wan_changed_params->direct_connect))
   {
      set_parameter (CM_WAN_SECTION, (void*)&wan.port[0].script_enabled, port_number, CM_INDEX_FORMAT, (void*)&disabled_value) ;
      set_parameter (CM_WAN_SECTION, (void*)&wan.port[0].restart_script_on_comm_failure, port_number, CM_INDEX_FORMAT, (void*)&disabled_value);
   }
   else
   {
      set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].script_enabled, port_number, (void*)&wan_changed_params->script_enable, "Script Enable");
      set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].restart_script_on_comm_failure, port_number, (void*)&wan_changed_params->restart_failure, "Restart Script on Failure"); 
   }

   if ((web.model_number == MODEL_MTSR3_200) || (web.model_number == MODEL_MTSR1_202ST)
		|| (web.model_number == MODEL_MTSR1_202NT))
      set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].asyncport, port_number, (void*)&enabled_value, "Async/Sync Mode") ;
	else
      set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].asyncport, port_number, (void*)&wan_changed_params->mode, "Async/Sync Mode") ;

   if (wan_changed_params->mode == 1)
      set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].port_speed, port_number, (void*)&wan_changed_params->baud_rate, "BaudRate");
   if (web.model_number != MODEL_MTSR3_200)
   {
      set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].InternalClk, port_number, (void*)&wan_changed_params->clock, "External/Internal Clock");
      if ((wan_changed_params->mode == 0) && (wan_changed_params->clock == 1))
         set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].sync_port_speed, port_number, (void*)&wan_changed_params->clock_speed, "Clock Speed");
   }
   if ((wan_changed_params->mode == 0) && (web.model_number != MODEL_MTSR3_200))
   {
       if (wan_changed_params->send_idle_flag) 
          set_parameter(CM_WAN_SECTION, (void*)&wan.port[0].sync_xmit_idle_flags, port_number, CM_INDEX_FORMAT, (void*)&enabled_value) ; 
       else
          set_parameter(CM_WAN_SECTION, (void*)&wan.port[0].sync_xmit_idle_flags, port_number, CM_INDEX_FORMAT, (void*)&disabled_value) ; 
   }
    else
       set_parameter(CM_WAN_SECTION, (void*)&wan.port[0].sync_xmit_idle_flags, port_number, CM_INDEX_FORMAT, (void*)&disabled_value) ; 

   set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].direct_connect_enabled, port_number, (void*)&wan_changed_params->direct_connect, "Direct Connect");
   wan_changed_params->modem_isdn = !(wan_changed_params->modem_isdn) ;
   set_value_and_handle_error_1(CM_WAN_SECTION, (void*)&wan.port[0].isdn_ta_enabled, port_number, (void*)&wan_changed_params->modem_isdn, "Modem/ISDN");
/* sudha 31 May 1999 */

	if ((web.model_number == MODEL_MTSR2_201) && (port_number == 0))
		wan_changed_params->port = 0; /* Dial Out Only */

	if ((wan_changed_params->direct_connect) && (wan_changed_params->port == 2))
		wan_changed_params->port = 0; /* Dial Out Only */
		
	set_value_and_handle_error_5(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.dial_in_out_type, port_number, (void*)&wan_changed_params->port, "Dial Out/In");

	get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.dial_in_out_type, port_number, CM_BYTE_FORMAT, &answer, 4);
/* If dial_in_out_type is dial_out, don't accept ras enabled function type */
   if (((port_function_type & 0x04) == 0x04) && (answer == 0))
	{
		/* mask ras enabled bit alone */
		port_function_type &= 0xFB;
	}

/* If dial_in_out_type is dial_in, don't accept any function type other than
ras */

	else if ((port_function_type != 0x04) && (answer == 1))
	{																 
		/* set port function type as ras enabled only */
		port_function_type = 0x04;
	}

/* If dial_in_out_type is dial_out_in, & if ras is not enabled, enable ras */

	else if (((port_function_type & 0x04) != 0x04) && (answer == 2))
	{
		/* set ras enabled bit */
		port_function_type |= 0x04;
	}

/* If dial_in_out_type is dial_out_in, & if ras only is enabled, enable proxy,
ag & ras */

	else if ((port_function_type == 0x04) && (answer == 2))
	{
		/* set proxy, ag, ras enabled bits */
		port_function_type = 0x07;
	}

/* printf("\n\rPort Function Type is %d", port_function_type); */

	if ((web.model_number == MODEL_MTSR2_201) && (port_number == 0))
		port_function_type = 0x01; /* Proxy Only */

	set_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.port_function_type, port_number, CM_BYTE_FORMAT, &port_function_type);

	set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand, port_number, (void*)&wan_changed_params->dial_on_demand_enabled, "Dial On Demand Enabled");
   value = atoi (wan_changed_params->hangup_time) ;
   value *= 60 ;
   sprintf (wan_changed_params->hangup_time, "%d", value) ;
   set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout, port_number, (void*)wan_changed_params->hangup_time, "Hangup");

	if (port_number > 0)
	{
	   if ((strcmp (wan_changed_params->port_address, ip_address) != 0) && (is_an_ip_address(wan_changed_params->port_address)))
   	{
      	strcpy (host_address.ip_addr, (void *)wan_changed_params->port_address) ;
	      host_address.port = port_number + 1 ;
   	   cm_insert_string (CM_PROXY_SECTION, "Privileged User Address", (void *)&host_address) ;
	   }
   	else
      	printf ("Enter Valid IP Address\n") ;
	}
}														

/* Jyothi */

/* sudha 03 June 1999 */
void display_wan_ras_message(Request_t* request) 
{
	InitReturnBuffer(request, WANMSG_PAGE_data_ptr, strlen(WANMSG_PAGE_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

BYTE get_wan_port_number() 
{
  return (wan_port_number + 1) ;
}

void display_isdn_page(Request_t* request)
{
   BYTE *buffer ;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	printf("Displaying ISDN Configuration Page...\n");
	
   buffer = (BYTE*)malloc(strlen(EDIT_ISDN_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display ISDN Configuration Page\n") ;
		display_framed_or_standard_main_page(request) ;
		return ;
	} 	
	strcpy(buffer, EDIT_ISDN_PAGE_data_ptr) ;
	fill_the_isdn_form_with_appropriate_values(buffer, wan_port_number) ;
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
   free (buffer) ;
}


void	fill_the_isdn_form_with_appropriate_values(BYTE* buffer, BYTE wan_port_number)
{
   char isdn_ini_string[50];
   char isdn_edit_string[4][25] ;
   int  index = 0 ;
   USHORT isdn_search_to_start_at = 0 ;

   if ((web.model_number == MODEL_MTSR3_200) || ((web.model_number == MODEL_MTSR2_201) && (wan_port_number == 0)))
   {  
       printf("ISDN not supported\n") ;
       return ;
   }
   else 
      if (((web.model_number == MODEL_MTSR2_201) && (wan_port_number == 1)) || (web.model_number == MODEL_MTSR1_202NT) || (web.model_number == MODEL_MTSR1_202ST))
      {
          get_parameter_by_name (CM_WAN_SECTION, "ISDN WAN Port ConfigName", wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50); 
          if ( !strcmp(&isdn_ini_string[0], NULL))
          {
 		       isdn_search_to_start_at = search_and_replace ("#___config_name___#", "", buffer, TRUE, 0) ;
             strcpy(&isdn_ini_string[0],"USA_5ESS") ;
             set_parameter_by_name (CM_WAN_SECTION, "ISDN Wan Port ConfigName", wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0]) ;
             strcpy(isdn_edit_string[0], "AT&T 5ESS") ;  
             strcpy(&isdn_ini_string[0], "AT!C0=0") ;
             USType = 1 ;
             set_parameter ( CM_WAN_SECTION,(void *)wan.port[0].isdn_info.strings.init_string[0][0], wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0]) ;
          }
          else
          {
		      isdn_search_to_start_at = search_and_replace ("#___config_name___#", isdn_ini_string, buffer, TRUE, 0) ;
            get_parameter (CM_WAN_SECTION, (void *) &wan.port[0].isdn_info.strings.init_string[0][0], wan_port_number , CM_STRING_FORMAT, &isdn_ini_string[0], 50); 
            switch ( isdn_ini_string[6])
            {
              case '0':  isdn_search_to_start_at = search_and_replace ("#___switch_type___#", "AT&T 5ESS", buffer, TRUE, isdn_search_to_start_at) ;
                         USType = 1;
                         break;
              case '1':  isdn_search_to_start_at = search_and_replace ("#___switch_type___#", "DMS-100", buffer, TRUE, isdn_search_to_start_at) ;
                         USType = 1;
                         break;
              case '2':  isdn_search_to_start_at = search_and_replace ("#___switch_type___#", "NET3", buffer, TRUE, isdn_search_to_start_at) ;
                         USType = 0;
                         break;
              case '3':  isdn_search_to_start_at = search_and_replace ("#___switch_type___#", "1TR6", buffer, TRUE, isdn_search_to_start_at) ;
                         USType = 0;
                         break;
              case '4':  isdn_search_to_start_at = search_and_replace ("#___switch_type___#", "INS64", buffer, TRUE, isdn_search_to_start_at) ;
                         USType = 0;
                         break;
              case '5':  isdn_search_to_start_at = search_and_replace ("#___switch_type___#", "NI-1", buffer, TRUE, isdn_search_to_start_at) ;
                         USType = 1;
                         break;
              case '6':  isdn_search_to_start_at = search_and_replace ("#___switch_type___#", "VN4", buffer, TRUE, isdn_search_to_start_at) ;
                         USType = 0;
                         break;
              default :  isdn_search_to_start_at = search_and_replace ("#___switch_type___#", "NET3", buffer, TRUE, isdn_search_to_start_at) ;
                         USType = 0;
                         break;
            }
          }
          if (USType)
          {
             get_parameter (CM_WAN_SECTION, (void *) &wan.port[0].isdn_info.strings.init_string[1][0],
      	 	   wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50) ; 
             strcpy(&isdn_edit_string[0][0], &isdn_ini_string[6]);
             get_parameter (CM_WAN_SECTION, (void *) &wan.port[0].isdn_info.strings.init_string[2][0],
 		      	wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50) ; 
             strcpy(&isdn_edit_string[1][0], &isdn_ini_string[7]);
          }

          get_parameter (CM_WAN_SECTION, (void *) &wan.port[0].isdn_info.strings.init_string[3][0],
		    	   wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50) ; 

          if (!strcmp (&isdn_ini_string[0], NULL))
          {
             strcpy(&isdn_edit_string[2][0], "000") ;
             if (!USType)
               strcpy(&isdn_edit_string[0][0], "000") ;
          }
          if (isdn_ini_string[0])
          {
             if (!USType)
             {
                index = 6;
                while ( index < strlen ( &isdn_ini_string[0]))
                {
                   if ( isdn_ini_string[index] == ':')
                   {
                      memcpy (&isdn_edit_string[0][0], &isdn_ini_string[6], index-6) ;
                      isdn_edit_string[0][index-6] = 0;
                      strcpy (&isdn_edit_string[2][0], &isdn_ini_string[index+1]);
                      break;
                   }
                   index++;
                }
                if ( index == strlen ( &isdn_ini_string[0]) )
                {
                   strcpy (&isdn_edit_string[0][0], &isdn_ini_string[6]);
                   strcpy (&isdn_edit_string[2][0], "000");
                }
             }
             else
               strcpy (&isdn_edit_string[2][0], &isdn_ini_string[6]);
          }

          get_parameter (CM_WAN_SECTION, (void *) &wan.port[0].isdn_info.strings.init_string[4][0],
         	   wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50); 
            if (!strcmp (&isdn_ini_string[0], NULL))
            {
               strcpy(&isdn_edit_string[3][0], "000");
               if (!USType)
                 strcpy(&isdn_edit_string[1][0],"000");
            }
            if (isdn_ini_string[0])
            {
               if (!USType)
               {
                  index = 7;
                  while ( index < strlen ( &isdn_ini_string[0] ))
                  {
                     if ( isdn_ini_string[index] == ':')
                     {
                        memcpy (&isdn_edit_string[1][0], &isdn_ini_string[7], index-7) ;
                        isdn_edit_string[1][index-7] = 0 ;
                        strcpy (&isdn_edit_string[3][0], &isdn_ini_string[index+1]) ;
                        break ; 
                     }
                     index++ ;
                  }
                  if ( index == strlen ( &isdn_ini_string[0]) )
                  {
                     strcpy (&isdn_edit_string[1][0], &isdn_ini_string[7]) ;
                     strcpy (&isdn_edit_string[3][0], "000") ;
                  }
               }
               else
                  strcpy (&isdn_edit_string[3][0], &isdn_ini_string[7]);
            }

        if (USType)
        {
          isdn_search_to_start_at = search_and_replace ("#SUS", "", buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#___TEXT___#___#____", isdn_edit_string[0], buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#___TEXT___#___#____", isdn_edit_string[1], buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#___TEXT___#___#____", isdn_edit_string[2], buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#___TEXT___#___#____", isdn_edit_string[3], buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#EUS", "", buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#SSE", "<!--", buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#ESE", "-->", buffer, TRUE, isdn_search_to_start_at) ;
        } 
        else
        {
          isdn_search_to_start_at = search_and_replace ("#SUS", "<!--", buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#EUS", "-->", buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#SSE", "", buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#___TEXT___#___#____", isdn_edit_string[0], buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#___TEXT___#___#____", isdn_edit_string[1], buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#___TEXT___#___#____", isdn_edit_string[2], buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#___TEXT___#___#____", isdn_edit_string[3], buffer, TRUE, isdn_search_to_start_at) ;
          isdn_search_to_start_at = search_and_replace ("#ESE", "", buffer, TRUE, isdn_search_to_start_at) ;
        }
      }
}

void change_isdn_parameters(Request_t* request)
{
	CHANGE_ISDN_PARAMS_form_output_type* isdn_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	isdn_changed_params = (CHANGE_ISDN_PARAMS_form_output_type*)form_data_of_request(request) ;
	if (isdn_changed_params == NULL)
	{
    	printf("ISDN : form_data_of_request failing to give the form data\n") ;
		return;
	}
	save_the_value_from_isdn_form (isdn_changed_params) ;
   display_framed_or_standard_main_page(request) ;
}  

void save_the_value_from_isdn_form(CHANGE_ISDN_PARAMS_form_output_type* isdn_changed_params)
{
   int index = 0 ;
   char isdn_ini_string4[50], isdn_ini_string5[50], isdn_ini_string[50] ;


/***** ISDN DATA SPID NUMBER *********/      

      strcpy (&isdn_ini_string[0], "AT*!C6=") ;
      if ( USType )
          strcat (&isdn_ini_string[0], isdn_changed_params->isdn_data_spid) ;
      set_parameter ( CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[1][0],
	   	  wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0]) ;
      if ( !USType ) 
      {
         get_parameter ( CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[3][0],
            wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50) ;

         strcpy ( &isdn_ini_string4[0],"AT!N1=") ;
         strcat ( isdn_ini_string4, isdn_changed_params->data_isdn) ;
         if ( isdn_ini_string[0] )
         {
            index = 6;
            while (index < strlen( &isdn_ini_string[0]))
            {
               if (isdn_ini_string[index] == ':')
               {
                  strcat (isdn_ini_string4, &isdn_ini_string[index]) ;
                  break ;
               }
               index++ ;
            }
            if ( index == strlen( &isdn_ini_string[0] ))
               strcat ( isdn_ini_string4, ":0" ) ;
         }

         set_parameter ( CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[3][0],
    		 	   wan_port_number, CM_STRING_FORMAT, &isdn_ini_string4[0]) ;
      }

/***** ISDN VOICE SPID NUMBER *********/
      
      strcpy( &isdn_ini_string[0], "AT*!C6=") ;
      if ( USType )
         strcat (isdn_ini_string, isdn_changed_params->isdn_voice_spid) ;
      set_parameter ( CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[2][0],
	   	wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0]) ;
         if ( !USType ) 
         {
            get_parameter ( CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[4][0],
              wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50) ;

            strcpy (&isdn_ini_string5[0], "AT*!N1=") ;
            strcat (isdn_ini_string5, isdn_changed_params->voice_isdn) ;
            if ( isdn_ini_string[0] )
            {
               index = 7;
               while (index < strlen (&isdn_ini_string[0]))
               {
                  if ( isdn_ini_string[index] == ':')
                  {
                     strcat ( isdn_ini_string5, &isdn_ini_string[index]) ;
                     break ;
                  }
                  index++ ;
               }
               if ( index == strlen (&isdn_ini_string[0] ))
                  strcat (isdn_ini_string5, ":0") ;
            }
            set_parameter (CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[4][0],
	   		   wan_port_number, CM_STRING_FORMAT, &isdn_ini_string5[0]) ;
         }

/***** ISDN DATA DIR SUB NUMBER *********/

         strcpy ( &isdn_ini_string[0], "AT!N1=") ;
         if ( USType )
         {
             strcat ( isdn_ini_string, isdn_changed_params->isdn_data_dir_num) ;
             set_parameter (CM_WAN_SECTION, (void *) &wan.port[0].isdn_info.strings.init_string[3][0],
         		wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0]) ;
         }
         else
         {
               get_parameter ( CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[3][0],
                  wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50) ;
               if ( isdn_ini_string[0] )
               {
                  index = 0 ;
                  while ( index < strlen ( &isdn_ini_string[0] ))
                  {
                     if ( isdn_ini_string[index] == ':' )
                     {
                        memcpy (&isdn_ini_string4[0], &isdn_ini_string[0], index+1) ;
                        isdn_ini_string4[index+1] =0;
                        strcat ( isdn_ini_string4, isdn_changed_params->data_sub_address) ;
                        break ;
                     }
                     index++ ;
                  }
                  if ( index == strlen ( &isdn_ini_string[0] ))
                  {
                     strcpy ( isdn_ini_string4, isdn_ini_string ) ;
                     if ( index == 6 )
                        strcat ( isdn_ini_string4, "0") ;
                     strcat ( isdn_ini_string4, ":") ;
                     strcat ( isdn_ini_string4, isdn_changed_params->data_sub_address) ;
                  }
                  set_parameter(CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[3][0],
            			wan_port_number, CM_STRING_FORMAT, &isdn_ini_string4[0]) ;
               }
               else
               {
                  printf("Enter ISDN Data value first \n") ;
                  return ;
               }
         }

/***** ISDN VOICE DIR SUB NUMBER *********/

         strcpy ( &isdn_ini_string[0], "AT*!N1=") ;
         if ( USType )
         {
              strcat ( isdn_ini_string, isdn_changed_params->isdn_voice_dir_num) ;
              set_parameter (CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[4][0],
          	  wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0]) ;
          }
          else
          {
                get_parameter ( CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[4][0],
                   wan_port_number, CM_STRING_FORMAT, &isdn_ini_string[0], 50) ;
                if (isdn_ini_string[0])
                {
                   index = 0 ;
                   while (index < strlen ( &isdn_ini_string[0] ))
                   {
                      if ( isdn_ini_string[index] == ':' )
                      {
                          memcpy (&isdn_ini_string5[0], &isdn_ini_string[0], index+1) ;
                          isdn_ini_string5[index+1] = 0 ;
                         strcat ( isdn_ini_string5, isdn_changed_params->voice_sub_address);
                         break ;
                      }
                      else
                         index++ ;
                   }
                   if (index == strlen ( &isdn_ini_string[0] ))
                   {
                      strcpy (isdn_ini_string5, isdn_ini_string) ;
                      if ( index == 7 )
                         strcat (isdn_ini_string5, "0") ;
                      strcat (isdn_ini_string5, ":") ;
                      strcat (isdn_ini_string5, isdn_changed_params->voice_sub_address) ;
                   }
                   set_parameter(CM_WAN_SECTION,(void *) &wan.port[0].isdn_info.strings.init_string[4][0],
             			wan_port_number, CM_STRING_FORMAT, &isdn_ini_string5[0]) ;
                }
                else
                {
                   printf("Enter ISDN Voice value first \n") ;
                   return ;
                }
          }               

}

/* Jyothi */

/*-------------------------- Application Configuration ----------------*/
void display_application_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	printf("Displaying Application Configuration Page...\n");

	fill_the_application_form_with_appropriate_values(APPLICATION_CONFIG_PAGE_data_ptr);
	InitReturnBuffer(request, APPLICATION_CONFIG_PAGE_data_ptr, strlen(APPLICATION_CONFIG_PAGE_data_ptr), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(APPLICATION_CONFIG_PAGE_data_ptr);
}

void 	fill_the_application_form_with_appropriate_values(BYTE* buffer)
{
	USHORT search_to_start_at = 0;
   BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, password[100], decrypted_password[100];

	number_of_saved_indices = 0;

 /*Router Password */
/*	search_to_start_at = get_value_and_handle_error_2(CM_TELNET_SECTION, (void*)&telnet.password, port_number, "Router Password", search_to_start_at, buffer);*/
   if (get_parameter(CM_TELNET_SECTION, (void*)&telnet.password, port_number,
                     CM_STRING_FORMAT, (void*)password, 100) == CM_GET_SUCCESSFUL)
   {
      decrypt(password, decrypted_password);
      append_quotes(decrypted_password);
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_LONG_TEXT_BOX], decrypted_password, buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_LONG_TEXT_BOX;
   }
   else
   {
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_LONG_TEXT_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_LONG_TEXT_BOX;
   }


 /* Server IP Address */
 	search_to_start_at = get_value_and_handle_error_8(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, 0, "Server IP Address", search_to_start_at, buffer);

 /* Telnet Server Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_TELNET_SECTION, (void*)&telnet.enabled, port_number, "Telnet Enabled", search_to_start_at, buffer);

 /*TFTP Server Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_TFTP_SECTION, (void*)&tftp.enabled, port_number, "Tftp Enabled", search_to_start_at, buffer);

 /*WEB Server Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_WEB_SECTION, (void*)&web.enabled, port_number, "WEB Enabled", search_to_start_at, buffer);

 /*Dumb TTY Managament Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_TELNET_SECTION, (void*)&telnet.dumb_tty_enabled, port_number, "Dumb TTY Enabled", search_to_start_at, buffer);

 /* Ag Server enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_AG_SECTION, (void*)&ag.enabled, port_number, "Ag Enabled", search_to_start_at, buffer);

 /* Ag Server Name*/
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.server_name, port_number, "Ag Server Name", search_to_start_at, buffer);

#if 0
 /*IPX Receives Per Session*/
	search_to_start_at = get_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.ipx_interface.receives_per_session, port_number, "IPX Recv Per Session", search_to_start_at, buffer);
#endif /* Not Reqd for Proxy */

	number_of_saved_indices--;

}

void change_application_parameters(Request_t* request)
{
	CHANGE_APPLICATION_PARAMS_form_output_type* app_changed_params;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	app_changed_params = (CHANGE_APPLICATION_PARAMS_form_output_type*)form_data_of_request(request);
	if (app_changed_params == NULL)
	{
		return;
	}
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	make_changes_to_corresponding_app_port(app_changed_params);
   display_framed_or_standard_main_page(request);
}

void make_changes_to_corresponding_app_port(CHANGE_APPLICATION_PARAMS_form_output_type* app_changed_params)
{
   BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT;

   set_value_and_handle_error_2(CM_TELNET_SECTION, (void*)&telnet.password, port_number, (void*)app_changed_params->router_password, "Router Password");

   set_value_and_handle_error_1(CM_TELNET_SECTION, (void*)&telnet.enabled, port_number, (void*)&app_changed_params->telnet_server_enable, "Telnet Server");
   set_value_and_handle_error_1(CM_TFTP_SECTION, (void*)&tftp.enabled, port_number, (void*)&app_changed_params->tftp_server_enable, "TFTP Server");
   set_value_and_handle_error_1(CM_WEB_SECTION, (void*)&web.enabled, port_number, (void*)&app_changed_params->web_server_enable, "WEB Server");
   set_value_and_handle_error_1(CM_TELNET_SECTION, (void*)&telnet.dumb_tty_enabled, port_number, (void*)&app_changed_params->dumb_terminal_management_enable, "DTTY Enabled");
   set_value_and_handle_error_1(CM_AG_SECTION, (void*)&ag.enabled, port_number, (void*)&app_changed_params->ag_enable, "AG Enabled");

	if ((strlen(app_changed_params->ag_server_name) > 15) ||
		(validate_alpha_numeric_underscore_name_and_convert_to_upper_case(app_changed_params->ag_server_name) == FALSE))
		printf("\n\r\Enter ag server name of length 15 ('A'-'Z', 'a'-'z', 0-9,_) : ");
	else		
   	set_value_and_handle_error_2(CM_AG_SECTION, (void*)&ag.server_name, port_number, (void*)app_changed_params->ag_server_name, "AG Server Name");

}
     
/* ---------------------------- PPP Section-----------------------------*/
void  display_ppp_cfg_page_for_wan1(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
   byte* buffer ;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying PPP Configuration Page of WAN1...\n");
	buffer = (BYTE*)malloc(strlen(PPP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, PPP_CONFIG_PAGE_data_ptr);

	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT1, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT1);

   if((web.model_number == 5) || (web.model_number == 6))
	  search_and_replace("%##$###%", "WAN", buffer, TRUE, 0);
   else
	  search_and_replace("%##$###%", "WAN1", buffer, TRUE, 0);
   display_ppp_page(request, buffer , 0);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ppp_config_port = WAN_PORT1;
   free(buffer) ;
}

void  display_ppp_cfg_page_for_wan2(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
   byte* buffer ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 2))
	{
		return;
	}
	buffer = (BYTE*)malloc(strlen(PPP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, PPP_CONFIG_PAGE_data_ptr);

	printf("Displaying PPP Configuration Page of WAN2...\n");

	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT2, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT2);

	search_and_replace("%##$###%", "WAN2", buffer, TRUE, 0);
	display_ppp_page(request,  buffer, 1);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ppp_config_port = WAN_PORT2;
	free(buffer);
}

void  display_ppp_cfg_page_for_wan3(Request_t* request)
{
	USHORT  replaced_anchor_index_in_the_buffer;
   byte* buffer ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if(!this_port_present_in_the_current_router(request, 3))
	{
		return;
	}

	printf("Displaying PPP Configuration Page of WAN3...\n");
	buffer = (BYTE*)malloc(strlen(PPP_CONFIG_PAGE_data_ptr));
	if (buffer == NULL)
	{
		printf("WEB:Not enough memory to display IP Configuration Page\n");
		display_framed_or_standard_main_page(request);
		return;
	} 	
	strcpy(buffer, PPP_CONFIG_PAGE_data_ptr);

	replaced_anchor_index_in_the_buffer= disable_hyperlink_and_change_text_colour((USHORT)WAN_PORT3, buffer);
	check_for_need_and_hide_irrelevent_fields(WAN_PORT3);

	search_and_replace("%##$###%", "WAN3", buffer, TRUE, 0);
	display_ppp_page(request, buffer, 2);

	enable_hyperlink(replaced_anchor_index_in_the_buffer, buffer);
	show_the_hidden_fields();
	ppp_config_port = WAN_PORT3;
	free(buffer);
}

void display_ppp_page(Request_t* request, BYTE* buffer, BYTE port_number)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   check_for_model_number_and_replace (buffer) ;
	fill_the_ppp_form_with_appropriate_values(buffer, port_number);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
}

void fill_the_ppp_form_with_appropriate_values(BYTE* buffer, BYTE port_number)
{
	USHORT search_to_start_at = 0, dial_in_out_type;
   BYTE slip_enabled;
   BYTE chap_returned_byte[20], pap_returned_byte[20], password[100], decrypted_password[100] ;

	number_of_saved_indices = 0;

 /*Dial Number */
	search_to_start_at = get_value_and_handle_error_12(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.strings.modem_dial_number, port_number, "Dial Number", search_to_start_at, buffer);

	/*PPP Enabled*/
	/* If Slip is enabled and if the port is dialing then it is not reqd check ppp port  */
	if (get_parameter(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled, port_number, CM_INDEX_FORMAT, (void*)&slip_enabled, 0) != CM_GET_SUCCESSFUL)
	{
		slip_enabled = FALSE;
	}
	/* Is port answering */
	get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.dial_in_out_type, port_number, CM_USHORT_FORMAT, (void*)&dial_in_out_type, 4);

   if ((slip_enabled) && (dial_in_out_type == 1))
   {
      /* Skip PPP Enable - Checkbox */
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "       ", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
   }   
   else
   {
      /* Continue normally */
   	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, "PPP Enabled", search_to_start_at, buffer);
   }

  /*DataCompression Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_CCP_SECTION, (void*)&ccp.ports[0].enabled, port_number, "DataCompression Enabled", search_to_start_at, buffer);
      
  /*VJC Enabled*/
	search_to_start_at = get_value_and_handle_error_1(CM_VJC_SECTION, (void*)&vjc.port[0].vjc_compression_enabled, port_number, "VJC Enabled", search_to_start_at, buffer);

  /*UserName*/
	search_to_start_at = get_value_and_handle_error_13(CM_PPP_SECTION, (void*)ppp.port[0].authentication.user_name, port_number, "UserName", search_to_start_at, buffer);

  /*Password*/
/* 	search_to_start_at = get_value_and_handle_error_13(CM_PPP_SECTION, (void*)ppp.port[0].authentication.password, port_number, "Password", search_to_start_at, buffer);*/

   if (get_parameter (CM_PPP_SECTION, (void*)ppp.port[0].authentication.password, port_number, CM_STRING_FORMAT, (void*)&password, 100) != CM_GET_SUCCESSFUL)
      printf ("Failed to get PPP password\n") ;
   else
   {
      decrypt(password, decrypted_password);
      append_quotes(decrypted_password);
      search_to_start_at = search_and_replace(templates[ENUM_LONG_USER_NAME], decrypted_password, buffer, TRUE, search_to_start_at);
   }
  /*Periodic Timer*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].authentication.timeout, port_number, "Periodic Timer", search_to_start_at, buffer);

  /*Number of Retries*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].authentication.maximum_number_of_retries , port_number, "Number of Retries", search_to_start_at, buffer);

   /* Slip Enabled */
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, "SLIP Enabled", search_to_start_at, buffer);
  
   /* CSlip Enabled */
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].cslip_enabled , port_number, "CSLIP Enabled", search_to_start_at, buffer);

   /* MTU */
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].slip_port.maximum_transmit_bufsize, port_number, "MTU", search_to_start_at, buffer);


  /*PAP/CHAP/PAP or CHAP Enabled*/
	get_parameter_by_name(CM_PPP_SECTION, "PAP", port_number, CM_STRING_FORMAT, (void*)pap_returned_byte, 20) ;

	get_parameter_by_name(CM_PPP_SECTION, "CHAP", port_number, CM_STRING_FORMAT, (void*)chap_returned_byte, 20) ;

   if ((strcmp(pap_returned_byte, "enabled") != 0) && (strcmp(chap_returned_byte, "enabled") != 0))
       search_to_start_at = search_and_replace ("#__CBOX", "checked", buffer, TRUE, search_to_start_at) ; 
     
    if ((strcmp(pap_returned_byte, "enabled") == 0) && (strcmp(chap_returned_byte,"enabled") !=0))
       search_to_start_at = search_and_replace ("#__CBOX", "checked", buffer, TRUE, search_to_start_at) ;
    else
       search_to_start_at = search_and_replace ("#__CBOX", "       ", buffer, TRUE, search_to_start_at) ;

    if ((strcmp(pap_returned_byte, "enabled") != 0) && (strcmp(chap_returned_byte, "enabled") == 0))
       search_to_start_at = search_and_replace ("#__CBOX", "checked", buffer, TRUE, search_to_start_at) ;
    else
       search_to_start_at = search_and_replace ("#__CBOX", "       ", buffer, TRUE, search_to_start_at) ;

    if ((strcmp(pap_returned_byte, "enabled") == 0) && (strcmp(chap_returned_byte, "enabled") == 0))
       search_to_start_at = search_and_replace ("#__CBOX", "checked", buffer, TRUE, search_to_start_at) ;
    else
       search_to_start_at = search_and_replace ("#__CBOX", "       ", buffer, TRUE, search_to_start_at) ;


  /*Remote Port Setup*/
/* Jo Not required for proxy
	search_to_start_at = get_value_and_handle_error_6(CM_PPP_SECTION, (void*)&ppp.port[0].client_only, port_number , "Remote Port Setup", search_to_start_at, buffer);  */

   number_of_saved_indices--;
}

void change_the_ppp_parameters(Request_t* request)
{
	CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
	ppp_changed_params = (CHANGE_PPP_CONFIG_PAGE_form_output_type*)form_data_of_request(request);
	if (ppp_changed_params == NULL)
		return;
	make_changes_to_corresponding_ppp_port(ppp_config_port, ppp_changed_params);
   display_framed_or_standard_main_page(request);
}

void make_changes_to_corresponding_ppp_port(enum wan_port_types ppp_config_port, CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params)
{
   switch(ppp_config_port)
   {
      case WAN_PORT1 :
      	save_the_values_from_ppp_form(ppp_changed_params, 0);
         break;

      case WAN_PORT2 :
      	save_the_values_from_ppp_form(ppp_changed_params, 1);
         break;

      case WAN_PORT3 :
      	save_the_values_from_ppp_form(ppp_changed_params, 2);
         break;

   }
}

void  save_the_values_from_ppp_form(CHANGE_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params, BYTE port_number)
{
	BYTE temp_disabled[20], temp_enabled[20] ;
	USHORT answering = 0;
	ULONG temp;

   set_value_and_handle_error_2(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.strings.modem_dial_number, port_number, (void*)ppp_changed_params->dial_number, "Dial Number");
   
   if (ppp_changed_params->ppp_enabled)
	{
		/* Check whether this port is answring if so proceed , otherwise
		   if slip is disabled u can proceed */
		if (get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.dial_in_out_type, port_number, CM_USHORT_FORMAT, (void*)&answering, 4) == CM_GET_SUCCESSFUL)
		{
			if (answering == 1)
				set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, (void*)&ppp_changed_params->ppp_enabled, "PPP Enabled");
			else
			/* Is Slip Enabled */
			if (!ppp_changed_params->slip_enabled)
				set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, (void*)&ppp_changed_params->ppp_enabled, "PPP Enabled");
		}
		else
		{
			/* Don't do anything if fail to know if port is answering */
		} 
	}
	else
	{
		temp = 0;
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].enabled , port_number, (void*)&temp, "PPP Enabled");
	}

	set_value_and_handle_error_1(CM_CCP_SECTION, (void*)&ccp.ports[0].enabled, port_number, (void*)&ppp_changed_params->data_compression_enabled, "Data Compression Enabled");
	set_value_and_handle_error_1(CM_VJC_SECTION, (void*)&vjc.port[0].vjc_compression_enabled, port_number, (void*)&ppp_changed_params->vjc_enabled, "VJC Enabled");
	set_value_and_handle_error_2(CM_PPP_SECTION, (void*)ppp.port[0].authentication.user_name, port_number, (void*)ppp_changed_params->user_name, "User Name");
	set_value_and_handle_error_2(CM_PPP_SECTION, (void*)ppp.port[0].authentication.password, port_number, (void*)ppp_changed_params->password, "Password");
	set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].authentication.timeout, port_number, (void*)ppp_changed_params->periodic_timer, "Periodic Timer");
	set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].authentication.maximum_number_of_retries, port_number, (void*)ppp_changed_params->num_of_retries, "Number Of Retries");
	if (ppp_changed_params->slip_enabled)
	{
		if (get_parameter(CM_WAN_SECTION, (void*)&wan.port[0].modem_info.dial_in_out_type, port_number, CM_USHORT_FORMAT, (void*)&answering, 4) == CM_GET_SUCCESSFUL)
		{
			if (answering == 1)
				set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, (void*)&ppp_changed_params->slip_enabled, "SLIP Enabled");
			else
			if (!ppp_changed_params->ppp_enabled)
				set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, (void*)&ppp_changed_params->slip_enabled, "SLIP Enabled");
		} 
	}
	else
	{
	 	temp = 0;
	 	set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].slip_enabled , port_number, (void*)&temp, "SLIP Enabled");
	}
   if (ppp_changed_params->slip_enabled)
    	set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].cslip_enabled , port_number, (void*)&ppp_changed_params->cslip_enabled, "CSLIP Enabled");
   else
      printf ("Enable SLIP\n") ;
	set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.port[0].slip_port.maximum_transmit_bufsize, port_number, (void*)ppp_changed_params->maximum_transmit_unit, "MTU");

/* Jo Not Required for Proxy
   ppp_changed_params->remote_port_setup = !(ppp_changed_params->remote_port_setup);
	set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.port[0].client_only, port_number, (void*)&ppp_changed_params->remote_port_setup, "Client Only");  */

   strcpy (temp_enabled, "enabled") ;
   strcpy (temp_disabled, "disabled") ;
   if (ppp_changed_params->authentication_type == 0)
      set_parameter_by_name(CM_PPP_SECTION, "PAP", port_number, CM_STRING_FORMAT, (void *)&temp_enabled) ;

   if (ppp_changed_params->authentication_type == 1)
      set_parameter_by_name(CM_PPP_SECTION, "CHAP", port_number, CM_STRING_FORMAT, (void *)&temp_enabled) ;

   if (ppp_changed_params->authentication_type == 2)
      set_parameter_by_name(CM_PPP_SECTION, "PAP OR CHAP", port_number, CM_STRING_FORMAT, (void *)&temp_enabled) ;
}

/* ------------------------- Advanced PPP Configuration ---------------*/
void display_ppp_advanced_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	printf("Displaying Advanced PPP Page...\n");

/*	replaced_anchor_index_in_the_buffer = disable_hyperlink_and_change_text_colour((USHORT)ADVANCED_PPP_CONFIG, ADVAN_PPP_CONFIG_PAGE_data_ptr);  */
	check_for_need_and_hide_irrelevent_fields(ADVANCED_PPP_CONFIG);

	send_advanced_ppp_page(request, ADVAN_PPP_CONFIG_PAGE_data_ptr);

/*	enable_hyperlink(replaced_anchor_index_in_the_buffer, ADVAN_PPP_CONFIG_PAGE_data_ptr);  */
	show_the_hidden_fields();
}

void	send_advanced_ppp_page(Request_t* request, BYTE* buffer)
{
	fill_the_advanced_ppp_form_with_appropriate_values(buffer);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	revert_back_form(buffer);
}

void	fill_the_advanced_ppp_form_with_appropriate_values(BYTE* buffer)
{
	BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, mlppp_enabled;
	USHORT search_to_start_at = 0;

	number_of_saved_indices = 0;

	/* MLPPP */
   if (get_parameter_by_name(CM_PPP_SECTION, "MLPPP", port_number, CM_INDEX_FORMAT, (void*)&mlppp_enabled, 0) == CM_GET_SUCCESSFUL)
   {
      if (mlppp_enabled)
      {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "checked", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
      }
      else
      {
		   saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "", buffer, TRUE, search_to_start_at);
		   search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		   saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
      }
   }
   else
   {
		saved_indices[number_of_saved_indices].string_starting_index = search_and_replace(templates[ENUM_CHECK_BOX], "", buffer, TRUE, search_to_start_at);
		search_to_start_at = saved_indices[number_of_saved_indices].string_starting_index;
		saved_indices[number_of_saved_indices++].template_type = ENUM_CHECK_BOX;
   }

	/* Echo Request - Maximum Number */   
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_unacknowledged_echo_requests, port_number, "Echo Request Max Number", search_to_start_at, buffer);	
	/* Echo Request - Send Interval Max*/   
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_echo_request_send_interval, port_number, "Echo Request Send Interval Max", search_to_start_at, buffer);	

	/* Termination Request - Maximum Number */
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_termination_requests, port_number, "Termination Request Max Number ", search_to_start_at, buffer);	
	/* Termination Request - Send interval Max*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_termination_request_send_interval, port_number, "Termination Send Interval Max", search_to_start_at, buffer);	

	/* Configuration Request - Maximum Number */
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_configuration_requests, port_number, "Configuration Requests Maximum Number", search_to_start_at, buffer);	
	/* Configuration Request - Send Interval Max*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_configuration_request_send_interval, port_number, "Configuration Requests Send interval Max", search_to_start_at, buffer);	
	/* Configuration Request - Backoff Interval Max*/
	search_to_start_at = get_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_configuration_request_backoff_interval, port_number, "Configuration Requests Backoff Interval Max", search_to_start_at, buffer);	

	/* Printf*/																		   
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.printing_enabled, port_number, "PPP Printf", search_to_start_at, buffer);	
	/* LCP Printf*/
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.lcp_printing_enabled, port_number, "LCP Printf", search_to_start_at, buffer);	
	/* Alarm Printf*/
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.alarm_printing_enabled, port_number, "Alarm Printf", search_to_start_at, buffer);	
	/* NCP Printf*/
	search_to_start_at = get_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.ncp_printing_enabled, port_number, "NCP Printf", search_to_start_at, buffer);	

	number_of_saved_indices --;	/* Very Importent statement */

}																						   

void change_advanced_ppp_parameters(Request_t* request)
{
	CHANGE_ADVAN_PPP_CONFIG_PAGE_form_output_type* ppp_changed_params;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	ppp_changed_params = (CHANGE_ADVAN_PPP_CONFIG_PAGE_form_output_type*)form_data_of_request(request);
	if (ppp_changed_params == NULL)
	{
		return;
	}
	make_changes_to_advanced_ppp_config(ppp_changed_params);
   if (ppp_changed_params->multilink_enabled)
     display_mlppp_message(request) ;
   else
     display_framed_or_standard_main_page(request) ;
}

void display_mlppp_message(Request_t* request) 
{
	InitReturnBuffer(request, MLPPP_PAGE_data_ptr, strlen(MLPPP_PAGE_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
}

void make_changes_to_advanced_ppp_config(CHANGE_ADVAN_PPP_CONFIG_PAGE_form_output_type* advanced_ppp_changed_params)
{
		BYTE port_number = CM_NO_PORT_PARAMETER_PRESENT, value;

      value = (BYTE)advanced_ppp_changed_params->multilink_enabled;
      set_parameter_by_name(CM_PPP_SECTION, "MLPPP", port_number, CM_INDEX_FORMAT, (void*)&value);  

	/* Echo Request - Maximum Number */   
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_unacknowledged_echo_requests, port_number, (void*)advanced_ppp_changed_params->max_number_echo_request, "Echo Request Max Number");
	/* Echo Request - Send Interval Max*/   
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_echo_request_send_interval, port_number, (void*)advanced_ppp_changed_params->send_interval_max_echo_request, "Echo Request Send Interval Max");

	/* */
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_termination_requests, port_number, (void*)advanced_ppp_changed_params->max_number_terminate_request, "Termination Send Max Number");
	/* */
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_termination_request_send_interval, port_number, (void*)advanced_ppp_changed_params->send_interval_max_terminate_request, "Termination Send Interval Max");
		
	
	/* Configuration Request - Maximum Number */
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_number_of_configuration_requests, port_number, (void*)advanced_ppp_changed_params->max_number_configuration_request, "Configuration Request - Maximum Number");
	/* Configuration Request - Send Interval Max*/
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_configuration_request_send_interval, port_number, (void*)advanced_ppp_changed_params->send_interval_max_configuration_request, "Configuration Request - Send Interval Max");
	/* Configuration Request - Backoff Interval Max*/
		set_value_and_handle_error_2(CM_PPP_SECTION, (void*)&ppp.maximum_configuration_request_backoff_interval, port_number, (void*)advanced_ppp_changed_params->backoff_interval_max, "Configuration Request - Backoff Interval Max");
		
	/* Printf*/
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.printing_enabled, port_number, (void*)&advanced_ppp_changed_params->printf_enabled, "Printf");
	/* LCP Printf*/
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.lcp_printing_enabled, port_number, (void*)&advanced_ppp_changed_params->lcp_printf_enabled, "LCP Printf");
	/* Alarm Printf*/
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.alarm_printing_enabled, port_number, (void*)&advanced_ppp_changed_params->alarm_printf_enabled, "Alarm Printf");
	/* NCP Printf*/
		set_value_and_handle_error_1(CM_PPP_SECTION, (void*)&ppp.ncp_printing_enabled, port_number, (void*)&advanced_ppp_changed_params->ncp_printf_enabled, "NCP Printf");
}
      
/* --------------------------- Util Functions --------------------------*/

/* NOTE: The following function assumes that search_string length is equal 
 			to replace_string length */

int search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at)
{
	USHORT buffer_length, i, j, search_string_starting_index;

	buffer_length = strlen(buffer);

	for(i = search_to_start_at + 1, j = 0; i <= buffer_length; ++i)
	{
		if (buffer[i] == search_string[j])
		{
			if ( j == 0) /*Remember where the search string starts in the buffer*/
				search_string_starting_index = i;

			if (j == (strlen(search_string)-1)) /* Search completed? */
			{
				if (required_to_replace)
					replace_string_starting_from_index(search_string, search_string_starting_index, replace_string, buffer);
				return (search_string_starting_index);
			}

			j++;
		}
		else
		{
			if (j)
			{
			  	i = search_string_starting_index;
		  		j = 0;
			}
		}
	}
#ifdef _NAVDEBUG_
		printf("Search String not found in the buffer %s\n", search_string);
#endif
	return(-1);
}

void replace_string_starting_from_index(BYTE* search_string, USHORT search_string_starting_index, char* replace_string, char* buffer)
{
	USHORT i, replace_string_length, search_string_length;

	replace_string_length = strlen(replace_string);
	search_string_length = strlen(search_string);

	for(i=0; i < search_string_length; ++i)
		buffer[search_string_starting_index+i] = 32;

	for(i=0; i < replace_string_length; ++i)
		buffer[search_string_starting_index+i] = replace_string[i];
}

USHORT	disable_hyperlink_and_change_text_colour(USHORT port_type, BYTE* buffer)
{
	USHORT port_number;
	USHORT i, search_to_start_at = 0, temp;

	port_number = port_type;

	for(i = 0;i < port_number;++i)
	{
		temp = search_and_replace("<A ","<!A", buffer, FALSE, search_to_start_at);
	   search_to_start_at = temp;
	}
	return (search_and_replace("<A ","<!A", buffer, TRUE, search_to_start_at));
}

void enable_hyperlink(USHORT replaced_anchor_index_in_the_buffer, BYTE* buffer)
{
	replace_string_starting_from_index(" ", replaced_anchor_index_in_the_buffer, "<A ", buffer);
}

void check_for_need_and_hide_irrelevent_fields()
{
}

void show_the_hidden_fields()
{
}

void revert_back_form(char* buffer)
{
	USHORT i;
   for(i=0; i <= number_of_saved_indices; ++i)
	{
		replace_string_starting_from_index(" ",saved_indices[i].string_starting_index, templates[saved_indices[i].template_type], buffer);
	}
	number_of_saved_indices = 0;
}

void write_the_setup_and_reboot(Request_t* request)
{  
	BYTE buffer[] = "Configuration is being written to Flash. Afterwards router will be rebooted and it is required to establish connection once again with the router for configuration";
   enum CM_WRITE_RESULTS write_results;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   write_results = cm_write_configuration();
   if (write_results != CM_WRITE_SUCCESS)
   {               
      printf("Failed to Write \n");      
   }
	else
	{
	   cm_deinitialize_configuration_manager(CM_OWNED_BY_HTTP);
	}
}

void display_filter_menu(Request_t* request)
{

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   InitReturnBuffer(request, FILTER_MAIN_MENU_data_ptr, strlen(FILTER_MAIN_MENU_data_ptr),HTML_CONTENT_TYPE, TRUE);
}

/* Jyothi */

void   check_for_model_number_and_replace (BYTE* buffer)
{
   if (web.model_number == MODEL_UNKNOWN)
   {
     printf ("unknown model") ;
     return ;
   }
   if (web.model_number == MODEL_MTSR3_200)
   {
	  search_and_replace("#SW2", "", buffer, TRUE, 0) ;
	  search_and_replace("#SW3", "", buffer, TRUE, 0) ;
	  search_and_replace("#EW2", "", buffer, TRUE, 0) ;
	  search_and_replace("#EW3", "", buffer, TRUE, 0) ;
	  
     search_and_replace("#____WAN____#", "WAN1", buffer, TRUE, 0) ;
     search_and_replace("#_______WAN______#", "WAN2", buffer, TRUE, 0) ;
     return ;
   }

   if (web.model_number == MODEL_MTSR2_201)
   {
	  search_and_replace("#SW2", "", buffer, TRUE, 0) ;
	  search_and_replace("#SW3", "<!--", buffer, TRUE, 0) ;
	  search_and_replace("#EW2", "", buffer, TRUE, 0) ;
	  search_and_replace("#EW3", "-->", buffer, TRUE, 0) ;
	  
     search_and_replace("#____WAN____#", "WAN1 (DSU)", buffer, TRUE, 0) ;
     search_and_replace("#_______WAN______#", "WAN2 (RS-232/V.35)", buffer, TRUE, 0) ;
     return ;
   }

   if ((web.model_number == MODEL_MTSR1_202ST) || (web.model_number == MODEL_MTSR1_202NT))
   {
	  search_and_replace("#SW2", "<!--", buffer, TRUE, 0) ;
	  search_and_replace("#SW3", "<!--", buffer, TRUE, 0) ;
	  search_and_replace("#EW2", "-->", buffer, TRUE, 0) ;
	  search_and_replace("#EW3", "-->", buffer, TRUE, 0) ;
	  if (web.model_number == MODEL_MTSR1_202ST)
       search_and_replace("#____WAN____#", "WAN (ISDN-ST)", buffer, TRUE, 0) ;
     else
       search_and_replace("#____WAN____#", "WAN (ISDN-NT)", buffer, TRUE, 0) ;
     return ;
   }
}

void check_for_model_number_and_replace_link_control(BYTE* buffer, BYTE port_number)
{
   USHORT search_to_start_at ;
   if (port_number == 0)
   {
	  search_to_start_at = search_and_replace("#SLC", "<!--", buffer, TRUE, 0) ;
	  search_to_start_at = search_and_replace("#ELC", "-->", buffer, TRUE, search_to_start_at) ;
	  search_to_start_at = search_and_replace("#SLNK#", "<!--", buffer, TRUE, search_to_start_at) ;
	  search_to_start_at = search_and_replace("#ELNK#", "-->", buffer, TRUE, search_to_start_at) ;
   }
   else

   {
	  search_to_start_at = search_and_replace("#SLC", "", buffer, TRUE, 0) ;
	  search_to_start_at = search_and_replace("#ELC", "", buffer, TRUE, search_to_start_at) ;
	  search_to_start_at = search_and_replace("#SLNK#", "", buffer, TRUE, search_to_start_at) ;
	  search_to_start_at = search_and_replace("#ELNK#", "", buffer, TRUE, search_to_start_at) ;
   }
}

BYTE  local_ip_address_and_remote_ip_address_belong_to_the_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* local_mask, BYTE* remote_mask)
{
	ULONG local_ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG remote_ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG local_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG remote_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
   ULONG local_ulong_ip, remote_ulong_ip, local_ulong_mask, remote_ulong_mask;
   BYTE* temp_ptr;


	if (!is_an_ip_address(local_ip_address))
	{
		printf("Invalid Local IP Address while Validating Remote IP Address\n");
      return FALSE;
	}
   if (!is_an_ip_address(remote_ip_address))
	{
    	printf("Invalid remote IP Address while Validating Remote IP Address\n");
      return FALSE;
	}
   if (strcmp (local_ip_address, remote_ip_address) == 0)
   {
    	printf("Remote IP Address Should Be Different From Ethernet Address\n");
      return FALSE;
   }
   if (!is_an_ip_address_mask(local_ip_address, local_mask))
	{
		printf("Invalid mask for IP Address while Validating Remote IP Address\n");
      return FALSE;
	}
   if (!is_an_ip_address_mask(remote_ip_address, remote_mask))
	{
		printf("Invalid mask for Remote IP Address while Validating Remote IP Address\n");
      return FALSE;
	}
   
	/* Read each of the bytes into an array of ULONG */
	sscanf(remote_ip_address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&remote_ip_address_array[0]),(ULONG *)(&remote_ip_address_array[1]),
		(ULONG *)(&remote_ip_address_array[2]),(ULONG *)(&remote_ip_address_array[3]));

	/* Read each of the bytes into an array of ULONG */
	sscanf(local_ip_address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&local_ip_address_array[0]),(ULONG *)(&local_ip_address_array[1]),
		(ULONG *)(&local_ip_address_array[2]),(ULONG *)(&local_ip_address_array[3]));

	/* Read each of the bytes into an array of ULONG */
	sscanf(local_mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&local_mask_array[0]),(ULONG *)(&local_mask_array[1]),
		(ULONG *)(&local_mask_array[2]),(ULONG *)(&local_mask_array[3]));

	sscanf(remote_mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&remote_mask_array[0]),(ULONG *)(&remote_mask_array[1]),
		(ULONG *)(&remote_mask_array[2]),(ULONG *)(&remote_mask_array[3]));

   temp_ptr = (BYTE*)&local_ulong_ip;
   *(temp_ptr+3) = local_ip_address_array[3];
   *(temp_ptr+2) = local_ip_address_array[2];
   *(temp_ptr+1) = local_ip_address_array[1];
   *(temp_ptr)   = local_ip_address_array[0];
  
   temp_ptr = (BYTE*)&remote_ulong_ip;
   *(temp_ptr+3) = remote_ip_address_array[3];
   *(temp_ptr+2) = remote_ip_address_array[2];
   *(temp_ptr+1) = remote_ip_address_array[1];
   *(temp_ptr)   = remote_ip_address_array[0];
  
   temp_ptr = (BYTE*)&local_ulong_mask;
   *(temp_ptr+3) = local_mask_array[3];
   *(temp_ptr+2) = local_mask_array[2];
   *(temp_ptr+1) = local_mask_array[1];
   *(temp_ptr)   = local_mask_array[0];

   temp_ptr = (BYTE*)&remote_ulong_mask;
   *(temp_ptr+3) = remote_mask_array[3];
   *(temp_ptr+2) = remote_mask_array[2];
   *(temp_ptr+1) = remote_mask_array[1];
   *(temp_ptr)   = remote_mask_array[0];
  
   if ((remote_ulong_ip & remote_ulong_mask) != (local_ulong_ip & local_ulong_mask))
	{
      return FALSE;
	}
   return TRUE;
}

BYTE check_if_is_numeric_value(BYTE* buffer)
{
   BYTE i;
   for (i=0 ; i<strlen(buffer) ; ++i)
   {
      if (buffer[i] < '0' || buffer[i] > '9')
         return FALSE;
   }
   return TRUE;   
}


/* Jyothi */

#if 0
void give_the_background_logo(Request_t* request)
{
   InitReturnBuffer(request, BACKGROUND_LOGO_data_ptr, strlen(BACKGROUND_LOGO_data_ptr), GIF_CONTENT_TYPE, TRUE);
}
#endif


void give_the_background_logo(Request_t* request)
{
   InitReturnBuffer(request, BACKGROUND_LOGO_data_ptr, BACKGROUND_LOGO_compiled_buffer.data_size, GIF_CONTENT_TYPE, TRUE);
}


void give_the_mts_logo(Request_t* request)
{
   InitReturnBuffer(request, MTS_LOGO_data_ptr, MTS_LOGO_compiled_buffer.data_size, GIF_CONTENT_TYPE, TRUE);
}

void give_the_mtr_logo(Request_t* request)
{
   InitReturnBuffer(request, MTR_LOGO_data_ptr, MTR_LOGO_compiled_buffer.data_size, GIF_CONTENT_TYPE, TRUE);
}

 
#if 0
#include "navcla.h"
void give_the_class(Request_t* request)
{  
   printf("Yahooooooooooo.................\n");
   InitReturnBuffer(request, navclass_data_ptr, navclass_compiled_buffer.data_size, UNKNOWN_CONTENT_TYPE, TRUE);
}

#include "nav.h"
void give_the_htm(Request_t* request)
{
   InitReturnBuffer(request, nav_data_ptr, strlen(nav_data_ptr), HTML_CONTENT_TYPE, TRUE);
}
#endif
