/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "httpd.h"
#include "reqlist.h"
#include "util.h"
#include "datatran.h"

#include "..\..\htmlform\src\formpars.h"
#include "..\..\htmlform\src\initoper.h"

#include "..\..\genapps\src\apputil.h"

#include "formphas.h"
#include "..\..\sysdep\src\tcprw.h"
#include "uridata.h"


typedef struct  _FormProssingPhaseData_t {
HtmlFormDesc_t *form_description ; 
void *form_data ; 
void *form_text_buffer ; 
HtmlOutputFields_t html_output ; 
DataTransferStatus_t  *form_processing_handle ; 
UploadInitializationFunction_t upload_function ; 
} FormProssingPhaseData_t ; 


void init_form_variables(Request_t *request, HtmlFormDesc_t *form_description,
			 UploadInitializationFunction_t upload_function) 
{
FormProssingPhaseData_t *form_processing_data;

form_processing_data =  malloc(sizeof( FormProssingPhaseData_t ) ) ; 

/*HTTP_TRACE( "forms", sprintf( tmp_trace, "form_procesing_data = %8.8lX", form_processing_data ) );*/

request->form_phase = (  struct _FormProsseingPhaseData_t  * ) form_processing_data ; 
form_processing_data->form_description = form_description ; 
form_processing_data->upload_function = upload_function ; 
}



void init_form_processing_phase(Request_t *request) 
{
FormProssingPhaseData_t *form_processing_data;
DataTransferStatus_t *data_transfer ; 
OperationStatus_t *upload_operation ; 
int text_buffer_size ; 

form_processing_data = (FormProssingPhaseData_t * ) request->form_phase;


form_processing_data->form_processing_handle = data_transfer=get_initialized_data_transfer(); 

data_transfer->nof_operations = 1 ;


form_processing_data->form_data = 
     malloc(form_processing_data->form_description->struct_size);


/*HTTP_TRACE_MSG( "forms", sprintf( tmp_trace, "form_processing_data->form_data = %8.8lX",
	form_processing_data->form_data ) );*/

if (request->params.method == GET_METHOD)
  {
    text_buffer_size =  request->params.uri_length ; 
  }
else /*** (request->params.method == POST_METHOD) ****/
  {
    text_buffer_size = compute_text_buffer_size 
                        (form_processing_data->form_description, 
                          request->params.content_length ) ; 
  }
 

form_processing_data->form_text_buffer=malloc(text_buffer_size );




InitHtmlOutputs( &form_processing_data->html_output,
		 form_processing_data->form_description, 
		 form_processing_data->form_data,
		 form_processing_data->form_text_buffer,
		 text_buffer_size) ; 



if (form_processing_data->upload_function == NULL )
  {
    InitInputFromFormOperation(&data_transfer->io_operations[0], 
			       form_processing_data->form_description, 
			       &form_processing_data->html_output,
			       request); 
  }
else
  {
    InitInputFromFormOperationWithUploads
                  (&data_transfer->io_operations[0], 
		   form_processing_data->form_description, 
		   &form_processing_data->html_output,
		   request,
		   &upload_operation );
    (*form_processing_data->upload_function)(request, upload_operation ) ; 
  }


}




void do_form_processing_phase(Request_t *request ) 
{
FormProssingPhaseData_t *form_processing_data;

form_processing_data = (FormProssingPhaseData_t * ) request->form_phase;



ContinueDataTransfer( form_processing_data->form_processing_handle , TRUE ) ; 

if ( form_processing_data->form_processing_handle->end_of_processing)
  {

    deallocate_data_transfer(form_processing_data->form_processing_handle);

    request->status.process_status = IN_RESPONSE_INITIALIZATION ; 
    
    if ( form_processing_data->form_processing_handle->socket_should_be_closed)
      {
	shutdown_socket(&request->socket) ; 
	request->status.process_status =  SOCKET_IS_CLOSED ; 
      } 

  }



}



void free_form_processing_phase_data(Request_t *request ) 
{
FormProssingPhaseData_t *form_processing_data;

form_processing_data = (FormProssingPhaseData_t *) request->form_phase;

if (form_processing_data != NULL )
  {
    free(form_processing_data->form_data);
    free(form_processing_data->form_text_buffer);
    free(form_processing_data ) ; 
  }
}


void *form_data_of_request(Request_t *request ) 
{
FormProssingPhaseData_t *form_processing_data;

form_processing_data = (FormProssingPhaseData_t *) request->form_phase;

HTTP_TRACE( "forms", sprintf( tmp_trace, "form_processing_data = %8.8lX", form_processing_data ) );

if (form_processing_data != NULL )
  {
    return form_processing_data->form_data;
  }

/** else: ***/
return NULL;

}


