/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "httpd.h"
#include "lstnsock.h"
#include "..\..\sysdep\src\tcprw.h"

#ifndef DEFAULT_PORT
#define DEFAULT_PORT 80
#endif


static Port_t listen_port = DEFAULT_PORT ; 

void set_listen_port(Port_t port)
{
listen_port = port ; 
}


#define DEFAULT_BACKLOG 10 


#define MAX_NUMBER_LISTEN_SOCKETS 5 

ListenSocket_t listen_sockets_array[MAX_NUMBER_LISTEN_SOCKETS] ; 


void add_listen_socket(ListenSocketsList_t *listen_sockets,
					Port_t new_port_number)
{
ListenSocket_t *curr_socket ; 
int temp;
int error ; 

if (listen_sockets->nof_listen_sockets == MAX_NUMBER_LISTEN_SOCKETS) 
  {
    HTTP_REPORT_ERROR(" Too many input sockets " ) ; 
    return ; 
  }

temp = listen_sockets->nof_listen_sockets;

curr_socket = &listen_sockets->sockets[temp] ; 

curr_socket->port_address = new_port_number ; 


initialize_new_server_socket(&curr_socket->socket, curr_socket->port_address, 
			     DEFAULT_BACKLOG, &error ) ; 


listen_sockets->nof_listen_sockets++ ; 

}



void init_listen_sockets(ListenSocketsList_t *listen_sockets )
{
listen_sockets->nof_listen_sockets = 0 ; 
listen_sockets->sockets = listen_sockets_array; 

add_listen_socket( listen_sockets , listen_port ) ; 

}





