/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef URIDATA_H
#define URIDATA_H

#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\prochttp\src\util.h"

#include "..\..\htmlform\src\formpars.h"

typedef void (*UploadInitializationFunction_t)
                    (Request_t * request , 
		     void *operation_handle) ; 

typedef struct {
  enum { CONTINUE_PARSING, 
         ATTACH_PROCESS_FUNCTION,
         PROCESS_FORM  } segment_type ; 
  void (*initialization_function)(Request_t *) ; 
  void *next_dictionary ; /** should be UriParseDictionary_t ***/
  void *form_description_struct ; 
  UploadInitializationFunction_t upload_function ; 
} ParseResults_t ; 


typedef struct {
  WordList_t *segment_name_dictionary ; 
  ParseResults_t *what_to_do_on_segment ; 
/** number of options is stored in the dictionary ***/
  ParseResults_t *default_to_do ; 
} UriParseDictionary_t ;  


extern UriParseDictionary_t *root_dispatch_ptr ; 

#endif /**8 URIDATA_H ***/

