/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "httpd.h"
#include "webdisp.h"

#include "util.h"
#include "datatran.h"

#include "..\..\sysdep\src\tcprw.h"
#include "formphas.h"

void init_web_dispatcher(WWWRequestDispatcher_t *web_dispatcher) 
{
}







void do_web_processing(Request_t *request )
{

if (request->response_entity_function != NULL)
  {
    (*request->response_entity_function)(request) ;
  }
else
  {
    shutdown_socket(&request->socket) ; 
    request->status.process_status = SOCKET_IS_CLOSED ;  
  }
}


void set_next_operation_by_application(DataTransferStatus_t *transfer_status,
				       int operation_number )
{
transfer_status->application_has_set_next_operation = TRUE ; 
transfer_status->next_operation_set_by_application =  operation_number;
}




void ContinueDataTransfer(DataTransferStatus_t *transfer_status,
			  int single_iteration)
{


OperationStatus_t *curr_operation ; 
int i_operation ; 
OperationStatus_t *operation_to_close ; 

while (1) {
  curr_operation = &transfer_status->io_operations[
                         transfer_status->current_operation_number]; 

  transfer_status->application_has_set_next_operation = FALSE ; 
  HTTP_TRACE("operations", sprintf(tmp_trace, "before do of operation %d", 
			   transfer_status->current_operation_number)); 
	HTTP_TRACE( "operations", sprintf( tmp_trace, "address of operation = %8.8lX", 
		curr_operation->do_operation ) );
  (*curr_operation->do_operation)(transfer_status,  curr_operation ) ; 

  HTTP_TRACE("operations", sprintf(tmp_trace, "after do of operation %d", 
			   transfer_status->current_operation_number)); 
			   
  if ( (transfer_status->end_of_processing) ||
      ( single_iteration && 
       (curr_operation->status == END_OPERATION) &&
       (transfer_status->current_operation_number == 
	  transfer_status->nof_operations - 1) ) )
    {

		HTTP_TRACE_MSG( "operations", "111111111" );
      transfer_status->end_of_processing = TRUE ; 
      for(i_operation = 0 ; 
	  i_operation < transfer_status->nof_operations ; 
	  i_operation++)
	{
		HTTP_TRACE( "operations", sprintf( tmp_trace, "i_operation = %d", i_operation ) );
	  operation_to_close = &transfer_status->io_operations[i_operation] ; 
	  if (operation_to_close->close_operation  != NULL)
	    {
		HTTP_TRACE_MSG( "operations", "222222222" );
	      (*operation_to_close->close_operation)(operation_to_close) ; 
	    }
	}

		HTTP_TRACE_MSG( "operations", "3333333333" );

      return ; 
    } /** if (end_of_processing) *******/
   

		HTTP_TRACE_MSG( "operations", "4444444444" );
		
  /*** error if we are in status START_OPERATION here *******/
  if (curr_operation->status != END_OPERATION)
    { 
		HTTP_TRACE_MSG( "operations", "5555555555" );
      return ; 
    }

  if (!transfer_status->application_has_set_next_operation)
    {
		HTTP_TRACE_MSG( "operations", "6666666666" );
      transfer_status->current_operation_number++ ; 
      if (transfer_status->current_operation_number == 
	  transfer_status->nof_operations)
	{
		HTTP_TRACE_MSG( "operations", "7777777777" );
	  transfer_status->current_operation_number = 0 ; 
	}
    }
  else
    {
		HTTP_TRACE_MSG( "operations", "8888888888" );
       transfer_status->current_operation_number =  
	 transfer_status->next_operation_set_by_application;
     }

		HTTP_TRACE_MSG( "operations", "9999999999" );
  curr_operation = &transfer_status->io_operations[
                               transfer_status->current_operation_number]; 

  curr_operation->status = START_OPERATION ; 
		HTTP_TRACE_MSG( "operations", "AAAAAAAAAA" );
#ifndef BLOCKING_IO_ONLY
		HTTP_TRACE_MSG( "operations", "BBBBBBBBBB" );
if (  transfer_status->current_operation_number == 0 )
  {
		HTTP_TRACE_MSG( "operations", "CCCCCCCCCC" );
    return ; 
  }
#endif

		HTTP_TRACE_MSG( "operations", "DDDDDDDDDD" );

}

		HTTP_TRACE_MSG( "operations", "EEEEEEEEEE" );
}



typedef struct {
  Request_t *request ; 
  char method_alpha[3] ; 
  enum { RETURN_DETAILS, RETURN_ORIG_TEXT, W_DONE  } status ; 
} ReturnBackParamsAnswer_t ; 



void AddBuffer( DataTransferStatus_t *transfer_status , void *buffer, int len)
{
if (transfer_status->nof_buffers == DT_MAX_NOF_BUFFERS)
  {
    HTTP_REPORT_ERROR("too many buffers"); 
    return ; 
  }

transfer_status->data_buffers[transfer_status->nof_buffers] = buffer ; 
transfer_status->buffer_sizes[transfer_status->nof_buffers] = len ; 

transfer_status->nof_buffers++ ; 
}

void AddStringBuffer( DataTransferStatus_t *transfer_status , char *buffer)
{
AddBuffer( transfer_status, buffer, strlen(buffer) ) ; 
}


void ReturnBackParamsInput(
                  void /***DataTransferStatus_t**/ *transfer_status_input , 
		  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 

ReturnBackParamsAnswer_t *params ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

params = (ReturnBackParamsAnswer_t *) operation_status->handle ; 

transfer_status->nof_buffers = 0 ; 
switch (params->status) {
 case RETURN_DETAILS: {
   AddStringBuffer(transfer_status,"Answer from (the new) the dummy test:\r\n method index:");

   sprintf(params->method_alpha, "%d", params->request->params.method  ) ; 

   AddStringBuffer( transfer_status,params->method_alpha );  
   AddStringBuffer( transfer_status,  " uri:" );  

   AddBuffer(transfer_status,  params->request->params.uri, 
	     params->request->params.uri_length ); 
   AddStringBuffer( transfer_status,  "[end uri] http version:"  ); 

   AddBuffer(transfer_status,  params->request->params.http_version, 
	     params->request->params.http_version_length ); 

   AddStringBuffer( transfer_status,  "[end http version]"); 

   if ( params->request->params.content_type == CONTENT_TYPE_MULTIPART_FORM)
     {
       AddStringBuffer( transfer_status,  "multipart boundary="); 
       AddBuffer(transfer_status,  params->request->params.boundary, 
	     params->request->params.boundary_length ); 
     }



   AddStringBuffer( transfer_status,  "header fields:"); 
   AddBuffer(transfer_status, 
	     params->request->status.beginning_of_header_fields, 
	     params->request->status.nof_chars_in_header - 
	      (  params->request->status.beginning_of_header_fields -
	        params->request->status.header_data) ) ; 

   AddStringBuffer( transfer_status, "[end header fields] full header:" ) ; 
   params->status = RETURN_ORIG_TEXT ; 
   break ; 
 }
 case RETURN_ORIG_TEXT: {
   AddBuffer(transfer_status,  params->request->status.header_data, 
	     params->request->status.nof_chars_in_header ); 
   params->status =W_DONE  ; 
   break ; 
  }
 case W_DONE: {
   transfer_status->end_of_processing = TRUE ; 
   transfer_status->socket_should_be_closed = TRUE ; 
   break ; 
 }
 }

operation_status->status = END_OPERATION ; 
}


void  FreeReturnBackParams( OperationStatus_t *operation_status)
{
free(operation_status->handle) ; 
}

void InitReturnParamsOutput(Request_t *request , 
			 OperationStatus_t *operation_status)
{

ReturnBackParamsAnswer_t *return_params ; 

operation_status->do_operation = ReturnBackParamsInput ; 
operation_status->handle = return_params = 
                      malloc(sizeof( ReturnBackParamsAnswer_t) ); 
return_params->request = request ; 
return_params->status = RETURN_DETAILS  ; 

operation_status->close_operation = FreeReturnBackParams ; 
operation_status->status = START_OPERATION ; 
}

void DoHeaderInput(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
	DataTransferStatus_t *transfer_status; 
	ResponseHeaderInformation_t *header_info; 

	HttpDate_t current_date ; 

	transfer_status = (DataTransferStatus_t *)transfer_status_input ; 
	header_info = (ResponseHeaderInformation_t *) operation_status->handle ; 

	transfer_status->nof_buffers = 0 ; 

	if (header_info->was_sent)
	{
    operation_status->status = END_OPERATION ; 
    transfer_status->end_of_processing = TRUE ; 
    return ; 
   }


	switch(header_info->status) 
	{
	 case STATUS_OK:             
	 			{ 
					AddStringBuffer(transfer_status , "HTTP/1.0 200 OK\r\n") ; 
					break ; 
				}
	 case FORBIDDEN:      
	 			{ 
					AddStringBuffer(transfer_status , "HTTP/1.0 403 Forbidden\r\n");
					break ; 
				}
	 case NOT_AUTHORIZED: 
	 			{ 
					AddStringBuffer(transfer_status , "HTTP/1.0 401 Unauthorized\r\n");
	            break ; 
				}
	 case NOT_CHANGED:    
	 			{
					AddStringBuffer(transfer_status , "HTTP/1.0 304 Not modified\r\n") ; 
	            break ; 
				}
	 case NOT_FOUND:      
	 			{ 
					AddStringBuffer(transfer_status , "HTTP/1.0 404 Not Found\r\n") ; 
	            break ; 
				}
	 }
	
	if (header_info->content_length != NO_CONTENT_LENGTH)
	{
   	 sprintf(header_info->string_content_length, "%d", header_info->content_length );
	    AddStringBuffer(transfer_status , "Content-Length:" ) ; 
	    AddStringBuffer(transfer_status , header_info->string_content_length ) ; 
	    AddStringBuffer(transfer_status , "\r\n" ) ; 
	}

	if (header_info->content_type !=  UNKNOWN_CONTENT_TYPE)
   {
 	   AddStringBuffer(transfer_status, "Content-Type: " ) ; 
      AddStringBuffer(transfer_status,content_type_strings[header_info->content_type] ) ; 
	   AddStringBuffer(transfer_status, "\r\n" ) ; 
   }


#ifdef OLD_CODE
switch(header_info->content_type)  {
 case UNKNOWN_CONTENT_TYPE: { break ;  }
 case GIF_CONTENT_TYPE : { AddStringBuffer(transfer_status,
					   "Content-Type: image/gif\r\n");
			   break ; }
 case HTML_CONTENT_TYPE : { AddStringBuffer(transfer_status,
					   "Content-Type: text/html\r\n");
			   break ; }
}
#endif /** OLD_CODE **/

#if 0
	get_current_date(&current_date); 
	local_date_to_GMT_text(&current_date,header_info->current_date_text ) ; 
	AddStringBuffer(transfer_status ,  "Date:" ); 
	AddStringBuffer(transfer_status ,   header_info->current_date_text ); 
	AddStringBuffer(transfer_status ,  "\r\n" ); 
	



	if (!test_if_date_is_null(&header_info->last_modified) )
   {
      local_date_to_GMT_text(&header_info->last_modified,header_info->last_modified_text ) ; 
      AddStringBuffer(transfer_status ,  "Last-Modified:" ); 
      AddStringBuffer(transfer_status ,   header_info->last_modified_text ); 
      AddStringBuffer(transfer_status ,  "\r\n" ); 
    }
#endif
	if (header_info->status == NOT_AUTHORIZED)
   {
   	 if (header_info->chalange == NULL)
       {
			HTTP_REPORT_ERROR("not authorized without a chalange") ; 
       }
	    else
   	 {
			AddStringBuffer(transfer_status ,  "WWW-Authenticate:" ); 
			AddStringBuffer(transfer_status ,  header_info->chalange); 
			AddStringBuffer(transfer_status ,  "\r\n" ); 
       }
  	}


	if (header_info->refresh != HTTP_NO_REFRESH )
   {
   	AddStringBuffer(transfer_status , "Refresh:" );
    	sprintf(header_info->refresh_text, "%d",header_info->refresh ) ;
    	AddStringBuffer(transfer_status ,header_info->refresh_text  );
     

    	if (header_info->refresh_url[0] != 0 )
      {
			AddStringBuffer(transfer_status , "; URL=" );
			AddStringBuffer(transfer_status , header_info->refresh_url );
      }
 
      

    	AddStringBuffer(transfer_status , "\r\n"  );
   }
#if 0
	if (header_info->additional_fields_info != NULL )
   {
    	AddStringBuffer(transfer_status ,  header_info->additional_fields_info ); 
   }
/*** should check the additional info ends with a \r\n ***/
#endif
	AddStringBuffer(transfer_status ,  "\r\n" ); 

	header_info->was_sent = TRUE ; 
	operation_status->status = END_OPERATION ; 


}


void InitHeaderInput(ResponseHeaderInformation_t *header_info , 
			 OperationStatus_t *operation_status)
{
operation_status->do_operation = DoHeaderInput ; 
operation_status->handle = header_info  ; 
operation_status->close_operation = NULL ; 
}





void *InitReturnParamsHandle(Request_t *request)
{

DataTransferStatus_t *data_transfer ; 


data_transfer = malloc(sizeof(DataTransferStatus_t) ) ; 

InitDataTransferStatus(data_transfer) ; 

data_transfer->nof_operations = 2 ; 

InitReturnParamsOutput( request, &data_transfer->io_operations[0] ) ; 


/***InitForSimpleBlockingOutput( request, &data_transfer->io_operations[1] );
**** The non blocking output functions a blocking one if the 
**** I/O is blocking
***/


InitNonBlockingOutput( request, &data_transfer->io_operations[1] ) ;
data_transfer->end_of_processing = FALSE ; 
data_transfer->socket_should_be_closed = FALSE ; 

return data_transfer ; 
}










void DataTransfer(Request_t *request )
{
/*** if you change this function, change also OneIterationDataTrasnfer ***/
DataTransferStatus_t *transfer_status;



transfer_status = (DataTransferStatus_t *) request->response_entity_handle ; 

ContinueDataTransfer( transfer_status, FALSE ) ; 
    /**** FALSe is the single iteration param ****/
if (transfer_status->end_of_processing)
  {
    request->status.process_status = WEB_PROCESSING_DONE ; 
    
    if ((transfer_status->socket_should_be_closed) ||
	(request->close_socket_after_entity) )
      {
	HTTP_TRACE_MSG("socket", "closing the socket" ) ; 
	shutdown_socket(&request->socket) ; 
	request->status.process_status =  SOCKET_IS_CLOSED ; 
      } 

    free_form_processing_phase_data(request);

    free(transfer_status) ; 

  }
}

void OneIterationDataTransfer(Request_t *request )
{

DataTransferStatus_t *transfer_status;



transfer_status = (DataTransferStatus_t *) request->response_entity_handle ; 

ContinueDataTransfer( transfer_status, TRUE ) ; 

if (transfer_status->end_of_processing)
  {
    request->status.process_status = WEB_PROCESSING_DONE ; 
    
    if ((transfer_status->socket_should_be_closed) ||
	(request->close_socket_after_entity) )
      {
	HTTP_TRACE_MSG("socket", "closing the socket" ) ; 
	shutdown_socket(&request->socket ) ; 
	request->status.process_status =  SOCKET_IS_CLOSED ; 
      } 

    free_form_processing_phase_data(request);

    free(transfer_status) ; 

  }
}




void InitDataTransferStatus( DataTransferStatus_t *transfer_status)
{
transfer_status->current_operation_number = 0 ; 
transfer_status->end_of_processing = FALSE ; 
transfer_status->socket_should_be_closed = FALSE ; 
transfer_status->io_operations[0].status = START_OPERATION ; 
}





























