/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#define ERROR_OUTPUT_LOCALY_FILE_DEFINED
#define TRACE_OUTPUT_LOCALY_FILE_DEFINED

#include "\rtrware\applicat\webserve\prochttp\src\httpd.h"
#include "oninit.h"

#if defined(UNIX_EMULATION) && !defined(VXWORKS) && !defined(MTS_SYSTEM)

#include <signal.h>

#endif

/* Added by Rajesh: 29-11-96*/
static enum TEST register_webserver (void);
enum TEST web_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
extern void http_one_iteration(void);
/* Added by Rajesh: 29-11-96*/


enum TEST sys_dependent_do_on_init()
{

/*	Added by Rajesh: 29-11-96	 */
	return(register_webserver());
/*	Added by Rajesh: 29-11-96	 */

}

#ifndef TRACE_FILE_NAME
#define TRACE_FILE_NAME "trace.web"
#endif



#ifndef ERROR_FILE_NAME
#define ERROR_FILE_NAME "errors.web"
#endif



void init_error_and_trace(void)
{
#ifdef ERROR_GOES_TO_FILE
error_output_file = OPEN_DEBUG_OUTPUT_FILE(ERROR_FILE_NAME);
#endif

#ifdef SEND_TRACE_TO_FILE
trace_output_file =  OPEN_DEBUG_OUTPUT_FILE(TRACE_FILE_NAME);
#endif


}

/* Added by Rajesh: 29-11-96*/

/****************************************************************************
	Routine		: register_webserver
	Synopsis		: Registers WebServer as an application with the LSL
****************************************************************************/
static enum TEST register_webserver (void)
{
#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "WEB Server", WEB_MANAGEMENT, http_one_iteration, web_control,
		&web.application_id) == FAIL)
	{
		printf ("\nWEB Server : Registering Application Failed");
		return (FAIL);
	}
	printf ("WEB Server initialized successfuly with timeout value of %d seconds\n", web.http_idle_timeout);
   web.http_idle_timeout *= 20 ;
	return (PASS);
#else
	return (FAIL);
#endif
}


/****************************************************************************
	Routine		: web_control
	Synopsis		: This control function is not used by any APP presently
****************************************************************************/
enum TEST web_control (enum APPLICATION_CONTROL_OPERATION command, 
					ULONG parameter_0, ULONG parameter_1)
{
	PARAMETER_NOT_USED(parameter_0);
	PARAMETER_NOT_USED(parameter_1);
	PARAMETER_NOT_USED(command);
	
	return PASS;
}

/* Added by Rajesh: 29-11-96*/


