#ifndef SYSDEFS_H
#define SYSDEFS_H

#define MTR_68K

#define NON_BLOCKING_UNIX_FILE_IO
#define UNIX_TCPIP
#define TWO_PARAMETER_OPEN_FILE
#define INITIALIZED_STATIC_DATA
#define NO_TRACING
#define NO_ERROR_REPORTING
#define NO_FILE_TIMEDATE_INFO
#define INTERMETRICS


#if defined(WINDOWS_VC) || defined(INTERMETRICS)

#define OFFSET_OF_FIELD_IN_STRUCT(instance, struct_type, field_name)  \
 	offsetof(struct_type, field_name) 
#else
#define OFFSET_OF_FIELD_IN_STRUCT(instance, struct_type, field_name)  \
 	offsetof(struct_type, field_name) 
#endif

#ifdef UNDERSCORED_LOW_LEVEL_FILE_IO

#define read _read
#define write _write
#define close _close
#define open _open
#define O_RDONLY _O_RDONLY
#define O_WRONLY _O_WRONLY
#define O_CREAT _O_CREAT
#define O_TRUNC _O_TRUNC


#endif









#if defined(WINDOWS_VC)

#define OPEN_FOR_READ_FLAGS  O_RDONLY | O_BINARY
#define OPEN_FOR_WRITE_FLAGS  O_WRONLY | O_BINARY

#elif defined(NON_BLOCKING_UNIX_FILE_IO)

#define OPEN_FOR_READ_FLAGS  O_RDONLY | O_NONBLOCK
#define OPEN_FOR_WRITE_FLAGS  O_WRONLY | O_NONBLOCK
                                       
#elif defined(BLOCKING_UNIX_FILE_IO)

#define OPEN_FOR_READ_FLAGS  O_RDONLY 
#define OPEN_FOR_WRITE_FLAGS  O_WRONLY 

#elif defined(POSIX_ASYNCHRONOUS_FILE_IO)

#define OPEN_FOR_READ_FLAGS  O_RDONLY 
#define OPEN_FOR_WRITE_FLAGS  O_WRONLY 

#else
#error what are the flags for file open?

#endif
                                       


#ifdef TWO_PARAMETER_FILE_OPEN
#define OPEN_FILE_FOR_READ(fn) open(fn, OPEN_FOR_READ_FLAGS)
#define OPEN_FILE_FOR_WRITE(fn) open(fn, OPEN_FOR_WRITE_FLAGS)
#else
#define OPEN_FILE_FOR_READ(fn) open(fn, OPEN_FOR_READ_FLAGS, 0 )
#define OPEN_FILE_FOR_WRITE(fn) open(fn, OPEN_FOR_WRITE_FLAGS, 0 )
#endif


#define OPEN_DEBUG_OUTPUT_FILE(fn) fopen(fn, "w" ) 

#ifdef MTR_68K
#undef NON_BLOCKING_UNIX_FILE_IO
#undef TWO_PARAMETER_OPEN_FILE
#endif

#endif /** SYSDEFS_H ****/
