/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef SYSERR_H
#define SYSERR_H

#ifdef UNIX_EMULATION
#include "errno.h"
#include "string.h"
#include "stdio.h"
#endif

#if defined(ERROR_GOES_TO_FILE)

#if !defined(ERROR_OUTPUT_LOCALY_FILE_DEFINED)
extern 
#endif
FILE *error_output_file ; 
#endif



#if defined(ERROR_GOES_TO_STDOUT)

#define ERROR_DESTINATION stdout

#elif defined(ERROR_GOES_TO_STDERR)

#define ERROR_DESTINATION stderr

#elif defined(ERROR_GOES_TO_FILE)

#define ERROR_DESTINATION error_output_file

#elif defined(NO_ERROR_REPORTING)

#else

#error where to report errors to?

#endif

#define FLUSH_ERROR_FILE fflush(ERROR_DESTINATION); 


#if defined(NO_ERROR_REPORTING)
#define HTTP_REPORT_ERROR(STRING)
#define HTTP_REPORT_ERROR_CODE(STRING, err) 


#else

#if  defined(ERRNO_DEFINED)
#define HTTP_REPORT_ERROR(STRING) { fprintf( ERROR_DESTINATION, \
           "Error %s file %s line %d errno = %d errno string %s \n" , \
            STRING, __FILE__, __LINE__, errno, strerror(errno) ) ; \
	    FLUSH_ERROR_FILE ; }

#define HTTP_REPORT_ERROR_CODE(STRING,err) { fprintf( ERROR_DESTINATION, \
           "Error %s file %s line %d error code = %d errno = %d errno string %s \n" , \
            STRING, __FILE__, __LINE__,err,  errno, strerror(errno) ) ; \
	    FLUSH_ERROR_FILE ; } }

#else 
/**** error repotin with no errno ***/  

#define HTTP_REPORT_ERROR(STRING) { fprintf(ERROR_DESTINATION,  \
           "Error %s file %s line %d  \n" , \
            STRING, __FILE__, __LINE__ ) ; \
	    FLUSH_ERROR_FILE ; } 
#define HTTP_REPORT_ERROR_CODE(STRING, err) { fprintf(ERROR_DESTINATION,  \
           "Error %s file %s line %d error %d \n" , \
            STRING, __FILE__, __LINE__, err ) ; \
	    FLUSH_ERROR_FILE ; } }

 
#endif

#endif 


#endif /*** SYSERR_H ***/

