
/* 
	File		:	cmfilt.c
	Author		:	Ramana Murthy
	Date  		:	Feb 27th, 1998
	Synopsis	:	Contains configuration manager support functions:
					    insert        remove        edit
						get_first     get_next      get_previous
					for the following items relating to proxy filters:
						- Forbidden Address List
						- Restricted Client List
						- Restricted Application List
						- Restricted MAC Address List
						- Restricted Domain Name List
					These support functions are invoked from Telnet and
					Web modules with cm_insert, cm_remove, etc. calls.
*/

#include "defs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>
#include <socklib.h>
#include <stddef.h>
#include "\rtrware\store\boot.h"
#include "incall.h"
#include "cfgmgr.h"
#include <flashmgr.h>

/* ---- Constants ---- */

/* The following order must be maintained in lhs string arrays also */

#define	DEST_FILTER		0		/* forbidden sites */
#define	SOURCE_FILTER	1		/* restricted clients */
#define	APP_FILTER		2		/* restricted applications */
#define	MAC_FILTER		3		/* restricted mac addresses */
#define	DNS_FILTER		4		/* restricted domain names */

#define	MAX_PROXY_FILTER_TYPES	5

/* ---- Extern Declerations ---- */
extern PARAMETER_NODE
*match_the_lhs_string_in_the_linked_list_and_return_rhs_string
					(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, 
					PARAMETER_NODE* start_of_next_section, BYTE* rhs_string, 
					USHORT port_number, BYTE* port_number_matched);
/*extern void convert_to_lower_case (BYTE* the_string);*/
extern PARAMETER_NODE *insert_missing_string_without_port
					(BYTE section_number, BYTE* lhs_string, BYTE* rhs_string);
extern void update_count_in_ini (BYTE *lhs_string, BYTE flag,USHORT port_num);

extern USHORT get_next_application_port_which_needs_re_entry(USHORT first_port_number);
extern BYTE is_re_entry_needed_for_application_port(USHORT port_number);

/* ---- Local Prototype Declaration ---- */
BYTE search_for_proxy_filter (void *filter_entry, BYTE *bptr_lhs_string);
void fill_proxy_application_filter_struct_from_rhs (BYTE *rhs_str, 
								STRUCT_PROXY_ENTRY *proxy_app_filter_entry);
BYTE proxy_filter_type (BYTE *bptr_lhs_string);
PARAMETER_NODE 
*seek_to_proxy_filter (void *filter_entry, BYTE *bptr_lhs_string);

/* ---- Strings in INI file ---- */

/* The order of these strings must correspond to that of the constants above */
BYTE *proxy_filter_lhs_strings_in_cfg[MAX_PROXY_FILTER_TYPES] =
{
			"Proxy Destination Filter",
			"Proxy Source Filter",
			"Proxy Application Filter",
			"Proxy MAC Filter",
			"Proxy DNS Filter"
};

BYTE *proxy_filter_lhs_strings_in_ini[MAX_PROXY_FILTER_TYPES] =
{
			"Proxy Server Forbidden Address List",
			"Proxy Server Restricted Client List",
			"Proxy Server Restricted Application List",
			"Proxy Server Restricted MAC Address List",
			"Proxy Server Restricted Domain Name List"
};

BYTE *proxy_filter_count_lhs_strings_in_ini[MAX_PROXY_FILTER_TYPES] =
{
	"Proxy Server Number of Forbidden Sites",
	"Proxy Server Number of Restricted Clients",
	"Proxy Server Number of Restricted Applications",
	"Proxy Server Number of Restricted MAC Address",
	"Proxy Server Number of Restricted Domain Names"
};

/* ------------------------------------------------------------------------ */
/*          Functions relating to : PROXY FILTERS                           */
/* ------------------------------------------------------------------------ */

PARAMETER_NODE
*insert_proxy_filter (enum CM_SECTIONS section_to_which_it_belongs_to, 
							BYTE *bptr_lhs_string, 
				  			void *vptr_rhs)
{
	STRUCT_PROXY_FILTER	*proxy_filter_entry;
	STRUCT_PROXY_ENTRY	*proxy_app_filter_entry;
	BYTE			rhs_string[300];
	BYTE			ftype;
	PARAMETER_NODE	*node;
	static BYTE		re_entry = 0;
   
	ftype = proxy_filter_type (bptr_lhs_string);

	proxy_filter_entry = (STRUCT_PROXY_FILTER *)vptr_rhs;
	proxy_app_filter_entry = (STRUCT_PROXY_ENTRY *)vptr_rhs;

   if (ftype == APP_FILTER)
	{

	/* For FTP(20,21), SSL-FTP(989,990), Q931(900,902), RTP(5004,5006),
		RTCP(5005,5007) ports */

		if ((is_re_entry_needed_for_application_port(proxy_app_filter_entry->port) == TRUE) 
			&& (re_entry == 0)) 
		{
			re_entry = 1;
			proxy_app_filter_entry->port = get_next_application_port_which_needs_re_entry(proxy_app_filter_entry->port);

			insert_proxy_filter (section_to_which_it_belongs_to,
												bptr_lhs_string, vptr_rhs);
			proxy_app_filter_entry->port = get_next_application_port_which_needs_re_entry(proxy_app_filter_entry->port);
			re_entry = 0;
		}
   }
	if (ftype == DEST_FILTER || ftype == SOURCE_FILTER) {
		/* Validate the proxy filter specified */
		if (! is_an_ip_address(proxy_filter_entry->addr))
		{
			printf("Not a Valid IP Address\n");
			return NULL;
		}
	}

	/* Check if the given filter already exists */
	if (search_for_proxy_filter (
			(ftype == APP_FILTER ? (void*)proxy_app_filter_entry:
												(void*)proxy_filter_entry),
			bptr_lhs_string) == TRUE)
	{
		printf("Cannot add Duplicate Proxy Filter Entry .......\n");
		return NULL;
	}

	/* filter not present - create a new one */
	if (ftype == APP_FILTER)
	{
		sprintf(rhs_string, "%04X,%04X\0", 
				(! proxy_app_filter_entry->protocol ? 0x0006 : 0x0011),
				proxy_app_filter_entry->port);
	}
	else
		sprintf(rhs_string, "%s\0\n", proxy_filter_entry->addr);

	node = insert_missing_string_without_port(CM_PROXY_SECTION, 
						proxy_filter_lhs_strings_in_ini[ftype],  rhs_string);
	if (node != NULL) {
		update_count_in_ini (proxy_filter_count_lhs_strings_in_ini[ftype], 
								CM_INCREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
	}
	return (node);
}

enum CM_REMOVE_STRING_RESULTS
remove_proxy_filter (enum CM_SECTIONS section_to_which_it_belongs_to, 
							BYTE *bptr_lhs_string, 
							void *vptr_rhs)
{
	STRUCT_PROXY_FILTER	*proxy_filter_entry;
	STRUCT_PROXY_ENTRY	*proxy_app_filter_entry;
	BYTE			buffer[300], string_ptr[300];
	BYTE			port_number = CM_NO_PORT_PARAMETER_PRESENT;
	BYTE			port_number_matched;
	PARAMETER_NODE	*search_to_start_at;
	BYTE			ftype;
	static BYTE		re_entry = 0;
   
	ftype = proxy_filter_type (bptr_lhs_string);

	proxy_filter_entry = (STRUCT_PROXY_FILTER *)vptr_rhs;
	proxy_app_filter_entry = (STRUCT_PROXY_ENTRY *)vptr_rhs;

	if (ftype == APP_FILTER)
	{

	/* For FTP(20,21), SSL-FTP(989,990), Q931(900,902), RTP(5004,5006),
		RTCP(5005,5007) ports */

		if ((is_re_entry_needed_for_application_port(proxy_app_filter_entry->port) == TRUE)
			&& (re_entry == 0)) 
		{
			re_entry = 1;
			proxy_app_filter_entry->port = get_next_application_port_which_needs_re_entry(proxy_app_filter_entry->port);

			remove_proxy_filter (section_to_which_it_belongs_to,
												bptr_lhs_string, vptr_rhs);
			proxy_app_filter_entry->port = get_next_application_port_which_needs_re_entry(proxy_app_filter_entry->port);
			re_entry = 0;
		}
	}

	/* Seek to the filter entry to be removed */
	if ((search_to_start_at = seek_to_proxy_filter (
			(ftype == APP_FILTER ? (void*)proxy_app_filter_entry:
												(void*)proxy_filter_entry),
			bptr_lhs_string)) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;	

	search_to_start_at->previous->next = search_to_start_at->next;
	search_to_start_at->next->previous = search_to_start_at->previous;
	free(search_to_start_at);
	update_count_in_ini (proxy_filter_count_lhs_strings_in_ini[ftype], 
								CM_DECREMENT_COUNT,CM_NO_PORT_PARAMETER_PRESENT);
	return CM_REMOVING_STRING_SUCCESSFUL;
}

enum CM_EDIT_STRING_RESULTS 
edit_proxy_filter (enum CM_SECTIONS section_to_which_it_belongs_to, 
							BYTE *bptr_lhs_string, 
							void *vptr_old_rhs,
							void *vptr_new_rhs)
{
	STRUCT_PROXY_FILTER		*old_filter_entry, *new_filter_entry;
	STRUCT_PROXY_ENTRY		*old_app_filter_entry, *new_app_filter_entry;
	BYTE			buffer[300], string_ptr[300];
	BYTE			port_number = CM_NO_PORT_PARAMETER_PRESENT;
	BYTE			port_number_matched;
	PARAMETER_NODE	*search_to_start_at;
	BYTE			ftype;
	enum CM_REMOVE_STRING_RESULTS delete_result;
   
	ftype = proxy_filter_type (bptr_lhs_string);
   
	old_filter_entry = (STRUCT_PROXY_FILTER *)vptr_old_rhs;
	new_filter_entry = (STRUCT_PROXY_FILTER *)vptr_new_rhs;
	old_app_filter_entry = (STRUCT_PROXY_ENTRY *)vptr_old_rhs;
	new_app_filter_entry = (STRUCT_PROXY_ENTRY *)vptr_new_rhs;

	if (ftype == DEST_FILTER || ftype == SOURCE_FILTER) {
		/* Validate the new proxy filter specified */
		if (! is_an_ip_address(new_filter_entry->addr))
		{
			printf("Not a Valid IP Address\n");
			return NULL;
		}
	}

	/* Check if the specified old proxy filter exists */
	if (search_for_proxy_filter (
			(ftype == APP_FILTER ? (void*)old_app_filter_entry : 
													(void*)old_filter_entry), 
			bptr_lhs_string) == FALSE)
	{
		printf("The given Proxy Filter does not exist.......\n");
		return NULL;
	}

	/* Check if the specified new proxy filter already exists */
	if (search_for_proxy_filter (
			(ftype == APP_FILTER ? (void*)new_app_filter_entry : 
													(void*)new_filter_entry), 
			bptr_lhs_string) == TRUE)
	{
		printf("The new Proxy Filter already exists........\n");
		return NULL;
	}

	delete_result = 
		remove_proxy_filter (section_to_which_it_belongs_to, 
											bptr_lhs_string, vptr_old_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;

	if (insert_proxy_filter(section_to_which_it_belongs_to, 
									bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;

	return CM_STRING_EDIT_SUCCESSFUL;
}

PARAMETER_NODE
*get_first_proxy_filter (enum CM_SECTIONS section_to_which_it_belongs_to,
							BYTE *bptr_lhs_string, 
							void *vptr_rhs)
{
	STRUCT_PROXY_FILTER	*proxy_filter_entry;
	STRUCT_PROXY_ENTRY	*proxy_app_filter_entry;
	BYTE			buffer[300], temp_buffer[300];
	BYTE			port_number = CM_NO_PORT_PARAMETER_PRESENT;
	BYTE			port_number_matched, i, j ;
	PARAMETER_NODE	*search_to_start_at;
	BYTE			ftype;

	ftype = proxy_filter_type (bptr_lhs_string);

	proxy_filter_entry = (STRUCT_PROXY_FILTER *)vptr_rhs;
	proxy_app_filter_entry = (STRUCT_PROXY_ENTRY *)vptr_rhs;
   
   search_to_start_at = sptr_to_each_section_in_the_configuration
										[section_to_which_it_belongs_to];

	search_to_start_at = 
		match_the_lhs_string_in_the_linked_list_and_return_rhs_string(
			proxy_filter_lhs_strings_in_ini[ftype], 
         search_to_start_at,
			sptr_to_each_section_in_the_configuration
										[section_to_which_it_belongs_to + 1],
			buffer, port_number, &port_number_matched);

	if (search_to_start_at == NULL)
   		return NULL;	

	if (ftype == APP_FILTER) {
		fill_proxy_application_filter_struct_from_rhs (search_to_start_at->parameter, 
												proxy_app_filter_entry);
	}
	else {
		/* copy the rhs into proxy filter entry */
		i = j = 0 ; 
		while (buffer[i] !=  '\0' && buffer[i] !=  '\n')
			temp_buffer[j++] = buffer[i++];
		temp_buffer[j] = '\0';
		strcpy (proxy_filter_entry->addr, temp_buffer);
	}

	return search_to_start_at;
}

PARAMETER_NODE
*get_next_proxy_filter (enum CM_SECTIONS section_to_which_it_belongs_to,
							PARAMETER_NODE *current_node, 
							void* vptr_rhs)
{
	STRUCT_PROXY_FILTER	*proxy_filter_entry;
	STRUCT_PROXY_ENTRY	*proxy_app_filter_entry;
	BYTE			temp_buffer[300];
	BYTE			current_node_lhs_string[100], lhs_string[100];
	BYTE			i, j;
	PARAMETER_NODE	*current_temp_node, *next_node;
	BYTE			ftype;

	if (! current_node)
		return NULL;

	i = 0;
	while (current_node->parameter[i] != '=')
	{
		lhs_string[i] = current_node->parameter[i];
		i++;
	}
	lhs_string[i-1] = 0;

	current_temp_node = current_node;
	while 
		(
		current_temp_node->next && 
		current_temp_node->next != sptr_to_each_section_in_the_configuration
											[section_to_which_it_belongs_to+1]
		)
	{
		next_node = current_temp_node->next;
		i = 0;
		while (next_node->parameter[i] != '=')
		{
			current_node_lhs_string[i] = next_node->parameter[i];
			i++;
		}
		current_node_lhs_string[i-1] = 0;
/*		convert_to_lower_case(current_node_lhs_string);*/
/*		convert_to_lower_case(lhs_string);*/
		if (strcmpi(lhs_string, current_node_lhs_string) == 0)
		{
			if (vptr_rhs == NULL)
				return next_node;

         if (strstr(lhs_string ,"Proxy Server Restricted Application List") != NULL)
            ftype = APP_FILTER;
         else
            ftype = 0; /* Don't care state */

			proxy_filter_entry = (STRUCT_PROXY_FILTER *)vptr_rhs;
			proxy_app_filter_entry = (STRUCT_PROXY_ENTRY *)vptr_rhs;

			/* fill proxy filter structure with rhs in parameter node */
			if (ftype == APP_FILTER) {
				fill_proxy_application_filter_struct_from_rhs (
								next_node->parameter, proxy_app_filter_entry);
			}
			else {
				i++ ; i++;     /* skip '=' and space */  
            j = 0;
				while (	next_node->parameter[i] !=  '\0' && 
						next_node->parameter[i] !=  '\n')
					temp_buffer[j++] = next_node->parameter[i++];
				temp_buffer[j] = '\0';
				strcpy (proxy_filter_entry->addr, temp_buffer);
			}
			return next_node;
		}
		current_temp_node = current_temp_node->next;
	}
	return NULL;
}

PARAMETER_NODE
*get_previous_proxy_filter (
							enum CM_SECTIONS section_to_which_it_belongs_to,
							PARAMETER_NODE *current_node,
							void *vptr_rhs)
{
	return NULL;
}

BYTE 
search_for_proxy_filter (void *filter_entry, BYTE *bptr_lhs_string)
{
	STRUCT_PROXY_FILTER	*proxy_filter_entry, temp_filter_entry;
	STRUCT_PROXY_ENTRY	*proxy_app_filter_entry, temp_app_filter_entry;
	BYTE				index, sub_index,
						temp_buffer1[300], temp_buffer2[300];
	PARAMETER_NODE		*node;
	BYTE				ftype;
   
	ftype = proxy_filter_type (bptr_lhs_string);
	proxy_filter_entry = (STRUCT_PROXY_FILTER *)filter_entry;
	proxy_app_filter_entry = (STRUCT_PROXY_ENTRY *)filter_entry;

	if (ftype == APP_FILTER)
		sprintf(temp_buffer2, "%04X,%04X\0", 
			(! proxy_app_filter_entry->protocol ? 0x0006 : 0x0011), proxy_app_filter_entry->port);
	else
		strcpy (temp_buffer2, proxy_filter_entry->addr);

	if ((node = 
			get_first_proxy_filter (CM_PROXY_SECTION, bptr_lhs_string, 
				(ftype == APP_FILTER ? (void *)&temp_app_filter_entry : 
										(void*)&temp_filter_entry))) == NULL)
		return FALSE;

	do {
		index = sub_index = 0;
		while (node->parameter[index++] != '=');/* skip  LHS string , '=' */
		index++; 								/* skip space */

		while ( node->parameter[index] != '\0' && 
				node->parameter[index] != '\n')
			temp_buffer1[sub_index++] = node->parameter[index++];

		temp_buffer1[sub_index] = '\0';

		/* Are the entries matching */
		if (!strcmpi(temp_buffer1, temp_buffer2))
            return TRUE;

		/* Try to read a next line/node that matches */
		node = 
			get_next_proxy_filter (CM_PROXY_SECTION, node,
				(ftype == APP_FILTER ? (void *)&temp_app_filter_entry : 
										(void*)&temp_filter_entry));
	}
	while (node);
	return FALSE;
}

void
fill_proxy_application_filter_struct_from_rhs (BYTE *rhs_str, 
						STRUCT_PROXY_ENTRY *proxy_app_filter_entry)
{
	BYTE	*sptr, temp_buffer[100], j;
   ULONG app_port = 0;

	sptr = rhs_str;
	while (*sptr && *sptr != '=') sptr++;	/* skip till '=' */
	sptr++;									/* skip the '=' */
	while (*sptr == ' ') sptr++;			/* skip spaces */

	/* copy the first part of the proxy application filter into protocol */
	j = 0;
	while (*sptr && *sptr != ',' && *sptr != '\n')
		temp_buffer[j++] = *sptr++;
	temp_buffer[j] = '\0';
	
/* Jyothi 9/3/98 */

   if (!strcmpi(temp_buffer, "0006"))
		proxy_app_filter_entry->protocol = 0x0006;
	else
		proxy_app_filter_entry->protocol = 0x0011;

/*  Jyothi 9/3/98  */

	/* copy the second part of the proxy application filter into port */
	j = 0;	sptr++;
	while (*sptr && *sptr != ',' && *sptr != '\0' && *sptr != '\n')
		temp_buffer[j++] = *sptr++;
	temp_buffer[j] = '\0';

/* Jyothi 9/3/98 */

	sscanf (temp_buffer, "%x", &app_port);
   proxy_app_filter_entry->port = (USHORT)app_port;

/* Jyothi 9/3/98 */

}

BYTE proxy_filter_type (BYTE *bptr_lhs_string)
{
	BYTE	i;

	for (i = 0; i < MAX_PROXY_FILTER_TYPES; i++) {
		if (! strcmpi (	bptr_lhs_string, proxy_filter_lhs_strings_in_cfg[i])) 
			return (i);
	}
	return (-1);
}

PARAMETER_NODE 
*seek_to_proxy_filter (void *filter_entry, BYTE *bptr_lhs_string)
{
	STRUCT_PROXY_FILTER	*proxy_filter_entry, temp_filter_entry;
	STRUCT_PROXY_ENTRY	*proxy_app_filter_entry, temp_app_filter_entry;
	BYTE				index, sub_index,
						temp_buffer1[300], temp_buffer2[300];
	PARAMETER_NODE		*node;
	BYTE				ftype;
   
	ftype = proxy_filter_type (bptr_lhs_string);
	proxy_filter_entry = (STRUCT_PROXY_FILTER *)filter_entry;
	proxy_app_filter_entry = (STRUCT_PROXY_ENTRY *)filter_entry;

	if (ftype == APP_FILTER)
		sprintf(temp_buffer2, "%04X,%04X\0", 
				(! proxy_app_filter_entry->protocol ? 0x0006 : 0x0011),
				proxy_app_filter_entry->port);
	else
		strcpy (temp_buffer2, proxy_filter_entry->addr);

	if ((node = 
			get_first_proxy_filter (CM_PROXY_SECTION, bptr_lhs_string, 
				(ftype == APP_FILTER ? (void *)&temp_app_filter_entry : 
										(void*)&temp_filter_entry))) == NULL)
		return NULL;

	do {
		index = sub_index = 0;
		while (node->parameter[index++] != '=');/* skip  LHS string , '=' */
		index++; 								/* skip space */

		while ( node->parameter[index] != '\0' && 
				node->parameter[index] != '\n')
			temp_buffer1[sub_index++] = node->parameter[index++];

		temp_buffer1[sub_index] = '\0';

		/* Are the entries matching */
		if (!strcmpi(temp_buffer1, temp_buffer2))
            return node;

		/* Try to read a next line/node that matches */
		node = 
			get_next_proxy_filter (CM_PROXY_SECTION, node,
				(ftype == APP_FILTER ? (void *)&temp_app_filter_entry : 
										(void*)&temp_filter_entry));
	}
	while (node);
	return NULL;
}

/* ------------------------------------------------------------------------ */
