/* 
	File		:	cmlink.c
	Author		:	Ramana Murthy
	Date  		:	March 9th, 1998
	Synopsis	:	Contains configuration manager support functions:
					    insert        remove        edit
						get_first     get_next      get_previous
					for the following items relating to link control:
						- Privileged User List
					These support functions are invoked from Telnet and
					Web modules with cm_insert, cm_remove, etc. calls.
*/

#include "defs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>
#include <socklib.h>
#include <stddef.h>
#include "\rtrware\store\boot.h"
#include "incall.h"
#include "cfgmgr.h"
#include <flashmgr.h>

/* ---- Constants  ---- */
#define	NUM_ADDRESSES_PER_NODE		3

/* ---- Extern Declerations ---- */
extern PARAMETER_NODE
*match_the_lhs_string_in_the_linked_list_and_return_rhs_string
					(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, 
					PARAMETER_NODE* start_of_next_section, BYTE* rhs_string, 
					USHORT port_number, BYTE* port_number_matched);
extern PARAMETER_NODE *insert_missing_string_with_port(
					BYTE section_number, BYTE port_number, 
					BYTE* lhs_string, BYTE* rhs_string);
extern void update_count_in_ini (BYTE *lhs_string, BYTE flag,USHORT port_num);

/* ---- Local Prototype Declaration ---- */
BYTE search_for_user_address (STRUCT_HOST_ENTRY *user_addr_entry,
								BYTE *bptr_lhs_string);
BYTE the_lastly_given_user_address_in_the_current_node(BYTE new_value, 
								BYTE is_to_save);
BYTE total_number_of_user_addresses_in_the_current_node(PARAMETER_NODE *node);
void fill_the_buffer_with_user_address (BYTE *address_ptr, BYTE *buffer);

/* ---- Strings in INI file ---- */
BYTE user_address_list_in_ini[] ="Proxy Server Port Privileged User List";
BYTE num_priv_users_in_ini[]    ="Proxy Server Port Number of Privileged Users";

/* ------------------------------------------------------------------------ */
/*          Functions relating to : LINK CONTROL - USER ADDRESS LIST        */
/* ------------------------------------------------------------------------ */

PARAMETER_NODE
*insert_user_address (enum CM_SECTIONS section_to_which_it_belongs_to, 
							BYTE *bptr_lhs_string, 
							void *vptr_rhs)
{
	STRUCT_HOST_ENTRY 	*user_address, temp_entry;
	BYTE			rhs_string[100];
	USHORT			port_number;
	PARAMETER_NODE	*node;
   
	user_address = (STRUCT_HOST_ENTRY *)vptr_rhs;
   port_number = user_address->port;
   temp_entry.port = user_address->port;

	/* Validation */
	if (! is_an_ip_address(user_address->ip_addr))
	{
		printf("Not a Valid IP Address\n");
		return NULL;
	}

	/* Check if the given user address already exists */
	if (search_for_user_address (user_address, bptr_lhs_string) == TRUE)
	{
		printf("Cannot add Duplicate User Address .......\n");
		return NULL;
	}

	/* 
	 * Check if a node having less than NUM_ADDRESSES_PER_NODE is
	 * already present. If so, append the given user address to it;
	 * or else create a new node and write into it.
	*/
	node = get_first_user_address (section_to_which_it_belongs_to, 
								bptr_lhs_string, (void*)&temp_entry);

	while (node)
	{
		if (total_number_of_user_addresses_in_the_current_node(node) < 
											NUM_ADDRESSES_PER_NODE)
		{
			/* Already a node is present....just append the address to it */
			node->parameter[strlen(node->parameter)-1] = 0; /* Remove '\n' */
			strcat(node->parameter, ",");
			strcat(node->parameter, user_address->ip_addr);
			strcat(node->parameter, "\n");

         if (node != NULL) {
	      	update_count_in_ini (num_priv_users_in_ini, CM_INCREMENT_COUNT,port_number);
      	}
			return node;
		}
		node = get_next_user_address (section_to_which_it_belongs_to, 
											node, (void*)&temp_entry);
	}
	/* Node not present - create a new one and insert the new user address */
	sprintf(rhs_string, "%s\0\n", user_address->ip_addr);
	node = insert_missing_string_with_port(CM_PROXY_SECTION, port_number,
							user_address_list_in_ini,  rhs_string);
	if (node != NULL) {
		update_count_in_ini (num_priv_users_in_ini, CM_INCREMENT_COUNT,port_number);
	}
	return (node);
}

enum CM_REMOVE_STRING_RESULTS
remove_user_address (enum CM_SECTIONS section_to_which_it_belongs_to, 
							BYTE *bptr_lhs_string, 
							void *vptr_rhs)
{
	STRUCT_HOST_ENTRY			*user_address,temp_entry;
	BYTE			temp_buffer[100];
	BYTE			main_index, sub_index, saved_index;
	PARAMETER_NODE	*node;
	BYTE			entries_available_in_the_same_buffer = FALSE;
   USHORT port_number;


	user_address = (STRUCT_HOST_ENTRY *)vptr_rhs;
   temp_entry.port = user_address->port;
   port_number = user_address->port;

	if ((node = get_first_user_address(section_to_which_it_belongs_to, 
							bptr_lhs_string, (void*)&temp_entry)) == NULL)
	{
		printf("Get First Entry Failed to get the required string to remove\n");
		return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
	}

	do {
		main_index = 0;
		while (node->parameter[main_index++] != '=');	/* skip LHS, '=' */
		main_index++; 									/* skip space */
      
      while (node->parameter[main_index++] != ',');	/* skip port number */

		do {
			sub_index = 0;
			saved_index = main_index;

			/* Read one user address into a buffer */
			while ( node->parameter[main_index] != ',' &&
					node->parameter[main_index] != '\0' && 
					node->parameter[main_index] != '\n')
				temp_buffer[sub_index++] = node->parameter[main_index++];
			temp_buffer[sub_index] = '\0';

			/* Check if the user addresses match */
			if (! strcmpi(temp_buffer, user_address->ip_addr))
			{
				/* Blank out from saved_index to main_index */
				if ((node->parameter[main_index] == 0 || 
					node->parameter[main_index] == '\n') && 
					(total_number_of_user_addresses_in_the_current_node
												(node) == 1))
				{
					/* Free the node as there are no entries now */
					node->previous->next = node->next;
					node->next->previous = node->previous;
					free(node); 
					update_count_in_ini (num_priv_users_in_ini,
											CM_DECREMENT_COUNT,port_number);
					return CM_REMOVING_STRING_SUCCESSFUL;
				}

				/* There are some more entries in this node. So leave it */

				if (node->parameter[main_index] == ',')
					main_index++;
				else {
					/* Last entry in the node ! */
					node->parameter[saved_index-1] = '\n';
					node->parameter[saved_index] = 0;
					update_count_in_ini (num_priv_users_in_ini,
											CM_DECREMENT_COUNT,port_number);
					return CM_REMOVING_STRING_SUCCESSFUL;
				}
				while (node->parameter[main_index] != 0)
					node->parameter[saved_index++] = 
											node->parameter[main_index++];
	   			node->parameter[saved_index] = 0;

				update_count_in_ini (num_priv_users_in_ini,
											CM_DECREMENT_COUNT,port_number);
				return CM_REMOVING_STRING_SUCCESSFUL;
			}
			else
			{
				/* 
				 * The given entry does not match with the read entry.
				 * Continue reading if there are more entries in the node. 
				*/
				if (node->parameter[main_index] == 0)		
					entries_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++; 			/* Skip the ',' */
					entries_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (entries_available_in_the_same_buffer);

		/* Read the next line/node and repeat the check for matching entries */
		node = get_next_user_address (CM_PROXY_SECTION, 
											node, (void*)&temp_entry);
	} while (node);

	printf("Failed to search node for removing entry \n");
	return CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING;
}

enum CM_EDIT_STRING_RESULTS 
edit_user_address (enum CM_SECTIONS section_to_which_it_belongs_to, 
							BYTE *bptr_lhs_string, 
							void *vptr_old_rhs,
							void *vptr_new_rhs)
{
	enum CM_REMOVE_STRING_RESULTS delete_result;
	STRUCT_HOST_ENTRY			*old_user_address;
	STRUCT_HOST_ENTRY			*new_user_address;

	old_user_address = (STRUCT_HOST_ENTRY *)vptr_old_rhs;
	new_user_address = (STRUCT_HOST_ENTRY *)vptr_new_rhs;

	/* Validation */
	if (! is_an_ip_address(new_user_address->ip_addr))
	{
		printf("Not a Valid IP Address\n");
		return CM_EDITING_FAILED_ON_VALIDATION;
	}

	/* Check if the specified old user address exists */
	if (search_for_user_address (old_user_address, bptr_lhs_string) == FALSE)
	{
		printf("The given User Address does not exist.......\n");
		return CM_EDITING_FAILED_ON_VALIDATION;
	}

	/* Check if the specified new user address already exists */
	if (search_for_user_address (new_user_address, bptr_lhs_string) == TRUE)
	{
		printf("The modified User Address is a duplicate entry.......\n");
		return CM_EDITING_FAILED_ON_VALIDATION;
	}

	/* Remove the old user address and insert the new one */
	delete_result = remove_user_address(section_to_which_it_belongs_to,
												bptr_lhs_string, vptr_old_rhs);
	if (delete_result != CM_REMOVING_STRING_SUCCESSFUL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;

	if (insert_user_address(section_to_which_it_belongs_to, 
								bptr_lhs_string, vptr_new_rhs) == NULL)
		return CM_RHS_STRING_NOT_FOUND_WHILE_EDIT;

	return CM_STRING_EDIT_SUCCESSFUL; 
}

PARAMETER_NODE
*get_first_user_address(enum CM_SECTIONS section_to_which_it_belongs_to, 
							  BYTE *bptr_lhs_string, 
							  void *vptr_rhs)
{
	PARAMETER_NODE	*search_to_start_at;
	USHORT			port_number = 0,i = 0,j = 0; 
   BYTE  			port_number_matched, buffer[200];
	STRUCT_HOST_ENTRY			*ptr_to_user_address;

   ptr_to_user_address = (STRUCT_HOST_ENTRY *) vptr_rhs;

   port_number = ptr_to_user_address->port;

   if (port_number > 3)
		return NULL;

   
	search_to_start_at = sptr_to_each_section_in_the_configuration
											[section_to_which_it_belongs_to];
   for(i=1;i <= 50;++i)
	{   
	   search_to_start_at = 
		match_the_lhs_string_in_the_linked_list_and_return_rhs_string(
				user_address_list_in_ini, search_to_start_at, 
				sptr_to_each_section_in_the_configuration
											[section_to_which_it_belongs_to+1],
				buffer, port_number, &port_number_matched);
   
   	if (search_to_start_at == NULL)
	   	return NULL;	

      if (port_number_matched)
			break;
	}
	if (port_number_matched)	
	{
      if (vptr_rhs == NULL)
   	   return search_to_start_at;

		i = 0;
		/* Skip the port number  -> This is not required
				while (buffer[i++] != ','); */

		j = 0;
  		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			ptr_to_user_address->ip_addr[j++] = buffer[i++];
		ptr_to_user_address->ip_addr[j] = 0;

	}

   if (! port_number_matched)
	   return NULL;

	the_lastly_given_user_address_in_the_current_node(1, TRUE);
	return search_to_start_at;
}

PARAMETER_NODE
*get_next_user_address (enum CM_SECTIONS section_to_which_it_belongs_to,
							PARAMETER_NODE *current_node, 
							void *vptr_rhs)
{

	BYTE	i = 0, j = 0, prev_count, total,main_index, sub_index;
   STRUCT_HOST_ENTRY *user_address;
	BYTE	port_number_matched,
			buffer[200];
   USHORT port_number = 0;
	PARAMETER_NODE	*search_to_start_at;

	if (!current_node) return NULL;
   
	user_address = (STRUCT_HOST_ENTRY *)vptr_rhs;
   port_number = user_address->port;

   if (port_number > 3)  /* Replace this with max no ports */
		return NULL;

	prev_count=the_lastly_given_user_address_in_the_current_node(0, FALSE);
	total = total_number_of_user_addresses_in_the_current_node(current_node);
	if (prev_count < total)
	{
		/* 
		 * One more entry can be read from the current node itself.
		 * Skip first prev_count entries.
		*/
		main_index = 0;

      while (current_node->parameter[main_index++] != ','); 

		for (i = 0; i < prev_count; i++) 
			while (current_node->parameter[main_index++] != ','); 
   
		sub_index = 0;
		while (	current_node->parameter[main_index] != ',' && 
				current_node->parameter[main_index] != '\0' && 
				current_node->parameter[main_index] != '\n')
			user_address->ip_addr[sub_index++] = current_node->parameter[main_index++];
		user_address->ip_addr[sub_index] = 0;
     
		the_lastly_given_user_address_in_the_current_node(prev_count+1, TRUE);
		return current_node;
	}   

	search_to_start_at = current_node;
   for(i=1;i <= 50;++i)
	{
   	search_to_start_at = 
		match_the_lhs_string_in_the_linked_list_and_return_rhs_string(
				user_address_list_in_ini, search_to_start_at,
				sptr_to_each_section_in_the_configuration
											[section_to_which_it_belongs_to+1], 
				buffer, port_number, &port_number_matched);
   	if (search_to_start_at == NULL)
	   	return NULL;	
      if (port_number_matched)
				break;
   }
	if (port_number_matched)	
	{
      if (vptr_rhs == NULL)
   	   return search_to_start_at;
   
		i = 0;
		/* Skip the port number  -> This not required
			while (buffer[i++] != ','); */

		j = 0;

		while ((buffer[i] != ',' && buffer[i] !=  0 && buffer[i] !=  '\n'))
			user_address->ip_addr[j++] = buffer[i++];
		user_address->ip_addr[j] = 0;
   }
		
	if (! port_number_matched)
		return NULL;

	the_lastly_given_user_address_in_the_current_node(1, TRUE);
	return search_to_start_at;
}

PARAMETER_NODE *get_previous_user_address 
							(enum CM_SECTIONS section_to_which_it_belongs_to,
							PARAMETER_NODE *current_node, 
							void *vptr_rhs)
{
	return NULL;
}

BYTE 
search_for_user_address (STRUCT_HOST_ENTRY *user_address, BYTE *bptr_lhs_string)
{
   STRUCT_HOST_ENTRY temp_entry;
	BYTE			temp_buffer[100];
	BYTE			main_index, sub_index;
	PARAMETER_NODE	*node;
	BYTE			entries_available_in_the_same_buffer = FALSE;
   
   temp_entry.port = user_address->port;
	if ((node = get_first_user_address(CM_PROXY_SECTION, 
						bptr_lhs_string, (void *)&temp_entry)) == NULL)
		return FALSE;

	do {
		main_index = 0;
		while (node->parameter[main_index++] != '=');	/* skip LHS, '=' */
		main_index++; 									/* skip space */
      
      while (node->parameter[main_index++] != ',');	/* skip port number */

		do {
			/* Read one user address into a buffer */
			sub_index = 0;
			while ( node->parameter[main_index] != ',' &&
                 node->parameter[main_index] != '\0' &&
					node->parameter[main_index] != '\n')
				temp_buffer[sub_index++] = node->parameter[main_index++];
			temp_buffer[sub_index] = '\0';

			/* Check if the user addresses match */
			if (! strcmpi(temp_buffer, user_address->ip_addr))
            	return TRUE;
			else
			{
				/* 
				 * The given entry does not match with the read entry.
				 * Continue reading if there are more entries in the node. 
				*/
				if (node->parameter[main_index] == 0)		
					entries_available_in_the_same_buffer = FALSE;
				else
				{
					main_index ++; 			/* Skip the ',' */
					entries_available_in_the_same_buffer = TRUE;
				}
			}
		}
		while (entries_available_in_the_same_buffer);

		/* Read the next line/node and repeat the check for matching entries */
		node = get_next_user_address (CM_PROXY_SECTION, 
											node, (void*)&temp_entry);
	}
	while (node);
	return FALSE;
}

BYTE the_lastly_given_user_address_in_the_current_node
							(BYTE new_value, BYTE is_to_save)
{
	static BYTE user_addr_value;

	if (is_to_save)
		user_addr_value = new_value;
	else
		return user_addr_value;
}

BYTE total_number_of_user_addresses_in_the_current_node(PARAMETER_NODE *node)
{
	BYTE	i, num_entries, len;

	num_entries = len = 0;
	len = strlen(node->parameter);
	for (i = 0; i < len; i++) {
		if (node->parameter[i] == ',')
			num_entries++;
	}
	return (num_entries);
}	

void fill_the_buffer_with_user_address (BYTE *address_ptr, BYTE *buffer)        
{
	BYTE	j = 0, k = 0;

	while (buffer[j] != '=') ++j;
	j += 2;				/* Skip '=' sign  and Space */

	while (	buffer[j] != ',' && 
			buffer[j] != '\n' && 
			buffer[j] != '\r' && 
			buffer[j] != '\0')
		address_ptr[k++] = buffer[j++];   

   address_ptr[k] = 0;
}

