#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>

#include <incall.h>
#include <cfgmgr.h>

#define NUMBER_OF_BYTES_IN_IP_ADDRESS	4
#define LOWER_LIMIT_OF_BYTE_IN_IP_ADDRESS 0
#define UPPER_LIMIT_OF_BYTE_IN_IP_ADDRESS 254
#define NUMBER_OF_BITS_IN_A_BYTE 8

/* Local Prototypes ... */
BYTE is_an_ip_address(BYTE* address);
BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
BYTE valid_bit_sequence(BYTE* mask);
BYTE mask_compatible_with_ip_address(BYTE* address, BYTE* mask);
BYTE local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);
BYTE valid_characters_in(BYTE* address);
void format_address(BYTE* address);
/* ... Local Prototypes */


BYTE valid_characters_in(BYTE* address)
{
	BYTE i;

	for( i = 0 ; i < strlen(address) ; i++ )
	{														
		if (address[i] == '.' || (address[i] >= '0' && address[i] <= '9'))
			continue;
		else
			return FALSE;
	}
	return TRUE;
}

BYTE is_a_default_ip_address(BYTE* address)
{
	BYTE main_index = 0, i, number_of_dots = 0;
	USHORT number_of_characters;
	BYTE ip_address[20], ip_mask[20], number_of_ports;


   if (strlen(address) == 0)
   {
      strcpy(address, "0.0.0.0");
      return TRUE;  
   }

	/* Cheack For Number of Dots */
	for(i=0;i<strlen(address);++i)
	{
		if (address[i] == '.')
			number_of_dots ++;
	}
	if (number_of_dots != 3)
		return FALSE;

	if (!valid_characters_in(address))
		return FALSE;

   /* The following function will remove unwanted zeros in the address */
   format_address(address);

	/* Check whether this address forms an ip address. For this check whether 
	   all the four bytes are present and they are in dot form */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		number_of_characters = 0;
		while (main_index < strlen(address))
		{
			if (address[main_index++] == '.') 
				break;
			number_of_characters++;
		}
		if (!number_of_characters || number_of_characters > 3)
		{
			return FALSE;
		}
	}

	if (!strcmp(address, "0.0.0.0"))
		return TRUE;
   number_of_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS) + lsl_control(GET_NUMBER_OF_LAN_PORTS);
	for(i=0;i<number_of_ports;++i)
	{
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, i, CM_STRING_FORMAT, (void*)ip_address, 20);
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, i, CM_STRING_FORMAT, (void*)ip_mask, 20);
		if (local_ip_address_and_remote_ip_address_on_same_network(ip_address, address, ip_mask))
		{
			return TRUE;
		}
	}
	return FALSE;
}

BYTE is_a_static_ip_address_mask(BYTE* address, BYTE* mask)
{
	BYTE main_index = 0, i, number_of_characters, number_of_dots = 0;
	ULONG ip_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];


	/* Cheack For Number of Dots */
	for(i=0;i<strlen(mask);++i)
	{
		if (mask[i] == '.')
			number_of_dots ++;
	}
	if (number_of_dots != 3)
		return FALSE;

	if (!valid_characters_in(mask))
		return FALSE;

   format_address(mask);

	/* Check whether this address forms ip address mask. For this check whether 
	   all the four bytes are present and they are in dot form */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		number_of_characters = 0;
		while (main_index < strlen(mask))
		{
			if (mask[main_index++] == '.') 
				break;
			number_of_characters++;
		}
		if (!number_of_characters  || number_of_characters > 3)
		{
			return FALSE;
		}
	}

	/* Read each of the bytes from mask into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_mask_array[0]),(ULONG *)(&ip_mask_array[1]),
		(ULONG *)(&ip_mask_array[2]),(ULONG *)(&ip_mask_array[3]));

	/* For a valid mask first 8 bit should be 1 */
	if (ip_mask_array[0] != 255)
	{
		return FALSE;
	}
	
	/* Check for the sequence of bits. First some bytes will be 1 afterwards
		it should be continues zeros. Once 0 bit starts 1 bit should not 
		come in between */

	if (!valid_bit_sequence(mask))
	{
		return FALSE;
	}

	/* check whether the ip address  and mask are compatible 
      if the first byte of ip address is in the range
       193 - 254 mask should be wider then or equal to 255.255.255.0
       128 - 192 mask should be wider then or equal to 255.255.0.0
       1   - 127 mask should be wider then or equal to 255.0.0.0
   */
	if (!mask_compatible_with_ip_address(address, mask))
   {
      return FALSE;
   }

	/* Now the passed mask is valid for ip address hence return TRUE */
	return TRUE;
}

BYTE is_a_static_ip_address(BYTE* address, BYTE* mask)
{
	BYTE main_index = 0, i, number_of_dots = 0;
	ULONG ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	USHORT number_of_characters;


	/* Cheack For Number of Dots */
	for(i=0;i<strlen(address);++i)
	{
		if (address[i] == '.')
			number_of_dots ++;
	}
	if (number_of_dots != 3)
		return FALSE;

	if (!valid_characters_in(address))
		return FALSE;

   /* The following function will remove unwanted zeros in the address */
   format_address(address);

	/* Check whether this address forms an ip address. For this check whether 
	   all the four bytes are present and they are in dot form */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		number_of_characters = 0;
		while (main_index < strlen(address))
		{
			if (address[main_index++] == '.') 
				break;
			number_of_characters++;
		}
		if (!number_of_characters || number_of_characters > 3)
		{
			printf("Invalid IP Address Bad format \n");
			return FALSE;
		}
	}

	/* Read each of the bytes into an array of ULONG */
	sscanf(address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_address_array[0]),(ULONG *)(&ip_address_array[1]),
		(ULONG *)(&ip_address_array[2]),(ULONG *)(&ip_address_array[3]));

	if (!is_a_static_ip_address_mask(address, mask))
	{
		return FALSE;
	}
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&mask_array[0]),(ULONG *)(&mask_array[1]),
		(ULONG *)(&mask_array[2]),(ULONG *)(&mask_array[3]));


	/* Each Byte Should be in the Range 1-254. Otherwise it is not an valid
	   IP address */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		if (ip_address_array[i] > UPPER_LIMIT_OF_BYTE_IN_IP_ADDRESS)
		{
			printf("Invalid IP Address out of limits\n");
			return FALSE;
		}
      if (mask_array[i] == 255 && ip_address_array[i] == 0)  
      {
         return FALSE;
      }
	}

	/* Now the passed address is an valid ip address hence return TRUE */
	return TRUE;
}


BYTE is_an_ip_address(BYTE* address)
{
	BYTE main_index = 0, i, number_of_dots = 0;
	ULONG ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	USHORT number_of_characters;


	/* Cheack For Number of Dots */
	for(i=0;i<strlen(address);++i)
	{
		if (address[i] == '.')
			number_of_dots ++;
	}
	if (number_of_dots != 3)
		return FALSE;

	if (!valid_characters_in(address))
		return FALSE;

   /* The following function will remove unwanted zeros in the address */
   format_address(address);

	/* Check whether this address forms an ip address. For this check whether 
	   all the four bytes are present and they are in dot form */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		number_of_characters = 0;
		while (main_index < strlen(address))
		{
			if (address[main_index++] == '.') 
				break;
			number_of_characters++;
		}
		if (!number_of_characters || number_of_characters > 3)
		{
			printf("Invalid IP Address Bad format \n");
			return FALSE;
		}
	}

	/* Read each of the bytes into an array of ULONG */
	sscanf(address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_address_array[0]),(ULONG *)(&ip_address_array[1]),
		(ULONG *)(&ip_address_array[2]),(ULONG *)(&ip_address_array[3]));

	/* Each Byte Should be in the Range 1-254. Otherwise it is not an valid
	   IP address */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		if (ip_address_array[i] < LOWER_LIMIT_OF_BYTE_IN_IP_ADDRESS 
		    || ip_address_array[i] > UPPER_LIMIT_OF_BYTE_IN_IP_ADDRESS)
		{
			return FALSE;
		}
	}
	/* Now the passed address is an valid ip address hence return TRUE */
	return TRUE;
}

BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask)
{
	BYTE main_index = 0, i, number_of_characters, number_of_dots = 0;
	ULONG ip_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];

	/* Check whether ip address is valid or not. */
	if (!is_an_ip_address(address))
	{
		return FALSE;
	}

	/* Cheack For Number of Dots */
	for(i=0;i<strlen(mask);++i)
	{
		if (mask[i] == '.')
			number_of_dots ++;
	}
	if (number_of_dots != 3)
		return FALSE;

	if (!valid_characters_in(mask))
		return FALSE;

   format_address(mask);

	/* Check whether this address forms ip address mask. For this check whether 
	   all the four bytes are present and they are in dot form */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		number_of_characters = 0;
		while (main_index < strlen(mask))
		{
			if (mask[main_index++] == '.') 
				break;
			number_of_characters++;
		}
		if (!number_of_characters  || number_of_characters > 3)
		{
			return FALSE;
		}
	}

	/* Read each of the bytes from mask into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_mask_array[0]),(ULONG *)(&ip_mask_array[1]),
		(ULONG *)(&ip_mask_array[2]),(ULONG *)(&ip_mask_array[3]));

	/* For a valid mask first 8 bit should be 1 */
	if (ip_mask_array[0] != 255)
	{
		return FALSE;
	}
	
	/* Check for the sequence of bits. First some bytes will be 1 afterwards
		it should be continues zeros. Once 0 bit starts 1 bit should not 
		come in between */

	if (!valid_bit_sequence(mask))
	{
		return FALSE;
	}

	/* check whether the ip address  and mask are compatible 
      if the first byte of ip address is in the range
       193 - 254 mask should be wider then or equal to 255.255.255.0
       128 - 192 mask should be wider then or equal to 255.255.0.0
       1   - 127 mask should be wider then or equal to 255.0.0.0
   */
	if (!mask_compatible_with_ip_address(address, mask))
   {
      return FALSE;
   }

	/* Now the passed mask is valid for ip address hence return TRUE */
	return TRUE;
}


BYTE valid_bit_sequence(BYTE* mask)
{
	ULONG ip_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
   BYTE local_byte, local_mask, zero_bit_found = FALSE, i, j;

	/* Read each of the bytes from mask into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_mask_array[0]),(ULONG *)(&ip_mask_array[1]),
		(ULONG *)(&ip_mask_array[2]),(ULONG *)(&ip_mask_array[3]));

	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		local_byte = (BYTE)ip_mask_array[i];
      local_mask = 0x80;
      for(j=0; j<NUMBER_OF_BITS_IN_A_BYTE; ++j)
      {
         if (local_byte & local_mask)
         {
            if (zero_bit_found)
               return FALSE;
         }
         else
            zero_bit_found = TRUE;
         local_mask >>= 1;
      }
	}
}

BYTE mask_compatible_with_ip_address(BYTE* address, BYTE* mask)
{
	ULONG ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG ip_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
   ULONG local_mask, actual_mask;
   BYTE* temp_ptr;
	/* Read each of the bytes into an array of ULONG */
	sscanf(address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_address_array[0]),(ULONG *)(&ip_address_array[1]),
		(ULONG *)(&ip_address_array[2]),(ULONG *)(&ip_address_array[3]));


	/* Read each of the bytes from mask into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_mask_array[0]),(ULONG *)(&ip_mask_array[1]),
		(ULONG *)(&ip_mask_array[2]),(ULONG *)(&ip_mask_array[3]));

   temp_ptr = (BYTE*)&local_mask;
   *(temp_ptr) = 255;
   *(temp_ptr+3) = 0;
   if (ip_address_array[0] >= 193 && ip_address_array[0] <= 254)
   {
      *(temp_ptr+1) = *(temp_ptr+2) = 255;
   }
   else
   if(ip_address_array[0] >= 128 && ip_address_array[0] <= 192)
   {
      *(temp_ptr+1) = 255;
      *(temp_ptr+2) = 0;
   }
   else
   if(ip_address_array[0] >= 1 && ip_address_array[0] <= 127)
   {
      *(temp_ptr+1) = *(temp_ptr+2) = 0;
   }

   temp_ptr = (BYTE*)&actual_mask;
   *(temp_ptr+3) = ip_mask_array[3];
   *(temp_ptr+2) = ip_mask_array[2];
   *(temp_ptr+1) = ip_mask_array[1];
   *(temp_ptr)   = ip_mask_array[0];
  
   if (actual_mask < local_mask)   
      return FALSE;
   else
      return TRUE;
}


BYTE  local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask)
{
	ULONG local_ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG remote_ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG local_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
   ULONG local_ulong_ip, remote_ulong_ip, local_mask;
   BYTE* temp_ptr;


	if (!is_an_ip_address(local_ip_address))
	{
/*		printf("Invalid Local Ip Address while Validating Remote IP Address\n");*/
      return FALSE;
	}
   if (!is_an_ip_address(remote_ip_address))
	{
/*		printf("Invalid remote Ip Address while Validating Remote IP Address\n");*/
      return FALSE;
	}
   if (!is_an_ip_address_mask(local_ip_address, mask))
	{
/*		printf("Invalid mask for IP Address while Validating Remote IP Address\n");*/
      return FALSE;
	}
   if (!is_an_ip_address_mask(remote_ip_address, mask))
	{
/*		printf("Invalid mask for Remote IP Address while Validating Remote IP Address\n");*/
      return FALSE;
	}
   
	/* Read each of the bytes into an array of ULONG */
	sscanf(remote_ip_address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&remote_ip_address_array[0]),(ULONG *)(&remote_ip_address_array[1]),
		(ULONG *)(&remote_ip_address_array[2]),(ULONG *)(&remote_ip_address_array[3]));

	/* Read each of the bytes into an array of ULONG */
	sscanf(local_ip_address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&local_ip_address_array[0]),(ULONG *)(&local_ip_address_array[1]),
		(ULONG *)(&local_ip_address_array[2]),(ULONG *)(&local_ip_address_array[3]));

	/* Read each of the bytes into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&local_mask_array[0]),(ULONG *)(&local_mask_array[1]),
		(ULONG *)(&local_mask_array[2]),(ULONG *)(&local_mask_array[3]));

   temp_ptr = (BYTE*)&local_ulong_ip;
   *(temp_ptr+3) = local_ip_address_array[3];
   *(temp_ptr+2) = local_ip_address_array[2];
   *(temp_ptr+1) = local_ip_address_array[1];
   *(temp_ptr)   = local_ip_address_array[0];
  
   temp_ptr = (BYTE*)&remote_ulong_ip;
   *(temp_ptr+3) = remote_ip_address_array[3];
   *(temp_ptr+2) = remote_ip_address_array[2];
   *(temp_ptr+1) = remote_ip_address_array[1];
   *(temp_ptr)   = remote_ip_address_array[0];
  
   temp_ptr = (BYTE*)&local_mask;
   *(temp_ptr+3) = local_mask_array[3];
   *(temp_ptr+2) = local_mask_array[2];
   *(temp_ptr+1) = local_mask_array[1];
   *(temp_ptr)   = local_mask_array[0];
  
   if ((remote_ulong_ip & local_mask) != (local_ulong_ip & local_mask))
	{
      return FALSE;
	}
   return TRUE;
}

void format_address(BYTE* address)
{        
   BYTE temp_address[100];
   BYTE got_non_zero = FALSE, i, j = 0;

   strcpy(temp_address, address);
   for(i=0; i<strlen(temp_address); ++i)
   {
      if (temp_address[i] == '0' && !got_non_zero && i != (strlen(temp_address)-1) && temp_address[i+1] != '.')
         continue;
      got_non_zero = TRUE;
      address[j++] = temp_address[i];
      if (temp_address[i] == '.')
         got_non_zero = FALSE;
   }
   address[j] = 0;
}

BYTE is_valid_ipx_network_number(BYTE* string_ptr)
{
	BYTE i;

	for(i=0;i<strlen(string_ptr);++i)
	{
		if (string_ptr[i] < '0' || (string_ptr[i] > '9' && string_ptr[i] < 'A') || (string_ptr[i] > 'F' && string_ptr[i] < 'a') || string_ptr[i] > 'f')
		{
			return FALSE;
		}
	}
	return TRUE;
}

#if 0
void format_the_ipx_network_number(BYTE* string_ptr)
{
	BYTE string_length, number_of_zeros_to_be_inserted, i;
	
	string_length = strlen(string_ptr);

	if (string_length == 8)
		return;

	number_of_zeros_to_be_inserted = 8 - string_length;
	for(i=1;i<=string_length;++i)
	{
		string_ptr[string_length+number_of_zeros_to_be_inserted-i] = string_ptr[string_length-i];
	}
	for(i=0;i<number_of_zeros_to_be_inserted;++i)
		string_ptr[i] = '0';
	string_ptr[8] = 0;
}
#endif
void format_the_ipx_network_number(BYTE* string_ptr)
{
	int string_length, i;
	char temp_buff[200] ;
	int number_of_zeros_to_be_inserted ;
	
	string_length = strlen(string_ptr);
	if (string_length == 8)
		return;
	memset (&temp_buff[0], '0', 200) ;

	number_of_zeros_to_be_inserted = 8 - string_length;

	for (i = number_of_zeros_to_be_inserted ; i < 8 ; i++)
		temp_buff[i] = string_ptr[i-number_of_zeros_to_be_inserted] ;
	temp_buff[8] = 0 ;

	strcpy(string_ptr, temp_buff);
}

void get_lhs_string_of_the_node(PARAMETER_NODE* node, BYTE* lhs_string)
{
   BYTE temp_string[300], *ptr_to_eq_sign;

   strcpy(temp_string, node->parameter);
   ptr_to_eq_sign = strchr(temp_string, '=');
   if (ptr_to_eq_sign == NULL)
   {
      lhs_string[0] = 0;
      return;
   }
   else
   {
      ptr_to_eq_sign --;
      *(ptr_to_eq_sign) = 0;
      strcpy(lhs_string, temp_string);
   }
}



