/*	$Modname: cipxinit.c$  $version: 1.4$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 03/30/95 titus Changes for dynamic loading
1.3 04/06/95 titus Changes to accomodate new configurable parameters
1.4 04/06/95 titus Cosmetic change: added cipx_printf's
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define GLOBAL_FILE
#include <string.h>
#include <stdlib.h>
#include "cipx.h"
/************************************************************************************/
static enum TEST initialize_line_compression_state (USHORT port_number,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
/************************************************************************************/
enum TEST initialize_cipx (ULONG clock_ticks_per_second)
{
	USHORT port_number;
	CIPX_PORT_CLASS *sptr_port_class;

	PARAMETER_NOT_USED (clock_ticks_per_second);

	if (cipx.enabled == TRUE)
		{
		if (cipx.number_of_ports > NUMBER_OF_CIPX_PORTS)
			{
			cipx_printf (CIPX_ALARM_PRINTF, "CIPX: NUMBER_OF_CIPX_PORTS is set to %u\n", NUMBER_OF_CIPX_PORTS);

			cipx_printf (CIPX_ALARM_PRINTF, "CIPX: Invalid number of ports: %u\n", cipx.number_of_ports);

			cipx.enabled = FALSE;

			cipx_printf (CIPX_ALARM_PRINTF, "CIPX: CIPX is now disabled\n");

			return (FAIL);
			}

		sptr_port_class = &cipx.port[0];

		for (port_number = 0x0000; port_number < cipx.number_of_ports; ++port_number)
			{
			if (sptr_port_class->cipx_compression_enabled == TRUE)
				{
				if (initialize_line_compression_state (port_number, &sptr_port_class->line_compression_state) == FAIL)
					{
					sptr_port_class->cipx_compression_enabled = FALSE;
					return (FAIL);
					}

				ppp_register_ipx_compression (port_number,
					(void (*) (USHORT real_port_number, void **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes))
					cipx_compress_header, cipx_get_maximum_connection_states, cipx_get_compress_slot_number,
					(enum TEST (*)
					(USHORT receive_port_number, void **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes))
					cipx_uncompress_header);
				}

			cipx_printf (CIPX_INIT_PRINTF, "CIPX: Initializing line compression state for port %u\n", port_number);

			++sptr_port_class;
			}

		cipx_printf (CIPX_INIT_PRINTF, "CIPX: Data Structures Initialized\n");

		return (PASS);
		}
	else
		{
		cipx_printf (CIPX_INIT_PRINTF, "CIPX: Class is not enabled\n");

		return (PASS);
		}
}
/************************************************************************************/
static enum TEST initialize_line_compression_state (USHORT port_number, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	USHORT slot_number;
	CIPX_CONNECTION_STATE *sptr_connection_state;
	ULONG size_of_buffer;

	size_of_buffer = (sptr_line_compression_state->maximum_number_of_slots + 1) * sizeof (CIPX_CONNECTION_STATE);

	sptr_line_compression_state->sptr_transmitted_connection_states =	(CIPX_CONNECTION_STATE *) buffer_malloc (size_of_buffer);
	
	if (sptr_line_compression_state->sptr_transmitted_connection_states == NULL)
	{
		cipx_printf (CIPX_ALARM_PRINTF, "CIPX: buffer_malloc failed\n");
		return (FAIL);
	}

	memset ((void *) &sptr_line_compression_state->sptr_transmitted_connection_states[0], 0x00, size_of_buffer);

	/* Link the transmit states into a circular list. */

	sptr_connection_state = &sptr_line_compression_state->sptr_transmitted_connection_states[0];

	for (slot_number = 0x0000; slot_number < sptr_line_compression_state->maximum_number_of_slots; ++slot_number)
		{
		sptr_connection_state->slot_number = (BYTE) slot_number;

		sptr_connection_state->sptr_connection_state_next = sptr_connection_state + 1;

		++sptr_connection_state;
		}

	sptr_connection_state->sptr_connection_state_next = sptr_line_compression_state->sptr_transmitted_connection_states;

	sptr_connection_state->slot_number = sptr_line_compression_state->maximum_number_of_slots;

	sptr_line_compression_state->sptr_last_connection_state = sptr_connection_state;

	/* Make sure we don't accidentally do slot ID compression (assumes MAXIMUM_NUMBER_OF_CONNECTION_STATES < 255). */

	sptr_line_compression_state->last_received_slot_number = INVALID_SLOT_NUMBER;

	sptr_line_compression_state->last_transmitted_slot_number = INVALID_SLOT_NUMBER;

	sptr_line_compression_state->port_number = port_number;

	sptr_line_compression_state->sptr_received_connection_states =	(CIPX_CONNECTION_STATE *) buffer_malloc (size_of_buffer);

	if (sptr_line_compression_state->sptr_received_connection_states == NULL)
	{
		cipx_printf (CIPX_ALARM_PRINTF, "CIPX: buffer_malloc failed\n");
		free (sptr_line_compression_state->sptr_received_connection_states);
		return (FAIL);
	}

	memset ((void *) &sptr_line_compression_state->sptr_received_connection_states[0], 0x00, size_of_buffer);

	sptr_connection_state = &sptr_line_compression_state->sptr_received_connection_states[0];

	/* Initialize the slot numbers for the receive states. */

	for (slot_number = 0x0000; slot_number <= sptr_line_compression_state->maximum_number_of_slots; ++slot_number)
		{
		sptr_connection_state->slot_number = (BYTE) slot_number;

		++sptr_connection_state;
		}

	return (PASS);
}
/*************************************************************************/
void set_cipx_class_to_zero (void)
{
	memset ((void *) &cipx, 0x00, sizeof (CIPX_CLASS));
}


/*************************************************************************/
/* Reset all the slots */
/*************************************************************************/

void cipx_reset_connection_states (USHORT port_number)
{
	CIPX_CONNECTION_STATE 			*sptr_tx_connection_state;
	CIPX_CONNECTION_STATE 			*sptr_rx_connection_state;
	CIPX_LINE_COMPRESSION_STATE	*sptr_line_compression_state;
	USHORT slot_number;

	if (cipx.enabled == TRUE && cipx.port[port_number].cipx_compression_enabled == TRUE) 
	{
		sptr_line_compression_state = &cipx.port[port_number].line_compression_state;

		sptr_tx_connection_state = &sptr_line_compression_state->sptr_transmitted_connection_states[0];
		sptr_rx_connection_state = &sptr_line_compression_state->sptr_received_connection_states[0];

		for (slot_number = 0x0000; slot_number < sptr_line_compression_state->maximum_number_of_slots; ++slot_number)
		{
			memset ((void *) &sptr_tx_connection_state->uncompressed_header[0], 0x00, MAXIMUM_HEADER_LENGTH);
			sptr_tx_connection_state->last_confirmed_initial_packet_id = 0;
			sptr_tx_connection_state->last_confirm_packet_id = 0;
			sptr_tx_connection_state->last_rejected_flags = 0;
			sptr_tx_connection_state->unconfirmed_initial_packet = 0;					/* set to TRUE when an unconfirmed initial packet is sent */

			memset ((void *) &sptr_rx_connection_state->uncompressed_header[0], 0x00, MAXIMUM_HEADER_LENGTH);
			sptr_rx_connection_state->last_confirmed_initial_packet_id = 0;
			sptr_rx_connection_state->last_confirm_packet_id = 0;
			sptr_rx_connection_state->last_rejected_flags = 0;
			sptr_rx_connection_state->unconfirmed_initial_packet = 0;					/* set to TRUE when an unconfirmed initial packet is sent */

			++sptr_rx_connection_state;
			++sptr_tx_connection_state;
		}
	}
}
