/*	$Modname: cipxrxun.c$  $version: 1.3$      $date: 03/30/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 02/06/95 titus
1.3 03/30/95 titus Changes for new configurable parameters and for Windows 95 testing
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "cipx.h"
/************************************************************************************/
static enum PROCESS_RESULT process_regular_packet (IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
static enum PROCESS_RESULT process_confirmed_initial_packet (IPX_PACKET **ptr_to_sptr_ipx_packet,
	USHORT *usptr_number_of_bytes, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
static enum PROCESS_RESULT process_unconfirmed_initial_packet (IPX_PACKET **ptr_to_sptr_ipx_packet,
	USHORT *usptr_number_of_bytes, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
static enum PROCESS_RESULT process_confirm_packet (CIPX_PACKET **ptr_to_sptr_cipx_packet,	USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
static enum PROCESS_RESULT process_reject_packet (CIPX_PACKET **ptr_to_sptr_cipx_packet, USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
/************************************************************************************/
enum PROCESS_RESULT uncompress_header (IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	BYTE flags_octet;
	enum PROCESS_RESULT process_result;

	flags_octet = *(BYTE *) &(*ptr_to_sptr_ipx_packet)->ipx_header;

	++cipx.statistics.packets_received_by_cipx;

	process_result = CONTINUE_PROCESSING;

	if (flags_octet == TYPE_NORMAL_IPX) {
		++cipx.statistics.normal_ipx_packets_received;
		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: Normal IPX packet is returned unaltered\n");
		return (process_result);
	}

	switch (flags_octet & PACKET_TYPE_MASK)
		{
		case TYPE_REGULAR:

			process_result = process_regular_packet (ptr_to_sptr_ipx_packet, usptr_number_of_bytes, sptr_line_compression_state);

			return (process_result);

		case TYPE_CONFIRMED_INITIAL:

			process_result = process_confirmed_initial_packet (ptr_to_sptr_ipx_packet, usptr_number_of_bytes,
				sptr_line_compression_state);

			return (process_result);

		case TYPE_UNCONFIRMED_INITIAL:

			process_result = process_unconfirmed_initial_packet (ptr_to_sptr_ipx_packet, usptr_number_of_bytes,
				sptr_line_compression_state);
			
			return (process_result);

		case TYPE_CONFIRM:

			process_result = process_confirm_packet ((CIPX_PACKET **) ptr_to_sptr_ipx_packet, usptr_number_of_bytes,
				sptr_line_compression_state);

			return (process_result);

		case TYPE_REJECT:

			process_result = process_reject_packet ((CIPX_PACKET **) ptr_to_sptr_ipx_packet, usptr_number_of_bytes,
				sptr_line_compression_state);

			return (process_result);

		case TYPE_COMPRESSED:

			process_result = process_compressed_packet (ptr_to_sptr_ipx_packet, usptr_number_of_bytes, sptr_line_compression_state);

			return (process_result);

/*		case TYPE_NORMAL_IPX:

			++cipx.statistics.normal_ipx_packets_received;

			cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: Normal IPX packet is returned unaltered\n");

			return (process_result);
*/
		default:

			process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, flags_octet, TRUE);

			cipx_printf (CIPX_ALARM_PRINTF, "CIPX: Unknown cipx type. Packet is returned unaltered\n");

			return (process_result);
		}
}
/************************************************************************************/
void process_bad_header_event (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_PACKET *sptr_ipx_packet,
	BYTE rejected_flags, enum BOOLEAN send_reject)
{
	++cipx.statistics.bad_cipx_header_events;

	sptr_line_compression_state->valid_flag = FALSE;

	if (send_reject == TRUE)
		{
		send_cipx_reject_packet (sptr_ipx_packet, rejected_flags, sptr_line_compression_state);
		}
}
/************************************************************************************/
static enum PROCESS_RESULT process_regular_packet (IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	BYTE *bptr_cipx_header;
	BYTE rejected_flags;

#ifdef DEBUG
	print_header_in_regular_packet (*ptr_to_sptr_ipx_packet, RECEIVE_MODE, FROM_LOWER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);
#endif

	++cipx.statistics.type_regular_packets_received;

	bptr_cipx_header = (BYTE *) &(*ptr_to_sptr_ipx_packet)->ipx_header;

	rejected_flags = *bptr_cipx_header;

	if (*usptr_number_of_bytes < (sizeof (UNION_MAC_HEADER) + LENGTH_OF_CIPX_REGULAR_HEADER + IPX_HEADER_LENGTH))
		{
		/* discard packet */

		process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, FALSE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: too few bytes in REGULAR packet : %u\n", *usptr_number_of_bytes);

		return (END_OF_PROCESSING);
		}

	++bptr_cipx_header;

	*usptr_number_of_bytes -= (USHORT) LENGTH_OF_CIPX_REGULAR_HEADER;
									  
	*ptr_to_sptr_ipx_packet = (IPX_PACKET *) (bptr_cipx_header - sizeof (UNION_MAC_HEADER));

#ifdef DEBUG
	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);

	print_addresses_in_ipx_packet (*ptr_to_sptr_ipx_packet, sptr_line_compression_state);

	print_uncompressed_header_in_ipx_packet (*ptr_to_sptr_ipx_packet, RECEIVE_MODE, TO_UPPER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif

	return (CONTINUE_PROCESSING);
}
/************************************************************************************/
static enum PROCESS_RESULT process_confirmed_initial_packet (IPX_PACKET **ptr_to_sptr_ipx_packet,
	USHORT *usptr_number_of_bytes, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CIPX_CONNECTION_STATE *sptr_connection_state;
	USHORT header_length;
	BYTE *bptr_cipx_header;
	USHORT slot_number;
	USHORT confirmed_initial_packet_id;
	BYTE rejected_flags;

#ifdef DEBUG
	print_header_in_initial_packet (*ptr_to_sptr_ipx_packet, RECEIVE_MODE, FROM_LOWER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);
#endif

	++cipx.statistics.type_confirmed_initial_packets_received;
			
	bptr_cipx_header = (BYTE *) &(*ptr_to_sptr_ipx_packet)->ipx_header;

	rejected_flags = *bptr_cipx_header;

	if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
		(((IPX_PACKET *) (bptr_cipx_header + LENGTH_OF_CONFIRMED_INITIAL_HEADER))->ipx_header.packet_type ==
		NETWORK_CORE_PROTOCOL_TYPE_PACKET))
		{
		if (*usptr_number_of_bytes < (sizeof (UNION_MAC_HEADER) + LENGTH_OF_CONFIRMED_INITIAL_HEADER + IPX_HEADER_LENGTH +
			MINIMUM_NCP_HEADER_LENGTH))
			{
			/* discard packet */

			process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

			cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: too few bytes in CONFIRMED INITIAL packet : %u\n", *usptr_number_of_bytes);

			return (END_OF_PROCESSING);
			}
		}
	else
		{
		if (*usptr_number_of_bytes < (sizeof (UNION_MAC_HEADER) + LENGTH_OF_CONFIRMED_INITIAL_HEADER + IPX_HEADER_LENGTH))
			{
			/* discard packet */

			process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

			cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: too few bytes in CONFIRMED INITIAL packet : %u\n", *usptr_number_of_bytes);

			return (END_OF_PROCESSING);
			}
		}

	++bptr_cipx_header;

	slot_number = *bptr_cipx_header;

	if (slot_number > sptr_line_compression_state->maximum_number_of_slots)
		{
		process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF,
			"CIPX: slot_number : %u in CONFIRMED INITIAL packet exceeds MAXIMUM NUMBER OF SLOTS : %u\n", slot_number,
			sptr_line_compression_state->maximum_number_of_slots);

		return (END_OF_PROCESSING);
		}

	++bptr_cipx_header;

	confirmed_initial_packet_id = *bptr_cipx_header;

	++bptr_cipx_header;

	sptr_line_compression_state->last_received_slot_number = slot_number;

	sptr_connection_state =	sptr_line_compression_state->sptr_received_connection_states + slot_number;

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, OLD, sptr_connection_state,
		sptr_line_compression_state);
#endif

	sptr_connection_state->last_confirmed_initial_packet_id = confirmed_initial_packet_id;

	sptr_line_compression_state->valid_flag = TRUE;

	header_length = IPX_HEADER_LENGTH;

	if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
		(((IPX_HEADER *) bptr_cipx_header)->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET))
		{
		if (check_if_ncp_packet_type_is_compressible ((NETWORK_CORE_PROTOCOL_HEADER *) (bptr_cipx_header + sizeof (IPX_HEADER)))
			== TRUE)
			{
			header_length += (USHORT) MINIMUM_NCP_HEADER_LENGTH;
			}
		}

	memcpy ((void *) &sptr_connection_state->uncompressed_header[0], (const void *) bptr_cipx_header, header_length);

	sptr_connection_state->header_length = header_length;

	*usptr_number_of_bytes -= (USHORT) LENGTH_OF_CONFIRMED_INITIAL_HEADER;

	*ptr_to_sptr_ipx_packet = (IPX_PACKET *) (bptr_cipx_header - sizeof (UNION_MAC_HEADER));

	send_cipx_confirm_packet (sptr_connection_state, sptr_line_compression_state);

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, NEW, sptr_connection_state,
		sptr_line_compression_state);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);

	print_addresses_in_ipx_packet (*ptr_to_sptr_ipx_packet, sptr_line_compression_state);

	print_uncompressed_header_in_ipx_packet (*ptr_to_sptr_ipx_packet, RECEIVE_MODE, TO_UPPER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif

	return (CONTINUE_PROCESSING);
}
/************************************************************************************/
static enum PROCESS_RESULT process_unconfirmed_initial_packet (IPX_PACKET **ptr_to_sptr_ipx_packet,
	USHORT *usptr_number_of_bytes, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CIPX_CONNECTION_STATE *sptr_connection_state;
	USHORT header_length;
	BYTE *bptr_cipx_header;
	USHORT slot_number;
	BYTE rejected_flags;

#ifdef DEBUG
	print_header_in_initial_packet (*ptr_to_sptr_ipx_packet, RECEIVE_MODE, FROM_LOWER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);
#endif

	++cipx.statistics.type_unconfirmed_initial_packets_received;

	bptr_cipx_header = (BYTE *) &(*ptr_to_sptr_ipx_packet)->ipx_header;

	rejected_flags = *bptr_cipx_header;

	if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
		(((IPX_PACKET *) (bptr_cipx_header + LENGTH_OF_UNCONFIRMED_INITIAL_HEADER))->ipx_header.packet_type ==
		NETWORK_CORE_PROTOCOL_TYPE_PACKET))
		{
		if (*usptr_number_of_bytes < (sizeof (UNION_MAC_HEADER) + LENGTH_OF_UNCONFIRMED_INITIAL_HEADER + IPX_HEADER_LENGTH +
			MINIMUM_NCP_HEADER_LENGTH))
			{
			/* discard packet */

			process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

			cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: too few bytes in UNCONFIRMED INITIAL packet : %u\n",
				*usptr_number_of_bytes);

			return (END_OF_PROCESSING);
			}
		}
	else
		{
		if (*usptr_number_of_bytes < (sizeof (UNION_MAC_HEADER) + LENGTH_OF_UNCONFIRMED_INITIAL_HEADER + IPX_HEADER_LENGTH))
			{
			/* discard packet */

			process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

			cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: too few bytes in UNCONFIRMED INITIAL packet : %u\n",
				*usptr_number_of_bytes);

			return (END_OF_PROCESSING);
			}
		}

	++bptr_cipx_header;

	slot_number = *bptr_cipx_header;

	if (slot_number > sptr_line_compression_state->maximum_number_of_slots)
		{
		process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF,
			"CIPX: slot_number : %u in UNCONFIRMED INITIAL packet exceeds MAXIMUM NUMBER OF SLOTS : %u\n", slot_number,
			sptr_line_compression_state->maximum_number_of_slots);

		return (END_OF_PROCESSING);
		}

	++bptr_cipx_header;

	sptr_line_compression_state->last_received_slot_number = slot_number;

	sptr_connection_state =	sptr_line_compression_state->sptr_received_connection_states + slot_number;

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, OLD, sptr_connection_state,
		sptr_line_compression_state);
#endif

	sptr_line_compression_state->valid_flag = TRUE;

	header_length = IPX_HEADER_LENGTH;

	if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
		(((IPX_HEADER *) bptr_cipx_header)->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET))
		{
		if (check_if_ncp_packet_type_is_compressible ((NETWORK_CORE_PROTOCOL_HEADER *) (bptr_cipx_header + sizeof (IPX_HEADER)))
			== TRUE)
			{
			header_length += (USHORT) MINIMUM_NCP_HEADER_LENGTH;
			}
		}

	memcpy ((void *) &sptr_connection_state->uncompressed_header[0], (const void *) bptr_cipx_header, header_length);

	sptr_connection_state->header_length = header_length;

	sptr_connection_state->unconfirmed_initial_packet = TRUE;

	*usptr_number_of_bytes -= (USHORT) LENGTH_OF_UNCONFIRMED_INITIAL_HEADER;

	*ptr_to_sptr_ipx_packet = (IPX_PACKET *) (bptr_cipx_header - sizeof (UNION_MAC_HEADER));

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, NEW, sptr_connection_state,
		sptr_line_compression_state);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);

	print_addresses_in_ipx_packet (*ptr_to_sptr_ipx_packet, sptr_line_compression_state);

	print_uncompressed_header_in_ipx_packet (*ptr_to_sptr_ipx_packet, RECEIVE_MODE, TO_UPPER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif

	return (CONTINUE_PROCESSING);
}
/************************************************************************************/
static enum PROCESS_RESULT process_confirm_packet (CIPX_PACKET **ptr_to_sptr_cipx_packet,	USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CIPX_CONNECTION_STATE *sptr_connection_state;
	BYTE *bptr_cipx_header;
	BYTE slot_number;
	BYTE confirm_packet_id;

#ifdef DEBUG
	print_header_in_confirm_packet (*ptr_to_sptr_cipx_packet, RECEIVE_MODE, FROM_LOWER_LEVEL, *usptr_number_of_bytes);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_cipx_packet is : %p\n", *ptr_to_sptr_cipx_packet);
#endif

	++cipx.statistics.type_confirm_packets_received;
			
	if (*usptr_number_of_bytes < sizeof (CIPX_PACKET))
		{
		/* discard packet */

		process_bad_header_event (sptr_line_compression_state, NULL, 0x00, FALSE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: too few bytes in CONFIRM packet : %u\n", *usptr_number_of_bytes);

		return (END_OF_PROCESSING);
		}

	bptr_cipx_header = (BYTE *) &(*ptr_to_sptr_cipx_packet)->cipx_header[0];

	++bptr_cipx_header;

	slot_number = *bptr_cipx_header;

	if (slot_number > sptr_line_compression_state->maximum_number_of_slots)
		{
		/* discard packet */

		process_bad_header_event (sptr_line_compression_state, NULL, 0x00, FALSE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: slot_number : %u in CONFIRM packet exceeds MAXIMUM NUMBER OF SLOTS : %u\n",
			slot_number, sptr_line_compression_state->maximum_number_of_slots);

		return (END_OF_PROCESSING);
		}

	++bptr_cipx_header;

	confirm_packet_id = *bptr_cipx_header;

	sptr_connection_state =	sptr_line_compression_state->sptr_transmitted_connection_states + slot_number;

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, OLD, sptr_connection_state,
		sptr_line_compression_state);
#endif

	sptr_connection_state->last_confirm_packet_id = confirm_packet_id;

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, NEW, sptr_connection_state,
		sptr_line_compression_state);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_cipx_packet is : %p\n", *ptr_to_sptr_cipx_packet);

	cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif

	return (END_OF_PROCESSING);
}
/************************************************************************************/
static enum PROCESS_RESULT process_reject_packet (CIPX_PACKET **ptr_to_sptr_cipx_packet, USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CIPX_CONNECTION_STATE *sptr_connection_state;
	BYTE *bptr_cipx_header;
	USHORT slot_number;
	BYTE rejected_flags;

	print_header_in_reject_packet (*ptr_to_sptr_cipx_packet, RECEIVE_MODE, FROM_LOWER_LEVEL, *usptr_number_of_bytes);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_cipx_packet is : %p\n", *ptr_to_sptr_cipx_packet);

	++cipx.statistics.type_reject_packets_received;
			
	if (*usptr_number_of_bytes < sizeof (CIPX_PACKET))
		{
		/* discard packet */

		process_bad_header_event (sptr_line_compression_state, NULL, 0x00, FALSE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: too few bytes in REJECT packet : %u\n", *usptr_number_of_bytes);

		return (END_OF_PROCESSING);
		}

	bptr_cipx_header = (BYTE *) &(*ptr_to_sptr_cipx_packet)->cipx_header[0];

	++bptr_cipx_header;

	slot_number = *bptr_cipx_header;

	if (slot_number > sptr_line_compression_state->maximum_number_of_slots)
		{
		/* discard packet */

		process_bad_header_event (sptr_line_compression_state, NULL, 0x00, FALSE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: slot_number : %u in REJECT packet exceeds MAXIMUM NUMBER OF SLOTS : %u\n",
			slot_number, sptr_line_compression_state->maximum_number_of_slots);

		return (END_OF_PROCESSING);
		}

	++bptr_cipx_header;

	rejected_flags = *bptr_cipx_header;

	sptr_connection_state =	sptr_line_compression_state->sptr_transmitted_connection_states + slot_number;

	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, OLD, sptr_connection_state,
		sptr_line_compression_state);

	sptr_connection_state->last_rejected_flags = rejected_flags;

	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, NEW, sptr_connection_state,
		sptr_line_compression_state);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_cipx_packet is : %p\n", *ptr_to_sptr_cipx_packet);

	cipx_printf (CIPX_DATA_PRINTF, "\n");

	return (END_OF_PROCESSING);
}

