/*	$Modname: kvjc.h$  $version: 1.2$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/26/94 titus Add Copyright
1.2 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _KVJC_H_
#define _KVJC_H_


#define NUMBER_OF_VJC_PORTS 													0x03

#define MAXIMUM_NUMBER_OF_CONNECTION_STATES 								0x10 	/* must be >2 and <255 */

#define MAXIMUM_HEADER_LENGTH 												0x80
																				/* max TCP+IP hdr length (by protocol def) is 128 bytes */

#define MAXIMUM_COMPRESSED_HEADER_LENGTH 									0x10		/* 16 */

#define MEMCOMPARE_MATCH		 												0x00

#define NUMBER_OF_BITS_IN_BYTE 												0x08

#define NUMBER_OF_BITS_IN_USHORT												0x10

#define WORD_LENGTH_TO_BYTE_LENGTH_CONVERSION 							0x02

#define MINIMUM_COMPRESSED_HEADER_WITH_CONNECTION_IDENTIFIER 		0x04

#define MINIMUM_COMPRESSED_HEADER_WITHOUT_CONNECTION_IDENTIFIER 	0x03

#define INVALID_CONNECTION_IDENTIFIER 										0xff

#define SIZEOF_FRAGMENT_OFFSET_MOST_SIGNIFICANT_PART					0x05

#define ENCODED_SIZEOF_USHORT					 								0x03

#define FOUR_BYTE_BOUNDARY_MASK 												0x00000003L

#define CHECKSUM_MASK			 												0xffff

#define IP_FRAGMENT_MASK			 											0x3fff

#define MAXIMUM_USHORT_VALUE	 												0x0000ffffL


enum TYPE_OF_PACKET
{
	/* packet types */

	TYPE_ERROR_PACKET 				= 0x00,		/* this is not a type that ever appears on the wire. The receive framer uses it to
															 * tell the uncompressor there was a packet transmission error. */

	TYPE_IP_PACKET 					= 0x40,
	TYPE_UNCOMPRESSED_TCP_PACKET 	= 0x70,
	TYPE_COMPRESSED_TCP_PACKET 	= 0x80
};


/*
 * Bits in first octet of compressed packet
 */

enum DELTA_TYPE
{
	/* flag bits for what changed in a packet */

	DELTA_NO_CHANGES 					= 0x00,
	DELTA_URGENT_POINTER 			= 0x01,
	DELTA_WINDOW_SIZE 				= 0x02,
	DELTA_ACKNOWLEDGMENT_NUMBER 	= 0x04,
	DELTA_SEQUENCE_NUMBER 			= 0x08,

	/* reserved, special-case values begin here */

	DELTA_SPECIAL_I 					= 0x0b, 				/* echoed interactive traffic */
	DELTA_SPECIAL_D 					= 0x0f,				/* unidirectional data */
	DELTA_SPECIAL_T 					= 0x0c,
	DELTA_SPECIALS_MASK 				= 0x0f,

	/* reserved, special-case values end here */

	DELTA_TCP_PUSH_BIT 				= 0x10,
	DELTA_PACKET_ID 					= 0x20,
	DELTA_CONNECTION_IDENTIFIER 	= 0x40
};


enum VJC_FIELD_TYPE
{
	URGENT_POINTER,
	WINDOW_SIZE,
	ACKNOWLEDGMENT_NUMBER,
	SEQUENCE_NUMBER,
	PACKET_ID
};


enum VJC_PRINTF_GROUPS
{
	VJC_PRINTF,
	VJC_INIT_PRINTF,
	VJC_COMPRESS_PRINTF,
	VJC_UNCOMPRESS_PRINTF,
	VJC_ENCODE_PRINTF,
	VJC_DECODE_PRINTF,
	VJC_CHECKSUM_PRINTF,
	VJC_STRING_PRINTF,
	VJC_ALARM_PRINTF,
	VJC_MEMORY_PRINTF,
	VJC_DATA_PRINTF,
	VJC_DIAGNOSTIC_PRINTF
};

#ifndef _COM_MODE_
#define _COM_MODE_
enum COMMUNICATION_MODE
{
	TRANSMIT,
	RECEIVE
};


enum PACKET_DIRECTION
{
	FROM_UPPER_LEVEL,
	TO_LOWER_LEVEL,
	FROM_LOWER_LEVEL,
	TO_UPPER_LEVEL
};


enum HEADER_AGE
{
	OLD,
	NEW
};
#endif
#endif /* _KVJC_H_ */


