/*	$Modname: vjcrx.c$  $version: 1.3$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/25/94 titus
1.2 08/26/94 titus Add Copyright
1.3 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "vjc.h"
/************************************************************************************/
static void process_bad_header_event (LINE_COMPRESSION_STATE *sptr_line_compression_state);
static void process_uncompressed_tcp_packet (enum BOOLEAN *eptr_bad_header, IP_PACKET *sptr_ip_packet,
	LINE_COMPRESSION_STATE *sptr_line_compression_state);
static void	process_compressed_tcp_packet (enum BOOLEAN *eptr_bad_header, IP_PACKET *sptr_ip_packet,
	USHORT *usptr_number_of_bytes, LINE_COMPRESSION_STATE *sptr_line_compression_state, BYTE **ptr_to_bptr_compressed_header);
static void	set_byte_pointer_and_change_mask (IP_PACKET *sptr_ip_packet, BYTE **ptr_to_bptr_compressed_header,
	BYTE *bptr_change_mask);
static enum BOOLEAN check_for_valid_connection_identifier (BYTE change_mask, BYTE **ptr_to_bptr_compressed_header,
	enum BOOLEAN *eptr_bad_header, LINE_COMPRESSION_STATE *sptr_line_compression_state);
static void get_connection_state_and_fill_in_tcp_checksum_and_push_bit (LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CONNECTION_STATE **ptr_to_sptr_connection_state, IP_HEADER **ptr_to_sptr_ip_header, USHORT *usptr_header_length,
	TCP_HEADER **ptr_to_sptr_tcp_header, BYTE **ptr_to_bptr_compressed_header, BYTE change_mask);
static void	fix_up_connection_state_based_on_change_mask (BYTE change_mask, IP_HEADER *sptr_ip_header,
	CONNECTION_STATE *sptr_connection_state, TCP_HEADER *sptr_tcp_header, BYTE **ptr_to_bptr_compressed_header);
static void process_special_i_encoding (IP_HEADER *sptr_ip_header, CONNECTION_STATE *sptr_connection_state,
	TCP_HEADER *sptr_tcp_header);
static void process_special_d_encoding (IP_HEADER *sptr_ip_header, CONNECTION_STATE *sptr_connection_state,
	TCP_HEADER *sptr_tcp_header);
static void	process_normal_encoding (BYTE change_mask, TCP_HEADER *sptr_tcp_header, BYTE **ptr_to_bptr_compressed_header);
static void	process_packet_id_encoding (BYTE change_mask, IP_HEADER *sptr_ip_header, BYTE **ptr_to_bptr_compressed_header);
static void	align_header_on_4_byte_boundary (IP_PACKET *sptr_ip_packet, BYTE **ptr_to_bptr_compressed_header,
	USHORT *usptr_number_of_bytes, enum BOOLEAN *eptr_bad_header);
static void	copy_uncompressed_header_and_adjust_number_of_bytes (CONNECTION_STATE *sptr_connection_state,
	BYTE **ptr_to_bptr_compressed_header, USHORT *usptr_number_of_bytes, IP_HEADER *sptr_ip_header);
static void	recompute_ip_header_checksum (BYTE **ptr_to_bptr_compressed_header, USHORT header_length,
	IP_HEADER **ptr_to_sptr_new_ip_header);
/************************************************************************************/
IP_PACKET *vjc_uncompress_tcp_header (IP_PACKET *sptr_ip_packet, USHORT *usptr_number_of_bytes, BYTE type_of_packet,
	LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	BYTE *bptr;
	enum BOOLEAN bad_header;
	IP_PACKET *sptr_header_uncompressed_ip_packet;

	bad_header = FALSE;

	switch (type_of_packet)
		{
		case TYPE_IP_PACKET:

			++vjc.statistics.type_ip_packets_received;
			
			return (sptr_ip_packet);

		case TYPE_UNCOMPRESSED_TCP_PACKET:

			++vjc.statistics.type_tcp_uncompressed_packets_received;

#ifdef DEBUG
			print_uncompressed_header_in_packet (sptr_ip_packet, RECEIVE, FROM_LOWER_LEVEL);
#endif

			process_uncompressed_tcp_packet (&bad_header, sptr_ip_packet, sptr_line_compression_state);
			
			if (bad_header == TRUE)
				{
				process_bad_header_event (sptr_line_compression_state);

				return (NULL);
				}

#ifdef DEBUG
			print_uncompressed_header_in_packet (sptr_ip_packet, RECEIVE, TO_UPPER_LEVEL);
#endif

			return (sptr_ip_packet);

		case TYPE_COMPRESSED_TCP_PACKET:

#ifdef DEBUG
			print_compressed_header_in_packet (sptr_ip_packet, RECEIVE, FROM_LOWER_LEVEL,
				(USHORT) (*usptr_number_of_bytes - sizeof (UNION_MAC_HEADER)), sptr_line_compression_state);
#endif

			++vjc.statistics.type_tcp_compressed_packets_received;
			
			process_compressed_tcp_packet (&bad_header, sptr_ip_packet, usptr_number_of_bytes, sptr_line_compression_state, &bptr);

			if (bad_header == TRUE)
				{
				process_bad_header_event (sptr_line_compression_state);

				return (NULL);
				}

			sptr_header_uncompressed_ip_packet = (IP_PACKET *) bptr;

#ifdef DEBUG
			print_uncompressed_header_in_packet (sptr_header_uncompressed_ip_packet, RECEIVE, TO_UPPER_LEVEL);
#endif

			return (sptr_header_uncompressed_ip_packet);

		case TYPE_ERROR_PACKET:
		default:

			++vjc.statistics.type_error_packets_received;

			process_bad_header_event (sptr_line_compression_state);

			return (NULL);

		}
}
/************************************************************************************/
static void process_bad_header_event (LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	++vjc.statistics.bad_header_events;

	sptr_line_compression_state->valid_flag = FALSE;

	vjc_printf (VJC_ALARM_PRINTF, "VJC: RX: Bad header event\n");
}
/************************************************************************************/
static void process_uncompressed_tcp_packet (enum BOOLEAN *eptr_bad_header, IP_PACKET *sptr_ip_packet,
	LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CONNECTION_STATE *sptr_connection_state;
	IP_HEADER *sptr_ip_header;
	TCP_HEADER *sptr_tcp_header;
	USHORT header_length;
	USHORT index;

	/*
	 * Locate the saved state for this connection. If the state index is legal, clear the 'discard' flag.
	 */

	sptr_ip_header = &sptr_ip_packet->header;

	if (sptr_ip_header->protocol >= MAXIMUM_NUMBER_OF_CONNECTION_STATES)
		{
		*eptr_bad_header = TRUE;

		return;
		}

	sptr_line_compression_state->last_received_connection_identifier = sptr_ip_header->protocol;

	index = sptr_line_compression_state->last_received_connection_identifier;

	sptr_connection_state =	&sptr_line_compression_state->received_connection_states[index];

#ifdef DEBUG
	print_connection_state (sptr_connection_state->uncompressed_header, RECEIVE, OLD, sptr_connection_state);
#endif

	sptr_line_compression_state->valid_flag = TRUE;

	/*
	 * Restore the IP protocol field then save a copy of this packet header. (The checksum is zeroed in the copy so we
	 * don't have to zero it each time we process a compressed packet.
	 */

	sptr_ip_header->protocol = TCP_PROTOCOL;

	header_length = (USHORT) sptr_ip_header->version_header_length.header_length;

	sptr_tcp_header = get_pointer_to_tcp_header (sptr_ip_header);

	header_length += (USHORT) sptr_tcp_header->header_length_byte.header_length;

	header_length <<= WORD_LENGTH_TO_BYTE_LENGTH_CONVERSION;

	memcpy ((void *) &sptr_connection_state->uncompressed_header[0], (const void *) sptr_ip_header, header_length);

	sptr_ip_header = (IP_HEADER *) &sptr_connection_state->uncompressed_header[0];

	sptr_ip_header->header_checksum = 0x0000;

	sptr_connection_state->header_length = header_length;

#ifdef DEBUG
	print_connection_state (sptr_connection_state->uncompressed_header, RECEIVE, NEW, sptr_connection_state);
#endif
}
/************************************************************************************/
static void	process_compressed_tcp_packet (enum BOOLEAN *eptr_bad_header, IP_PACKET *sptr_ip_packet,
	USHORT *usptr_number_of_bytes, LINE_COMPRESSION_STATE *sptr_line_compression_state, BYTE **ptr_to_bptr_compressed_header)
{
	CONNECTION_STATE *sptr_connection_state;
	IP_HEADER *sptr_ip_header;
	IP_HEADER *sptr_new_ip_header;
	TCP_HEADER *sptr_tcp_header;
	USHORT header_length;
	BYTE change_mask;

	/* We've got a compressed packet. */

	set_byte_pointer_and_change_mask (sptr_ip_packet, ptr_to_bptr_compressed_header, &change_mask);

	if (check_for_valid_connection_identifier (change_mask, ptr_to_bptr_compressed_header, eptr_bad_header,
		sptr_line_compression_state) == FALSE)
		{
		*ptr_to_bptr_compressed_header = NULL;

		return;
		}
	
	get_connection_state_and_fill_in_tcp_checksum_and_push_bit (sptr_line_compression_state, &sptr_connection_state,
		&sptr_ip_header, &header_length, &sptr_tcp_header, ptr_to_bptr_compressed_header, change_mask);

	fix_up_connection_state_based_on_change_mask (change_mask, sptr_ip_header,	sptr_connection_state, sptr_tcp_header,
		ptr_to_bptr_compressed_header);
	
	align_header_on_4_byte_boundary (sptr_ip_packet, ptr_to_bptr_compressed_header, usptr_number_of_bytes, eptr_bad_header);

	if (*eptr_bad_header == TRUE)
		{
		return;
		}

	copy_uncompressed_header_and_adjust_number_of_bytes (sptr_connection_state, ptr_to_bptr_compressed_header,
		usptr_number_of_bytes, sptr_ip_header);

	recompute_ip_header_checksum (ptr_to_bptr_compressed_header, header_length, &sptr_new_ip_header);

	/* adjusting the byte pointer to point to the begining of IP_PACKET */

	*ptr_to_bptr_compressed_header -= sizeof (UNION_MAC_HEADER);
}
/************************************************************************************/
static void	set_byte_pointer_and_change_mask (IP_PACKET *sptr_ip_packet, BYTE **ptr_to_bptr_compressed_header,
	BYTE *bptr_change_mask)
{
	*ptr_to_bptr_compressed_header = (BYTE *) &sptr_ip_packet->header;

	*bptr_change_mask = **ptr_to_bptr_compressed_header;

	++(*ptr_to_bptr_compressed_header);
}
/************************************************************************************/
static enum BOOLEAN check_for_valid_connection_identifier (BYTE change_mask, BYTE **ptr_to_bptr_compressed_header,
	enum BOOLEAN *eptr_bad_header, LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	if ((change_mask & DELTA_CONNECTION_IDENTIFIER) != 0x00)
		{
		/*
		 * Make sure the state index is in range, then grab the state. If we have a good state index, clear the 'discard' flag.
		 */

		if (**ptr_to_bptr_compressed_header >= MAXIMUM_NUMBER_OF_CONNECTION_STATES)
			{
			*eptr_bad_header = TRUE;

			return (FALSE);
			}

		sptr_line_compression_state->valid_flag = TRUE;

		sptr_line_compression_state->last_received_connection_identifier = **ptr_to_bptr_compressed_header;

		++(*ptr_to_bptr_compressed_header);

		return (TRUE);
		}
	else
		{
		/*
		 * This packet has an implicit state index. If we've had a line error since the last time we got an explicit state
		 * index, we have to toss the packet.
		 */

		if (sptr_line_compression_state->valid_flag == FALSE)
			{
			return (FALSE);
			}

		return (TRUE);
		}
}
/************************************************************************************/
static void get_connection_state_and_fill_in_tcp_checksum_and_push_bit (LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CONNECTION_STATE **ptr_to_sptr_connection_state, IP_HEADER **ptr_to_sptr_ip_header, USHORT *usptr_header_length,
	TCP_HEADER **ptr_to_sptr_tcp_header, BYTE **ptr_to_bptr_compressed_header, BYTE change_mask)
{
	USHORT index;

	/*
 	 * Find the state then fill in the TCP checksum and PUSH bit.
 	 */

	index = sptr_line_compression_state->last_received_connection_identifier;

	*ptr_to_sptr_connection_state = &sptr_line_compression_state->received_connection_states[index];

#ifdef DEBUG
	print_connection_state ((*ptr_to_sptr_connection_state)->uncompressed_header, RECEIVE, OLD, *ptr_to_sptr_connection_state);
#endif

	*ptr_to_sptr_ip_header = (IP_HEADER *) ((*ptr_to_sptr_connection_state)->uncompressed_header);

	*usptr_header_length = (USHORT) ((*ptr_to_sptr_ip_header)->version_header_length.header_length <<
		WORD_LENGTH_TO_BYTE_LENGTH_CONVERSION);

	*ptr_to_sptr_tcp_header = get_pointer_to_tcp_header (*ptr_to_sptr_ip_header);

	(*ptr_to_sptr_tcp_header)->checksum =
		host_to_net_short ((USHORT) (((USHORT) **ptr_to_bptr_compressed_header << NUMBER_OF_BITS_IN_BYTE) |
		(*ptr_to_bptr_compressed_header)[1]));

	*ptr_to_bptr_compressed_header += sizeof (USHORT);

	if ((change_mask & DELTA_TCP_PUSH_BIT) != 0x00)
		{
		(*ptr_to_sptr_tcp_header)->flags.push_flag = TRUE;
		}
	else
		{
		(*ptr_to_sptr_tcp_header)->flags.push_flag = FALSE;
		}
}
/************************************************************************************/
static void	fix_up_connection_state_based_on_change_mask (BYTE change_mask, IP_HEADER *sptr_ip_header,
	CONNECTION_STATE *sptr_connection_state, TCP_HEADER *sptr_tcp_header, BYTE **ptr_to_bptr_compressed_header)
{
	/*
 	 * Fix up the state's ack, seq, urg and win fields based on the change_mask.
 	 */

	switch (change_mask & DELTA_SPECIALS_MASK)
		{
		case DELTA_SPECIAL_I:

#ifdef DEBUG
			vjc_printf (VJC_DECODE_PRINTF, "VJC: RX: Decoding SPECIAL_I coding\n");
#endif

			process_special_i_encoding (sptr_ip_header, sptr_connection_state, sptr_tcp_header);

			break;

		case DELTA_SPECIAL_D:

#ifdef DEBUG
			vjc_printf (VJC_DECODE_PRINTF, "VJC: RX: Decoding SPECIAL_D coding\n");
#endif

			process_special_d_encoding (sptr_ip_header, sptr_connection_state, sptr_tcp_header);

			break;

		default:

#ifdef DEBUG
			vjc_printf (VJC_DECODE_PRINTF, "VJC: RX: Decoding NORMAL coding\n");
#endif

			process_normal_encoding (change_mask, sptr_tcp_header, ptr_to_bptr_compressed_header);

			break;
		}

	process_packet_id_encoding (change_mask, sptr_ip_header, ptr_to_bptr_compressed_header);
}
/************************************************************************************/
static void process_special_i_encoding (IP_HEADER *sptr_ip_header, CONNECTION_STATE *sptr_connection_state,
	TCP_HEADER *sptr_tcp_header)
{
	USHORT delta;

	delta = (USHORT) (net_to_host_short (sptr_ip_header->total_length) - sptr_connection_state->header_length);

	sptr_tcp_header->acknowledgment_number =
		host_to_net_long ((ULONG) (net_to_host_long (sptr_tcp_header->acknowledgment_number) + delta));

	sptr_tcp_header->sequence_number =
		host_to_net_long ((ULONG) (net_to_host_long (sptr_tcp_header->sequence_number) + delta));
}
/************************************************************************************/
static void process_special_d_encoding (IP_HEADER *sptr_ip_header, CONNECTION_STATE *sptr_connection_state,
	TCP_HEADER *sptr_tcp_header)
{
	sptr_tcp_header->sequence_number =
		host_to_net_long (net_to_host_long (sptr_tcp_header->sequence_number) +
		net_to_host_short (sptr_ip_header->total_length) - sptr_connection_state->header_length);
}
/************************************************************************************/
static void	process_normal_encoding (BYTE change_mask, TCP_HEADER *sptr_tcp_header, BYTE **ptr_to_bptr_compressed_header)
{
	if ((change_mask & DELTA_URGENT_POINTER) != 0x00)
		{
		sptr_tcp_header->flags.urgent_flag = TRUE;

		decode_value (&sptr_tcp_header->urgent_pointer, ptr_to_bptr_compressed_header);
		}
	else
		{
		sptr_tcp_header->flags.urgent_flag = FALSE;
		}

	if ((change_mask & DELTA_WINDOW_SIZE) != 0x00)
		{
		decode_short (&sptr_tcp_header->window_size, ptr_to_bptr_compressed_header);
		}

	if ((change_mask & DELTA_ACKNOWLEDGMENT_NUMBER) != 0x00)
		{
		decode_long (&sptr_tcp_header->acknowledgment_number, ptr_to_bptr_compressed_header);
		}

	if ((change_mask & DELTA_SEQUENCE_NUMBER) != 0x00)
		{
		decode_long (&sptr_tcp_header->sequence_number, ptr_to_bptr_compressed_header);
		}
}
/************************************************************************************/
static void	process_packet_id_encoding (BYTE change_mask, IP_HEADER *sptr_ip_header, BYTE **ptr_to_bptr_compressed_header)
{
	/* Update the IP ID */

	if ((change_mask & DELTA_PACKET_ID) != 0x00)
		{
		decode_short (&sptr_ip_header->identifier, ptr_to_bptr_compressed_header);
		}
	else
		{
		sptr_ip_header->identifier =
			host_to_net_short ((USHORT) (net_to_host_short (sptr_ip_header->identifier) + 1));
		}
}
/************************************************************************************/
static void	align_header_on_4_byte_boundary (IP_PACKET *sptr_ip_packet, BYTE **ptr_to_bptr_compressed_header,
	USHORT *usptr_number_of_bytes, enum BOOLEAN *eptr_bad_header)
{
	BYTE *aligned_bptr;
	USHORT length;

	/*
 	 * At this point, bptr_compressed_header points to the first byte of data in the packet. If we're not aligned on a 4-byte
	 * boundary, copy the data down so the IP & TCP headers will be aligned.
	 */

	length = (USHORT) (*ptr_to_bptr_compressed_header - (BYTE *) &sptr_ip_packet->header);

	if (length > *usptr_number_of_bytes)
		{
		/* we must have dropped some characters (crc should detect this but the old slip framing won't */

		vjc_printf (VJC_ALARM_PRINTF, "VJC: RX: error in length %u,%p->%p\n", length, &sptr_ip_packet->header,
			*ptr_to_bptr_compressed_header); 

		*eptr_bad_header = TRUE;

		return;
		}
	else
		{
		*usptr_number_of_bytes -= length;
		}

	if (vjc.align_header_on_4_byte_boundary_enabled == TRUE)
		{
		if (((ULONG) *ptr_to_bptr_compressed_header & FOUR_BYTE_BOUNDARY_MASK) != 0x00000000L)
			{
			aligned_bptr = (BYTE *) ((ULONG) *ptr_to_bptr_compressed_header & ~(FOUR_BYTE_BOUNDARY_MASK));

			if (*usptr_number_of_bytes > 0x00000000L)
				{
				memmove ((void *) aligned_bptr, (const void *) *ptr_to_bptr_compressed_header, *usptr_number_of_bytes);
				}

#ifdef DEBUG
			vjc_printf (VJC_PRINTF, "VJC: RX: headers aligned by %u bytes\n", (USHORT) ((ULONG) *ptr_to_bptr_compressed_header &
				FOUR_BYTE_BOUNDARY_MASK));
#endif

			*ptr_to_bptr_compressed_header = aligned_bptr;
			}
		}
}
/************************************************************************************/
static void	copy_uncompressed_header_and_adjust_number_of_bytes (CONNECTION_STATE *sptr_connection_state,
	BYTE **ptr_to_bptr_compressed_header, USHORT *usptr_number_of_bytes, IP_HEADER *sptr_ip_header)
{
	/*
	 * Then back up bptr_compressed_header by the TCP/IP header length to make room for the reconstructed header (we assume	the
	 * packet we were handed has enough space to prepend 128 bytes of header). Adjust the number_of_bytes to account for the new
	 * header & fill in the IP total length.
 	 */

	*ptr_to_bptr_compressed_header -= sptr_connection_state->header_length;

	*usptr_number_of_bytes += sptr_connection_state->header_length;

	/* sizeof (UNION_MAC_HEADER) is subtracted from number_of_bytes */

	sptr_ip_header->total_length = host_to_net_short ((USHORT) (*usptr_number_of_bytes - sizeof (UNION_MAC_HEADER)));

#ifdef DEBUG
	print_connection_state (sptr_connection_state->uncompressed_header, RECEIVE, NEW, sptr_connection_state);
#endif

	memcpy ((void *) *ptr_to_bptr_compressed_header, (const void *) sptr_connection_state->uncompressed_header,
		sptr_connection_state->header_length);
}
/************************************************************************************/
static void	recompute_ip_header_checksum (BYTE **ptr_to_bptr_compressed_header, USHORT header_length,
	IP_HEADER **ptr_to_sptr_new_ip_header)
{
	ULONG checksum;
	USHORT *usptr_header;

	/* recompute the ip header checksum */
	usptr_header = (USHORT *) *ptr_to_bptr_compressed_header;

	for (checksum = 0x00000000L; header_length > 0x0000;)
		{
		checksum += *usptr_header;

		++usptr_header;

		header_length = (USHORT) (header_length - sizeof (USHORT));
		}

	checksum = (checksum & CHECKSUM_MASK) + (checksum >> NUMBER_OF_BITS_IN_USHORT);

	checksum = (checksum & CHECKSUM_MASK) + (checksum >> NUMBER_OF_BITS_IN_USHORT);

	if (checksum > MAXIMUM_USHORT_VALUE)
		{
		vjc_printf (VJC_CHECKSUM_PRINTF, "VJC: checksum error : %x\n", checksum);
		}

	*ptr_to_sptr_new_ip_header = (IP_HEADER *) *ptr_to_bptr_compressed_header;

	(*ptr_to_sptr_new_ip_header)->header_checksum = (USHORT) (~checksum);
}

