/*	$Modname: vjctxen.c$  $version: 1.3$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/25/94 titus
1.2 08/26/94 titus Add Copyright
1.3 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "vjc.h"
/************************************************************************************/
static enum BOOLEAN check_if_tcp_urgent_flag_set (TCP_HEADER *sptr_tcp_header, USHORT *usptr_delta_urgent_pointer);
static enum BOOLEAN check_if_urgent_pointer_changed (TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header);
static enum BOOLEAN check_if_window_size_changed (TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header,
	USHORT *usptr_delta_window_size);
static enum BOOLEAN check_if_acknowledgment_number_changed (TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header,
	ULONG *ulptr_delta_acknowledgment_number);
static enum BOOLEAN check_if_sequence_number_changed (TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header,
	ULONG *ulptr_delta_sequence_number);
static void	process_special_case_for_echoed_terminal_traffic (ULONG delta_sequence_number, ULONG delta_acknowledgment_number,
	IP_HEADER *sptr_old_ip_header, USHORT header_length, BYTE *bptr_change_mask, BYTE **ptr_to_bptr_compressed_header,
	BYTE *compressed_header);
static void	process_special_case_for_data_transfer (ULONG delta_sequence_number, IP_HEADER *sptr_old_ip_header,
	USHORT header_length, BYTE *bptr_change_mask, BYTE **ptr_to_bptr_compressed_header, BYTE *compressed_header);
/************************************************************************************/
void figure_out_which_of_the_fields_changed (BYTE *bptr_change_mask, enum BOOLEAN *eptr_send_uncompressed,
	TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header, ULONG *ulptr_delta_sequence_number,
	ULONG *ulptr_delta_acknowledgment_number, BYTE **ptr_to_bptr_compressed_header)
{
	USHORT delta_urgent_pointer;
	USHORT delta_window_size;

	if (check_if_tcp_urgent_flag_set (sptr_tcp_header, &delta_urgent_pointer) == TRUE)
		{
		encode_possibly_zero_delta (URGENT_POINTER, bptr_change_mask, delta_urgent_pointer, ptr_to_bptr_compressed_header);
		}
	else
		{
		if (check_if_urgent_pointer_changed (sptr_tcp_header, sptr_old_tcp_header) == TRUE)
			{
			/*
			 * argh! URG not set but urp changed -- a sensible implementation should never do this but RFC793 doesn't
			 * prohibit the change so we have to deal with it.
			 */
			*eptr_send_uncompressed = TRUE;

			return;
 			}
 		}

	if (check_if_window_size_changed (sptr_tcp_header, sptr_old_tcp_header, &delta_window_size) == TRUE)
		{
		encode_non_zero_delta (WINDOW_SIZE, bptr_change_mask, delta_window_size, ptr_to_bptr_compressed_header);
		}

	if (check_if_acknowledgment_number_changed (sptr_tcp_header, sptr_old_tcp_header, ulptr_delta_acknowledgment_number)	== TRUE)
		{
		if (*ulptr_delta_acknowledgment_number > MAXIMUM_USHORT_VALUE)
			{
			*eptr_send_uncompressed = TRUE;
			}
		else
			{
			encode_non_zero_delta (ACKNOWLEDGMENT_NUMBER, bptr_change_mask, (USHORT) *ulptr_delta_acknowledgment_number,
				ptr_to_bptr_compressed_header);
			}
		}

	if (check_if_sequence_number_changed (sptr_tcp_header, sptr_old_tcp_header, ulptr_delta_sequence_number) == TRUE)
		{
		if (*ulptr_delta_sequence_number > MAXIMUM_USHORT_VALUE)
			{
			*eptr_send_uncompressed = TRUE;
			}
		else
			{
			encode_non_zero_delta (SEQUENCE_NUMBER, bptr_change_mask, (USHORT) *ulptr_delta_sequence_number,
				ptr_to_bptr_compressed_header);
			}
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_tcp_urgent_flag_set (TCP_HEADER *sptr_tcp_header, USHORT *usptr_delta_urgent_pointer)
{
	*usptr_delta_urgent_pointer = net_to_host_short (sptr_tcp_header->urgent_pointer);

	if (sptr_tcp_header->flags.urgent_flag == TRUE)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_urgent_pointer_changed (TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header)
{
	if (sptr_tcp_header->urgent_pointer != sptr_old_tcp_header->urgent_pointer)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_window_size_changed (TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header,
	USHORT *usptr_delta_window_size)
{
	*usptr_delta_window_size = (USHORT) (net_to_host_short (sptr_tcp_header->window_size) -
		net_to_host_short (sptr_old_tcp_header->window_size));

	if (*usptr_delta_window_size != 0x0000)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_acknowledgment_number_changed (TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header,
	ULONG *ulptr_delta_acknowledgment_number)
{
	*ulptr_delta_acknowledgment_number = net_to_host_long (sptr_tcp_header->acknowledgment_number) -
		net_to_host_long (sptr_old_tcp_header->acknowledgment_number);

	if (*ulptr_delta_acknowledgment_number != 0x00000000L)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_sequence_number_changed (TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header,
	ULONG *ulptr_delta_sequence_number)
{
	*ulptr_delta_sequence_number = net_to_host_long (sptr_tcp_header->sequence_number) -
		net_to_host_long (sptr_old_tcp_header->sequence_number);

	if (*ulptr_delta_sequence_number != 0x00000000L)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
void look_for_special_case_encodings (BYTE *bptr_change_mask, enum BOOLEAN *eptr_send_uncompressed, USHORT header_length,
	IP_HEADER *sptr_ip_header,	IP_HEADER *sptr_old_ip_header, ULONG delta_sequence_number,
	ULONG delta_acknowledgment_number, BYTE **ptr_to_bptr_compressed_header, BYTE *compressed_header)
{
	switch (*bptr_change_mask)
		{
		case DELTA_NO_CHANGES:

			/*
			 * Nothing changed. If this packet contains data and the last one didn't, this is probably a data packet following an
			 * ack (normal on an interactive connection) and we send it compressed. Otherwise it's probably a retransmit,
			 * retransmitted ack or window probe. Send it uncompressed in case the other side missed the compressed version.
			 */

			if ((sptr_ip_header->total_length != sptr_old_ip_header->total_length) &&
				(net_to_host_short (sptr_old_ip_header->total_length) == header_length))
				{
				break;
				}

			/* else (fall through) */

		case DELTA_SPECIAL_I:
		case DELTA_SPECIAL_D:

			/*
			 * Actual changes match one of our special case encodings -- send packet uncompressed.
			 */

			*eptr_send_uncompressed = TRUE;

			break;

		case (DELTA_SPECIAL_T):

			process_special_case_for_echoed_terminal_traffic (delta_sequence_number, delta_acknowledgment_number,
				sptr_old_ip_header, header_length, bptr_change_mask, ptr_to_bptr_compressed_header, compressed_header);

			break;

		case DELTA_SEQUENCE_NUMBER:

			process_special_case_for_data_transfer (delta_sequence_number, sptr_old_ip_header,
				header_length, bptr_change_mask, ptr_to_bptr_compressed_header, compressed_header);

			break;

		default:

			break;
		}
}
/************************************************************************************/
static void	process_special_case_for_echoed_terminal_traffic (ULONG delta_sequence_number, ULONG delta_acknowledgment_number,
	IP_HEADER *sptr_old_ip_header, USHORT header_length, BYTE *bptr_change_mask, BYTE **ptr_to_bptr_compressed_header,
	BYTE *compressed_header)
{
	if ((delta_sequence_number == delta_acknowledgment_number) && (delta_sequence_number ==
		(net_to_host_short (sptr_old_ip_header->total_length) - header_length)))
		{
		/* special case for echoed terminal traffic */

		*bptr_change_mask = DELTA_SPECIAL_I;

		*ptr_to_bptr_compressed_header = compressed_header;
		}
}
/************************************************************************************/
static void	process_special_case_for_data_transfer (ULONG delta_sequence_number, IP_HEADER *sptr_old_ip_header,
	USHORT header_length, BYTE *bptr_change_mask, BYTE **ptr_to_bptr_compressed_header, BYTE *compressed_header)
{
	if (delta_sequence_number == (net_to_host_short (sptr_old_ip_header->total_length) - header_length))
		{
		/* special case for data xfer */

		*bptr_change_mask = DELTA_SPECIAL_D;

		*ptr_to_bptr_compressed_header = compressed_header;
		}
}
/************************************************************************************/
void check_for_change_in_packet_identifier_or_whether_tcp_push_flag_is_set (BYTE *bptr_change_mask,
	IP_HEADER *sptr_ip_header,	IP_HEADER *sptr_old_ip_header, TCP_HEADER *sptr_tcp_header, BYTE **ptr_to_bptr_compressed_header)
{
	USHORT delta_identifier;

	delta_identifier = (USHORT) (net_to_host_short (sptr_ip_header->identifier) -
		net_to_host_short (sptr_old_ip_header->identifier));

	if (delta_identifier != 0x0001)
		{																			 
		encode_possibly_zero_delta (PACKET_ID, bptr_change_mask, delta_identifier, ptr_to_bptr_compressed_header);
		}

	if (sptr_tcp_header->flags.push_flag == TRUE)
		{
		*bptr_change_mask = *bptr_change_mask | DELTA_TCP_PUSH_BIT;
		}
}
/************************************************************************************/
void update_connection_state_with_new_header (USHORT *usptr_checksum, CONNECTION_STATE *sptr_connection_state,
	TCP_HEADER *sptr_tcp_header, IP_HEADER *sptr_ip_header, USHORT header_length)
{
	/*
 	 * Grab the cksum before we overwrite it later. Then update our state with this packet's header.
 	 */

	*usptr_checksum = net_to_host_short (sptr_tcp_header->checksum);

#ifdef DEBUG
	vjc_printf (VJC_CHECKSUM_PRINTF, "VJC: checksum %x->%x\n", sptr_tcp_header->checksum, *usptr_checksum);
#endif

	memset ((void *) &sptr_connection_state->uncompressed_header[0], 0x00, MAXIMUM_HEADER_LENGTH);

	memcpy ((void *) &sptr_connection_state->uncompressed_header[0], (const void *) sptr_ip_header, header_length);
}
/************************************************************************************/
void send_uncompressed_packet (LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CONNECTION_STATE *sptr_connection_state, IP_HEADER *sptr_ip_header, USHORT header_length, IP_PACKET *sptr_ip_packet)
{
	/*
 	 * Update connection state & send uncompressed packet ('uncompressed' means a regular ip/tcp packet but with
	 * the 'conversation id' we hope to use on future compressed packets in the protocol field).
 	 */

	memset ((void *) &sptr_connection_state->uncompressed_header[0], 0x00, MAXIMUM_HEADER_LENGTH);

	memcpy ((void *) &sptr_connection_state->uncompressed_header[0], (const void *) sptr_ip_header, header_length);

	sptr_ip_header->protocol = sptr_connection_state->connection_identifier;

	sptr_line_compression_state->last_transmitted_connection_identifier = sptr_connection_state->connection_identifier;

#ifdef DEBUG
	print_connection_state (sptr_connection_state->uncompressed_header, TRANSMIT, NEW, sptr_connection_state);

	print_uncompressed_header_in_packet (sptr_ip_packet, TRANSMIT, TO_LOWER_LEVEL);
#endif

	++vjc.statistics.type_tcp_uncompressed_packets_transmitted;
}
/************************************************************************************/
void insert_compressed_header_into_original_packet_in_place_of_old_header (IP_PACKET **ptr_to_sptr_ip_packet,
	LINE_COMPRESSION_STATE *sptr_line_compression_state, CONNECTION_STATE *sptr_connection_state, BYTE change_mask,
	USHORT header_length, USHORT checksum,	BYTE **ptr_to_bptr_compressed_header, BYTE *compressed_header,
	IP_HEADER *sptr_ip_header, USHORT *usptr_number_of_bytes)
{
	USHORT length;
	USHORT length_of_minimum_compressed_header;
	BYTE *bptr_packet_data;
	VJC_PORT_CLASS *sptr_port_class;

	/*
 	 * We want to use the original packet as our compressed packet. (bptr_compressed_header - compressed_header) is the number of
	 * bytes we need for compressed sequence numbers. In addition we need one byte for the change mask, one for the connection id
	 * (if the connection_id compression is disabled) and two for the TCP checksum. So,
	 * (bptr_compressed_header - compressed_header) + 4 (or + 3 if the connection_id compression is enabled and there is no change
	 * from the last transmitted connection identifier) bytes of header are needed. header_length is the number bytes of the
	 * original packet to toss and so subtract the two to get the new packet size.
 	 */

	length = (USHORT) (*ptr_to_bptr_compressed_header - compressed_header);

	bptr_packet_data = (BYTE *) sptr_ip_header;

	sptr_port_class = get_pointer_to_port_class_for_the_specified_line_compression_state (sptr_line_compression_state);

	if ((sptr_port_class->connection_id_compression_enabled == FALSE) ||
		(sptr_line_compression_state->last_transmitted_connection_identifier !=	sptr_connection_state->connection_identifier))
		{
		sptr_line_compression_state->last_transmitted_connection_identifier = sptr_connection_state->connection_identifier;

		length_of_minimum_compressed_header = MINIMUM_COMPRESSED_HEADER_WITH_CONNECTION_IDENTIFIER;

		header_length -= (USHORT) (length + MINIMUM_COMPRESSED_HEADER_WITH_CONNECTION_IDENTIFIER);

		bptr_packet_data += header_length;

		*bptr_packet_data = (BYTE) (change_mask | DELTA_CONNECTION_IDENTIFIER);

		++bptr_packet_data;

		*bptr_packet_data = sptr_connection_state->connection_identifier;

		++bptr_packet_data;
		}
	else
		{
		length_of_minimum_compressed_header = MINIMUM_COMPRESSED_HEADER_WITHOUT_CONNECTION_IDENTIFIER;

		header_length -= (USHORT) (length + MINIMUM_COMPRESSED_HEADER_WITHOUT_CONNECTION_IDENTIFIER);

		bptr_packet_data += header_length;

		*bptr_packet_data = change_mask;

		++bptr_packet_data;
		}

	*bptr_packet_data = (BYTE) (checksum >> NUMBER_OF_BITS_IN_BYTE);

	++bptr_packet_data;

	*bptr_packet_data = checksum;

	++bptr_packet_data;

	memcpy ((void *) bptr_packet_data, (const void *) compressed_header, length);

	*usptr_number_of_bytes -= header_length;

	*ptr_to_sptr_ip_packet = (IP_PACKET *) (bptr_packet_data - sizeof (UNION_MAC_HEADER) -
		length_of_minimum_compressed_header);
}
/************************************************************************************/
VJC_PORT_CLASS *get_pointer_to_port_class_for_the_specified_line_compression_state (LINE_COMPRESSION_STATE
	*sptr_line_compression_state)
{
	VJC_PORT_CLASS *sptr_port_class;

	sptr_port_class = (VJC_PORT_CLASS *) ((ULONG) sptr_line_compression_state - (2 * sizeof (enum BOOLEAN)));

	return (sptr_port_class);
}

