/*	$Modname: vjcutil.c$  $version: 1.2$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/26/94 titus Add Copyright
1.2 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "vjc.h"
/************************************************************************************/
static void encode (USHORT delta, BYTE **ptr_to_bptr_compressed_header);
static void encodez (USHORT delta, BYTE **ptr_to_bptr_compressed_header);
/************************************************************************************/
/*
 * The following routines are used to encode and decode numbers. They all assume that `ptr_to_bptr_compressed_header' is a
 * pointer to a byte pointer which points to a compressed_header where the next byte encoded (decoded) is to be
 * stored (retrieved). Since the decode routines do arithmetic, they have to convert from and to network byte order.
 */
/************************************************************************************/
void encode_possibly_zero_delta (enum VJC_FIELD_TYPE field_type, BYTE *bptr_change_mask, USHORT delta,
	BYTE **ptr_to_bptr_compressed_header)
{
	switch (field_type)
		{
		case URGENT_POINTER:

			encodez (delta, ptr_to_bptr_compressed_header);

			*bptr_change_mask = *bptr_change_mask | DELTA_URGENT_POINTER;

			break;

		case PACKET_ID:

			encodez (delta, ptr_to_bptr_compressed_header);

			*bptr_change_mask = *bptr_change_mask | DELTA_PACKET_ID;

			break;

		default:

			vjc_printf (VJC_ENCODE_PRINTF, "VJC: Invalid field type %u", field_type);

			break;
		}

	return;
}
/************************************************************************************/
void encode_non_zero_delta (enum VJC_FIELD_TYPE field_type, BYTE *bptr_change_mask, USHORT delta,
	BYTE **ptr_to_bptr_compressed_header)
{
	switch (field_type)
		{
		case WINDOW_SIZE:

			encode (delta, ptr_to_bptr_compressed_header);

			*bptr_change_mask = *bptr_change_mask | DELTA_WINDOW_SIZE;

			break;

		case ACKNOWLEDGMENT_NUMBER:

			encode (delta, ptr_to_bptr_compressed_header);

			*bptr_change_mask = *bptr_change_mask | DELTA_ACKNOWLEDGMENT_NUMBER;

			break;

		case SEQUENCE_NUMBER:

			encode (delta, ptr_to_bptr_compressed_header);

			*bptr_change_mask = *bptr_change_mask | DELTA_SEQUENCE_NUMBER;

			break;

		default:

			vjc_printf (VJC_ENCODE_PRINTF, "VJC: Invalid field type %u", field_type);

			break;
		}

	return;
}
/************************************************************************************/
void decode_long (ULONG *ulptr_field, BYTE **ptr_to_bptr_compressed_header)
{
	/*
	 * decode_long routine takes the (compressed) change at the byte pointed to by *ptr_to_bptr_compressed_header and adds it
	 * to the current value pointed to by ulptr_field (which must be a 4-byte (long) integer in network byte order).
	 * 'ptr_to_bptr_compressed_header' is updated to point to the next field in the compressed header.
	 */

	if (**ptr_to_bptr_compressed_header == 0x00)
		{
		*ulptr_field = (ULONG) (host_to_net_long ((ULONG) (net_to_host_long (*ulptr_field) +
			(((*ptr_to_bptr_compressed_header)[1] << NUMBER_OF_BITS_IN_BYTE) | (*ptr_to_bptr_compressed_header)[2]))));

		(*ptr_to_bptr_compressed_header) += ENCODED_SIZEOF_USHORT;
		}
	else
		{
		*ulptr_field = host_to_net_long ((ULONG) (net_to_host_long (*ulptr_field) + **ptr_to_bptr_compressed_header));

		++(*ptr_to_bptr_compressed_header);
		}

	return;
}
/************************************************************************************/
void decode_short (USHORT *usptr_field, BYTE **ptr_to_bptr_compressed_header)
{
	/*
	 * decode_short routine takes the (compressed) change at the byte pointed to by *ptr_to_bptr_compressed_header and adds it
	 * to the current value pointed to by usptr_field (which must be a 2-byte (short) integer in network byte order).
	 * 'ptr_to_bptr_compressed_header' is updated to point to the next field in the compressed header.
	 */

	if (**ptr_to_bptr_compressed_header == 0x00)
		{
		*usptr_field = host_to_net_short ((USHORT) (net_to_host_short (*usptr_field) +
			(((*ptr_to_bptr_compressed_header)[1] << NUMBER_OF_BITS_IN_BYTE) | (*ptr_to_bptr_compressed_header)[2])));

		(*ptr_to_bptr_compressed_header) += ENCODED_SIZEOF_USHORT;
		}
	else
		{
		*usptr_field = host_to_net_short ((USHORT) (net_to_host_short (*usptr_field) + **ptr_to_bptr_compressed_header));

		++(*ptr_to_bptr_compressed_header);
		}

	return;
}
/************************************************************************************/
void decode_value (USHORT *usptr_field, BYTE **ptr_to_bptr_compressed_header)
{
	/*
	 * decode_value routine takes the 2-byte (short) value at the two successive bytes pointed to by
	 * *ptr_to_bptr_compressed_header and stuffs it into the location pointed to by usptr_field (which must be a 2-byte (short)
	 * integer in network byte order).
	 *	'ptr_to_bptr_compressed_header' is updated to point to the next field in the compressed header.
	 */

	if (**ptr_to_bptr_compressed_header == 0x00)
		{
		*usptr_field = host_to_net_short ((USHORT) (((*ptr_to_bptr_compressed_header)[1] << NUMBER_OF_BITS_IN_BYTE) |
			(*ptr_to_bptr_compressed_header)[2]));

		(*ptr_to_bptr_compressed_header) += ENCODED_SIZEOF_USHORT;

		}
	else
		{
		*usptr_field = host_to_net_short (**ptr_to_bptr_compressed_header);

		++(*ptr_to_bptr_compressed_header);
		}

	return;
}
/************************************************************************************/
static void encode (USHORT delta, BYTE **ptr_to_bptr_compressed_header)
{
	/* The encode routine encodes a number that is known to be non-zero. */

	if (delta >= 0x0100)
		{
		**ptr_to_bptr_compressed_header = 0x00;

		++(*ptr_to_bptr_compressed_header);

		(*ptr_to_bptr_compressed_header)[1] = (BYTE) delta;

		(*ptr_to_bptr_compressed_header)[0] = (BYTE) (delta >> NUMBER_OF_BITS_IN_BYTE);

		(*ptr_to_bptr_compressed_header) += sizeof (USHORT);
		}
	else
		{
		**ptr_to_bptr_compressed_header = (BYTE) delta;

		++(*ptr_to_bptr_compressed_header);
		}

	return;
}
/************************************************************************************/
static void encodez (USHORT delta, BYTE **ptr_to_bptr_compressed_header)
{
	/* The encodez checks for zero (zero has to be encoded in the long, 3 byte form). */

	if ((delta >= 0x0100) || (delta == 0x0000))
		{
		**ptr_to_bptr_compressed_header = 0x00;

		++(*ptr_to_bptr_compressed_header);

		(*ptr_to_bptr_compressed_header)[1] = (BYTE) delta;

		(*ptr_to_bptr_compressed_header)[0] = (BYTE) (delta >> NUMBER_OF_BITS_IN_BYTE);

		(*ptr_to_bptr_compressed_header) += sizeof (USHORT);
		}
	else
		{
		**ptr_to_bptr_compressed_header = (BYTE) delta;

		++(*ptr_to_bptr_compressed_header);
		}

	return;
}
#ifndef __LSL__
	/************************************************************************************/
	USHORT host_to_net_short (USHORT host_order_short_value)
	{
	#ifdef BIG_ENDIAN

		return (host_order_short_value);

	#else

		BYTE *bptr_return_value;
		USHORT net_order_value;

		bptr_return_value = (BYTE *) &net_order_value;

		*bptr_return_value = (BYTE) (host_order_short_value >> NUMBER_OF_BITS_IN_BYTE);

		++bptr_return_value;

		*bptr_return_value = (BYTE) host_order_short_value;

		return (net_order_value);

	#endif
	}
	/************************************************************************************/
	USHORT net_to_host_short (USHORT net_order_short_value)
	{
	#ifdef BIG_ENDIAN

		return (net_order_short_value);

	#else

		USHORT host_order_value;
		BYTE *bptr_net_order_value;

		bptr_net_order_value = (BYTE *) &net_order_short_value;

		host_order_value = *bptr_net_order_value;

		++bptr_net_order_value;

		host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

		host_order_value = (USHORT) (host_order_value | *bptr_net_order_value);

		return (host_order_value);

	#endif
	}											
	/************************************************************************************/
	ULONG host_to_net_long (ULONG host_order_long_value)
	{
	#ifdef BIG_ENDIAN

		return (host_order_long_value);

	#else

		BYTE *bptr_net_order_value;
		BYTE *bptr_host_order_long_value;
		ULONG net_order_value;

		bptr_net_order_value = (BYTE *) &net_order_value + (sizeof (ULONG) - 1);

		bptr_host_order_long_value = (BYTE *) &host_order_long_value;

		*bptr_net_order_value = *bptr_host_order_long_value;

		--bptr_net_order_value;

		++bptr_host_order_long_value;
	
		*bptr_net_order_value = *bptr_host_order_long_value;

		--bptr_net_order_value;

		++bptr_host_order_long_value;
	
		*bptr_net_order_value = *bptr_host_order_long_value;

		--bptr_net_order_value;

		++bptr_host_order_long_value;
	
		*bptr_net_order_value = *bptr_host_order_long_value;

		return (net_order_value);

	#endif
	}
	/************************************************************************************/
	ULONG net_to_host_long (ULONG net_order_long_value)
	{
	#ifdef BIG_ENDIAN

		return (net_order_long_value);

	#else

		ULONG host_order_value;
		BYTE *bptr_net_order_long_value;

		bptr_net_order_long_value = (BYTE *) &net_order_long_value;

		host_order_value = *bptr_net_order_long_value;

		++bptr_net_order_long_value;

		host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

		host_order_value = host_order_value | *bptr_net_order_long_value;

		++bptr_net_order_long_value;

		host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

		host_order_value = host_order_value | *bptr_net_order_long_value;

		++bptr_net_order_long_value;

		host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

		host_order_value = host_order_value | *bptr_net_order_long_value;

		return (host_order_value);

	#endif
	}
#endif /* __LSL__ */

