/****************************************************************************/
/* 
	This file contains the init routines of ethernet. initialize_ethernet_cont-
	roller() is called from main. This function is put in \rtrware\store\vrtrwstr
	.h file in the device drivers structure. initialize_routerware_software
	function calls this. we just register with lsl with all the entry points
	for tx, rx, timer and control. presently control function is not being used
	as we have no use of this presently.
*/
/****************************************************************************/

#include	"defs.h"
#include	<stdarg.h>
#include	"ethernet.h"

enum TEST ethernet_control (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);

static void 
	initialize_ethernet_tx_descriptors (void);
static void 
	initialize_ethernet_rx_descriptors (USHORT buffer_size);
extern	void ethernet_init(ULONG localio,void *);	

ETHERNET_CLASS		ethernet;
ULONG	EthRxError;
ULONG EthTxError;
ULONG	NetRcvOverFlow;

ETHERNET_ADDRESS ether_address;

/****************************************************************************/
/*
	This is called from main. Registering with lsl , initialization of Rx & Tx
	descriptors are done from here.
*/
/****************************************************************************/
enum TEST initialize_ethernet_controller(ULONG clock_ticks_per_second)
{
	USHORT buffer_size = 1520;
	PARAMETER_NOT_USED (clock_ticks_per_second);

		if(!(lsl_control (REGISTER_LOW_LEVEL_DEVICE_DRIVER,"Ethernet Driver",
		ETHERNET_DEVICE_DRIVER,
		(enum TEST (*) (ULONG protocol_stack_id,USHORT port_number, 
				USHORT virtual_port_number, void *sptr_tx_buffer,
				USHORT number_of_bytes,	enum BOOLEAN bridged_packet, 
				enum BOOLEAN protocol_packet,
				void (*fptr_tx_completion) (USHORT port_number, 
					void *sptr_ethernet_buffer))) send_ethernet_packet,
		(void (*) (USHORT port_number)) ethernet_packet_transmitted,
		(enum BOOLEAN (*) (USHORT port_number, void **vptr_buffer, 
				USHORT *usptr_number_of_bytes_rxed)) ethernet_packet_received,
		NULL,
	   	(enum TEST (*) (enum DEVICE_CONTROL_OPERATION command, 
				ULONG parameter_0, ULONG parameter_1)) ethernet_control,
		(void (*) (USHORT port_number,void *vptr_buffer) )
				ethernet_return_buffer_to_device_driver,
		&ethernet.port.device_driver_id)) ){
			printf("\n\r ETHERNET INIT FAILED \n\r");
			return(FAIL);
		}
		lsl_control (DEVICE_DRIVER_GET_MAC_ADDRESS,ETHERNET_PORT_NUMBER,&ether_address);
/* add all the buffers descriptors to freelist suitably */
	initialize_ethernet_tx_descriptors();
	buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, ETHERNET_PORT_NUMBER);
	initialize_ethernet_rx_descriptors(buffer_size);
#ifdef DEBUG
	printf ("AUI=%d, LocalIO=%x\n\r", ethernet.port.port_is_AUI,
				ethernet.port.ethernet_local_io_value);
#endif
	if (ethernet.port.ethernet_local_io_value == 0) {
		if (ethernet.port.port_is_AUI) {
/*			printf("Ethernet Port inited for AUI\n\r");*/
			ethernet_init(0x31,&ether_address);			/* Works for AUI */
		} else {
/*			printf("Ethernet Port inited for UTP\n\r");*/
			ethernet_init(0xE7,&ether_address);		/* works for UTP, errors on AUI */
		}
	} else {
/*			printf("Ethernet Port inited for LocalIO= 0%x\n\r",*/
/*										ethernet.port.ethernet_local_io_value);*/
			ethernet_init(ethernet.port.ethernet_local_io_value,&ether_address);	
	}
	return(PASS);
}
/****************************************************************************/
/*	initialize_ethernet_tx_descriptors.
	In ethernet port class we have declared ETHERNET_TX_DESCRIPTORS which is 
	defined in nvethstr.h. 
	All the tx descriptors are added to free_tx_list.
*/
/****************************************************************************/
static void 
	initialize_ethernet_tx_descriptors ()
{
	USHORT number_of_tx_descriptors;

	for (number_of_tx_descriptors = 0; number_of_tx_descriptors < NUMBER_OF_ETHERNET_TX_BUFFERS; ++number_of_tx_descriptors)

		{
		ethernet.port.tx_descriptor[number_of_tx_descriptors].in_use = FALSE;
		ethernet.port.tx_descriptor[number_of_tx_descriptors].device_driver_buffer = FALSE;
		ethernet.port.tx_descriptor[number_of_tx_descriptors].sptr_tx_packet = NULL;
		ethernet.port.tx_descriptor[number_of_tx_descriptors].fptr_tx_complete = NULL;

		add_entry_to_list (&ethernet.port.free_tx_list,
		   &ethernet.port.tx_descriptor[number_of_tx_descriptors].links);
		}
}

/****************************************************************************/
/*
	initialize_ethernet_rx_descriptors
	All the rx descriptors are added to free_rx_list if a free buffer is found
	otherwise they are added to rx_descriptor_need_buffer_list.
*/
/****************************************************************************/
static void 
	initialize_ethernet_rx_descriptors (USHORT buffer_size)
{
	USHORT number_of_rx_descriptors;

	for (number_of_rx_descriptors = 0; number_of_rx_descriptors < NUMBER_OF_ETHERNET_RX_BUFFERS; ++number_of_rx_descriptors)
		{
		ethernet.port.rx_descriptor[number_of_rx_descriptors].buffer_size = buffer_size;
		ethernet.port.rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer =
		(ETHERNET_BUFFER *)	device_driver_malloc (ETHERNET_PORT_NUMBER, ethernet.port.device_driver_id, (USHORT) NULL);

#ifdef DEBUG
		printf("\n\r for ethernet %d buffer  %p",number_of_rx_descriptors,ethernet.port.rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer);
#endif
		ethernet.port.rx_descriptor[number_of_rx_descriptors].number_of_bytes_rxed = 0x0000;

		if(ethernet.port.rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer == NULL )
		add_entry_to_list (&ethernet.port.rx_descriptor_need_buffer_list,
			&ethernet.port.rx_descriptor[number_of_rx_descriptors].links);
	else
		add_entry_to_list (&ethernet.port.free_rx_list,
			&ethernet.port.rx_descriptor[number_of_rx_descriptors].links);
		}

}

/****************************************************************************/
/*  ethernet_control 
	presently not supported 
*/
/****************************************************************************/
enum TEST ethernet_control (enum DEVICE_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
}

/****************************************************************************/
/*
	ether_printf
	presently calls the actual printf library routine. The first argument is 
	to be made an int. So that if it is more than the DEBUG_VALUE printf(..)
	is called otherwise it will just return.
*/
/****************************************************************************/
void ether_printf (const char *cptr_format, ...)
{
	va_list argptr;
	va_start (argptr,cptr_format);

	printf (cptr_format,argptr);

	va_end (argptr);
}
