#include	"defs.h"
/*	$Modname: annexdtx.c$  $version: 1.16$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 01/02/93 ross
1.1 01/02/93 ross
1.2 01/10/93 ross changing to symmetric dlci's - IBM way
1.3 01/17/93 ross added function to store ipx dlci
1.4 02/11/93 ross changes for annex d.
1.5 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.6 02/01/94 ross added cast to transmit.
1.7 03/01/94 ross testing with cisco frame relay and pacific bell.
1.8 03/19/94 ross fixes for cisco conformance testing
1.9 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.10 04/12/94 ross cosmetic change.
1.11 05/02/94 ross more inverse arp fixes.
1.12 06/23/94 ross fixed network mode.  Courtesy of Rick.
1.13 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.14 08/22/94 ross liv not sent during full status enquiry.  Courtesy of Nathanial.
1.15 01/12/95 ross conversion warnings.
1.16 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdlib.h>
#include "fr.h"
/****************************************************************************/
static enum TEST send_annex_d_message (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_txed_frame,USHORT number_of_bytes);
static LIV_STATUS_ENQUIRY_MESSAGE *build_liv_status_enquiry_message (USHORT port_number);
static FULL_STATUS_ENQUIRY_MESSAGE *build_full_status_enquiry_message (USHORT port_number);
static ASYNC_STATUS_ENQUIRY_MESSAGE *build_async_status_enquiry_message (USHORT port_number, USHORT dlci);
static void build_message_header (UNION_ANNEX_D_MESSAGE *sptr_message,enum ANNEX_D_STATUS_MESSAGE_TYPE status_message,
	enum ANNEX_D_REPORT_TYPE report_type,BYTE report_length);
static void build_anxa_message_header (UNION_ANNEX_D_MESSAGE *sptr_message,enum ANNEX_D_STATUS_MESSAGE_TYPE status_message,
	enum ANNEX_D_REPORT_TYPE report_type,BYTE report_length);
static USHORT get_annexd_bit_dlci_from_ushort (USHORT annex_d_format_dlci);
/****************************************************************************/
void send_liv_status_enquiry_message (USHORT port_number)
{
	LIV_STATUS_ENQUIRY_MESSAGE *sptr_txed_frame;

	frame_relay.port[port_number].annex_d.user.number_of_polling_cycles += (BYTE) 1;

	if (frame_relay.timer > (frame_relay.port[port_number].annex_d.user.time_since_last_status_enquiry_message_sent +
		frame_relay.port[port_number].annex_d.frDlcmiPollingInterval))
		{
#if 0
		frame_relay.port[port_number].annex_d.user.time_since_last_status_enquiry_message_sent = frame_relay.timer;

		sptr_txed_frame = build_liv_status_enquiry_message (port_number);
		if (sptr_txed_frame == NULL)
			return;

		++frame_relay.port[port_number].annex_d.statistics.tx.number_of_liv_status_enquiries;
		frame_relay.port[port_number].annex_d.user.number_of_status_enquiries_sent += (BYTE) 1;

		if (frame_relay.port[port_number].annex_d.user.liv_response_received == FALSE)
			{
			frame_relay.port[port_number].annex_d.total_number_of_monitored_events += (BYTE) 1;
			frame_relay.port[port_number].annex_d.total_number_of_error_events += (BYTE) 1;
			frame_relay.port[port_number].annex_d.user.number_of_missed_status_response_messages += (BYTE) 1;
			++frame_relay.port[port_number].annex_d.statistics.number_of_missed_status_response_messages;

			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Missed Liv Status Enquiry Response on port %04x\n",port_number);
			}
		else
			frame_relay.port[port_number].annex_d.user.liv_response_received = FALSE;

		frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Tx Liv Status Enquiry on port %04x\n",port_number);

		if (frame_relay.port[port_number].annex_d.user.number_of_polling_cycles <
			frame_relay.port[port_number].annex_d.frDlcmiFullEnquiryInterval)
			{
			if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
				send_annex_d_message (port_number,(UNION_ANNEX_D_MESSAGE *) sptr_txed_frame,sizeof (LIV_STATUS_ENQUIRY_MESSAGE));
			else
				send_annex_d_message (port_number,(UNION_ANNEX_D_MESSAGE *) sptr_txed_frame,sizeof (ANXA_LIV_STATUS_ENQUIRY_MESSAGE));
			}
		else
			{
			frame_relay.port[port_number].annex_d.tx_sequence_number -= (BYTE) 1;

			frame_relay_tx_completion_routine (port_number,(FRAME_RELAY_PACKET *)sptr_txed_frame);
			}
#else
		if (frame_relay.port[port_number].annex_d.user.number_of_polling_cycles <
				frame_relay.port[port_number].annex_d.frDlcmiFullEnquiryInterval)
			{
			frame_relay.port[port_number].annex_d.user.time_since_last_status_enquiry_message_sent = frame_relay.timer;

			sptr_txed_frame = build_liv_status_enquiry_message (port_number);
			if (sptr_txed_frame == NULL)
				return;

			++frame_relay.port[port_number].annex_d.statistics.tx.number_of_liv_status_enquiries;
			frame_relay.port[port_number].annex_d.user.number_of_status_enquiries_sent += (BYTE) 1;

			if (frame_relay.port[port_number].annex_d.user.liv_response_received == FALSE)
				{
				frame_relay.port[port_number].annex_d.total_number_of_monitored_events += (BYTE) 1;
				frame_relay.port[port_number].annex_d.total_number_of_error_events += (BYTE) 1;
				frame_relay.port[port_number].annex_d.user.number_of_missed_status_response_messages += (BYTE) 1;
				++frame_relay.port[port_number].annex_d.statistics.number_of_missed_status_response_messages;

				frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Missed Liv Status Enquiry Response on port %04x\n",port_number);
				}
			else
				frame_relay.port[port_number].annex_d.user.liv_response_received = FALSE;

			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Tx Liv Status Enquiry on port %04x\n",port_number);

			if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
				send_annex_d_message (port_number,(UNION_ANNEX_D_MESSAGE *) sptr_txed_frame,sizeof (LIV_STATUS_ENQUIRY_MESSAGE));
			else
				send_annex_d_message (port_number,(UNION_ANNEX_D_MESSAGE *) sptr_txed_frame,sizeof (ANXA_LIV_STATUS_ENQUIRY_MESSAGE));
			}
#endif
		}
}
/****************************************************************************/
void send_full_status_enquiry_message (USHORT port_number)
{
	FULL_STATUS_ENQUIRY_MESSAGE *sptr_txed_frame;

	if (frame_relay.port[port_number].annex_d.user.number_of_polling_cycles >=
		frame_relay.port[port_number].annex_d.frDlcmiFullEnquiryInterval)
		{
		frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Tx Full Status Enquiry on port %04x\n",port_number);

		frame_relay.port[port_number].annex_d.user.number_of_polling_cycles = 0x0000;

		sptr_txed_frame = build_full_status_enquiry_message (port_number);
		if (sptr_txed_frame == NULL)
			return;

		++frame_relay.port[port_number].annex_d.statistics.tx.number_of_full_status_enquiries;

		if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
			send_annex_d_message (port_number,(UNION_ANNEX_D_MESSAGE *) sptr_txed_frame,sizeof (FULL_STATUS_ENQUIRY_MESSAGE));
		else
			send_annex_d_message (port_number,(UNION_ANNEX_D_MESSAGE *) sptr_txed_frame,sizeof (ANXA_FULL_STATUS_ENQUIRY_MESSAGE));
		}
}
/****************************************************************************/
void send_async_status_enquiry_message (USHORT port_number)
{
	USHORT pvc_index;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;

	pvc_index = 0x0000;

	sptr_current_connection_entry = (DLCI_LIST_ENTRY *) frame_relay.port[port_number].dlci_list.sptr_forward_link;

	while (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS && sptr_current_connection_entry != NULL)
		{
		if (sptr_current_connection_entry->mib.frCircuitState == ACTIVE_FRAME_RELAY_CIRCUIT_STATE)
			send_async_status_enquiry_message_dlci (port_number, sptr_current_connection_entry->dlci);

		++pvc_index;

		sptr_current_connection_entry	= sptr_current_connection_entry->links.sptr_forward_link;
		}
}
/****************************************************************************/
void send_async_status_enquiry_message_dlci (USHORT port_number, USHORT dlci)
{
	ASYNC_STATUS_ENQUIRY_MESSAGE *sptr_txed_frame;

	sptr_txed_frame = build_async_status_enquiry_message (port_number, dlci);
	if (sptr_txed_frame == NULL)
		return;

	frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Tx Async Status Enquiry on DLCI %04x\n",dlci);

	++frame_relay.port[port_number].annex_d.statistics.tx.number_of_async_status_enquiries;

	if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
		send_annex_d_message (port_number,(UNION_ANNEX_D_MESSAGE *) sptr_txed_frame,sizeof (ASYNC_STATUS_ENQUIRY_MESSAGE));
	else
		send_annex_d_message (port_number,(UNION_ANNEX_D_MESSAGE *) sptr_txed_frame,sizeof (ANXA_ASYNC_STATUS_ENQUIRY_MESSAGE));
}
/****************************************************************************/
static enum TEST send_annex_d_message (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_tx_frame,USHORT number_of_bytes)
{
	if (sptr_tx_frame == NULL)
		{
		++frame_relay.port[port_number].annex_d.statistics.number_of_out_of_memory_sends;
		return (FAIL);
		}

	convert_dlci ((UNION_USEABLE_DLCI *) &sptr_tx_frame->header.dlci._ushort);

	if (frame_relay.port[port_number].enabled == TRUE)
		{
		if (frame_relay.port[port_number].serial_driver.fptr_tx_routine == NULL)
			goto TxComplete;

		(*frame_relay.port[port_number].serial_driver.fptr_tx_routine) (port_number,
			port_number,
			(FRAME_RELAY_PACKET *)sptr_tx_frame,
			number_of_bytes,
			FALSE,
			FALSE,
			(void (*) (USHORT port_number,void *sptr_buffer)) frame_relay_tx_completion_routine,
			(char *)sptr_tx_frame);
		}
	else
		{
TxComplete:
		frame_relay_tx_completion_routine (port_number,(FRAME_RELAY_PACKET *) sptr_tx_frame);
		}

	return (PASS);
}
/****************************************************************************/
void frame_relay_tx_completion_routine (USHORT port_number,FRAME_RELAY_PACKET *sptr_serial_buffer)
{
	frame_relay_printf (FRAME_RELAY_MEMORY_PRINTF,"Frame Relay: Freeing ptr to send packet for port %04x, %p\r\n",port_number,
		sptr_serial_buffer);

#ifdef FR_COMP
	fr_free (sptr_serial_buffer);
#else
	free (sptr_serial_buffer);
#endif
}
/****************************************************************************/
static LIV_STATUS_ENQUIRY_MESSAGE *build_liv_status_enquiry_message (USHORT port_number)
{
	LIV_STATUS_ENQUIRY_MESSAGE *sptr_return_message;
	ANXA_LIV_STATUS_ENQUIRY_MESSAGE *sptr_anxa_return_message;

	sptr_return_message = (LIV_STATUS_ENQUIRY_MESSAGE *) get_a_frame_relay_send_packet (port_number,
		sizeof (LIV_STATUS_ENQUIRY_MESSAGE));
	if (sptr_return_message == NULL)
		return (NULL);

	if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
		{
		build_message_header ((UNION_ANNEX_D_MESSAGE *)sptr_return_message,STATUS_ENQUIRY_MESSAGE,LIV_MESSAGE_REPORT,
			sizeof (sptr_return_message->header.report.type));

		sptr_return_message->liv_information_element.id = LIV_ID;
		sptr_return_message->liv_information_element.length =
			sizeof (sptr_return_message->liv_information_element.tx_sequence_number) +
			sizeof (sptr_return_message->liv_information_element.rx_sequence_number);

		frame_relay.port[port_number].annex_d.tx_sequence_number += (BYTE) 1;

		sptr_return_message->liv_information_element.tx_sequence_number =
			frame_relay.port[port_number].annex_d.tx_sequence_number;

		sptr_return_message->liv_information_element.rx_sequence_number =
			frame_relay.port[port_number].annex_d.rx_sequence_number;
		}
	else
		{
		sptr_anxa_return_message = (ANXA_LIV_STATUS_ENQUIRY_MESSAGE *)sptr_return_message;

		build_anxa_message_header ((UNION_ANNEX_D_MESSAGE *)sptr_anxa_return_message,STATUS_ENQUIRY_MESSAGE,LIV_MESSAGE_REPORT,
			sizeof (sptr_anxa_return_message->header.report.type));

		sptr_anxa_return_message->liv_information_element.id = ANXA_LIV_ID;
		sptr_anxa_return_message->liv_information_element.length =
			sizeof (sptr_anxa_return_message->liv_information_element.tx_sequence_number) +
			sizeof (sptr_anxa_return_message->liv_information_element.rx_sequence_number);

		frame_relay.port[port_number].annex_d.tx_sequence_number += (BYTE) 1;

		sptr_anxa_return_message->liv_information_element.tx_sequence_number =
			frame_relay.port[port_number].annex_d.tx_sequence_number;

		sptr_anxa_return_message->liv_information_element.rx_sequence_number =
			frame_relay.port[port_number].annex_d.rx_sequence_number;
		}

	return (sptr_return_message);
}
/****************************************************************************/
static FULL_STATUS_ENQUIRY_MESSAGE *build_full_status_enquiry_message (USHORT port_number)
{
	FULL_STATUS_ENQUIRY_MESSAGE *sptr_return_message;
	ANXA_FULL_STATUS_ENQUIRY_MESSAGE *sptr_anxa_return_message;

	sptr_return_message = (FULL_STATUS_ENQUIRY_MESSAGE *) get_a_frame_relay_send_packet (port_number,
		sizeof (FULL_STATUS_ENQUIRY_MESSAGE));
	if (sptr_return_message == NULL)
		return NULL;

	if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
		{
		build_message_header ((UNION_ANNEX_D_MESSAGE *)sptr_return_message,STATUS_ENQUIRY_MESSAGE,FULL_STATUS_MESSAGE_REPORT,
			sizeof (sptr_return_message->header.report.type));

		sptr_return_message->liv_information_element.id = LIV_ID;
		sptr_return_message->liv_information_element.length =
			sizeof (sptr_return_message->liv_information_element.tx_sequence_number) +
			sizeof (sptr_return_message->liv_information_element.rx_sequence_number);

		sptr_return_message->liv_information_element.rx_sequence_number =
			frame_relay.port[port_number].annex_d.rx_sequence_number;

		frame_relay.port[port_number].annex_d.tx_sequence_number += (BYTE) 1;

		sptr_return_message->liv_information_element.tx_sequence_number =
			frame_relay.port[port_number].annex_d.tx_sequence_number;
		}
	else
		{
		sptr_anxa_return_message = (ANXA_FULL_STATUS_ENQUIRY_MESSAGE *) sptr_return_message;

		build_anxa_message_header ((UNION_ANNEX_D_MESSAGE *)sptr_anxa_return_message,STATUS_ENQUIRY_MESSAGE,FULL_STATUS_MESSAGE_REPORT,
			sizeof (sptr_anxa_return_message->header.report.type));

		sptr_anxa_return_message->liv_information_element.id = ANXA_LIV_ID;
		sptr_anxa_return_message->liv_information_element.length =
			sizeof (sptr_anxa_return_message->liv_information_element.tx_sequence_number) +
			sizeof (sptr_anxa_return_message->liv_information_element.rx_sequence_number);

		sptr_anxa_return_message->liv_information_element.rx_sequence_number =
			frame_relay.port[port_number].annex_d.rx_sequence_number;

		frame_relay.port[port_number].annex_d.tx_sequence_number += (BYTE) 1;

		sptr_anxa_return_message->liv_information_element.tx_sequence_number =
			frame_relay.port[port_number].annex_d.tx_sequence_number;
		}

	return (sptr_return_message);
}
/****************************************************************************/
static ASYNC_STATUS_ENQUIRY_MESSAGE *build_async_status_enquiry_message (USHORT port_number, USHORT dlci)
{
	ASYNC_STATUS_ENQUIRY_MESSAGE *sptr_return_message;
	PVC_STATUS_INFORMATION_ELEMENT *sptr_pvc_status;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;
	ANXA_ASYNC_STATUS_ENQUIRY_MESSAGE *sptr_anxa_return_message;

	sptr_current_connection_entry = get_dlci_connection_entry (port_number,dlci);
	if (sptr_current_connection_entry == NULL)
		return NULL;

	sptr_return_message = (ASYNC_STATUS_ENQUIRY_MESSAGE *) get_a_frame_relay_send_packet (port_number,
		sizeof (ASYNC_STATUS_ENQUIRY_MESSAGE));
	if (sptr_return_message == NULL)
		return NULL;

	if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
		{
		build_message_header ((UNION_ANNEX_D_MESSAGE *)sptr_return_message,
				STATUS_ENQUIRY_MESSAGE, ASYNC_STATUS_MESSAGE_REPORT,
				sizeof (sptr_return_message->header.report.type));

		sptr_pvc_status = &sptr_return_message->pvc_status;
		sptr_pvc_status->id = PVC_STATUS_ID;
		}
	else
		{
		sptr_anxa_return_message = (ANXA_ASYNC_STATUS_ENQUIRY_MESSAGE *) sptr_return_message;

		build_anxa_message_header ((UNION_ANNEX_D_MESSAGE *)sptr_anxa_return_message,
				STATUS_ENQUIRY_MESSAGE, ASYNC_STATUS_MESSAGE_REPORT,
				sizeof (sptr_anxa_return_message->header.report.type));

		sptr_pvc_status = &sptr_anxa_return_message->pvc_status;
		sptr_pvc_status->id = ANXA_PVC_STATUS_ID;
		}

	sptr_pvc_status->length = sizeof (sptr_pvc_status->dlci) + sizeof (sptr_pvc_status->type);
	sptr_pvc_status->dlci._ushort = get_annexd_bit_dlci_from_ushort (dlci);

	if (sptr_current_connection_entry->mib.frCircuitState == ACTIVE_FRAME_RELAY_CIRCUIT_STATE)
		sptr_pvc_status->type._bit.active = TRUE;
	else
		sptr_pvc_status->type._bit.active = FALSE;

	sptr_pvc_status->type._bit.extension = TRUE;

	return (sptr_return_message);
}
/****************************************************************************/
static void build_message_header (UNION_ANNEX_D_MESSAGE *sptr_message,enum ANNEX_D_STATUS_MESSAGE_TYPE status_message,
	enum ANNEX_D_REPORT_TYPE report_type,BYTE report_length)
{
	sptr_message->header.dlci._ushort = ANNEX_D_DLCI;
	sptr_message->header.unnumbered_frame_info = UNNUMBERED_INFORMATION;
	sptr_message->header.protocol_discriminator = ANNEX_D_DISCRIMINATOR;
	sptr_message->header.call_reference = 0x00;
	sptr_message->header.status_message = status_message;
	sptr_message->header.locking_shift = LOCKING_SHIFT;
	sptr_message->header.report.type = report_type;
	sptr_message->header.report.length = report_length;
	sptr_message->header.report.id = REPORT_TYPE_ID;
}
/****************************************************************************/
static void build_anxa_message_header (UNION_ANNEX_D_MESSAGE *sptr_message,enum ANNEX_D_STATUS_MESSAGE_TYPE status_message,
	enum ANNEX_D_REPORT_TYPE report_type,BYTE report_length)
{
	sptr_message->anxa_header.dlci._ushort = ANNEX_D_DLCI;
	sptr_message->anxa_header.unnumbered_frame_info = UNNUMBERED_INFORMATION;
	sptr_message->anxa_header.protocol_discriminator = ANNEX_D_DISCRIMINATOR;
	sptr_message->anxa_header.call_reference = 0x00;
	sptr_message->anxa_header.status_message = status_message;
	sptr_message->anxa_header.report.type = report_type;
	sptr_message->anxa_header.report.length = report_length;
	sptr_message->anxa_header.report.id = ANXA_REPORT_TYPE_ID;
}
/****************************************************************************/
void *get_a_frame_relay_send_packet (USHORT port_number,USHORT size_of_packet)
{
	void *sptr_send_packet;

#ifdef FR_COMP
	sptr_send_packet = fr_malloc (size_of_packet);
#else
	sptr_send_packet = malloc (size_of_packet);
#endif

	if (sptr_send_packet == NULL)
		{
		frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,"Frame Relay: Error Allocating Packet port number %04x size of %08lx\r\n",
			port_number,size_of_packet);
		}
	else
		{
		frame_relay_printf (FRAME_RELAY_MEMORY_PRINTF,"Frame Relay: Alloced ptr to send packet for port %04x, %p\r\n",port_number,
			sptr_send_packet);
		}

	return (sptr_send_packet);
}
/****************************************************************************/
static USHORT get_annexd_bit_dlci_from_ushort (USHORT ushort_dlci)
{
	UNION_ANNEX_D_DLCI annex_d_dlci;
	UNION_USEABLE_DLCI useable_dlci;

	useable_dlci._ushort = ushort_dlci;

	annex_d_dlci._ushort = 0x0000;

	annex_d_dlci._bit.dlci_lsb = useable_dlci._bit.dlci_lsb;
	annex_d_dlci._bit.dlci_msb = useable_dlci._bit.dlci_msb;

	annex_d_dlci._bit.extended_address_1 = 0x1;

	return (annex_d_dlci._ushort);
}
