#include	"defs.h"

/**************************************************************************/
/* Module to compress the data and encapsulate them as FRF.9 frames.      */
/**************************************************************************/

#include <string.h>
#include "fr.h"

#include "bsd.h"

/****************************************************************************/
BYTE *build_frf9_frame (USHORT port_number, USHORT dlci,
		BYTE *sptr_frame, USHORT *ptr_number_of_bytes)
{
	USHORT	length, newlen;
	BYTE		*new_buf_ptr = NULL;
	FRF9_DCP_HEADER dcp_header;
	DLCI_LIST_ENTRY *sptr_dlci_entry;

	if ((sptr_dlci_entry = get_dlci_connection_entry (port_number, dlci)) == NULL)
		return (sptr_frame);

	if (sptr_dlci_entry->compression == FALSE)
		return (sptr_frame);

	if (sptr_dlci_entry->mode_1_state != OPERATION_STATE)
		return (sptr_frame);

	dcp_header.extension = 1;			/* no extension */
	dcp_header.control_or_data = 0;	/* data PDU */
	dcp_header.reset_request = 0;		/* not a reset request */
	dcp_header.reset_ack = 0;			/* not a reset ack */

	/* call the compression module to compress the data */
	length = *ptr_number_of_bytes;
	newlen = length - sizeof(FRAME_RELAY_GENERIC_HEADER);

	/* try to compress the data */
	new_buf_ptr = BSD_compress_packet (sptr_dlci_entry->bsd_context_id,
		(sptr_frame + sizeof(FRAME_RELAY_GENERIC_HEADER)), (USHORT *)&newlen);

	/* if the data got compressed, copy the new data, update the length */
	/* variable and free up the buffer given by compression module. */
	if (new_buf_ptr != NULL) {
#ifdef DEBUG
		printf ("FRF9: Compressed data from - %d, to %d, on DLCI - %d\r\n",
			(length-3), newlen, dlci);
#endif
		my_memcpy ((sptr_frame + sizeof(FRAME_RELAY_GENERIC_HEADER)), new_buf_ptr, newlen);

		length = newlen + sizeof(FRAME_RELAY_GENERIC_HEADER);

		BSD_free_compressed_packet (sptr_dlci_entry->bsd_context_id, new_buf_ptr);

		dcp_header.compressed_mode = 1;
	}
	else {
#ifdef DEBUG
		printf ("FRF9: Compress failed on data - len = %d, on DLCI - %d\r\n",
			(length-3), dlci);
#endif
		dcp_header.compressed_mode = 0;
	}

	/* adjust the buffer pointer for FRF_9 (NLPID + header + seq.# + len) */
	sptr_frame -= FRF9_BUFFER_ADJUSTMENT;

	/* first move the DLCI & control byte */
	*sptr_frame = *(sptr_frame + FRF9_BUFFER_ADJUSTMENT);
	*(sptr_frame+1) = *(sptr_frame + FRF9_BUFFER_ADJUSTMENT + 1);
	*(sptr_frame+2) = *(sptr_frame + FRF9_BUFFER_ADJUSTMENT + 2);

	*(sptr_frame+3) = FRF9_NLPID;
	*(sptr_frame+4) = *(BYTE *)&dcp_header;
	*(sptr_frame+5) = sptr_dlci_entry->tx_sequence_number;
	*(USHORT *)(sptr_frame+6) = (USHORT)((*ptr_number_of_bytes) - sizeof(FRAME_RELAY_GENERIC_HEADER));

	sptr_dlci_entry->tx_sequence_number += (BYTE)1;
	(*ptr_number_of_bytes) = length + FRF9_BUFFER_ADJUSTMENT;

#ifdef DEBUG
	printf ("FRF9: Sent %d bytes on DLCI - %d\r\n", length, dlci);
#endif

	return (sptr_frame);
}

/****************************************************************************/
void send_frf9_reset_request (USHORT port_number, USHORT dlci)
{
	FRF9_DCP_DATA_PDU_HEADER	*sptr_frame;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;

	if (frame_relay.port[port_number].serial_driver.fptr_tx_routine == NULL)
		return;

	sptr_frame = (FRF9_DCP_DATA_PDU_HEADER *) fr_malloc(sizeof(FRF9_DCP_DATA_PDU_HEADER));
	if (sptr_frame == NULL) {
#ifdef DEBUG
		printf ("FRF9: Calloc failed. Reset request not sent.\r\n");
#endif
		return;
	}

	sptr_frame->dlci._ushort = dlci;
	sptr_frame->control = 0x03;
	sptr_frame->nlpid = FRF9_NLPID;

	sptr_frame->dcp_header.extension = 1;			/* no extension */
	sptr_frame->dcp_header.control_or_data = 0;	/* data PDU */
	sptr_frame->dcp_header.reset_request = 1;		/* reset request */
	sptr_frame->dcp_header.reset_ack = 0;			/* not a reset ack */
	sptr_frame->dcp_header.compressed_mode = 0;

	convert_dlci ((UNION_USEABLE_DLCI *) &sptr_frame->dlci);

#if 1
	printf ("FRF9: Sent reset request on DLCI - %d\r\n", dlci);
#endif

	if ((*frame_relay.port[port_number].serial_driver.fptr_tx_routine) (port_number,
			port_number,
			sptr_frame,
			sizeof(FRF9_DCP_DATA_PDU_HEADER),
			FALSE,
			FALSE,
			(void (*) (USHORT port_number,void *sptr_buffer)) frf9_tx_completion_routine,
			(char *)sptr_frame) == TRUE) {

		sptr_dlci_connection_entry = get_dlci_connection_entry (0,dlci);
		sptr_dlci_connection_entry->bytes_sent.Other_data += sizeof(FRF9_DCP_DATA_PDU_HEADER);
		sptr_dlci_connection_entry->frames_sent.Other_data ++;
	}
}

/****************************************************************************/
void send_frf9_reset_ack (USHORT port_number, USHORT dlci)
{
	FRF9_DCP_DATA_PDU_HEADER	*sptr_frame;
	DLCI_LIST_ENTRY 				*sptr_dlci_connection_entry;

	if (frame_relay.port[port_number].serial_driver.fptr_tx_routine == NULL)
		return;

	sptr_frame = (FRF9_DCP_DATA_PDU_HEADER *) fr_malloc(sizeof(FRF9_DCP_DATA_PDU_HEADER));
	if (sptr_frame == NULL) {
#ifdef DEBUG
		printf ("FRF9: Calloc failed. Reset ack not sent.\r\n");
#endif
		return;
	}

	sptr_frame->dlci._ushort = dlci;
	sptr_frame->control = 0x03;
	sptr_frame->nlpid = FRF9_NLPID;

	sptr_frame->dcp_header.extension = 1;			/* no extension */
	sptr_frame->dcp_header.control_or_data = 0;	/* data PDU */
	sptr_frame->dcp_header.reset_ack = 1;			/* reset request */
	sptr_frame->dcp_header.reset_request = 0;		/* not a reset request */
	sptr_frame->dcp_header.compressed_mode = 0;

	convert_dlci ((UNION_USEABLE_DLCI *) &sptr_frame->dlci);

#if 1
	printf ("FRF9: Sent reset ack on DLCI - %d\r\n", dlci);
#endif

	if ((*frame_relay.port[port_number].serial_driver.fptr_tx_routine) (port_number,
			port_number,
			sptr_frame,
			sizeof(FRF9_DCP_DATA_PDU_HEADER),
			FALSE,
			FALSE,
			(void (*) (USHORT port_number,void *sptr_buffer)) frf9_tx_completion_routine,
			(char *)sptr_frame) == TRUE) {

		sptr_dlci_connection_entry = get_dlci_connection_entry (0,dlci);
		sptr_dlci_connection_entry->bytes_sent.Other_data += sizeof(FRF9_DCP_DATA_PDU_HEADER);
		sptr_dlci_connection_entry->frames_sent.Other_data ++;
	}
}

/****************************************************************************/
void send_mode_1_request (USHORT port_number, USHORT dlci)
{
	FRF9_DCP_DATA_PDU_HEADER		*sptr_frame;
	FRF9_DCPCP_MODE1_PDU_FORMAT	*sptr_mode1_data;
	DLCI_LIST_ENTRY 					*sptr_dlci_connection_entry;

	if (frame_relay.port[port_number].serial_driver.fptr_tx_routine == NULL)
		return;

	sptr_frame = (FRF9_DCP_DATA_PDU_HEADER *)
		fr_malloc(sizeof(FRF9_DCP_DATA_PDU_HEADER) + sizeof(FRF9_DCPCP_MODE1_PDU_FORMAT));
	if (sptr_frame == NULL) {
#ifdef DEBUG
		printf ("FRF9: Calloc failed. MODE-1 request not sent.\r\n");
#endif
		return;
	}

	sptr_frame->dlci._ushort = dlci;
	sptr_frame->control = 0x03;
	sptr_frame->nlpid = FRF9_NLPID;

	sptr_frame->dcp_header.extension = 1;			/* no extension */
	sptr_frame->dcp_header.control_or_data = 1;	/* control PDU */

	sptr_mode1_data = (FRF9_DCPCP_MODE1_PDU_FORMAT *)((ULONG)sptr_frame + sizeof(FRF9_DCP_DATA_PDU_HEADER));

	sptr_mode1_data->request_response.code = MODE1_REQUEST_CODE;
	sptr_mode1_data->request_response.identifier = 0;
	sptr_mode1_data->request_response.length = 7;

	sptr_mode1_data->config_options.type = 254;
	sptr_mode1_data->config_options.length = 3;
	sptr_mode1_data->config_options.revision = 1;

	convert_dlci ((UNION_USEABLE_DLCI *) &sptr_frame->dlci);

#ifdef DEBUG
	printf ("FRF9: Sent MODE_1 request on DLCI - %d\r\n", dlci);
#endif

	if ((*frame_relay.port[port_number].serial_driver.fptr_tx_routine) (port_number,
			port_number,
			sptr_frame,
			sizeof(FRF9_DCP_DATA_PDU_HEADER) + sizeof(FRF9_DCPCP_MODE1_PDU_FORMAT),
			FALSE,
			FALSE,
			(void (*) (USHORT port_number,void *sptr_buffer)) frf9_tx_completion_routine,
			(char *)sptr_frame) == TRUE) {

		sptr_dlci_connection_entry = get_dlci_connection_entry (0,dlci);
		sptr_dlci_connection_entry->bytes_sent.Other_data += 
			sizeof(FRF9_DCP_DATA_PDU_HEADER) + sizeof(FRF9_DCPCP_MODE1_PDU_FORMAT);
		sptr_dlci_connection_entry->frames_sent.Other_data ++;
	}
}

/****************************************************************************/
void send_mode_1_response (USHORT port_number, USHORT dlci)
{
	FRF9_DCP_DATA_PDU_HEADER		*sptr_frame;
	FRF9_DCPCP_MODE1_PDU_FORMAT	*sptr_mode1_data;
	DLCI_LIST_ENTRY 					*sptr_dlci_connection_entry;

	if (frame_relay.port[port_number].serial_driver.fptr_tx_routine == NULL)
		return;

	sptr_frame = (FRF9_DCP_DATA_PDU_HEADER *)
		fr_malloc(sizeof(FRF9_DCP_DATA_PDU_HEADER) + sizeof(FRF9_DCPCP_MODE1_PDU_FORMAT));
	if (sptr_frame == NULL) {
#ifdef DEBUG
		printf ("FRF9: Calloc failed. MODE-1 response not sent.\r\n");
#endif
		return;
	}

	sptr_frame->dlci._ushort = dlci;
	sptr_frame->control = 0x03;
	sptr_frame->nlpid = FRF9_NLPID;

	sptr_frame->dcp_header.extension = 1;			/* no extension */
	sptr_frame->dcp_header.control_or_data = 1;	/* control PDU */

	sptr_mode1_data = (FRF9_DCPCP_MODE1_PDU_FORMAT *)((ULONG)sptr_frame + sizeof(FRF9_DCP_DATA_PDU_HEADER));

	sptr_mode1_data->request_response.code = MODE1_RESPONSE_CODE;
	sptr_mode1_data->request_response.identifier = 0;
	sptr_mode1_data->request_response.length = 7;

	sptr_mode1_data->config_options.type = 254;
	sptr_mode1_data->config_options.length = 3;
	sptr_mode1_data->config_options.revision = 1;

	convert_dlci ((UNION_USEABLE_DLCI *) &sptr_frame->dlci);

#ifdef DEBUG
	printf ("FRF9: Sent MODE_1 response on DLCI - %d\r\n", dlci);
#endif

	if ((*frame_relay.port[port_number].serial_driver.fptr_tx_routine) (port_number,
			port_number,
			sptr_frame,
			sizeof(FRF9_DCP_DATA_PDU_HEADER) + sizeof(FRF9_DCPCP_MODE1_PDU_FORMAT),
			FALSE,
			FALSE,
			(void (*) (USHORT port_number,void *sptr_buffer)) frf9_tx_completion_routine,
			(char *)sptr_frame) == TRUE) {

		sptr_dlci_connection_entry = get_dlci_connection_entry (0,dlci);
		sptr_dlci_connection_entry->bytes_sent.Other_data += 
			sizeof(FRF9_DCP_DATA_PDU_HEADER) + sizeof(FRF9_DCPCP_MODE1_PDU_FORMAT);
		sptr_dlci_connection_entry->frames_sent.Other_data ++;
	}
}

/****************************************************************************/
void frf9_tx_completion_routine (USHORT port_number,BYTE *sptr_serial_buffer)
{
	fr_free(sptr_serial_buffer);
}

/****************************************************************************/
void reset_frf9_tx_sequence_number (DLCI_LIST_ENTRY *sptr_dlci_entry)
{
	sptr_dlci_entry->tx_sequence_number -= (BYTE)1;
}
