#include	"defs.h"
/*	$Modname: frinit.c$  $version: 1.24$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 12/27/92 ross
1.1 01/02/93 ross
1.2 01/02/93 ross
1.3 01/10/93 ross changing to symmetric dlci's - IBM way
1.4 01/17/93 ross added function to store ipx dlci
1.5 01/21/93 ross added extended_address = TRUE.
1.6 01/21/93 ross added code to set extended address bit properly.
1.7 01/22/93 ross moved to extended address 1.
1.8 01/23/93 ross added frame_relay.enabled = TRUE.
1.9 02/07/93 ross added external call to check for cisco type enapsulation.
1.10 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.11 12/03/93 ross fixes for lsl version 3.0
1.12 02/01/94 ross added some parameters for configuration.
1.13 02/27/94 ross added support for new ip
1.14 03/01/94 ross testing with cisco frame relay and pacific bell.
1.15 03/19/94 ross fixes for cisco conformance testing
1.16 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.17 04/12/94 ross added STANDALONE if def for non-users of our spanning tree.
1.18 05/02/94 ross inverse arp fixes.
1.19 05/03/94 ross added __LSL__ conditional compile statement.
1.20 06/13/94 ross added snmp access routines, fixed bug with ip header tx's.  Courtesy of Rick.
1.21 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.22 01/12/95 ross fixed use of NULL.
1.23 01/12/95 ross conversion warnings.
1.24 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#define GLOBAL_FILE
#include <stdlib.h>
#include <string.h>
#include "fr.h"

extern void BreakToMonitor(void);
extern void mux_initialize (USHORT port_number, USHORT port_type);

/****************************************************************************/
STACK_NAME_ARRAY stack_name_array[] =
{
	{"Spanning Tree",NULL},
	{"IPX Routing",NULL},
	{"Source Routing",NULL},
	{"IP Routing",NULL},
	{"",NULL}
};

#ifdef FRAME_RELAY_STANDALONE
	#ifdef BIG_ENDIAN
		GLOBAL	MAC_ADDRESS	bridge_group_address = { 0x0180c200L,0x0000 };
		GLOBAL	MAC_ADDRESS	bridge_management_group_address = { 0x0180c200L,0x1000 };
		GLOBAL	MAC_ADDRESS	token_ring_bridge_group_address = { 0xc0000000L,0x0100 };
	#else
		GLOBAL	MAC_ADDRESS	bridge_group_address = { 0x00c28001L,0x0000 };
		GLOBAL	MAC_ADDRESS	bridge_management_group_address = { 0x00c28001L,0x0010 };
		GLOBAL	MAC_ADDRESS	token_ring_bridge_group_address = { 0x000000c0L,0x0001 };
	#endif
#endif

static void initialize_frame_relay_ports (void);
static enum TEST frame_relay_device_driver_control (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);
static ULONG frame_relay_register_serial_device_driver (USHORT port_number,LOW_LEVEL_DEVICE_DRIVER_API *sptr_serial_driver_api);
/****************************************************************************/
enum TEST initialize_frame_relay (ULONG clock_ticks_per_second)
{
	if (frame_relay.enabled == FALSE)
		return PASS ;

	frame_relay.number_of_lan_ports = lsl_control (GET_NUMBER_OF_LAN_PORTS);

	if (frame_relay.total_number_of_frame_relay_ports == 0x0000)
		{
		frame_relay.enabled = FALSE;

		return (PASS);
		}

	frame_relay.enabled = TRUE;	/* KVSP */

	frame_relay.clock_ticks_per_second = clock_ticks_per_second;

#ifdef FR_COMP
	fr_init_mem ();
#endif

	initialize_annex_d ();

	initialize_lmi ();

	initialize_frame_relay_ports ();

#ifdef FR_COMP
	initialize_compression_contexts();
#endif

	stack_name_array[0].usptr_stack_id = &frame_relay.stp_stack_id;
	stack_name_array[1].usptr_stack_id = &frame_relay.ipx_stack_id;
	stack_name_array[2].usptr_stack_id = &frame_relay.source_routing_stack_id;
	stack_name_array[3].usptr_stack_id = &frame_relay.ip_stack_id;

	frame_relay.stp_stack_id = ILLEGAL_STACK_ID;
	frame_relay.ipx_stack_id = ILLEGAL_STACK_ID;
	frame_relay.source_routing_stack_id = ILLEGAL_STACK_ID;
	frame_relay.ip_stack_id = ILLEGAL_STACK_ID;

	frame_relay.CIR_ticks = 0;
	frame_relay.CIR_timer = 0;
	frame_relay.check_CIR_timeout = FALSE;

	printf ("FR: Frame Relay Initialized\r\n");

	return (PASS);
}
/****************************************************************************/
static void initialize_frame_relay_ports (void)
{
	USHORT port_number;

	for (port_number = 0; port_number < frame_relay.total_number_of_frame_relay_ports; ++port_number)
		{
		frame_relay.port[port_number].port_number = port_number;
		frame_relay.port[port_number].mib.frDlcmiIfIndex = port_number;
		frame_relay.port[port_number].last_error_packet.frErrIfIndex = port_number; 

#ifdef __LSL__
		if ((enum TEST) lsl_control (REGISTER_HIGH_LEVEL_DEVICE_DRIVER,"Frame Relay Driver",FRAME_RELAY_DEVICE_DRIVER,
			send_frame_relay_frame,frame_relay_packet_transmitted,frame_relay_receive,
			frame_relay_timer,frame_relay_device_driver_control,frame_relay_return_buffer_to_device_driver,
			&frame_relay.port[port_number].device_driver_id) == FAIL)
			{
			frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,"FR: Problem registering device driver");
			}
#endif
		memset (&frame_relay.port[port_number].statistics,(int) NULL,sizeof (FRAME_RELAY_STATISTICS));
		}
}
/****************************************************************************/
static enum TEST frame_relay_device_driver_control (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1)
{
	BYTE 		stack_name_index;
	USHORT	port_number;

	switch (command)
		{
		case OPEN_DEVICE_DRIVER_PORT:
			port_number = ((USHORT)parameter_0 - (USHORT) frame_relay.number_of_lan_ports);

#ifdef DEBUG
			printf ("FR: Device driver port opened\r\n");
#endif
			if (frame_relay.port[port_number].serial_driver.fptr_control_routine != NULL)
			{
				(* frame_relay.port[port_number].serial_driver.fptr_control_routine) (OPEN_SERIAL_PORT,
					(ULONG) port_number,(ULONG) frame_relay.port[port_number].device_driver_id);
			}
#ifdef MUX
			mux_initialize (port_number, 2);		/* register with APSM module */
#endif
			break;
		case STACK_HAS_REGISTERED:
			for (stack_name_index = 0x00; stack_name_array[stack_name_index].usptr_stack_id != NULL; stack_name_index += (BYTE) 1)
				{
				if (strcmp ((char *) parameter_0,&stack_name_array[stack_name_index].name[0]) == STRINGS_MATCH)
					{
#ifdef DEBUG
					printf ("FR: %s Stack registered\r\n", (char *) parameter_0);
#endif
					*stack_name_array[stack_name_index].usptr_stack_id = (ULONG) parameter_1;
					break;
					}
				}
			break;
		case CLOSE_DEVICE_DRIVER_PORT:
			port_number = ((USHORT)parameter_0 - (USHORT) frame_relay.number_of_lan_ports);
			reset_frame_relay_port (port_number);
			break;
		case OPEN_DEVICE_DRIVER:
			break;
		case CLOSE_DEVICE_DRIVER:
			break;
		case DEVICE_QUERY:
			break;
		case GET_DEVICE_MAC_ADDRESS:
			break;
		case REGISTER_SERIAL_DEVICE_DRIVER:
			port_number = ((USHORT)parameter_0 - (USHORT) frame_relay.number_of_lan_ports);
			frame_relay_register_serial_device_driver (port_number,(LOW_LEVEL_DEVICE_DRIVER_API *) parameter_1);
			break;
		}

	return (PASS);
}
/*************************************************************************/
void frame_relay_return_buffer_to_device_driver (USHORT real_port_number,void *vptr_buffer)
{
	real_port_number -= (USHORT) frame_relay.number_of_lan_ports;

	(*frame_relay.port[real_port_number].serial_driver.fptr_rx_buffer_return) (real_port_number,vptr_buffer);
}
/****************************************************************************/
void set_protocol_stacks_virtual_port (USHORT dlci,enum BOOLEAN up_or_down)
{
	USHORT protocol_stack_virtual_port_number;
	enum PROTOCOL_CONTROL_OPERATION control_operation;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;
   /* Quick fix here */
   ULONG mtu = frame_relay.port[0].maximum_frame_size ;

	sptr_dlci_connection_entry = get_dlci_connection_entry (0, dlci);

	if (up_or_down == TRUE)
		{
		control_operation = OPEN_VIRTUAL_PORT;
		}
	else
		{
		control_operation = CLOSE_VIRTUAL_PORT;
		}

	if (frame_relay.ipx_stack_id != ILLEGAL_STACK_ID)
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (dlci,&frame_relay.ipx_dlci_table);

		if (protocol_stack_virtual_port_number != ILLEGAL_VIRTUAL_PORT_NUMBER)
			{
			if (frame_relay.ipx_dlci_table.entry[protocol_stack_virtual_port_number].inverse_arp_enabled == FALSE)
				{
				lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,protocol_stack_virtual_port_number,frame_relay.ipx_stack_id,control_operation,
					(ULONG) NULL, NULL);
				}

			if (sptr_dlci_connection_entry != NULL)
				{
				sptr_dlci_connection_entry->ipx_virtual_port_number = protocol_stack_virtual_port_number;
#ifdef DEBUG
				printf ("DLCI - %d, Virtual IPX Port - %d\r\n", dlci, protocol_stack_virtual_port_number);
#endif
				}
			}
		}

	if (frame_relay.ip_stack_id != ILLEGAL_STACK_ID)
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (dlci,&frame_relay.ip_dlci_table);

		if (protocol_stack_virtual_port_number != ILLEGAL_VIRTUAL_PORT_NUMBER)
			{
			if (frame_relay.ip_dlci_table.entry[protocol_stack_virtual_port_number].inverse_arp_enabled == FALSE)
				{
				lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,protocol_stack_virtual_port_number,frame_relay.ip_stack_id,control_operation,
					(ULONG) NULL, mtu);
				}

			if (sptr_dlci_connection_entry != NULL)
				{
				sptr_dlci_connection_entry->ip_virtual_port_number = protocol_stack_virtual_port_number;
#ifdef DEBUG
				printf ("DLCI - %d, Virtual IP Port - %d\r\n", dlci, protocol_stack_virtual_port_number);
#endif
				}
			}
		}

	if (frame_relay.stp_stack_id != ILLEGAL_STACK_ID)
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (dlci,&frame_relay.stp_dlci_table);

		if (protocol_stack_virtual_port_number != ILLEGAL_VIRTUAL_PORT_NUMBER)
			{
			lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,protocol_stack_virtual_port_number,frame_relay.stp_stack_id,control_operation,
				(ULONG) NULL, NULL);

			if (sptr_dlci_connection_entry != NULL)
				{
				sptr_dlci_connection_entry->stp_virtual_port_number = protocol_stack_virtual_port_number;
#ifdef DEBUG
				printf ("DLCI - %d, Virtual STP Port - %d\r\n", dlci, protocol_stack_virtual_port_number);
#endif
				}
			}
		}

	if (frame_relay.source_routing_stack_id != ILLEGAL_STACK_ID)
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (dlci,&frame_relay.source_routing_dlci_table);

		if (protocol_stack_virtual_port_number != ILLEGAL_VIRTUAL_PORT_NUMBER)
			{
			lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,protocol_stack_virtual_port_number,frame_relay.source_routing_stack_id,control_operation,
				(ULONG) NULL);
			}
		}
}
/****************************************************************************/
void set_inverse_arp_protocol_stack_virtual_port (USHORT dlci,enum BOOLEAN up_or_down,void *vptr_protocol_address,
	enum PROTOCOL_STACK_TYPE protocol_stack_type)
{
	ULONG ip_address;
	USHORT protocol_stack_virtual_port_number;
	enum PROTOCOL_CONTROL_OPERATION control_operation;
   /* Quick fix here */
   ULONG mtu = frame_relay.port[0].maximum_frame_size ;

	if (vptr_protocol_address != NULL)
		{
		if (protocol_stack_type == IP_PROTOCOL_STACK)
			{
			ip_address = *(ULONG *)vptr_protocol_address;
			}

		if (up_or_down == TRUE)
			{
			control_operation = OPEN_VIRTUAL_PORT;
			}
		else
			{
			control_operation = CLOSE_VIRTUAL_PORT;
			}
		}

	if ((frame_relay.ipx_stack_id != ILLEGAL_STACK_ID) && (protocol_stack_type == IPX_PROTOCOL_STACK))
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (dlci,&frame_relay.ipx_dlci_table);

		if (protocol_stack_virtual_port_number != ILLEGAL_VIRTUAL_PORT_NUMBER)
			{
			if (frame_relay.ipx_dlci_table.entry[protocol_stack_virtual_port_number].inverse_arp_enabled == TRUE)
				{
				lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,protocol_stack_virtual_port_number,frame_relay.ipx_stack_id,control_operation,
					(ULONG) vptr_protocol_address, NULL);
				}
			}
		}

	if ((frame_relay.ip_stack_id != ILLEGAL_STACK_ID) && (protocol_stack_type == IP_PROTOCOL_STACK))
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (dlci,&frame_relay.ip_dlci_table);

		if (protocol_stack_virtual_port_number != ILLEGAL_VIRTUAL_PORT_NUMBER)
			{
			if (frame_relay.ip_dlci_table.entry[protocol_stack_virtual_port_number].inverse_arp_enabled == TRUE)
				{
				lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,protocol_stack_virtual_port_number,frame_relay.ip_stack_id,control_operation,
					(ULONG) ip_address, mtu);
				}
			}
		}
}
/****************************************************************************/
static ULONG frame_relay_register_serial_device_driver (USHORT port_number,LOW_LEVEL_DEVICE_DRIVER_API *sptr_serial_driver_api)
{
	strcpy (frame_relay.port[port_number].serial_driver.name,sptr_serial_driver_api->cptr_device_name);

	frame_relay.port[port_number].serial_driver.type = sptr_serial_driver_api->device_driver_type;

	frame_relay.port[port_number].serial_driver.fptr_tx_routine = sptr_serial_driver_api->fptr_tx_routine;
	frame_relay.port[port_number].serial_driver.fptr_tx_complete = sptr_serial_driver_api->fptr_tx_complete;
	frame_relay.port[port_number].serial_driver.fptr_rx_routine = sptr_serial_driver_api->fptr_rx_routine;
	frame_relay.port[port_number].serial_driver.fptr_timer_routine = sptr_serial_driver_api->fptr_timer_routine;
	frame_relay.port[port_number].serial_driver.fptr_control_routine = sptr_serial_driver_api->fptr_control_routine;
	frame_relay.port[port_number].serial_driver.fptr_rx_buffer_return = sptr_serial_driver_api->fptr_rx_buffer_return;

	return (frame_relay.port[port_number].device_driver_id);
}
/****************************************************************************/
void check_for_inverse_arp_packets_to_send (void)
{
	if (++frame_relay.current_arp_timer > frame_relay.inverse_arp_timer)
		{
		frame_relay.current_arp_timer = 0x0000;

		send_periodic_inverse_arp_packets ();
		}
}

