#include	"defs.h"
/*	$Modname: frsnmp.c$  $version: 1.10$      $date: 06/29/95$   */
/*
* 	$lgb$
1.0 01/02/93 ross
1.1 01/02/93 ross
1.2 01/10/93 ross changing to symmetric dlci's - IBM way
1.3 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.4 03/01/94 ross testing with cisco frame relay and pacific bell.
1.5 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.6 06/13/94 ross added snmp access routines, fixed bug with ip header tx's.  Courtesy of Rick.
1.7 06/14/94 ross added dlci table access routines.
1.8 01/12/95 ross making changes for new snmp.
1.9 04/21/95 ross Increased size of stack_id.
1.10 06/29/95 ross new snmp access routine
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include "fr.h"
#include	<visnpstr.h>
#include "vfrsnmp.h"
/****************************************************************************/
static void save_error_information (enum FRAME_RELAY_ALARM_TYPE error_type,USHORT port_number,ULONG length,void *sptr_data);
/****************************************************************************/
/* Srikar, Apr 11, 1997. Changed the type of the parameter bptr_table_indices from BYTE * to OBJECT_ID * */
/* and its name from bptr_table_indices to sptr_table_indices */
enum TEST get_frame_relay_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation,cptr_mib_string,bptr_variable_value,
		usptr_size_of_variable_value,usptr_size_of_table_indices,sptr_table_indices,eptr_end_of_table,
		ptr_to_cptr_next_variable_name,&frame_relay_snmp_table[0x00]);

	return (return_code);
}
/****************************************************************************/
FRAME_RELAY_PORT_CLASS *get_frame_relay_port_class (USHORT port_number)
{
	return (&frame_relay.port[port_number]);
}
/****************************************************************************/
ANNEX_D_CLASS *get_annex_d_control_information (USHORT port_number)
{
	return (&frame_relay.port[port_number].annex_d);
}
/****************************************************************************/
FRAME_RELAY_STATISTICS *get_frame_relay_port_statistics (USHORT port_number)
{
	return (&frame_relay.port[port_number].statistics);
}
/****************************************************************************/
void *get_frame_relay_port_connection_list (USHORT port_number)
{
	return (&frame_relay.port[port_number].dlci_list);
}
/****************************************************************************/
void frame_relay_management_alarm (enum FRAME_RELAY_ALARM_TYPE error_type,enum BOOLEAN annex_d_frame,USHORT port_number,
	void *sptr_frame,USHORT number_of_bytes)
{
	FRAME_RELAY_STATISTICS *sptr_statistics;

	if (annex_d_frame == FALSE)
		sptr_statistics = &frame_relay.port[port_number].statistics;
	else
		sptr_statistics = &frame_relay.port[port_number].annex_d.statistics.general;

	switch (error_type)
		{
		case RX_PACKET_TOO_SHORT: 
#ifdef DEBUG
			printf ("FR: Packet too short\r\n");
#endif
			++sptr_statistics->number_rxed_less_than_minumum_size;
			break;

		case RX_PACKET_TOO_LONG:
#ifdef DEBUG
			printf ("FR: Packet too long\r\n");
#endif
			++sptr_statistics->number_rxed_greater_than_maximum_size;
			break;

		case ILLEGAL_DLCI:
#ifdef DEBUG
			printf ("FR: Illegal DLCI\r\n");
#endif
			++sptr_statistics->number_of_illegal_dlcis;
			break;
		case UNKNOWN_DLCI:
#ifdef DEBUG
			printf ("FR: Unknown DLCI\r\n");
#endif
			++sptr_statistics->number_of_unknown_dlcis;
			break;
		case ANNEX_D_SEQUENCE_ERROR:
		case ANNEX_D_UNKNOWN_REPORT:
		case ANNEX_D_UNKNOWN_INFORMATION_ELEMENT:
		case ANNEX_D_PROTOCOL_ERROR:
#ifdef DEBUG
			printf ("FR: Annex_D error\r\n");
#endif
			break;

		case NO_ERROR_SINCE_RESET:
			break;
		default:
			break;
		}

	if (frame_relay.fptr_alarm_function != NULL)
		{
		(*frame_relay.fptr_alarm_function) (error_type,port_number,(ULONG) sptr_frame,number_of_bytes);
		}

	save_error_information (error_type, port_number, number_of_bytes, sptr_frame);
}
/****************************************************************************/
static void save_error_information (enum FRAME_RELAY_ALARM_TYPE error_type,USHORT port_number,ULONG length,void *sptr_data)
{
	frame_relay.port[port_number].last_error_packet.frErrType = error_type;
	frame_relay.port[port_number].last_error_packet.frErrTime = frame_relay.timer;

	if (length >= NUMBER_OF_ERROR_BYTES)
		{
		length = NUMBER_OF_ERROR_BYTES;
		}

	memcpy (&frame_relay.port[port_number].last_error_packet.frErrData[0], sptr_data, (USHORT) length);

	frame_relay.port[port_number].last_error_packet.length = (BYTE) length;
}
/****************************************************************************/
void set_frame_relay_snmp_trap_function (void (*fptr_snmp_trap_function) (ULONG index,USHORT dlci,enum FR_CIRCUIT_STATE state))
{
	frame_relay.fptr_snmp_trap_function = fptr_snmp_trap_function;
}
/****************************************************************************/
void set_frame_relay_snmp_alarm_function (void (*fptr_alarm_function) (enum FRAME_RELAY_ALARM_TYPE error_type,
	USHORT port_number,ULONG parameter_1,ULONG parameter_2))
{
	frame_relay.fptr_alarm_function = fptr_alarm_function;
}
