#include	"defs.h"

/************************************************************************/
#include <stdlib.h>
#include "fr.h"

#ifdef DLCI_STATS
/****************************************************************************/
void clear_dlci_stats (USHORT dlci)
{
	DLCI_LIST_ENTRY *sptr_matching_entry;

	if ((sptr_matching_entry = get_dlci_connection_entry (0,dlci)) == NULL)
		return;

	sptr_matching_entry->mib.frCircuitReceivedBECNs = 0;
	sptr_matching_entry->mib.frCircuitReceivedFECNs = 0;

	sptr_matching_entry->dlci_down_count = 0;
	sptr_matching_entry->dlci_uptime = 0;

	memset (&sptr_matching_entry->bytes_sent, (int)NULL, sizeof(DLCI_TRAFFIC));
	memset (&sptr_matching_entry->frames_sent, (int)NULL, sizeof(DLCI_TRAFFIC));
	memset (&sptr_matching_entry->bytes_received, (int)NULL, sizeof(DLCI_TRAFFIC));
	memset (&sptr_matching_entry->frames_received, (int)NULL, sizeof(DLCI_TRAFFIC));
}

/****************************************************************************/
int get_dlci_stats (USHORT dlci, BYTE *buf)
{
	DLCI_LIST_ENTRY *sptr_matching_entry;
	DLCI_STATISTICS *dlci_stats;

	sptr_matching_entry = get_dlci_connection_entry (0,dlci);
	if (sptr_matching_entry == NULL)
		return (0);

	dlci_stats = (DLCI_STATISTICS *)buf;

	dlci_stats->dlci = dlci;
	dlci_stats->dlci_state = (sptr_matching_entry->mib.frCircuitState == ACTIVE_FRAME_RELAY_CIRCUIT_STATE) ? 1 : 0;

#if 0
	dlci_stats->thruput = calculate_thruput (sptr_matching_entry);
#else
	dlci_stats->thruput = sptr_matching_entry->thruput;
#endif

	dlci_stats->BECNS_received = sptr_matching_entry->mib.frCircuitReceivedBECNs;
	dlci_stats->FECNS_received = sptr_matching_entry->mib.frCircuitReceivedFECNs;

	dlci_stats->dlci_down_count = sptr_matching_entry->dlci_down_count;
	dlci_stats->dlci_uptime = sptr_matching_entry->dlci_uptime;

	dlci_stats->bytes_sent = sptr_matching_entry->bytes_sent;
	dlci_stats->frames_sent = sptr_matching_entry->frames_sent;

	dlci_stats->bytes_received = sptr_matching_entry->bytes_received;
	dlci_stats->frames_received = sptr_matching_entry->frames_received;

	return (sizeof(DLCI_STATISTICS));
}
#endif

/****************************************************************************/
void update_dlci_uptime (void)
{
	USHORT pvc_index = 0;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;

	sptr_current_connection_entry = (DLCI_LIST_ENTRY *) frame_relay.port[0].dlci_list.sptr_forward_link;

	while (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS && sptr_current_connection_entry != NULL)
	{
		if (sptr_current_connection_entry->mib.frCircuitState == ACTIVE_FRAME_RELAY_CIRCUIT_STATE) {
			sptr_current_connection_entry->dlci_uptime++;
#ifdef DLCI_STATS
			update_thruput (sptr_current_connection_entry);
#endif
		}

		++pvc_index;
		sptr_current_connection_entry	= sptr_current_connection_entry->links.sptr_forward_link;
	}
}

#ifdef DLCI_STATS
/****************************************************************************/
ULONG calculate_thruput (DLCI_LIST_ENTRY *sptr_dlci_entry)
{
	ULONG		total;

	if (sptr_dlci_entry->dlci_uptime <= 0)
		return (0);

	total = sptr_dlci_entry->bytes_sent.IP_data +
				sptr_dlci_entry->bytes_sent.IPX_data +
				sptr_dlci_entry->bytes_sent.STP_data +
				sptr_dlci_entry->bytes_sent.Channel_1_data +
				sptr_dlci_entry->bytes_sent.Channel_2_data +
				sptr_dlci_entry->bytes_sent.Other_data;

	return (total / sptr_dlci_entry->dlci_uptime);
}

/****************************************************************************/
void update_thruput (DLCI_LIST_ENTRY *sptr_dlci_entry)
{
	ULONG		total;

	total = sptr_dlci_entry->bytes_sent.IP_data +
				sptr_dlci_entry->bytes_sent.IPX_data +
				sptr_dlci_entry->bytes_sent.STP_data +
				sptr_dlci_entry->bytes_sent.Channel_1_data +
				sptr_dlci_entry->bytes_sent.Channel_2_data +
				sptr_dlci_entry->bytes_sent.Other_data;

	sptr_dlci_entry->thruput = total - sptr_dlci_entry->bytes_sent_till_last_sec;
	sptr_dlci_entry->bytes_sent_till_last_sec = total;
}

/****************************************************************************/
int get_management_stats (BYTE *buffer)
{
	MANAGEMENT_STATISTICS *mgmt_stats;

	mgmt_stats = (MANAGEMENT_STATISTICS *)buffer;

	mgmt_stats->management_type = frame_relay.port[0].management_type;

	if (mgmt_stats->management_type == LMI_MGMT_TYPE) {
		mgmt_stats->status_enquiries_sent =
			frame_relay.port[0].lmi.statistics.stats.number_of_status_enquiries;
		mgmt_stats->status_responses_received =
			frame_relay.port[0].lmi.statistics.stats.number_of_status_responses;
		mgmt_stats->full_status_enquiries_sent =
			frame_relay.port[0].lmi.statistics.stats.number_of_full_status_enquiries;
		mgmt_stats->full_status_responses_received =
			frame_relay.port[0].lmi.statistics.stats.number_of_full_status_responses;

		mgmt_stats->number_of_missed_status_responses =
			frame_relay.port[0].lmi.statistics.number_of_missed_status_response_messages;
		mgmt_stats->number_of_sequence_number_errors =
			frame_relay.port[0].lmi.statistics.number_of_sequence_number_errors;

		mgmt_stats->number_of_link_ups = frame_relay.port[0].lmi.statistics.number_of_link_ups;
		mgmt_stats->number_of_link_downs = frame_relay.port[0].lmi.statistics.number_of_link_downs;
	}
	else {
		mgmt_stats->status_enquiries_sent =
			frame_relay.port[0].annex_d.statistics.tx.number_of_liv_status_enquiries;
		mgmt_stats->status_responses_received =
			frame_relay.port[0].annex_d.statistics.rx.number_of_liv_status_responses;
		mgmt_stats->full_status_enquiries_sent =
			frame_relay.port[0].annex_d.statistics.tx.number_of_full_status_enquiries;
		mgmt_stats->full_status_responses_received =
			frame_relay.port[0].annex_d.statistics.rx.number_of_full_status_responses;

		mgmt_stats->number_of_missed_status_responses =
			frame_relay.port[0].annex_d.statistics.number_of_missed_status_response_messages;
		mgmt_stats->number_of_sequence_number_errors =
			frame_relay.port[0].annex_d.statistics.number_of_sequence_number_errors;

		mgmt_stats->number_of_link_ups = frame_relay.port[0].annex_d.statistics.number_of_link_ups;		  
		mgmt_stats->number_of_link_downs = frame_relay.port[0].annex_d.statistics.number_of_link_downs;		  
	}

	return (sizeof(MANAGEMENT_STATISTICS));
}

#endif
