;     21/july/97 Chetan made the initialization of IVT using the VBR
;		contents. See the comments NEW_BOOT.
; 		Thus old assumptions of VBR are made away now
;     Also Boot Mode locations in DPRAM and DRAM are added

RX_BUF_SIZE	EQU	$0600	; Max Buffer Size = 1520 bytes
SCC1VEC 	EQU	$1e		; Vector for SCC1 (5 bits)
URT1VEC 	EQU	$1d		; Vector for URT1 (5 bits)
URT2VEC 	EQU	$1c		; Vector for URT2 (5 bits)
URT3VEC 	EQU	$1b		; Vector for URT2 (5 bits)

MAX_NO_RX_BD	equ	$8
MAX_NO_TX_BD	equ	$4

ETH_NO_RX_BD	equ	$8
ETH_NO_TX_BD	equ	$4

ASYNC_HDLC_NO_RX_BD	equ	$8
ASYNC_HDLC_NO_TX_BD	equ	$4

SYNC_WAN_NO_RX_BD	equ	$8
SYNC_WAN_NO_TX_BD	equ	$4

; the ASYNC HDLC micro code is to be located from DPRBASE+0 till DPRBASE+400h
; also the DPRBASE+600h to DPRBASE+6ffh is not to be used for it is the
; micro code scratch. So all the buffer descriptors for the different SCC's are 
; to be located within the boundary DPRBASE+400 to DPRBASE+5ff. SMC port 
; requires one rxbd and one txbd. the SCC BD's are located after this.
; maximum of only 64 bd's can be allocated.

SccBufferDescs	EQU	ModBaseAdr+$400

SMC1RxBD		equ	SccBufferDescs
SMC1TxBD		equ	SccBufferDescs+$10

OFFSETSMC1RXBD	equ	SMC1RxBD-ModBaseAdr
OFFSETSMC1TXBD	equ	SMC1TxBD-ModBaseAdr

OFFSETSCC1RXBD	EQU	OFFSETSMC1TXBD+8

OFFSETSCC1TXBD	EQU	OFFSETSCC1RXBD+8*MAX_NO_RX_BD	;50	

OFFSETWAN1RXBD	EQU	OFFSETSCC1TXBD+8*MAX_NO_TX_BD 	;70
OFFSETWAN1TXBD	EQU	OFFSETWAN1RXBD+8*MAX_NO_RX_BD 	;B0

OFFSETWAN2RXBD	EQU	OFFSETWAN1TXBD+8*MAX_NO_TX_BD 	;D0
OFFSETWAN2TXBD	EQU	OFFSETWAN2RXBD+8*MAX_NO_RX_BD 	;110

OFFSETWAN3RXBD	EQU	OFFSETWAN2TXBD+8*MAX_NO_TX_BD 	;130
OFFSETWAN3TXBD	EQU	OFFSETWAN3RXBD+8*MAX_NO_RX_BD 	;170

WAN_RX_BUF_SIZE	EQU	3200		; Max Buffer Size = 3k bytes

SCC1RXBD	EQU	ModBaseAdr+OFFSETSCC1RXBD
SCC1TXBD	EQU	ModBaseAdr+OFFSETSCC1TXBD

WAN1RXBD	EQU	ModBaseAdr+OFFSETWAN1RXBD
WAN1TXBD	EQU	ModBaseAdr+OFFSETWAN1TXBD

WAN2RXBD	EQU	ModBaseAdr+OFFSETWAN2RXBD
WAN2TXBD	EQU	ModBaseAdr+OFFSETWAN2TXBD

WAN3RXBD	EQU	ModBaseAdr+OFFSETWAN3RXBD
WAN3TXBD	EQU	ModBaseAdr+OFFSETWAN3TXBD

; Kamalnath SLIP 14\03\1997 
PPP_DELIMITER	 	EQU		$7E
SLIP_DELIMITER		EQU		$C0
; Kamalnath SLIP 14\03\1997
SAFE_LEVEL			EQU		7


; NEW_BOOT
;SCC2VECOFFSET	equ	$100274	
;SCC3VECOFFSET	equ	$100270
;SCC4VECOFFSET	equ	$10026c
; NEW_BOOT
OFFSETBOOTMODELOC	EQU OFFSETWAN3TXBD+8*MAX_NO_TX_BD 	;190
BootModeLocationInDPRAM EQU ModBaseAdr+OFFSETBOOTMODELOC-8
BootModeLocationInSIMMDRAM EQU $1C10

