/* $modname: bsdcomp.h$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
/*
** Following are structures, macros, and function prototypes required by the BSD LzW Compression algorithm 
** implementation. They are derived from the 4.3BSD compress source and please refer to bsdcomp.c for 
** copyright information.
*/
typedef struct HASH_VALUE_STRUCTURE
{
#ifdef BIG_ENDIAN
	BYTE		padding;
	BYTE		last_character_of_new_code;
	USHORT	preceding_code;       		
#else
	USHORT 	preceding_code;       		
	BYTE		last_character_of_new_code;
	BYTE		padding;
#endif
} HASH_VALUE_STRUCTURE;

typedef union UNION_HASH_VALUE
{
	ULONG						hash_value_code;
	HASH_VALUE_STRUCTURE	hash_value_structure;
} UNION_HASH_VALUE;

typedef struct BSD_COMPRESSION_DICTIONARY
{
	UNION_HASH_VALUE	union_hash_value;
	USHORT				output_of_hash_table_minus_one;
	USHORT				code_to_hash_table_entry;      
} BSD_COMPRESSION_DICTIONARY;

typedef struct BSD_COMPRESSION_DATABASE 
{
	BYTE  	hash_table_shift_value;      
	BYTE  	current_bits_or_code;        
	
	USHORT  	real_port_number;
	USHORT	sequence_number;        	  
	USHORT	*lengths_of_codes;           
	
	ULONG   	total_length_of_database;    
	ULONG 	hash_table_size;       		  
	ULONG 	largest_valid_code;  		  
	ULONG 	largest_code_in_use;     	  
	ULONG 	number_of_uncompressed_bytes;
	ULONG 	number_of_compressed_bytes;  
	ULONG 	recent_compression_ratio;    
	ULONG 	ratio_check_point;  
	ULONG   	number_of_incompressible_packets; 
	ULONG   	number_of_packets_decompressed; 
	
	int   	number_of_times_the_dictionary_get_cleared; 
	
	BSD_COMPRESSION_DICTIONARY	dictionary[1];
} BSD_COMPRESSION_DATABASE;

#define MINIMUM_BSD_BITS	9
#define BSD_INITIAL_BITS	MINIMUM_BSD_BITS
#define MAXIMUM_BSD_BITS	15

/* the next two codes should not be changed lightly, as they must not lie within the contiguous general code space. */
#define CLEAR_CODE	256         /* table clear output code */
#define FIRST_CODE	257         /* first free entry */
#define LAST_CODE		255

#define MAXIMUM_CODE(b) ((1 << (b)) - 1)

#define BAD_CODE_MINUS_ONE MAXIMUM_CODE(MAXIMUM_BSD_BITS);

#define BSD_HASH(preceding_code, last_character_of_new_code, hash_table_shift_value) \
	((((ULONG)(last_character_of_new_code)) << (hash_table_shift_value)) ^ (ULONG) (preceding_code))

#define BSD_KEY(preceding_code, last_character_of_new_code) \
	((((ULONG) (last_character_of_new_code)) << 16) + (ULONG) (preceding_code))

#define CHECK_GAP 		10000 	/* Ratio check interval */
#define RATIO_SCALE_LOG	8
#define RATIO_SCALE		(1 << RATIO_SCALE_LOG)
#define MAXIMUM_RATIO	(0x7fffffff >> RATIO_SCALE_LOG)

/* bsdcomp.c */

void BSD_clear_database (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database);
BSD_COMPRESSION_DATABASE *create_and_initialize_BSD_compression_database (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database, 
	USHORT unit, USHORT largest_code_size_used);

USHORT BSD_compress (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database, BYTE *bptr_data_to_be_compressed,
	BYTE *bptr_buffer_to_compress_to, USHORT length_of_data_to_be_compressed);
void	BSD_compress_incompressible_data (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database, 
	BYTE *bptr_incompressible_data, USHORT incompressible_data_length);
USHORT BSD_decompress (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database, BYTE *bptr_BSD_compression_packet,
	BYTE *bptr_current_write_position, USHORT BSD_compression_packet_length);
