#include	".\defs.h"
/* $modname: ccpbsd.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "ccp.h"
/*************************************************************************/
static UNION_PPP_PACKET *BSD_decompress_compressed_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length);
static void free_compressed_ppp_packet (USHORT port_number, void *vptr_buffer);
static BYTE *adjust_compression_pointer_and_length (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, 
	USHORT *usptr_length_of_data_to_be_compressed, USHORT *usptr_ppp_packet_length);
static PPP_PACKET_WITH_MAC_HEADER *prepare_a_ppp_send_packet (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet,
	USHORT length_of_data_to_be_compressed);
static enum TEST check_sequence_number (USHORT real_port_number, BSD_COMPRESSION_PACKET* sptr_BSD_compression_packet); 
static PPP_PACKET_WITH_MAC_HEADER *prepare_a_ppp_receive_packet (USHORT real_port_number, USHORT BSD_compressed_data_length);
static void adjust_decompressed_packet_with_uncompressed_protocol_field	(BYTE *bptr_ppp_protocol_type_field, 
	USHORT *usptr_ppp_packet_length, USHORT decompressed_data_length);

/* sudha 30 Jan 1999 */
extern void *ccp_device_driver_malloc (unsigned short real_port_number, unsigned long device_driver_id, unsigned short buffer_length) ;

/*************************************************************************/
PPP_PACKET_WITH_MAC_HEADER *BSD_compress_ppp (USHORT real_port_number,USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	BYTE *bptr_data_to_be_compressed;
	PPP_PACKET_WITH_MAC_HEADER *sptr_compressed_ppp_packet;
	BSD_COMPRESSION_PACKET *sptr_BSD_compression_packet;
	USHORT length_of_data_to_be_compressed;
	USHORT length_of_data_compressed;
	USHORT BSD_compression_packet_length;
	
	if ((net_to_host_short (sptr_ppp_packet->header.protocol_type) < 0x0000) ||		/* Only packets with PPP protocol numbers	*/ 
		(net_to_host_short (sptr_ppp_packet->header.protocol_type) > 0x3fff) ||			/* in the range 0x0000 to 0x3fff and		*/
		(sptr_ppp_packet->header.protocol_type == FIRST_CHOICE_COMPRESSION_PROTOCOL)) /* neither 0xfd nor 0xfb are compressed	*/
		{
		return (sptr_ppp_packet);
		}
	
	bptr_data_to_be_compressed = adjust_compression_pointer_and_length (sptr_ppp_packet, &length_of_data_to_be_compressed,
		usptr_ppp_packet_length);
	
	sptr_compressed_ppp_packet = prepare_a_ppp_send_packet (sptr_ppp_packet, length_of_data_to_be_compressed);

	if (sptr_compressed_ppp_packet == NULL)
		{
		return (NULL);
		}
	
	sptr_BSD_compression_packet = (BSD_COMPRESSION_PACKET *) sptr_compressed_ppp_packet->protocol_data;	

	sptr_BSD_compression_packet->sequence_number = 
		host_to_net_short (ccp.ports[real_port_number].BSD.sptr_sender_compression_database->sequence_number);

	ccp.ports[real_port_number].BSD.sptr_sender_compression_database->sequence_number++;

	length_of_data_compressed = BSD_compress (ccp.ports[real_port_number].BSD.sptr_sender_compression_database, 
		bptr_data_to_be_compressed, sptr_BSD_compression_packet->data, length_of_data_to_be_compressed);
	
	BSD_compression_packet_length = (USHORT) (length_of_data_compressed + SIZE_OF_BSD_LZW_SEQUENCE_NUMBER);
	
	if (length_of_data_compressed > length_of_data_to_be_compressed)	/* data expansion detected */
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: Data Expansion Detected on Port %04x, Ratio(Source/Compressed) = %d/%d\n", 
			real_port_number, length_of_data_to_be_compressed,	length_of_data_compressed);
		
		buffer_free ((void *) sptr_compressed_ppp_packet);
		
		return (sptr_ppp_packet);
		}
	else
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: PPP Packet Compressed on Port %04x, Ratio(Source/Compressed) = %d/%d\n", 
			real_port_number, length_of_data_to_be_compressed,	length_of_data_compressed);
				
		/* we've done with the original PPP packet, so we return the buffer */
		return_buffer (real_port_number, protocol_virtual_port_number, *eptr_device_driver_buffer, 
			sptr_ppp_packet, *ptr_fptr_tx_completion);
		
		*eptr_device_driver_buffer = FALSE;

		/* the newly constructed packet will be freed by our own tx_completion function */
		*ptr_fptr_tx_completion = free_compressed_ppp_packet;	
		
		*usptr_ppp_packet_length = (USHORT) (sizeof (PPP_HEADER) + BSD_compression_packet_length);
		
		return (sptr_compressed_ppp_packet);
		}
}
/*************************************************************************/
static BYTE *adjust_compression_pointer_and_length (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, 
	USHORT *usptr_length_of_data_to_be_compressed, USHORT *usptr_ppp_packet_length)
{
	BYTE *bptr_data_to_be_compressed;

	if	((sptr_ppp_packet->header.protocol_type & BIG_ENDIAN_CONSTANT (0xff00)) != 0x0000)
		{	
		/* PPP protocol field is not compressible	*/
		bptr_data_to_be_compressed = (BYTE *) &(sptr_ppp_packet->header) + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS;
		*usptr_length_of_data_to_be_compressed = (USHORT) (*usptr_ppp_packet_length - SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
		}
	else
		{
		bptr_data_to_be_compressed = (BYTE *) &(sptr_ppp_packet->header) + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + 
			HALF_SIZE_OF_PPP_PROTOCOL_FIELD;
		
		*usptr_length_of_data_to_be_compressed = (USHORT) (*usptr_ppp_packet_length - SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS - 
			HALF_SIZE_OF_PPP_PROTOCOL_FIELD);
		}

	return (bptr_data_to_be_compressed);
}
/*************************************************************************/
static PPP_PACKET_WITH_MAC_HEADER *prepare_a_ppp_send_packet (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet,
	USHORT length_of_data_to_be_compressed)
{
	PPP_PACKET_WITH_MAC_HEADER *sptr_compressed_ppp_packet;
	USHORT longest_possible_compressed_data_length;
	USHORT longest_possible_ppp_encapsulated_BSD_compression_packet_length;
	
	longest_possible_compressed_data_length = (USHORT) (length_of_data_to_be_compressed * (1 + BSD_LZW_MAXIMUM_EXPANSION_RATIO));
	
	longest_possible_ppp_encapsulated_BSD_compression_packet_length = (USHORT) (sizeof (PPP_PACKET_WITH_MAC_HEADER) 
		- VARIABLE_NUMBER_OF_BYTES + sizeof (BSD_COMPRESSION_PACKET) - VARIABLE_NUMBER_OF_BYTES + 
		longest_possible_compressed_data_length);
	
	sptr_compressed_ppp_packet = 
		(PPP_PACKET_WITH_MAC_HEADER *) buffer_malloc (longest_possible_ppp_encapsulated_BSD_compression_packet_length);
	
	if (sptr_compressed_ppp_packet == NULL)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:BSD LZW: prepare_a_ppp_send_packet () buffer_malloc () failed\n");

		return (NULL);
		}
	
	memcpy ((void *) sptr_compressed_ppp_packet, 
		(void *) sptr_ppp_packet, SIZE_OF_MAC_HEADER + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
	
	sptr_compressed_ppp_packet->header.protocol_type = FIRST_CHOICE_COMPRESSION_PROTOCOL;

	return (sptr_compressed_ppp_packet);
}
/*************************************************************************/
UNION_PPP_PACKET *BSD_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length)
{
	UNION_PPP_PACKET *sptr_decompressed_ppp_packet;

	if (uptr_ppp_packet->generic.header.protocol_type == FIRST_CHOICE_COMPRESSION_PROTOCOL)
		{
		if (ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack == TRUE)
			{
			send_ccp_reset_request (real_port_number);
			
			return (NULL);
			}
		
		sptr_decompressed_ppp_packet = 
			BSD_decompress_compressed_ppp (real_port_number, uptr_ppp_packet, usptr_ppp_packet_length);

		return (sptr_decompressed_ppp_packet);
		}
	else if ((net_to_host_short (uptr_ppp_packet->generic.header.protocol_type) >= 0x0000) && 
		(net_to_host_short (uptr_ppp_packet->generic.header.protocol_type) <= 0x3fff))
		{
		/*	It is assumed that this packet would have caused expansion if compressed. It will be locally compressed
			to update the compression history */
		
		if (ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack == TRUE)
			{
			send_ccp_reset_request (real_port_number);
			
			return (NULL);
			}
		
		if	((uptr_ppp_packet->generic.header.protocol_type & BIG_ENDIAN_CONSTANT (0xff00)) != 0x0000)
			{
			BSD_compress_incompressible_data (ccp.ports[real_port_number].BSD.sptr_receiver_compression_database, 
				(BYTE *) uptr_ppp_packet + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS, 
				(USHORT) (*usptr_ppp_packet_length - SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS));
			}
		else
			{
			BSD_compress_incompressible_data (ccp.ports[real_port_number].BSD.sptr_receiver_compression_database, 
				(BYTE *) uptr_ppp_packet + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + HALF_SIZE_OF_PPP_PROTOCOL_FIELD, 
				(USHORT) (*usptr_ppp_packet_length - SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS - HALF_SIZE_OF_PPP_PROTOCOL_FIELD));
			}
		
		ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: PPP Packet Locally Compressed to Update Compression History on Port %04x\n",
			real_port_number);
		
		return (uptr_ppp_packet); 
		}
	else
		{
		return (uptr_ppp_packet);
		}
}
/*************************************************************************/
static UNION_PPP_PACKET *BSD_decompress_compressed_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length)
{
	BSD_COMPRESSION_PACKET* sptr_BSD_compression_packet;
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	BYTE *bptr_ppp_protocol_type_field;
	USHORT BSD_compression_packet_length;
	USHORT BSD_compressed_data_length;
	USHORT decompressed_data_length;
	ULONG device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);

	sptr_BSD_compression_packet = (BSD_COMPRESSION_PACKET *) ((BYTE *) uptr_ppp_packet + sizeof (PPP_HEADER));
	
	if (check_sequence_number (real_port_number, sptr_BSD_compression_packet) == FAIL)
		{
		return (NULL); 
		}

	BSD_compression_packet_length = (USHORT) (*usptr_ppp_packet_length - sizeof (PPP_HEADER));
	
	BSD_compressed_data_length = (USHORT) (BSD_compression_packet_length - SIZE_OF_BSD_LZW_SEQUENCE_NUMBER);

	sptr_decompressed_ppp_packet = prepare_a_ppp_receive_packet (real_port_number, BSD_compressed_data_length);

	if (sptr_decompressed_ppp_packet == NULL)
		{
		return (NULL);
		}
	
	bptr_ppp_protocol_type_field = (BYTE *) (&(sptr_decompressed_ppp_packet->header)) + 
		SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + HALF_SIZE_OF_PPP_PROTOCOL_FIELD;

	decompressed_data_length = BSD_decompress (ccp.ports[real_port_number].BSD.sptr_receiver_compression_database, 
		sptr_BSD_compression_packet->data, bptr_ppp_protocol_type_field, BSD_compressed_data_length);

	if (decompressed_data_length == 0x0000)
		{
/* Sachin 17/06/1997 */
#if 0
		device_driver_free (real_port_number, device_driver_id, sptr_decompressed_ppp_packet);
#endif
		ccp_device_driver_free (real_port_number, device_driver_id, sptr_decompressed_ppp_packet);
/* Sachin 17/06/1997 */

		send_ccp_reset_request (real_port_number);

		ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack = TRUE;
		
		return (NULL);
		}
	
	ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: PPP Packet Decompressed on Port %04x, Ratio (Compressed/Source) = %d/%d\n",
		real_port_number, BSD_compressed_data_length, decompressed_data_length);
	
	adjust_decompressed_packet_with_uncompressed_protocol_field	(bptr_ppp_protocol_type_field, usptr_ppp_packet_length, 
		decompressed_data_length);
	
	/* now that we are done with the original PPP packet, we free it. */
#if 0
	device_driver_free (real_port_number, device_driver_id, (void *) uptr_ppp_packet);
#endif
/* Sachin 17/06/1997 */
	ccp_device_driver_free (real_port_number, device_driver_id, (void *) uptr_ppp_packet);
/* Sachin 17/06/1997 */

#if 0
/* Sachin 17/06/1997 */
   ccp_preallocate_buffer (real_port_number) ;
/* Sachin 17/06/1997 */
#endif
	
	return ((UNION_PPP_PACKET *) &(sptr_decompressed_ppp_packet->header));
}
/*************************************************************************/
static enum TEST check_sequence_number (USHORT real_port_number, BSD_COMPRESSION_PACKET* sptr_BSD_compression_packet) 
{
	USHORT sequence_number_received;

	sequence_number_received = net_to_host_short (sptr_BSD_compression_packet->sequence_number);

	if (sequence_number_received != ccp.ports[real_port_number].BSD.sptr_receiver_compression_database->sequence_number)
		{
		ccp_printf (CCP_ALARM_PRINTF,
			"CCP:BSD LZW: Incorrect Sequence Number %d Instead of %d Received on Port: %04x\n", sequence_number_received, 
			ccp.ports[real_port_number].BSD.sptr_receiver_compression_database->sequence_number, real_port_number);
		
		send_ccp_reset_request (real_port_number);

		ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack = TRUE;
		
		return (FAIL);
		}
	
	++ccp.ports[real_port_number].BSD.sptr_receiver_compression_database->sequence_number;
	
	return (PASS);
}
/*************************************************************************/
static PPP_PACKET_WITH_MAC_HEADER *prepare_a_ppp_receive_packet (USHORT real_port_number, USHORT BSD_compressed_data_length)
{
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	USHORT longest_possible_decompressed_data_length;
	USHORT decompressed_ppp_packet_length;
	ULONG device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);
	
	longest_possible_decompressed_data_length = (USHORT) (BSD_compressed_data_length * BSD_LZW_MAXIMUM_COMPRESSION_RATIO);
	
	decompressed_ppp_packet_length = (USHORT) (SIZE_OF_MAC_HEADER + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + 
		HALF_SIZE_OF_PPP_PROTOCOL_FIELD + longest_possible_decompressed_data_length);
	
/* Chidanand	- PPP Dial Backup  - 1st October 1996 */
	if (decompressed_ppp_packet_length > 2000)
		decompressed_ppp_packet_length = 2000;
/* Chidanand	- PPP Dial Backup  - 1st October 1996 */	

/* Sachin 17/06/1997 */
#if 0
	sptr_decompressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) device_driver_malloc (real_port_number, 
			device_driver_id, decompressed_ppp_packet_length);
#endif
	sptr_decompressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) ccp_device_driver_malloc (real_port_number, 
			device_driver_id, decompressed_ppp_packet_length);
/* Sachin 17/06/1997 */

	if (sptr_decompressed_ppp_packet == NULL)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:BSD LZW: prepare_a_ppp_receive_packet () device_driver_malloc () failed\n");
		
		return (NULL);
		}

	sptr_decompressed_ppp_packet->header.hdlc_address = HDLC_ADDRESS;
	sptr_decompressed_ppp_packet->header.hdlc_control = UNNUMBERED_INFORMATION;
	
	return (sptr_decompressed_ppp_packet);
}
/*************************************************************************/
static void adjust_decompressed_packet_with_uncompressed_protocol_field	(BYTE *bptr_ppp_protocol_type_field, 
	USHORT *usptr_ppp_packet_length, USHORT decompressed_data_length)
{
	if (*bptr_ppp_protocol_type_field & '\x01'== 0x00)
		{
		memmove ((void *) (bptr_ppp_protocol_type_field - 1), (void *) bptr_ppp_protocol_type_field, decompressed_data_length);
		
		*usptr_ppp_packet_length = (USHORT) (decompressed_data_length + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
		}
	else
		{
		*(bptr_ppp_protocol_type_field - 1) = '\0';
		
		*usptr_ppp_packet_length = 
			(USHORT) (decompressed_data_length + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + HALF_SIZE_OF_PPP_PROTOCOL_FIELD);
		}
}
/*************************************************************************/
static void free_compressed_ppp_packet (USHORT port_number, void *vptr_buffer)
{
	PARAMETER_NOT_USED (port_number);
	
	buffer_free ((void *) vptr_buffer); 
}

