#include	".\defs.h"
/* $modname: ccppred1.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "ccp.h"
/*************************************************************************/
static USHORT compress_ppp_and_fill_predictor_type_I_packet (USHORT real_port_number, BYTE *bptr_source_data, 
	USHORT source_data_length, PREDICTOR_TYPE_I_PACKET *sptr_predictor_type_I_packet);
static void predictor_type_I_free_compressed_ppp_packet (USHORT port_number, void *vptr_buffer);
static UNION_PPP_PACKET *predictor_type_I_decompress_uncompressed_ppp (USHORT real_port_number, 
	PREDICTOR_TYPE_I_PACKET* sptr_predictor_type_I_packet, UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length);
static UNION_PPP_PACKET *predictor_type_I_decompress_compressed_ppp (USHORT real_port_number, 
	PREDICTOR_TYPE_I_PACKET* sptr_predictor_type_I_packet, UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length);
static PPP_PACKET_WITH_MAC_HEADER *predictor_type_I_prepare_a_ppp_receive_packet (USHORT real_port_number, 
	PREDICTOR_TYPE_I_PACKET* sptr_predictor_type_I_packet);

extern	USHORT compress_uncompressible_predictor_type_data (USHORT real_port_number, BYTE *bptr_source, BYTE *bptr_destination, USHORT source_length);
/*************************************************************************/
static USHORT compress_ppp_and_fill_predictor_type_I_packet (USHORT real_port_number, BYTE *bptr_source_data, 
	USHORT source_data_length, PREDICTOR_TYPE_I_PACKET *sptr_predictor_type_I_packet)
{
	USHORT actual_compressed_data_length;
	USHORT original_data_checksum;
	USHORT predictor_type_I_packet_length;

	actual_compressed_data_length = compress (real_port_number, bptr_source_data, sptr_predictor_type_I_packet->compressed_data, 
		source_data_length);
	
	if (actual_compressed_data_length > source_data_length)
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP:Predictor: Data Expansion Detected on Port %04x, Source Data Not Compressed\n",
			real_port_number);

		sptr_predictor_type_I_packet->compression_flag_and_length.compression_flag = UNCOMPRESSED;
		
		sptr_predictor_type_I_packet->compression_flag_and_length.compressed_data_length = source_data_length;

		memcpy ((void *) sptr_predictor_type_I_packet->compressed_data, bptr_source_data, source_data_length);
		
		actual_compressed_data_length = source_data_length;
		}
	else
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP:Predictor: PPP Packet Compressed on Port %04x, Ratio(Source/Compressed) = %d/%d\n",
			real_port_number, source_data_length, actual_compressed_data_length);

		sptr_predictor_type_I_packet->compression_flag_and_length.compression_flag = COMPRESSED;
		
		sptr_predictor_type_I_packet->compression_flag_and_length.compressed_data_length = actual_compressed_data_length;
		}
	
	original_data_checksum = calculate_frame_check_sequence (INIT_FRAME_CHECK_SEQUENCE, bptr_source_data, source_data_length);
	
	original_data_checksum = (USHORT) ~original_data_checksum;

	predictor_type_I_packet_length = (USHORT) (SIZE_OF_PREDICTOR_COMPRESSION_FLAG_AND_LENGTH + 
		actual_compressed_data_length + SIZE_OF_WAN_CRC );

	((BYTE *) sptr_predictor_type_I_packet->compressed_data)[actual_compressed_data_length] = 
		(BYTE) (0x00ff & original_data_checksum);
	((BYTE *) sptr_predictor_type_I_packet->compressed_data)[actual_compressed_data_length + 1] = 
		(BYTE) (0x00ff & (original_data_checksum >> 8));

	swap_in_place ((USHORT *) sptr_predictor_type_I_packet);	/* turn the 2-byte bit field structure into network order */

	return (predictor_type_I_packet_length);
}
/*************************************************************************/
PPP_PACKET_WITH_MAC_HEADER *predictor_type_I_compress_ppp (USHORT real_port_number,USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	BYTE *bptr_data_to_be_compressed;
	PPP_PACKET_WITH_MAC_HEADER *sptr_compressed_ppp_packet;
	USHORT length_of_data_to_be_compressed;
	USHORT predictor_type_I_packet_length;
	USHORT longest_possible_compressed_data_length;
	USHORT longest_possible_compressed_ppp_packet_length;
	
	bptr_data_to_be_compressed = (BYTE *) &(sptr_ppp_packet->header) + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS;
	length_of_data_to_be_compressed = (USHORT) (*usptr_ppp_packet_length - SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
	
	longest_possible_compressed_data_length = (USHORT) (length_of_data_to_be_compressed / 8 * 9 + 9);
	
	longest_possible_compressed_ppp_packet_length = (USHORT) (sizeof (PPP_PACKET_WITH_MAC_HEADER) - VARIABLE_NUMBER_OF_BYTES +
		SIZE_OF_PREDICTOR_COMPRESSION_FLAG_AND_LENGTH + longest_possible_compressed_data_length + SIZE_OF_WAN_CRC);
	
	sptr_compressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) buffer_malloc (longest_possible_compressed_ppp_packet_length);
	
	if (sptr_compressed_ppp_packet == NULL)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:Predictor: predictor_type_I_compress_ppp () buffer_malloc () failed\n");

		return (NULL);
		}
	
	memcpy ((void *) sptr_compressed_ppp_packet, (void *) sptr_ppp_packet, 
		SIZE_OF_MAC_HEADER + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
	
	sptr_compressed_ppp_packet->header.protocol_type = FIRST_CHOICE_COMPRESSION_PROTOCOL;
	
	predictor_type_I_packet_length = compress_ppp_and_fill_predictor_type_I_packet (real_port_number, bptr_data_to_be_compressed, 
		length_of_data_to_be_compressed, (PREDICTOR_TYPE_I_PACKET *) sptr_compressed_ppp_packet->protocol_data);

	/* we've done with the original PPP packet, so we return the buffer */
	return_buffer (real_port_number, protocol_virtual_port_number, *eptr_device_driver_buffer, 
		sptr_ppp_packet, *ptr_fptr_tx_completion);

	*eptr_device_driver_buffer = FALSE;
	
	/* the newly constructed packet will be freed by our own tx_completion function */
	*ptr_fptr_tx_completion = predictor_type_I_free_compressed_ppp_packet;	
	
	*usptr_ppp_packet_length = (USHORT) (sizeof (PPP_HEADER) + predictor_type_I_packet_length);
	
	return (sptr_compressed_ppp_packet);
}
/*************************************************************************/
UNION_PPP_PACKET *predictor_type_I_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length)
{
	PREDICTOR_TYPE_I_PACKET* sptr_predictor_type_I_packet;
	UNION_PPP_PACKET *sptr_decompressed_ppp_packet;
	UNION_PPP_PACKET *sptr_restored_ppp_packet;

	if (uptr_ppp_packet->generic.header.protocol_type == FIRST_CHOICE_COMPRESSION_PROTOCOL)
		{
		sptr_predictor_type_I_packet = (PREDICTOR_TYPE_I_PACKET *) ((BYTE *) uptr_ppp_packet + sizeof (PPP_HEADER));
		
		swap_in_place ((USHORT *) sptr_predictor_type_I_packet);
		
		if (sptr_predictor_type_I_packet->compression_flag_and_length.compression_flag == COMPRESSED)
			{
			sptr_decompressed_ppp_packet = predictor_type_I_decompress_compressed_ppp (real_port_number, sptr_predictor_type_I_packet, 
				uptr_ppp_packet, usptr_ppp_packet_length);

			return (sptr_decompressed_ppp_packet);
			}
		else	/* for some reason, the payload is not compressed */
			{
			sptr_restored_ppp_packet = predictor_type_I_decompress_uncompressed_ppp (real_port_number, sptr_predictor_type_I_packet, 
				uptr_ppp_packet, usptr_ppp_packet_length);
			
			return (sptr_restored_ppp_packet);
			}
		}
	else	/* the PPP packet is not a CCP compressed packet */
		{
		return (uptr_ppp_packet); 
		}
}
/*************************************************************************/
static UNION_PPP_PACKET *predictor_type_I_decompress_compressed_ppp (USHORT real_port_number, 
	PREDICTOR_TYPE_I_PACKET* sptr_predictor_type_I_packet, UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length)
{
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	BYTE *bptr_ppp_protocol_type_field;
	USHORT compressed_data_length;
	USHORT decompressed_data_length;
	USHORT new_checksum;
	USHORT compressed_data_length_used_by_the_compression_function;
	ULONG device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);

	sptr_decompressed_ppp_packet = predictor_type_I_prepare_a_ppp_receive_packet (real_port_number, sptr_predictor_type_I_packet);

	if (sptr_decompressed_ppp_packet == NULL)
		{
		return (NULL);
		}
	
	bptr_ppp_protocol_type_field = (BYTE *) (&(sptr_decompressed_ppp_packet->header)) + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS;
	
	compressed_data_length_used_by_the_compression_function = 
		sptr_predictor_type_I_packet->compression_flag_and_length.compressed_data_length;		
	
	compressed_data_length = (USHORT) compressed_data_length_used_by_the_compression_function;

	decompressed_data_length = decompress (real_port_number, sptr_predictor_type_I_packet->compressed_data, 
		bptr_ppp_protocol_type_field, &compressed_data_length_used_by_the_compression_function, TRUE);

	ccp_printf (CCP_DATA_PRINTF, "CCP:Predictor: PPP Packet Decompressed on Port %04x, Ratio(Compressed/Decompressed) = %d/%d\n",
		real_port_number, compressed_data_length, decompressed_data_length);

	bptr_ppp_protocol_type_field[decompressed_data_length] = 
		(sptr_predictor_type_I_packet->compressed_data)[compressed_data_length];
	bptr_ppp_protocol_type_field[decompressed_data_length + 1] = 
		(sptr_predictor_type_I_packet->compressed_data)[compressed_data_length + 1];
	
	*usptr_ppp_packet_length = (USHORT) (decompressed_data_length + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);

	new_checksum = calculate_frame_check_sequence (INIT_FRAME_CHECK_SEQUENCE, bptr_ppp_protocol_type_field,
		(USHORT) (decompressed_data_length + SIZE_OF_WAN_CRC));

	if (new_checksum != FINAL_GOOD_FRAME_CHECK_SEQUENCE)
		{
		ccp_printf (CCP_ALARM_PRINTF,"CCP:Predictor: CRC Check Failed on Port %04x\n",real_port_number);

		device_driver_free (real_port_number, device_driver_id, sptr_decompressed_ppp_packet);
		
		send_ccp_configuration_request (real_port_number);
		
		return (NULL);
		}
	
	/* now that we are done with the original PPP packet, we free it. */
	device_driver_free (real_port_number, device_driver_id, (void *) uptr_ppp_packet);
	
	return ((UNION_PPP_PACKET *) &(sptr_decompressed_ppp_packet->header));
}
/*************************************************************************/
static PPP_PACKET_WITH_MAC_HEADER *predictor_type_I_prepare_a_ppp_receive_packet (USHORT real_port_number, 
	PREDICTOR_TYPE_I_PACKET* sptr_predictor_type_I_packet)
{	
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	USHORT longest_possible_decompressed_data_length;
	USHORT decompressed_ppp_packet_length;
	ULONG device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);
	
	longest_possible_decompressed_data_length = 
		(USHORT) (sptr_predictor_type_I_packet->compression_flag_and_length.compressed_data_length * 9 + 9);
	
	decompressed_ppp_packet_length = (USHORT) (SIZE_OF_MAC_HEADER + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + 
		longest_possible_decompressed_data_length + SIZE_OF_WAN_CRC);
	
	sptr_decompressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) device_driver_malloc (real_port_number, 
			device_driver_id, decompressed_ppp_packet_length);

	if (sptr_decompressed_ppp_packet == NULL)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:Predictor: predictor_type_I_prepare_a_ppp_receive_packet () buffer_malloc () failed\n");
		
		return (NULL);
		}

	sptr_decompressed_ppp_packet->header.hdlc_address = HDLC_ADDRESS;
	sptr_decompressed_ppp_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

	return (sptr_decompressed_ppp_packet);
}

/*************************************************************************/
static UNION_PPP_PACKET *predictor_type_I_decompress_uncompressed_ppp (USHORT real_port_number, 
	PREDICTOR_TYPE_I_PACKET* sptr_predictor_type_I_packet, UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length)
{
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	BYTE *bptr_ppp_protocol_type_field;
	USHORT decompressed_ppp_packet_length;
	ULONG device_driver_id;

/* Sowmya 15/3/96 */	
	USHORT	source_length, longest_possible_compressed_data_length;
	PPP_PACKET_WITH_MAC_HEADER *sptr_compressed_ppp_packet;
/* Sowmya 15/3/96 */	

	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);
	
/* Sowmya 15/3/96 */	
	/* call compress routine to update the decompression hash value */
	source_length = sptr_predictor_type_I_packet->compression_flag_and_length.compressed_data_length;

	longest_possible_compressed_data_length = (USHORT) (source_length/ 8 * 9 + 9);
	
	sptr_compressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) device_driver_malloc (real_port_number, 
		device_driver_id, longest_possible_compressed_data_length);

	if (sptr_compressed_ppp_packet != NULL)
	{
		compress_uncompressible_predictor_type_data (real_port_number, sptr_predictor_type_I_packet->compressed_data,
			sptr_compressed_ppp_packet, source_length);

		/* Now free up the buffer */
		device_driver_free (real_port_number, device_driver_id, (void *) sptr_compressed_ppp_packet);
	}
/* Sowmya 15/3/96 */	

	decompressed_ppp_packet_length = (USHORT) (SIZE_OF_MAC_HEADER + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS +	
		sptr_predictor_type_I_packet->compression_flag_and_length.compressed_data_length);
	
	sptr_decompressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) device_driver_malloc (real_port_number, 
		device_driver_id, decompressed_ppp_packet_length);

	if (sptr_decompressed_ppp_packet == NULL)
		{
		return (NULL);
		}
	
	sptr_decompressed_ppp_packet->header.hdlc_address = HDLC_ADDRESS;
	sptr_decompressed_ppp_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

	bptr_ppp_protocol_type_field = (BYTE *) (&(sptr_decompressed_ppp_packet->header)) + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS;
	
	memcpy ((void *) bptr_ppp_protocol_type_field, (void *) sptr_predictor_type_I_packet->compressed_data,
		sptr_predictor_type_I_packet->compression_flag_and_length.compressed_data_length);
	
	*usptr_ppp_packet_length = (USHORT) (decompressed_ppp_packet_length - SIZE_OF_MAC_HEADER);
	
	/* now that we are done with the original PPP packet, we free it. */
	device_driver_free (real_port_number, device_driver_id, (void *) uptr_ppp_packet);
	
	return ((UNION_PPP_PACKET *) &(sptr_decompressed_ppp_packet->header));
}
/*************************************************************************/
static void predictor_type_I_free_compressed_ppp_packet (USHORT port_number, void *vptr_buffer)
{
	PARAMETER_NOT_USED (port_number);
	
	buffer_free ((void *) vptr_buffer); 
}



