/* $modname: vccpstat.h$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
/*
      | State																		 State
      |    0         1         2         3         4         5		    6         7         8           9
Events| Initial   Starting  Closed    Stopped   Closing   Stopping Req-Sent  Ack-Rcvd  Ack-Sent    Opened
------+----------------------------------------------------------------------------------------------------
 Up   |    2     irc,scr/6     -         -         -         -		    -         -         -           -
 Down |    -         -         0       tls/1       0         1		    1         1         1         tld/1
 Open |  tls/1       1     irc,scr/6     3r        5r        5r	    6         7         8           9r
 Close|    0         0         2         2         4         4		irc,str/4 irc,str/4 irc,str/4 tld,irc,str/4
      |
  TO+ |    -         -         -         -       str/4     str/5	  scr/6     scr/6     scr/8         -
  TO- |    -         -         -         -       tlf/2     tlf/3	  tlf/3p    tlf/3p    tlf/3p        -
      |
 RCR+ |    -         -       sta/2 irc,scr,sca/8   4         5		  sca/8   sca,tlu/9   sca/8   tld,scr,sca/8
 RCR- |    -         -       sta/2 irc,scr,scn/6   4         5		  scn/6     scn/7     scn/6   tld,scr,scn/6
 RCA  |    -         -       sta/2     sta/3       4         5		  irc/7     scr/6x  irc,tlu/9   tld,scr/6x
 RCN  |    -         -       sta/2     sta/3       4         5		irc,scr/6   scr/6x  irc,scr/8   tld,scr/6x
      |
 RTR  |    -         -       sta/2     sta/3     sta/4     sta/5	  sta/6     sta/6     sta/6   tld,zrc,sta/5
 RTA  |    -         -         2         3       tlf/2     tlf/3	    6         6         8       tld,scr/6
      |
 RUC  |    -         -       scj/2     scj/3     scj/4     scj/5	  scj/6     scj/7     scj/8       scj/9
 RXJ+ |    -         -         2         3         4         5		    6         6         8           9
 RXJ- |    -         -       tlf/2     tlf/3     tlf/2     tlf/3	  tlf/3     tlf/3     tlf/3   tld,irc,str/5
      |
 RXR  |    -         -         2         3         4         5		    6         7         8         ser/9

*/

PPP_STATE_MACHINE_TABLE	ccp_state_machine_table[NUMBER_OF_PPP_STATES][NUMBER_OF_PPP_EVENTS] = 
{
/* ------------------------------------------------------------------------ */
/*										     INITIAL   0                     			 */		 
/* ------------------------------------------------------------------------ */
{
/* UP	 								  	*/		{set_ccp_state, PPP_CLOSED_STATE}, 
/* DOWN								  	*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* OPEN								  	*/		{ccp_this_layer_start, PPP_STARTING_STATE}, 
/* CLOSE								   */		{set_ccp_state, PPP_INITIAL_STATE}, 
/* 									   */																		
/* TIMEOUT_WITH_COUNTER_GREATER  */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* TIMEOUT_WITH_COUNTER_EXPIRED  */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* 									   */																		
/* RX									   */																		
/* 									   */																		
/* CONFIGURE_REQUEST_GOOD		   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* CONFIGURE_REQUEST_BAD		   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* CONFIGURE_REQUEST_BAD_OPTION  */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* CONFIGURE_ACK					   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* CONFIGURE_NAK					   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* CONFIGURE_REJECT				   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* TERMINATE_REQUEST				   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* TERMINATE_ACK					   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* UNKNOWN_CODE					   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* CODE_REJECT_PERMITTED		   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* PROTOCOL_REJECT				   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* CODE_REJECT_CATASTROPHIC	   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*											  STARTING	 1										 */			 
/* ------------------------------------------------------------------------ */
{																												 
/* UP										*/		{ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 								 
(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/* DOWN									*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* OPEN								   */		{set_ccp_state, PPP_STARTING_STATE}, 
/* CLOSE								   */		{set_ccp_state, PPP_INITIAL_STATE}, 
/* 									   */																			
/* TIMEOUT_WITH_COUNTER_GREATER  */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* TIMEOUT_WITH_COUNTER_EXPIRED  */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* 									   */		
/* RX									   */		
/* 									   */		
/* CONFIGURE_REQUEST_GOOD		   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* CONFIGURE_REQUEST_BAD		   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* CONFIGURE_REQUEST_BAD_OPTION  */		{ccp_null_state, ILLEGAL_PPP_STATE}, 												 
/* CONFIGURE_ACK					   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* CONFIGURE_NAK					   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* CONFIGURE_REJECT				   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* TERMINATE_REQUEST				   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* TERMINATE_ACK					   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* UNKNOWN_CODE					   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* CODE_REJECT_PERMITTED		   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* PROTOCOL_REJECT				   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* CODE_REJECT_CATASTROPHIC	   */		{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*											  CLOSED		 2										 */
/* ------------------------------------------------------------------------ */
{
/* UP										*/	  	{ccp_null_state, ILLEGAL_PPP_STATE},         
/* 										*/		
/* DOWN									*/	  	{set_ccp_state, PPP_INITIAL_STATE}, 
/* OPEN									*/	  	{ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
(void (*) (USHORT, void *, USHORT, enum PPP_STATE))	  	send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/* 										*/
/* CLOSE									*/	  	{set_ccp_state, PPP_CLOSED_STATE}, 
/* 										*/																		 
/* TIMEOUT_WITH_COUNTER_GREATER	*/	  	{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{ccp_null_state, ILLEGAL_PPP_STATE}, 													 
/* 										*/																		 
/* RX										*/																		 
/* 										*/																		 
/* CONFIGURE_REQUEST_GOOD			*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_CLOSED_STATE}, 
/* CONFIGURE_REQUEST_BAD			*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_CLOSED_STATE}, 
/* CONFIGURE_REQUEST_BAD_OPTION	*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_CLOSED_STATE}, 
/* CONFIGURE_ACK						*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_CLOSED_STATE}, 
/* CONFIGURE_NAK						*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_CLOSED_STATE}, 
/* CONFIGURE_REJECT					*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_CLOSED_STATE}, 
/* TERMINATE_REQUEST					*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_CLOSED_STATE}, 
/* TERMINATE_ACK						*/	  	{set_ccp_state, PPP_CLOSED_STATE}, 
/* UNKNOWN_CODE						*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_code_reject, PPP_CLOSED_STATE}, 
/* CODE_REJECT_PERMITTED			*/	  	{set_ccp_state, PPP_CLOSED_STATE}, 
/* PROTOCOL_REJECT					*/	  	{set_ccp_state, PPP_CLOSED_STATE}, 
/* CODE_REJECT_CATASTROPHIC		*/	  	{ccp_this_layer_finished, PPP_CLOSED_STATE}, 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*											  STOPPED	 3										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*											*/	
/*	DOWN									*/	  	{ccp_this_layer_start, PPP_STARTING_STATE}, 
/* OPEN									*/	  	{set_ccp_state, PPP_STOPPED_STATE}, 
/*	CLOSE									*/	  	{set_ccp_state, PPP_CLOSED_STATE}, 
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/   	(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, NO_CHANGE_TO_PPP_STATE, 
/*											*/   	(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_ack, PPP_ACK_SENT_STATE}, 
/*											*/
/*	CONFIGURE_REQUEST_BAD			*/	  	{ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/   	(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, NO_CHANGE_TO_PPP_STATE, 
/*											*/   	(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_nak, PPP_ACK_SENT_STATE}, 
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/   	(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, NO_CHANGE_TO_PPP_STATE, 
/*											*/   	(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_nak, PPP_ACK_SENT_STATE}, 
/*											*/
/*	CONFIGURE_ACK						*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_STOPPED_STATE}, 
/*	CONFIGURE_NAK						*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_STOPPED_STATE}, 
/*	CONFIGURE_REJECT					*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_STOPPED_STATE}, 
/*	TERMINATE_REQUEST					*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_STOPPED_STATE}, 
/*	TERMINATE_ACK						*/	  	{set_ccp_state, PPP_STOPPED_STATE}, 
/*	UNKNOWN_CODE						*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_code_reject, PPP_STOPPED_STATE}, 
/*	CODE_REJECT_PERMITTED			*/	  	{set_ccp_state, PPP_STOPPED_STATE}, 
/*	PROTOCOL_REJECT					*/	  	{set_ccp_state, PPP_STOPPED_STATE}, 
/*	CODE_REJECT_CATASTROPHIC		*/	  	{ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*								 CLOSING					 4										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*											*/		
/*	DOWN									*/	  	{set_ccp_state, PPP_INITIAL_STATE}, 
/* OPEN									*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	CLOSE									*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_request, PPP_CLOSING_STATE}, 
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{ccp_this_layer_finished, PPP_CLOSED_STATE}, 
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*	CONFIGURE_REQUEST_BAD			*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*	CONFIGURE_ACK						*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*	CONFIGURE_NAK						*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*	CONFIGURE_REJECT					*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*	TERMINATE_REQUEST					*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_CLOSING_STATE}, 
/*	TERMINATE_ACK						*/	  	{ccp_this_layer_finished, PPP_CLOSED_STATE}, 
/*	UNKNOWN_CODE						*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_code_reject, PPP_CLOSING_STATE}, 
/*	CODE_REJECT_PERMITTED			*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*	PROTOCOL_REJECT					*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*	CODE_REJECT_CATASTROPHIC		*/	  	{ccp_this_layer_finished, PPP_CLOSED_STATE}, 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*								STOPPING					 5										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*											*/			
/*	DOWN									*/	  	{set_ccp_state, PPP_STARTING_STATE}, 
/* OPEN									*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	CLOSE									*/	  	{set_ccp_state, PPP_CLOSING_STATE}, 
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_request, PPP_STOPPING_STATE}, 
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	CONFIGURE_REQUEST_BAD			*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	CONFIGURE_ACK						*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	CONFIGURE_NAK						*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	CONFIGURE_REJECT					*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	TERMINATE_REQUEST					*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_STOPPING_STATE}, 
/*	TERMINATE_ACK						*/	  	{ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*	UNKNOWN_CODE						*/	  	{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_code_reject, PPP_STOPPING_STATE}, 
/*	CODE_REJECT_PERMITTED			*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	PROTOCOL_REJECT					*/	  	{set_ccp_state, PPP_STOPPING_STATE}, 
/*	CODE_REJECT_CATASTROPHIC		*/	  	{ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*										REQUEST_SENT	  6										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {ccp_null_state, ILLEGAL_PPP_STATE},  
/*											*/				
/*	DOWN									*/	  {set_ccp_state, PPP_STARTING_STATE}, 
/*	OPEN									*/	  {set_ccp_state, PPP_REQUEST_SENT_STATE}, 
/*	CLOSE									*/	  {ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_request, PPP_CLOSING_STATE}, 
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_ack, PPP_ACK_SENT_STATE}, 
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_nak, PPP_REQUEST_SENT_STATE}, 
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_reject, PPP_REQUEST_SENT_STATE}, 
/*	CONFIGURE_ACK						*/	  {ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/	  set_ccp_state, PPP_ACK_RECEIVED_STATE}, 
/*											*/
/*	CONFIGURE_NAK                 */   {ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE,  
/*											*/	  (void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*	CONFIGURE_REJECT					*/	  {ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE,  
/*											*/	  (void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*											*/
/*	TERMINATE_REQUEST					*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_REQUEST_SENT_STATE}, 
/*	TERMINATE_ACK						*/	  {set_ccp_state, PPP_REQUEST_SENT_STATE}, 
/*	UNKNOWN_CODE						*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_code_reject, PPP_REQUEST_SENT_STATE}, 
/*	CODE_REJECT_PERMITTED			*/	  {set_ccp_state, PPP_REQUEST_SENT_STATE}, 
/*	PROTOCOL_REJECT					*/	  {set_ccp_state, PPP_REQUEST_SENT_STATE}, 
/*	CODE_REJECT_CATASTROPHIC		*/	  {ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*									 	 ACK_RECEIVED		7									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {ccp_null_state, ILLEGAL_PPP_STATE},  
/*											*/				
/*	DOWN									*/	  {set_ccp_state, PPP_STARTING_STATE}, 
/*	OPEN									*/	  {set_ccp_state, PPP_ACK_RECEIVED_STATE}, 
/*	CLOSE									*/	  {ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_request, PPP_CLOSING_STATE}, 
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_ack, NO_CHANGE_TO_PPP_STATE, 
/*											*/	  ccp_this_layer_up, PPP_OPENED_STATE}, 
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_nak, PPP_ACK_RECEIVED_STATE}, 
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_reject, PPP_ACK_RECEIVED_STATE}, 
/*	CONFIGURE_ACK						*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*	CONFIGURE_NAK                 */   {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*	CONFIGURE_REJECT					*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*	TERMINATE_REQUEST					*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_REQUEST_SENT_STATE}, 
/*	TERMINATE_ACK						*/	  {set_ccp_state, PPP_REQUEST_SENT_STATE}, 
/*	UNKNOWN_CODE						*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_code_reject, PPP_ACK_RECEIVED_STATE}, 
/*	CODE_REJECT_PERMITTED			*/	  {set_ccp_state, PPP_REQUEST_SENT_STATE}, 
/*	PROTOCOL_REJECT					*/	  {set_ccp_state, PPP_REQUEST_SENT_STATE}, 
/*	CODE_REJECT_CATASTROPHIC		*/	  {ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*											  ACK_SENT		 8									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {ccp_null_state, ILLEGAL_PPP_STATE},  
/*											*/				
/*	DOWN									*/	  {set_ccp_state, PPP_STARTING_STATE}, 
/*	OPEN									*/	  {set_ccp_state, PPP_ACK_SENT_STATE}, 
/*	CLOSE									*/	  {ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_request, PPP_CLOSING_STATE}, 
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_ACK_SENT_STATE}, 
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_ack, PPP_ACK_SENT_STATE}, 
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_nak, PPP_ACK_RECEIVED_STATE}, 
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_reject, PPP_ACK_RECEIVED_STATE}, 
/*	CONFIGURE_ACK						*/	  {ccp_initialize_restart_counter, PPP_OPENED_STATE, 
/*											*/	  ccp_this_layer_up, PPP_OPENED_STATE}, 
/*	CONFIGURE_NAK                 */   {ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_ACK_SENT_STATE}, 
/*	CONFIGURE_REJECT					*/	  {ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_ACK_SENT_STATE}, 
/*	TERMINATE_REQUEST					*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_REQUEST_SENT_STATE}, 
/*	TERMINATE_ACK						*/	  {set_ccp_state, PPP_ACK_SENT_STATE}, 
/*	UNKNOWN_CODE						*/	  {(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_code_reject, PPP_ACK_SENT_STATE}, 
/*	CODE_REJECT_PERMITTED			*/	  {set_ccp_state, PPP_ACK_SENT_STATE}, 
/*	PROTOCOL_REJECT					*/	  {set_ccp_state, PPP_ACK_SENT_STATE}, 
/*	CODE_REJECT_CATASTROPHIC		*/	  {ccp_this_layer_finished, PPP_STOPPED_STATE}, 
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}, 
/* ------------------------------------------------------------------------ */
/*											OPENED			 9									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*											*/
/*	DOWN									*/		{ccp_this_layer_down, PPP_STARTING_STATE}, 
/*	OPEN									*/		{set_ccp_state, PPP_OPENED_STATE}, 
/*	CLOSE									*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_request, PPP_CLOSING_STATE}, 
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_ack, PPP_ACK_SENT_STATE}, 
/*	CONFIGURE_REQUEST_BAD			*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_nak, PPP_REQUEST_SENT_STATE}, 
/*	CONFIGURE_REQUEST_BAD_OPTION	*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_reject, PPP_REQUEST_SENT_STATE}, 
/*	CONFIGURE_ACK						*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*											*/
/*	CONFIGURE_NAK						*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*	CONFIGURE_REJECT					*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*											*/
/*	TERMINATE_REQUEST					*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		ccp_zero_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_ack, PPP_STOPPING_STATE}, 
/*											*/
/*	TERMINATE_ACK						*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_configuration_request, PPP_REQUEST_SENT_STATE}, 
/*											*/
/*	UNKNOWN_CODE						*/		{(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_code_reject, PPP_OPENED_STATE}, 
/*	CODE_REJECT_PERMITTED			*/		{set_ccp_state, PPP_OPENED_STATE}, 
/*	PROTOCOL_REJECT					*/		{set_ccp_state, PPP_OPENED_STATE}, 
/*	CODE_REJECT_CATASTROPHIC		*/		{ccp_this_layer_down, NO_CHANGE_TO_PPP_STATE, 
/*											*/		ccp_initialize_restart_counter, NO_CHANGE_TO_PPP_STATE, 
/*											*/		(void (*) (USHORT, void *, USHORT, enum PPP_STATE))send_ccp_termination_request, PPP_STOPPING_STATE}, 
/*											*/
/*	ECHO_REQUEST						*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 			
/*	ECHO_REPLY							*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	DISCARD_REQUEST					*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ccp_null_state, ILLEGAL_PPP_STATE}, 
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ccp_null_state, ILLEGAL_PPP_STATE}
}
};

