/* $modname: vccpstr.h$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
typedef	struct	CCP_HEADER
{
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;
} CCP_HEADER;

typedef struct PREDICTOR_TYPE_I_OPTION
{
	BYTE_ENUM (CCP_OPTION_TYPE) 	type;
	BYTE									length;
} PREDICTOR_TYPE_I_OPTION;

typedef struct PREDICTOR_TYPE_II_OPTION
{
	BYTE_ENUM (CCP_OPTION_TYPE) 	type;
	BYTE									length;
} PREDICTOR_TYPE_II_OPTION;

typedef struct BSD_LZW_COMPRESSION_OPTION
{
	BYTE_ENUM (CCP_OPTION_TYPE) 	type;
	BYTE									length;
	BYTE									vers_and_dict;
} BSD_LZW_COMPRESSION_OPTION;

#ifdef STAC_LZS	
typedef struct STACKER_LZS_COMPRESSION_OPTION
{ 
	BYTE_ENUM (CCP_OPTION_TYPE) 			type;
	BYTE											length;
	USHORT										history_count;
	BYTE_ENUM (CCP_STACKER_CHECK_MODE)	check_mode;
} STACKER_LZS_COMPRESSION_OPTION;
#endif	/* STAC_LZS	*/

typedef	union		UNION_CCP_OPTIONS
{
	PREDICTOR_TYPE_I_OPTION				predictor_type_I_option;
	PREDICTOR_TYPE_II_OPTION			predictor_type_II_option;
	BSD_LZW_COMPRESSION_OPTION 		BSD_lzw_compression_option;
#ifdef STAC_LZS	
	STACKER_LZS_COMPRESSION_OPTION 	stacker_lzs_compression_option;
#endif	/* STAC_LZS	*/
} UNION_CCP_OPTIONS;

typedef	struct	CCP_PACKET
{
	PPP_HEADER				ppp_header;
	CCP_HEADER				ccp_header;
	UNION_CCP_OPTIONS		options;
} CCP_PACKET;

typedef	struct	CCP_CONFIGURE_REQUEST
{
	PPP_HEADER								header;
	BYTE_ENUM (PPP_CONTROL_CODE) 		code;
	BYTE										id;
	USHORT 									length;

	PREDICTOR_TYPE_I_OPTION				predictor_type_I_option;
	PREDICTOR_TYPE_II_OPTION			predictor_type_II_option;
	BSD_LZW_COMPRESSION_OPTION 		BSD_lzw_compression_option;
#ifdef STAC_LZS	
	STACKER_LZS_COMPRESSION_OPTION 	stacker_lzs_compression_option;
#endif	/* STAC_LZS	*/
} CCP_CONFIGURE_REQUEST;

typedef	struct	CCP_CONFIGURE_REQUEST_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
	UNION_CCP_OPTIONS					options;
} CCP_CONFIGURE_REQUEST_PACKET;

typedef	struct	CCP_CONFIGURE_ACK_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
	UNION_CCP_OPTIONS	 				union_lcp_options[VARIABLE_NUMBER_OF_BYTES];
} CCP_CONFIGURE_ACK_PACKET;

typedef	struct	CCP_CONFIGURE_NAK_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
	UNION_CCP_OPTIONS	 				options;
} CCP_CONFIGURE_NAK_PACKET;

typedef	struct	CCP_CONFIGURE_REJECT_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
	UNION_CCP_OPTIONS	 				options;
} CCP_CONFIGURE_REJECT_PACKET;

typedef	struct	CCP_TERMINATE_REQUEST
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
} CCP_TERMINATE_REQUEST;

typedef	struct	CCP_TERMINATE_ACK
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
} CCP_TERMINATE_ACK;

typedef	struct	CCP_CODE_REJECT_PACKET
{
	PPP_HEADER	  						header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE			  						id;
	USHORT 		  						length;
	CCP_PACKET	  						rejected_packet;

} CCP_CODE_REJECT_PACKET;

typedef struct CCP_RESET_REQUEST
{ 
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
} CCP_RESET_REQUEST;

typedef struct CCP_RESET_REQUEST_WITH_HISTORY_NUMBER
{ 
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
	USHORT								history_number;
} CCP_RESET_REQUEST_WITH_HISTORY_NUMBER;

typedef struct CCP_RESET_ACK
{ 
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
} CCP_RESET_ACK;

typedef struct CCP_RESET_ACK_WITH_HISTORY_NUMBER
{ 
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;
	BYTE									id;
	USHORT 								length;
	USHORT								history_number;
} CCP_RESET_ACK_WITH_HISTORY_NUMBER;


typedef struct PREDICTOR_TYPE_I_PACKET_COMPRESSION_FLAG_AND_LENGTH
{
#ifdef BIG_ENDIAN
		unsigned short compression_flag : 1;
		unsigned short compressed_data_length : 15;
#else
		unsigned short compressed_data_length : 15;
		unsigned short compression_flag : 1;
#endif
} PREDICTOR_TYPE_I_PACKET_COMPRESSION_FLAG_AND_LENGTH;
	
typedef struct PREDICTOR_TYPE_I_PACKET
{ 
	PREDICTOR_TYPE_I_PACKET_COMPRESSION_FLAG_AND_LENGTH	compression_flag_and_length;
	BYTE 																	compressed_data[VARIABLE_NUMBER_OF_BYTES];
} PREDICTOR_TYPE_I_PACKET;

typedef struct PREDICTOR_TYPE_II_PACKET
{
	PREDICTOR_TYPE_I_PACKET frames[VARIABLE_NUMBER_OF_FRAMES];
} PREDICTOR_TYPE_II_PACKET;

typedef struct BSD_COMPRESSION_PACKET
{
	USHORT 	sequence_number;
	BYTE		data[VARIABLE_NUMBER_OF_BYTES];
} BSD_COMPRESSION_PACKET;

#ifdef STAC_LZS	
typedef struct STACKER_COMPRESSION_PACKET_WITH_LCB
{ 
	BYTE 	LCB;
	BYTE	data[VARIABLE_NUMBER_OF_BYTES];
} STACKER_COMPRESSION_PACKET_WITH_LCB;

typedef struct STACKER_COMPRESSION_PACKET_WITH_CRC
{ 
	USHORT	CRC;
	BYTE		data[VARIABLE_NUMBER_OF_BYTES];
} STACKER_COMPRESSION_PACKET_WITH_CRC;

typedef struct STACKER_COMPRESSION_PACKET_WITH_SEQUENCE_NUMBER
{ 
	BYTE 	sequence_number;
	BYTE	data[VARIABLE_NUMBER_OF_BYTES];
} STACKER_COMPRESSION_PACKET_WITH_SEQUENCE_NUMBER;

typedef union UNION_STACKER_COMPRESSION_PACKET
{
	STACKER_COMPRESSION_PACKET_WITH_LCB					stacker_compression_packet_with_lcb;
	STACKER_COMPRESSION_PACKET_WITH_CRC 				stacker_compression_packet_with_crc;
	STACKER_COMPRESSION_PACKET_WITH_SEQUENCE_NUMBER	stacker_compression_packet_with_sequence_number;
} UNION_STACKER_COMPRESSION_PACKET;
#endif	/* STAC_LZS	*/


typedef	struct	CCP_RECEIVE_OPTION_FUNCTIONS
{
	enum TEST (*fptr_process_receive_options[NUMBER_OF_CCP_OPTIONS]) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class);
} CCP_RECEIVE_OPTION_FUNCTIONS;

typedef struct HISTORY_COUNT_AND_CHECK_MODE
{
#ifdef BIG_ENDIAN
	BYTE		unused_field;
	USHORT 	history_count;
	BYTE	 	check_mode;
#else
	BYTE	 	check_mode;
	USHORT 	history_count;
	BYTE		unused_field;
#endif
} HISTORY_COUNT_AND_CHECK_MODE;

typedef union UNION_HISTORY_COUNT_AND_CHECK_MODE
{ 
	ULONG									ulong;
	HISTORY_COUNT_AND_CHECK_MODE	structure;
} UNION_HISTORY_COUNT_AND_CHECK_MODE;	
	
typedef struct CCP_PREDICTOR_CLASS
{
	USHORT	compression_hash_value;
	USHORT 	decompression_hash_value;
	
	BYTE 		*bptr_compression_guess_table;
	BYTE 		*bptr_decompression_guess_table;
} CCP_PREDICTOR_CLASS;

#ifdef STAC_LZS	
typedef struct CCP_STACKER_CLASS
{ 
	BYTE											*bptr_scratch_RAM;
	
	BYTE											receiver_sequence_number;
	BYTE											sender_sequence_number;
	BYTE											sequence_number_of_latest_received_packet;

	USHORT										performance_value;
	USHORT										performance_mode;

	UNION_HISTORY_COUNT_AND_CHECK_MODE	receiver_history_count_and_check_mode;
	UNION_HISTORY_COUNT_AND_CHECK_MODE	sender_history_count_and_check_mode;
} CCP_STACKER_CLASS;
#endif	/* STAC_LZS	*/

typedef struct CCP_BSD_CLASS
{ 
	BYTE								receiver_compression_vers_and_dict;
	BYTE								sender_compression_vers_and_dict;

	BSD_COMPRESSION_DATABASE	*sptr_receiver_compression_database;
	BSD_COMPRESSION_DATABASE	*sptr_sender_compression_database;
} CCP_BSD_CLASS;

typedef struct CCP_FUNCTIONS
{ 
	enum TEST							(*fptr_initialize_sender_compression_database) (USHORT real_port_number);
	enum TEST							(*fptr_initialize_receiver_compression_database) (USHORT real_port_number);
	
	PPP_PACKET_WITH_MAC_HEADER 	*(*fptr_sender_compress_ppp) (USHORT real_port_number, USHORT protocol_virtual_port_number, 
											enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, 
											USHORT *usptr_ppp_packet_length,	void (**ptr_fptr_tx_completion)
											(USHORT port_number, void *vptr_buffer));
	UNION_PPP_PACKET 					*(*fptr_receiver_decompress_ppp) (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
											USHORT *usptr_ppp_packet_length);
	void 									(*fptr_receiver_handle_reset_ack) (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);
	void 									(*fptr_sender_handle_reset_request) (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);

} CCP_FUNCTIONS;

typedef	struct	PPP_CCP_STATISTICS
{
	ULONG	number_of_tx_packets;
	ULONG	number_of_tx_bytes;
	ULONG	number_of_rx_packets;
	ULONG	number_of_rx_bytes;
	ULONG	number_of_packets_rxed_greater_than_maximum_size;
	ULONG	number_of_packets_rxed_less_than_minimum_size;
	ULONG	number_of_control_tx_packets[NUMBER_OF_PPP_CONTROL_CODES];
	ULONG	number_of_control_rx_packets[NUMBER_OF_PPP_CONTROL_CODES];
} PPP_CCP_STATISTICS;

typedef struct CCP_PORT_CLASS
{ 
	BYTE_ENUM (PPP_STATE)			state;

	BYTE_ENUM (PPP_STATE)			old_state;

	BYTE_ENUM (BOOLEAN) 				enabled;

	OPTION_LISTS						option_lists;

	LINK_QUALITY_COUNTERS			link_quality_counters;


	BYTE									id_sequence_number;
	BYTE									last_id_of_ccp_packet_sent;

	USHORT								number_of_configuration_requests;
	USHORT								number_of_termination_requests;
	USHORT								number_of_reset_requests;

	USHORT  								configuration_request_backoff_interval;
	USHORT  								configuration_request_send_interval;
	USHORT  								termination_request_send_interval;

	PPP_CCP_STATISTICS				ccp_statistics;

	CCP_CONFIGURE_REQUEST	 		last_txed_ccp_configuration_request_packet;
	USHORT								length_of_last_txed_ccp_packet;

	CCP_CONFIGURE_REQUEST	 		last_rxed_ccp_configuration_request_packet;
	USHORT								length_of_last_rxed_ccp_configuration_packet;

	void 									(*fptr_ccp_packet_received[NUMBER_OF_PPP_CONTROL_CODES])
												(USHORT real_port_number,CCP_PACKET *sptr_lcp_rx_packet,
												USHORT number_of_bytes_rxed);

	CCP_RECEIVE_OPTION_FUNCTIONS	receive;				
	CCP_RECEIVE_OPTION_FUNCTIONS	receive_nak;

	USHORT								port_number;

	BYTE_ENUM (BOOLEAN)				receiver_is_waiting_for_reset_ack;

	BYTE_ENUM (CCP_OPTION_TYPE)	receiver_primary_compression_algorithm;
	BYTE_ENUM (CCP_OPTION_TYPE)	sender_primary_compression_algorithm;

	BYTE_ENUM (BOOLEAN)				sender_compression_database_initialization_failure;
	BYTE_ENUM (BOOLEAN)				receiver_compression_database_initialization_failure;

	CCP_PREDICTOR_CLASS				predictor;
#ifdef STAC_LZS	
	CCP_STACKER_CLASS					stacker;
#endif	/* STAC_LZS	*/
	CCP_BSD_CLASS						BSD;
/* Sachin 17/06/1997 */
   void *sptr_preallocated_buffer ;
/* Sachin 17/06/1997 */
} CCP_PORT_CLASS;

typedef struct CCP_PPP_CLASS
{ 
	ULONG 			(*fptr_get_device_driver_id_function) (USHORT real_port_number);
	ULONG 			(*fptr_get_maximum_number_of_termination_requests_function) (void);
	ULONG 			(*fptr_get_ppp_remote_MRU_function) (USHORT real_port_number);
} CCP_PPP_CLASS;

typedef struct CCP_CLASS
{
	CCP_PPP_CLASS		ppp;

	BYTE_ENUM (BOOLEAN)	printing_enabled;
	BYTE_ENUM (BOOLEAN)	data_printing_enabled;
	BYTE_ENUM (BOOLEAN)	memory_printing_enabled;
	BYTE_ENUM (BOOLEAN)	alarm_printing_enabled;

	BYTE_ENUM (BOOLEAN)	initialization_breakpoint;
	BYTE_ENUM (BOOLEAN)	runtime_breakpoint;

	CCP_PORT_CLASS			ports[MAXIMUM_NUMBER_OF_PPP_PORTS];
	CCP_FUNCTIONS			functions[NUMBER_OF_CCP_OPTIONS];
	
	ULONG 					(*fptr_event_upcall) (USHORT real_port_number,USHORT event,...);
} CCP_CLASS;

/* ccpstate.c */
void execute_ccp_state_machine (enum PPP_EVENT ppp_event, USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes);

void set_ccp_state (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, 
	enum PPP_STATE end_state);
void ccp_this_layer_start (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, 
	enum PPP_STATE end_state);
void ccp_this_layer_finished (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, 
	enum PPP_STATE end_state);
void ccp_this_layer_up (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, 
	enum PPP_STATE end_state);
void ccp_this_layer_down (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, 
	enum PPP_STATE end_state);
void ccp_initialize_restart_counter (USHORT real_port_number, void *vptr_packet, 
	USHORT number_of_bytes, enum PPP_STATE end_state);
void ccp_zero_restart_counter (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, 
	enum PPP_STATE end_state);
void ccp_null_state (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, 
	enum PPP_STATE end_state);

/* ccptx.c */
void send_ccp_configuration_request (USHORT real_port_number);
void send_ccp_configuration_ack (USHORT real_port_number, CCP_PACKET *sptr_lcp_rx_packet, USHORT number_of_bytes_rxed);
void send_ccp_configuration_nak (USHORT real_port_number, CCP_PACKET *sptr_lcp_rx_packet);
void send_ccp_configuration_reject (USHORT real_port_number, CCP_PACKET *sptr_lcp_rx_packet);
void send_ccp_termination_request (USHORT real_port_number);
void send_ccp_termination_ack (USHORT real_port_number, CCP_PACKET *sptr_lcp_rx_packet);
void send_ccp_code_reject (USHORT real_port_number, CCP_PACKET *sptr_lcp_rx_packet, USHORT number_of_bytes);
void send_ccp_reset_request (USHORT real_port_number);
void send_ccp_reset_ack (USHORT real_port_number,  CCP_PACKET *sptr_ccp_rx_packet);
void send_ccp_reset_request_with_history_number (USHORT real_port_number, USHORT history_number);
void send_ccp_reset_ack_with_history_number (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);

/* ccprx.c */
enum TEST ccp_packet_received (USHORT real_port_number, void *vptr_lcp_rx_packet, USHORT number_of_bytes_rxed);
void ccp_configure_request_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed);
void ccp_configure_ack_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, 
	USHORT number_of_bytes_rxed);
void ccp_configure_nak_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed);
void ccp_configure_reject_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed);
void ccp_termination_request_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed);
void ccp_termination_ack_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, 
	USHORT number_of_bytes_rxed);
void ccp_code_reject_received (USHORT real_port_number,  CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed);
void ccp_reset_request_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed);
void ccp_reset_ack_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed);

/* ccpupcal.c */
ULONG ccp_event_upcall_example (USHORT event, USHORT real_port_number,...);

/* ccputil.c */
void ccp_printf (enum CCP_PRINTF_GROUPS printf_group, const char *cptr_format, ...);
void swap_in_place (USHORT *usptr_ushort_to_swap_bytes_with);
/* Sachin 17/06/1997 */
void ccp_preallocate_buffer (unsigned short real_port_number) ;
void *ccp_device_driver_malloc (unsigned short real_port_number, unsigned long device_driver_id, unsigned short buffer_length) ;
void ccp_device_driver_free (unsigned short real_port_number, unsigned long device_driver_id, void *sptr_buffer) ;
/* Sachin 17/06/1997 */

/* ccpoptnp.c */
enum TEST ccp_configure_request_option_processor (OPTION_LIST_ENTRY *sptr_remote_option, CCP_PORT_CLASS *sptr_port);
enum TEST ccp_configure_nak_option_processor (OPTION_LIST_ENTRY *sptr_remote_option, CCP_PORT_CLASS *sptr_port);

/* ccptimer.c */
void ccp_timer_routine (USHORT real_port_number, USHORT number_of_protocol_stacks_loaded, 
	ULONG maximum_configuration_request_send_interval, ULONG maximum_number_of_configuration_requests,
	ULONG maximum_termination_request_send_interval, ULONG maximum_number_of_termination_requests);

/* ccpconfg.c */
ULONG get_ccp_configuration_table_address (void);

/* ccppred1.c */
PPP_PACKET_WITH_MAC_HEADER *predictor_type_I_compress_ppp (USHORT real_port_number,USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer));
UNION_PPP_PACKET *predictor_type_I_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length);

/* ccppred2.c */
PPP_PACKET_WITH_MAC_HEADER *predictor_type_II_compress_ppp (USHORT real_port_number,USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer));
UNION_PPP_PACKET *predictor_type_II_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length);

/* ccpbsd.c */
PPP_PACKET_WITH_MAC_HEADER *BSD_compress_ppp (USHORT real_port_number,USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer));
UNION_PPP_PACKET *BSD_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length);

/* ccpstac.c */
#ifdef STAC_LZS	
PPP_PACKET_WITH_MAC_HEADER *stacker_compress_ppp (USHORT real_port_number,USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer));
UNION_PPP_PACKET *stacker_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length);
#endif	/* STAC_LZS	*/

/* ccpdebug.c */
void check_for_ccp_initialization_breakpoint (void);
void check_for_ccp_runtime_breakpoint (void);


