#include	"defs.h"
#include <stdio.h>

#ifdef __MLPPP__

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "ppp.h"

#define	PORT_NOT_FOUND	0xff

#define	MAX_PORT_SPEED	115200l

enum TEST is_multilink_negotiated_on_link(USHORT real_port_number);
USHORT find_matching_multilink(USHORT real_port_number);
USHORT create_multilink_bundle(USHORT real_port_number, USHORT virtual_port_number);
void	add_link_to_multilink_bundle(USHORT virtual_port_number, USHORT real_port_number);
void	free_ressemble_resources(USHORT port_number);
void	initialize_link_params(LINKS_CLASS *sptr_link, USHORT ppp_port_number);

#ifdef	_MY_DEBUG_
BYTE	UpdateMessage[100];
#endif

void initialize_mlppp_ports (void)
{
	USHORT port_number;
	MLPPP_PORT_CLASS	*sptr_mlppp;
	int i;

	for (port_number = 0x0000; port_number < ppp.number_of_ppp_ports; ++port_number)
	{
		sptr_mlppp = &mlppp.port[port_number];

/* Added By Naveen for DOD Support ...*/
      mlppp.dod_enabled_bundle[port_number].link_down_by_demand = FALSE;
/* ... Added By Naveen for DOD Support */

		sptr_mlppp->port_number = port_number;
		for(i = 0; i < NO_OF_REASSEMBLE_RESOURCES; i++)
		{
			add_entry_to_list (&sptr_mlppp->free_rx_list,
						(LINK *)(&sptr_mlppp->rx_descriptor_array[i]));
		}
	}
}

USHORT map_physical_port_to_virtual_port(USHORT real_port_number)
{
	USHORT free_port_no, port_number, links, link_port_number;
	OPTION_LIST_ENTRY *sptr_option; 


/* The Following Code Added by Naveen For DOD Support ... */

   /* It is reqd to check if the real_port_number was a member/link in the
      bundle which was brought down by demand,if so give the same bundle number
      (if that bundle number is free)
   */

   for (port_number = 0 ;  port_number < ppp.number_of_ppp_ports ; ++ port_number)
   {
      if (mlppp.dod_enabled_bundle[port_number].link_down_by_demand)
      {
         for(links = 0 ; links < mlppp.dod_enabled_bundle[port_number].number_of_links ; ++links)
         {
            link_port_number = mlppp.dod_enabled_bundle[port_number].link_port_number[links];
            if (link_port_number == real_port_number)
            {
               if (mlppp.port[port_number].used == FALSE)
               {
                  free_port_no = port_number;
                  goto initialize_port;
               }
            }
         }
      }
   }

/* ...The Following Code Added by Naveen For DOD Support */


	if (mlppp.port[real_port_number].used != FALSE
/* Added by Naveen for DOD Support ... */
       && 
       mlppp.dod_enabled_bundle[real_port_number].link_down_by_demand == FALSE
/* ... Added by Naveen for DOD Support */
	   )
	{
		for (free_port_no = 0; free_port_no < ppp.number_of_ppp_ports; free_port_no++)
		{
			if (mlppp.port[free_port_no].used == FALSE)
/* Added by Naveen for DOD support ... */
         {
            if (mlppp.dod_enabled_bundle[free_port_no].link_down_by_demand == FALSE)
   				break;
         }
/* ... Added by Naveen for DOD support */
		}
	}
	else
	{
		free_port_no = real_port_number;
	}


initialize_port:

	mlppp.port[free_port_no].used = TRUE;
	mlppp.port[free_port_no].multilink_enabled = FALSE;
	mlppp.port[free_port_no].LinkInfo[0].port = &ppp.port[real_port_number];
	mlppp.port[free_port_no].NoOfLinks = 1;

	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
					LCP_MAXIMUM_RECEIVE_UNIT);
	if (sptr_option != NULL)
		mlppp.port[free_port_no].RemoteMRRU = swap(sptr_option->uptr_data->_ushort);
	else
		mlppp.port[free_port_no].RemoteMRRU = DEFAULT_MAXIMUM_MRU;

	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.tx_accepted,
				LCP_MAXIMUM_RECEIVE_UNIT);
	if (sptr_option != NULL)
		mlppp.port[free_port_no].LocalMRRU = swap(sptr_option->uptr_data->_ushort);
	else
		mlppp.port[free_port_no].LocalMRRU = DEFAULT_MAXIMUM_MRU;

/*	lsl_control(SET_PORT_OPEN_STATUS, ppp.number_of_lan_ports + free_port_no, TRUE);*/

   ppp_printf(PPP_MLPPP_PRINTF, "MLPPP:REAL Port %04X mapped to VIRTUAL Port %04X\n", real_port_number, free_port_no);

#ifdef	_MY_DEBUG_
	printf("mapped to virtual port %d", free_port_no);
#endif
	return(free_port_no);
}

USHORT join_multilink_if_negotiated(USHORT real_port_number,USHORT virtual_port_number)
{
	USHORT multilink_port_number;

	if (is_multilink_negotiated_on_link(real_port_number) == FALSE)
   {
      ppp_printf(PPP_MLPPP_PRINTF, "MLPPP: MLPPP not negotiated on Real Port %04X\n", real_port_number) ;
		return(virtual_port_number);
   }
	multilink_port_number = find_matching_multilink(real_port_number);

/*need to check if mrru are equal
not sure what to be done if they are not equal.
rfc says a peer MUST request the same mrru on different links of the bundle.
we can either disconnect the link or
renegotiate lcp with the proper values for mrru
right now we dont do both.*/

	if (multilink_port_number != PORT_NOT_FOUND)
	{
   	remove_link_from_bundle(real_port_number, virtual_port_number);
		add_link_to_multilink_bundle(multilink_port_number, real_port_number);
/* __NMD__ 13/06/98 Vidy - took from Murali's fix */
/* ACCM is not applied on the subsequent links which join the bundle, but *
 * is applied only after successfully sending one packet on this link.    */
   	ppp.port[real_port_number].accm_applied = FALSE ;
/* __NMD__ */
	   return (multilink_port_number);
	}
	else
	{
		create_multilink_bundle(real_port_number, virtual_port_number);
		return (virtual_port_number);
	}
}

enum TEST is_multilink_negotiated_on_link(USHORT real_port_number)
{
	OPTION_LIST_ENTRY *sptr_option; 

	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
					LCP_MAXIMUM_RECONSTRUCTED_UNIT);
	if (sptr_option == NULL)
	{
		sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
					LCP_SHORT_SEQUENCE_NUMBER_HEADER);
	}
	if (sptr_option == NULL)
		return(FALSE);
	else
		return(TRUE);
}


USHORT find_matching_multilink(USHORT real_port_number)
{
	int	i;
	OPTION_LIST_ENTRY *sptr_option; 
	ENDPOINT_DISCRIMINATOR	epd;

	memset(&epd, 0, sizeof(ENDPOINT_DISCRIMINATOR));

	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
					LCP_ENDPOINT_DISCRIMINATOR);

	if (sptr_option != NULL)
	{
		epd.length = sptr_option->length;
		memcpy(&epd.class, sptr_option->uptr_data->byte_array, epd.length);
	}

	for (i = 0; i < ppp.number_of_ppp_ports; i++)
	{
		if (mlppp.port[i].multilink_enabled)
		{
			if ((!memcmp(&mlppp.port[i].RemoteEPD, &epd, epd.length + sizeof(epd.length))) &&
					(!strncmp(ppp.port[real_port_number].ras_user_database_record.user_name, 
								mlppp.port[i].UserName,UDB_USER_NAME_LENGTH)))
         {
				return(i);
         }
		}
	}
	return (PORT_NOT_FOUND);
}

USHORT create_multilink_bundle(USHORT real_port_number, USHORT virtual_port_number)
{
	OPTION_LIST_ENTRY *sptr_option; 
	MLPPP_PORT_CLASS	*sptr_mlppp;

	sptr_mlppp = &mlppp.port[virtual_port_number];
	sptr_mlppp->multilink_enabled = TRUE;
	sptr_mlppp->sequence_number_wrap_around = FALSE;
	sptr_mlppp->MinimumSequenceNumber = 0;
	sptr_mlppp->ExpectedSequenceNumber = 0;
	sptr_mlppp->NextSendSequenceNumber = 0;
	sptr_mlppp->LastTxLink = 0;
	sptr_mlppp->EnableShortSequenceNumberHeader = FALSE;
	strcpy(sptr_mlppp->UserName, ppp.port[real_port_number].ras_user_database_record.user_name);

	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
					LCP_ENDPOINT_DISCRIMINATOR);
	if (sptr_option != NULL)
	{
		sptr_mlppp->RemoteEPD.length = sptr_option->length;
		memcpy(&sptr_mlppp->RemoteEPD.class, sptr_option->uptr_data->byte_array, sptr_mlppp->RemoteEPD.length);
	}

	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
					LCP_MAXIMUM_RECONSTRUCTED_UNIT);

	if (sptr_option != NULL)
		sptr_mlppp->RemoteMRRU = swap(sptr_option->uptr_data->_ushort);

	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.tx_accepted,
					LCP_MAXIMUM_RECONSTRUCTED_UNIT);

	if (sptr_option != NULL)
		sptr_mlppp->LocalMRRU = swap(sptr_option->uptr_data->_ushort);

#ifdef	_MY_DEBUG_
	printf("Create multilink virtual port %d", virtual_port_number+1);
#endif

	initialize_link_params(&sptr_mlppp->LinkInfo[0], real_port_number);

   ppp_printf(PPP_MLPPP_PRINTF, "MLPPP: Created MultiLink Bundle %04X with Link %04X\n", virtual_port_number, real_port_number) ;

	return(virtual_port_number);
}

void	initialize_link_params(LINKS_CLASS *sptr_link, USHORT ppp_port_number)
{
	ULONG	port_speed;
	OPTION_LIST_ENTRY *sptr_option; 
	PPP_PORT_CLASS	*sptr_ppp = &ppp.port[ppp_port_number];

	sptr_link->port = sptr_ppp;

	sptr_link->port_number = ppp_port_number;
	sptr_link->LastSequenceNumber = 0;


#if 0 /* commented by Naveen because the speed_multiplier  is not used
         currently */
	(*sptr_ppp->serial_driver.fptr_control_routine) (GET_PORT_SPEED,
				(ULONG) ppp_port_number,(ULONG) &port_speed);

	sptr_link->speed_multipler = MAX_PORT_SPEED / port_speed;
#endif

	sptr_link->mlppp_payload = sptr_ppp->lcp_mibs.pppLinkStatusRemoteMRU - sizeof(MLPPP_HEADER);

	sptr_link->max_queue_depth = sptr_ppp->async.number_of_buffers * sptr_link->speed_multipler;


	sptr_option = find_matching_option (&sptr_ppp->option_lists.tx_accepted,
					LCP_LINK_DISCRIMINATOR);

	if (sptr_option != NULL)
		sptr_link->link_discriminator = sptr_option->uptr_data->_ushort;
}

void	add_link_to_multilink_bundle(USHORT virtual_port_number, USHORT real_port_number)
{
	MLPPP_PORT_CLASS	*sptr_mlppp = &mlppp.port[virtual_port_number];

	initialize_link_params(&sptr_mlppp->LinkInfo[sptr_mlppp->NoOfLinks], real_port_number);

	sptr_mlppp->NoOfLinks++;

#ifdef	_MY_DEBUG_
	printf("joined multilink virtual port %d", virtual_port_number+1);
#endif
   ppp_printf(PPP_MLPPP_PRINTF, "MLPPP: Added Link %04X to MultiLink bundle %04X\n", real_port_number, virtual_port_number) ;
}

enum TEST remove_link_from_bundle(USHORT real_port_number,USHORT virtual_port_number)
{
	USHORT	port_number;
	BYTE protocol_stack_index;
	PPP_NCP_CLASS *sptr_ncp;
	MLPPP_PORT_CLASS	*sptr_mlppp = &mlppp.port[virtual_port_number];

#if 0
	printf("Ravi : Real Port Number : %d\n", real_port_number);
	printf("Ravi : Virtual Port Number : %d\n", virtual_port_number);
#endif
   
	for (port_number = 0; port_number < sptr_mlppp->NoOfLinks; port_number++)
	{
		if (sptr_mlppp->LinkInfo[port_number].port->port_number == real_port_number)
			break;
	}
	if (port_number == sptr_mlppp->NoOfLinks)
   {
		return(FALSE);
   }

#ifdef	_MY_DEBUG_
	printf("removed multilink virtual port %d", virtual_port_number+1);
#endif

	sptr_mlppp->NoOfLinks--;

	if (sptr_mlppp->NoOfLinks == 0)
	{
		sptr_mlppp->multilink_enabled = FALSE;
		sptr_mlppp->used = FALSE;
		free_ressemble_resources(virtual_port_number);
		for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
		{
			sptr_ncp = &mlppp.port[virtual_port_number].ncp[protocol_stack_index];

			if (sptr_ncp->protocol_stack_id != ILLEGAL_STACK_ID)
			{
				
#if 0
				printf("Ravi : Free Called for protocol stack id : %d\n", sptr_ncp->protocol_stack_id);
#endif
				execute_ncp_state_machine (PPP_DOWN_EVENT,sptr_ncp,virtual_port_number,NULL,0x0000);
				free_ppp_option_lists (&sptr_ncp->option_lists);
			}
		}
#if defined (CCP)
		if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (virtual_port_number) == TRUE))
		{
			(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_DOWN_EVENT, virtual_port_number, NULL, 0x0000);
		}

		if (ppp.ccp.enabled == TRUE)
		{
			if ((ppp.ccp.fptr_get_ccp_port_status_function != NULL) && 
				((*ppp.ccp.fptr_get_ccp_port_status_function) (virtual_port_number) == TRUE))
			{
				free_ccp_option_lists (virtual_port_number);
				reset_ccp_state_machine(virtual_port_number);
				initialize_ccp_tx_accepted_option_list(virtual_port_number);
			}
		}
#endif				

		initialize_ncp_tx_accepted_option_list(virtual_port_number);
		cipx_reset_connection_states (virtual_port_number);
		vjc_reset_connection_states (virtual_port_number);

/*		lsl_control(SET_PORT_OPEN_STATUS, ppp.number_of_lan_ports + virtual_port_number, FALSE);*/
      ppp_printf(PPP_MLPPP_PRINTF, "MLPPP: Bundle %04X removed.........\n", virtual_port_number);
		return(TRUE);
	}

 	if (port_number < sptr_mlppp->LastTxLink)
		sptr_mlppp->LastTxLink--;

	for (; port_number < sptr_mlppp->NoOfLinks; port_number++)
	{
		sptr_mlppp->LinkInfo[port_number] = sptr_mlppp->LinkInfo[port_number+1];
	}

//   ppp_printf(PPP_MLPPP_PRINTF, "MLPPP:Removed Link %04X from Bundle %04X \n", real_port_number, virtual_port_number);
   printf("MLPPP:Removed Link %04X from Bundle %04X \n", real_port_number, virtual_port_number);
	return(TRUE);
}

void	free_ressemble_resources(USHORT port_number)
{
	MLPPP_RX_DESCRIPTOR	*sptr_current_entry;
	MLPPP_PORT_CLASS	*sptr_mlppp = &mlppp.port[port_number];

	while (1)
	{
		sptr_current_entry = get_entry_from_list(&sptr_mlppp->assembled_rx_list);
		if (sptr_current_entry == NULL)
			break;
		add_entry_to_list (&sptr_mlppp->free_rx_list, (LINK *)sptr_current_entry);
	}

	while (1)
	{
		sptr_current_entry = get_entry_from_list(&sptr_mlppp->reassembly_rx_list);
		if (sptr_current_entry == NULL)
			break;
		add_entry_to_list (&sptr_mlppp->free_rx_list, (LINK *)sptr_current_entry);
	}
}

enum BOOLEAN is_this_link_multilink(USHORT port_number)
{
	return(mlppp.port[port_number].multilink_enabled);
}
#endif
