#include	"defs.h"
#include	<stddef.h>
#include	<stdio.h>
#include	<string.h>

#ifdef __MLPPP__

#include "ppp.h"

#define	MIN_PPP_PACKET_LEN	2

enum TEST verify_upper_layer_packet (USHORT real_port_number,UNION_PPP_PACKET *sptr_rx_packet,
	USHORT *usptr_number_of_bytes_rxed);
enum TEST determine_upper_layer_packet_type (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed);
enum TEST multilink_receive_from_individual_links(MLPPP_PORT_CLASS	*sptr_mlppp);
enum TEST reassemble_packets(MLPPP_PORT_CLASS	*sptr_mlppp);
void	calculate_minimum_sequence_number(MLPPP_PORT_CLASS	*sptr_mlppp);
void	discard_fragments(MLPPP_PORT_CLASS *sptr_mlppp, int number_of_fragments);
void	reassemble_a_packet(MLPPP_PORT_CLASS *sptr_mlppp, int number_of_fragments);
enum TEST process_received_multilink_fragment(MLPPP_PORT_CLASS *sptr_mlppp,
	int link, UNION_PPP_PACKET *sptr_rxed_packet, USHORT number_of_bytes_rxed);

void check_if_sequence_number_wrap_around_is_complete(MLPPP_PORT_CLASS	*sptr_mlppp);
extern PPP_PACKET *decompress_ppp_header (PPP_PACKET *sptr_rxed_packet,
	USHORT *usptr_number_of_bytes_rxed, enum BOOLEAN, enum BOOLEAN);

extern UNION_PPP_PACKET	*ccp_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *sptr_rxed_packet, 
	USHORT *usptr_number_of_bytes_rxed);    /* Sudha from Chris 27 Jan 1999 */

USHORT is_the_link_member_of_some_bundle(USHORT link);

/* #define	_MY_DEBUG_*/

#ifdef	_MY_DEBUG_
extern	BYTE	UpdateMessage[];
#endif

#if defined (CCP)       /* Sudha from Chris 27 Jan 1999 */
extern enum BOOLEAN decompressed_by_ppp_rx;
#endif                  /* Sudha from Chris 27 Jan 1999 */

enum BOOLEAN mlppp_receive (USHORT real_port_number,UNION_PPP_PACKET **sptr_return_packet,USHORT *usptr_number_of_bytes_rxed)
{
	MLPPP_RX_DESCRIPTOR	*sptr_current_entry;
	UNION_PPP_PACKET *sptr_rxed_packet;
	USHORT number_of_bytes_rxed;
	MLPPP_PORT_CLASS	*sptr_mlppp;
	USHORT	device_driver_buffer_port_number;

	real_port_number = (USHORT) (real_port_number - ppp.number_of_lan_ports);

/* Sachin, 07th November */
   if (ppp.port[real_port_number].slip_on == TRUE)
	{
		BYTE *usptr_rx_packet;

		if (!ppp.port[real_port_number].serial_driver.fptr_rx_routine) 
			return (FALSE);

		if ((*ppp.port[real_port_number].serial_driver.fptr_rx_routine) (real_port_number,(void **) &usptr_rx_packet,
				&number_of_bytes_rxed) == FALSE)
		{
			return (FALSE);
		}

		*sptr_return_packet = usptr_rx_packet;
		
		if (receive_slip_packet (real_port_number, &usptr_rx_packet,&number_of_bytes_rxed) == FAIL)
		{
			ppp_return_buffer_to_device_driver ((USHORT) (real_port_number + ppp.number_of_lan_ports),*sptr_return_packet);

			return (FALSE);
		}
		*usptr_number_of_bytes_rxed = number_of_bytes_rxed;
		*sptr_return_packet = usptr_rx_packet;
		return (TRUE);
	}
/* Sachin, 07th November */

	sptr_mlppp = &mlppp.port[real_port_number];

	if (sptr_mlppp->multilink_enabled)
	{
		if (multilink_receive_from_individual_links(sptr_mlppp))
		{
			reassemble_packets(sptr_mlppp);
			if (sptr_mlppp->sequence_number_wrap_around != FALSE)
			{
				check_if_sequence_number_wrap_around_is_complete(sptr_mlppp);
			}
		}

		sptr_current_entry = get_entry_from_list(&sptr_mlppp->assembled_rx_list);

		if (sptr_current_entry == NULL)
			return (FALSE);

		sptr_rxed_packet = sptr_current_entry->sptr_rx_packet;
		number_of_bytes_rxed = sptr_current_entry->number_of_bytes_rxed;

		device_driver_buffer_port_number = sptr_current_entry->port_number;

		add_entry_to_list (&sptr_mlppp->free_rx_list, (LINK *)sptr_current_entry);

		sptr_rxed_packet = decompress_ppp_header (sptr_rxed_packet,
							&number_of_bytes_rxed, TRUE, TRUE);

		if (verify_upper_layer_packet (real_port_number,sptr_rxed_packet,&number_of_bytes_rxed) == FAIL)
		{
			mlppp_return_buffer_to_device_driver (device_driver_buffer_port_number + ppp.number_of_lan_ports, sptr_rxed_packet);
			return (FALSE);
		}
	}
	else
	{
      if (sptr_mlppp->used)
      {
   		device_driver_buffer_port_number = sptr_mlppp->LinkInfo[0].port->port_number;
	   	if (ppp_receive (device_driver_buffer_port_number, 
						&sptr_rxed_packet, &number_of_bytes_rxed) == FALSE)
			return (FALSE);
      }
      else
      {
         if (is_the_link_member_of_some_bundle(real_port_number) != NOT_A_MEMBER_OF_ANY_BUNDLE)
         {
            return FALSE;
         }
   		device_driver_buffer_port_number = real_port_number;
	   	if (ppp_receive (real_port_number, 
						&sptr_rxed_packet, &number_of_bytes_rxed) == FALSE)
			return (FALSE);

      }   
	}

#if defined (CCP)

/* note buffer free in decompresser. he allocates a device driver buffer
   using device driver malloc and device driver free */
	if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE)
       && (decompressed_by_ppp_rx == FALSE))      /* Sudha from Chris 28 Jan 1999 */

		{
		if (sptr_rxed_packet == NULL)
			{
			return (FALSE);
			}
		sptr_rxed_packet = ccp_decompress_ppp (real_port_number, sptr_rxed_packet, &number_of_bytes_rxed);

		if (sptr_rxed_packet == NULL)
			{
			return (FALSE);
			}
		}
      decompressed_by_ppp_rx = FALSE;      /* Sudha from Chris 28 Jan 1999 */

#endif

	if (determine_upper_layer_packet_type (real_port_number,sptr_rxed_packet,(void **) &sptr_rxed_packet,&number_of_bytes_rxed) == FAIL)
		{
		mlppp_return_buffer_to_device_driver ((USHORT) (device_driver_buffer_port_number + ppp.number_of_lan_ports),sptr_rxed_packet);
		return (FALSE);
		}

	*usptr_number_of_bytes_rxed = number_of_bytes_rxed;
	*sptr_return_packet = sptr_rxed_packet;

	return (TRUE);
}

/****************************************************************************/
enum TEST verify_upper_layer_packet (USHORT real_port_number,UNION_PPP_PACKET *sptr_rx_packet,
	USHORT *usptr_number_of_bytes_rxed)
{																															/* check for padding */
	if (sptr_rx_packet->generic.header.hdlc_address != HDLC_ADDRESS)
		{
/*		ppp_printf (PPP_ALARM_PRINTF,"PPP: HDLC Address Error: %04x\r\n",real_port_number);
		UpdateLastMessage(real_port_number,"PPP: HDLC Address Error",LEVEL_0);
		++ppp.port[real_port_number].lcp_mibs.pppLinkStatusBadAddresses;*/

		return (FAIL);
		}

	if (sptr_rx_packet->generic.header.hdlc_control != UNNUMBERED_INFORMATION)
		{
/*		ppp_printf (PPP_ALARM_PRINTF,"PPP: HDLC Control Error: %04x\r\n",real_port_number);
		UpdateLastMessage(real_port_number,"PPP: HDLC Control Error",LEVEL_0);
		++ppp.port[real_port_number].lcp_mibs.pppLinkStatusBadControls;*/

		return (FAIL);
		}

	if ((swap (sptr_rx_packet->generic.header.protocol_type) & 0xff00) != 0x0000)
		{
		if (*usptr_number_of_bytes_rxed > (swap (sptr_rx_packet->lcp.lcp_header.length) + sizeof (PPP_HEADER))) 
			{																													/* ignore padding bytes */
			*usptr_number_of_bytes_rxed = (USHORT) (swap (sptr_rx_packet->lcp.lcp_header.length) + sizeof (PPP_HEADER));  
			}
		}

	if ((*usptr_number_of_bytes_rxed - sizeof (PPP_HEADER)) > mlppp.port[real_port_number].LocalMRRU)
		{
/*		ppp_printf (PPP_ALARM_PRINTF,"PPP: Length Too Large Error: %04x\r\n",real_port_number);
		UpdateLastMessage(real_port_number,"PPP: Length too large error",LEVEL_0);
		++ppp.port[real_port_number].lcp_mibs.pppLinkStatusPacketTooLongs;*/

		return (FAIL);
		}

	return (PASS);
}
			 
enum TEST determine_upper_layer_packet_type(USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed)
{
	PPP_NCP_CLASS *sptr_ncp;
	enum TEST return_code;

	switch (sptr_rxed_packet->generic.header.protocol_type)
	{
		case IP_PROTOCOL:
		case VAN_JACOBSON_COMPRESSED_PROTOCOL:
		case VAN_JACOBSON_UNCOMPRESSED_PROTOCOL:
			return_code = ip_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,usptr_number_of_bytes_rxed);

			return (return_code);
		case IPX_PROTOCOL:
			return_code = ipx_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,usptr_number_of_bytes_rxed);

			return (return_code);
		case APPLETALK_PROTOCOL:
			return_code = appletalk_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,
				usptr_number_of_bytes_rxed);

			return (return_code);
		case BRIDGING_PROTOCOL:
			return_code = bridge_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,
				usptr_number_of_bytes_rxed);

			return (return_code);
		case NETBIOS_PROTOCOL:
			return_code = netbios_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,
				usptr_number_of_bytes_rxed);

			return (return_code);
		case IPCP_PROTOCOL:

			if (mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].enabled) 
			{
				if (is_dhcp_client_enabled (real_port_number + ppp.number_of_lan_ports))
				{
					if (ppp.port[real_port_number].dhcp_status != DHCP_STATUS_IP_ADDRESS_OBTAINED)
					{
						printf ("IP ADDRESS not obtained, silently dropping IPCP packet\n") ;
						return (FAIL) ;
					}
				}
			}
			else
			{
				printf ("IP disabled for port %d\n", real_port_number + ppp.number_of_lan_ports) ;
				return (FAIL);
			}

			if (verify_ncp (real_port_number,sptr_rxed_packet) == FAIL)
			{
				return (FAIL);
			}
/*			if (is_dhcp_enabled(real_port_number + ppp.number_of_lan_ports) && ppp.port[real_port_number].dhcp_status == UNSUCCESSFUL)
				break;*/
			sptr_ncp = find_ppp_ncp (real_port_number,IP_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case IPXCP_PROTOCOL:

			if (verify_ncp (real_port_number,sptr_rxed_packet) == FAIL)
			{
				return (FAIL);
			}
			sptr_ncp = find_ppp_ncp (real_port_number,IPX_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case ATCP_PROTOCOL:
			if (verify_ncp (real_port_number,sptr_rxed_packet) == FAIL)
			{
				return (FAIL);
			}
			sptr_ncp = find_ppp_ncp (real_port_number,APPLETALK_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case NBFCP_PROTOCOL:
			if (verify_ncp (real_port_number,sptr_rxed_packet) == FAIL)
			{
				return (FAIL);
			}
			sptr_ncp = find_ppp_ncp (real_port_number,NETBIOS_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case BCP_PROTOCOL:
			if (verify_ncp (real_port_number,sptr_rxed_packet) == FAIL)
			{
				return (FAIL);
			}
			sptr_ncp = find_ppp_ncp (real_port_number,SPANNING_TREE_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;

#if defined (CCP)
		case CCP_PROTOCOL:
			if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
			{
				BYTE last_id_of_ccp_packet_sent;

				last_id_of_ccp_packet_sent = (*ppp.ccp.fptr_get_last_id_of_ccp_packet_sent_function) (real_port_number);

				if (check_id (real_port_number,sptr_rxed_packet->generic.code,sptr_rxed_packet->generic.id,
					last_id_of_ccp_packet_sent,"CCP") == FAIL)
				{
					return (FAIL);
				}
				(*ppp.ccp.fptr_ccp_packet_received_function) (real_port_number,(void *) sptr_rxed_packet,
					*usptr_number_of_bytes_rxed);
			}
			break;
#endif

#ifdef	__BACP__
		case BACP_PROTOCOL:
			if (verify_ncp (real_port_number,sptr_rxed_packet) == FAIL)
			{
				return (FAIL);
			}
			sptr_ncp = find_ppp_ncp (real_port_number,BAP_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case BAP_PROTOCOL:
			bap_packet_rx (real_port_number,sptr_rxed_packet,*usptr_number_of_bytes_rxed);
			break;
#endif

		case LCP_PROTOCOL:
		case PAP_PROTOCOL:
		case CHAP_PROTOCOL:
		case LINK_QUALITY_PROTOCOL:
		case CBCP_PROTOCOL:
			return (FAIL);

		default:
			send_lcp_protocol_reject (mlppp.port[real_port_number].LinkInfo[0].port->port_number,
				(LCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed);
			return (FAIL);
	}

	return (FAIL);
}

enum TEST multilink_receive_from_individual_links(MLPPP_PORT_CLASS *sptr_mlppp)
{
	UNION_PPP_PACKET *sptr_rxed_packet;
	USHORT number_of_bytes_rxed;
	int link;
	enum TEST packet_received = FALSE;

	for (link = 0; link < sptr_mlppp->NoOfLinks; link++)
	{
		if (ppp_receive(sptr_mlppp->LinkInfo[link].port->port_number, &sptr_rxed_packet, &number_of_bytes_rxed) != FALSE)
		{
			packet_received = TRUE;
			if (process_received_multilink_fragment(sptr_mlppp, link,
								sptr_rxed_packet, number_of_bytes_rxed) == FAIL)
				break;
		}
	}
	return(packet_received);
}

enum TEST process_received_multilink_fragment(MLPPP_PORT_CLASS *sptr_mlppp,
	int link, UNION_PPP_PACKET *sptr_rxed_packet, USHORT number_of_bytes_rxed)
{
/*	LINKED_LIST_SORT_PARAMETERS	sort_param;*/
	MLPPP_RX_DESCRIPTOR	*sptr_current_entry;
	LINKS_CLASS	*sptr_link = &sptr_mlppp->LinkInfo[link];
	ULONG	packet_seq_no;

	if (sptr_rxed_packet->generic.header.protocol_type == MULTILINK_PROTOCOL)
	{
		(*(ULONG *)(&sptr_rxed_packet->multilink_fragment.mlppp_header)) = 
			host_to_net_long((*(ULONG *)(&sptr_rxed_packet->multilink_fragment.mlppp_header)));

		packet_seq_no = sptr_rxed_packet->multilink_fragment.mlppp_header.sequence_number;

/*		This is to take care of sequence number wraparound.
		This may not the best way to do it, but I coudn't find a better way.*/

		if (sptr_link->LastSequenceNumber > packet_seq_no)
		{
			packet_seq_no += MAX_SEQUENCE_NUMBER + 1;
			sptr_mlppp->sequence_number_wrap_around = TRUE;
		}
		sptr_link->LastSequenceNumber = packet_seq_no;
	}

	sptr_current_entry = (MLPPP_RX_DESCRIPTOR	*)get_entry_from_list(&sptr_mlppp->free_rx_list);

	if (sptr_current_entry == NULL)
	{
      printf("Not Enough Buffer....\n");
		mlppp_return_buffer_to_device_driver ((USHORT) (sptr_link->port->port_number + ppp.number_of_lan_ports),sptr_rxed_packet);
		return(FAIL);
	}

	sptr_current_entry->port_number = sptr_link->port->port_number;
	sptr_current_entry->number_of_bytes_rxed = number_of_bytes_rxed;
	sptr_current_entry->sptr_rx_packet = sptr_rxed_packet;

	if (sptr_rxed_packet->generic.header.protocol_type != MULTILINK_PROTOCOL)
	{
		add_entry_to_list (&sptr_mlppp->assembled_rx_list, (LINK *)sptr_current_entry);
		return(PASS);
	}

	sptr_current_entry->header = sptr_rxed_packet->multilink_fragment.mlppp_header;

	sptr_current_entry->sequence_number = packet_seq_no;

#ifdef	_MY_DEBUG_
	sprintf("Rx Pkt Seq No %8lx", packet_seq_no);
#endif

/*	sort_param.index[0].offset = offsetof(MLPPP_RX_DESCRIPTOR, sequence_number);
	sort_param.index[0].size = sizeof(sptr_current_entry->sequence_number);
	sort_param.index[0].swap = FALSE;
	sort_param.index[1].size = 0;
	sort_param.sptr_list = &sptr_mlppp->reassembly_rx_list;
	sort_param.sptr_entry_to_add = (LINK *)sptr_current_entry;
	add_entry_to_sorted_linked_list(&sort_param);*/

	add_fragment_sorted_linked_list(&sptr_mlppp->reassembly_rx_list, sptr_current_entry);

	return(PASS);
}

enum TEST reassemble_packets(MLPPP_PORT_CLASS	*sptr_mlppp)
{
	MLPPP_RX_DESCRIPTOR	*sptr_current_entry;
	ULONG	expected_sequence_number;
	int	number_of_fragments = 0;
	enum TEST begin_found = FALSE;


	calculate_minimum_sequence_number(sptr_mlppp);

	expected_sequence_number = sptr_mlppp->ExpectedSequenceNumber;

	sptr_current_entry = (MLPPP_RX_DESCRIPTOR	*)
					sptr_mlppp->reassembly_rx_list.sptr_forward_link;

	while (sptr_current_entry != NULL)
	{
		if (sptr_current_entry->sequence_number != expected_sequence_number)
		{
			if (expected_sequence_number >= sptr_mlppp->MinimumSequenceNumber)
				return(FAIL);

#ifdef	_MY_DEBUG_
			sprintf("MP: FrLoss ExpSeq %7lx MinSeq %7lx NextSeq %7lx", 
				expected_sequence_number, sptr_mlppp->MinimumSequenceNumber, sptr_current_entry->sequence_number);

#else
#endif

			if (number_of_fragments)
			{
            printf("Discarding Fragments due to illegal SEQ number\n");
				discard_fragments(sptr_mlppp, number_of_fragments);

				expected_sequence_number++;
/*				expected_sequence_number &= MAX_SEQUENCE_NUMBER;*/

				number_of_fragments = 0;
			}
			else
			{
				expected_sequence_number = sptr_current_entry->sequence_number;
			}

			sptr_mlppp->ExpectedSequenceNumber = expected_sequence_number;
			begin_found = FALSE;
			continue;
		}

		if (sptr_current_entry->header.begin)
		{
			begin_found = TRUE;
			if (number_of_fragments)
			{
            printf("Discarding Fragments due to no END \n");
				discard_fragments(sptr_mlppp, number_of_fragments);
				sptr_mlppp->ExpectedSequenceNumber = expected_sequence_number;
				number_of_fragments = 0;
			}
		}

		expected_sequence_number++;
/*		expected_sequence_number &= MAX_SEQUENCE_NUMBER;*/

		number_of_fragments++;

		if (sptr_current_entry->header.end)
		{
			sptr_mlppp->ExpectedSequenceNumber = expected_sequence_number;
			sptr_current_entry = (MLPPP_RX_DESCRIPTOR	*)sptr_current_entry->links.sptr_forward_link;
			if (begin_found == TRUE)
			{
				reassemble_a_packet(sptr_mlppp, number_of_fragments);
				begin_found = FALSE;
			}
			else
			{
            printf("Discarding Fragments due to no BEGIN\n");
				discard_fragments(sptr_mlppp, number_of_fragments);
			}
			number_of_fragments = 0;
			continue;
		}
		sptr_current_entry = (MLPPP_RX_DESCRIPTOR	*)sptr_current_entry->links.sptr_forward_link;
	}
	return(FAIL);
}

void	calculate_minimum_sequence_number(MLPPP_PORT_CLASS	*sptr_mlppp)
{
	int i;
	ULONG	new_min_seq_no;
	new_min_seq_no = sptr_mlppp->LinkInfo[0].LastSequenceNumber;

	for (i = 1; i < sptr_mlppp->NoOfLinks; i++)
		if (new_min_seq_no > sptr_mlppp->LinkInfo[i].LastSequenceNumber)
			new_min_seq_no = sptr_mlppp->LinkInfo[i].LastSequenceNumber;

	sptr_mlppp->MinimumSequenceNumber = new_min_seq_no;
}

void check_if_sequence_number_wrap_around_is_complete(MLPPP_PORT_CLASS	*sptr_mlppp)
{
	int i;
	MLPPP_RX_DESCRIPTOR	*sptr_current_entry;

 	if (sptr_mlppp->ExpectedSequenceNumber <= MAX_SEQUENCE_NUMBER)
		return;

	if (sptr_mlppp->MinimumSequenceNumber <= MAX_SEQUENCE_NUMBER)
		return;

 	sptr_mlppp->ExpectedSequenceNumber &= MAX_SEQUENCE_NUMBER;
	sptr_mlppp->MinimumSequenceNumber &= MAX_SEQUENCE_NUMBER;

	for (i = 0; i < sptr_mlppp->NoOfLinks; i++)
		sptr_mlppp->LinkInfo[i].LastSequenceNumber &= MAX_SEQUENCE_NUMBER;

	sptr_current_entry = (MLPPP_RX_DESCRIPTOR	*)
					sptr_mlppp->reassembly_rx_list.sptr_forward_link;

	while (sptr_current_entry != NULL)
	{
		sptr_current_entry->sequence_number &= MAX_SEQUENCE_NUMBER;
		sptr_current_entry = (MLPPP_RX_DESCRIPTOR	*)sptr_current_entry->links.sptr_forward_link;
	}
	sptr_mlppp->sequence_number_wrap_around = FALSE;
}

void	discard_fragments(MLPPP_PORT_CLASS *sptr_mlppp, int number_of_fragments)
{
	MLPPP_RX_DESCRIPTOR	*sptr_current_entry;

	while (number_of_fragments)
	{
		sptr_current_entry = get_entry_from_list(&sptr_mlppp->reassembly_rx_list);


		mlppp_return_buffer_to_device_driver ((USHORT) (sptr_current_entry->port_number + ppp.number_of_lan_ports),
			sptr_current_entry->sptr_rx_packet);

		add_entry_to_list (&sptr_mlppp->free_rx_list, (LINK *)sptr_current_entry);
		number_of_fragments--;
	}
}

void	reassemble_a_packet(MLPPP_PORT_CLASS *sptr_mlppp, int number_of_fragments)
{
	int i;
	MLPPP_RX_DESCRIPTOR	*sptr_reassemble_entry;
	MLPPP_RX_DESCRIPTOR	*sptr_current_entry;
	int	fragment_data_length;
	BYTE	*sptr_buffer;

	sptr_current_entry = sptr_reassemble_entry = 
				get_entry_from_list(&sptr_mlppp->reassembly_rx_list);
	sptr_buffer = (BYTE *)&sptr_current_entry->sptr_rx_packet->multilink_fragment.header;

	fragment_data_length = sptr_current_entry->number_of_bytes_rxed 
						- sizeof(MLPPP_HEADER) - sizeof(PPP_HEADER);
	memcpy(sptr_buffer, 
		&sptr_current_entry->sptr_rx_packet->multilink_fragment.data, fragment_data_length);

	sptr_buffer += fragment_data_length;
	sptr_reassemble_entry->number_of_bytes_rxed = fragment_data_length;

	for (i = 1; i < number_of_fragments; i++)
	{
		sptr_current_entry = get_entry_from_list(&sptr_mlppp->reassembly_rx_list);
		fragment_data_length = sptr_current_entry->number_of_bytes_rxed 
							- sizeof(MLPPP_HEADER) - sizeof(PPP_HEADER);
		memcpy(sptr_buffer, 
			&sptr_current_entry->sptr_rx_packet->multilink_fragment.data, fragment_data_length);

		sptr_buffer += fragment_data_length;
		sptr_reassemble_entry->number_of_bytes_rxed += fragment_data_length;
		mlppp_return_buffer_to_device_driver ((USHORT) (sptr_current_entry->port_number + ppp.number_of_lan_ports),
			sptr_current_entry->sptr_rx_packet);
		add_entry_to_list (&sptr_mlppp->free_rx_list, (LINK *)sptr_current_entry);
	}

	if (sptr_reassemble_entry->number_of_bytes_rxed >= MIN_PPP_PACKET_LEN)
	{
		add_entry_to_list (&sptr_mlppp->assembled_rx_list, (LINK *)sptr_reassemble_entry);
	}
	else
	{
		mlppp_return_buffer_to_device_driver ((USHORT) (sptr_reassemble_entry->port_number + ppp.number_of_lan_ports),
			sptr_reassemble_entry->sptr_rx_packet);
		add_entry_to_list (&sptr_mlppp->free_rx_list, (LINK *)sptr_reassemble_entry);
	}
}

/*************************************************************************/
void mlppp_return_buffer_to_device_driver (USHORT real_port_number,void *vptr_buffer)
{
	packet_forward_device_driver_free (real_port_number,ppp.port[real_port_number].device_driver_id,
		vptr_buffer);
}

/* Added By Naveen .... */
/* This function checks whether the 'link' is a member of some bundle 
   or not. 
   For each of the bundle we check whether 'multilink_enabled' is 
   TRUE or FALSE. if TRUE then we try to match the 'link' to each of the
   links in the bundle, if there is a match then it means to say that
   'link' is a part of that bundle, if no match continue search in the next
   bundle until all the bundles are searched. 
*/
USHORT is_the_link_member_of_some_bundle(USHORT link)
{
   USHORT port_number, link_number, links, link_port_number;
	MLPPP_PORT_CLASS	*sptr_mlppp ;

   for (port_number = 0 ; port_number < ppp.number_of_ppp_ports ; ++port_number)
   {
		sptr_mlppp = &mlppp.port[port_number];

      /* Is this a Bundle */
      if (sptr_mlppp->multilink_enabled )  
      {
         /* Yes, try to match the links with the current link */
         for (link_number = 0 ; link_number < sptr_mlppp->NoOfLinks ; ++link_number)
         {
      		if (sptr_mlppp->LinkInfo[link_number].port->port_number == link)
		      	return port_number;
         }
      }
/* __Sudha__ 5 August 1998 
Naveen added this for MLPPP-DOD problem to get the bundle number
correctly when the bundle is coming up from down by no demand state as
soon as it is given demand. */

		else
		if (mlppp.dod_enabled_bundle[port_number].link_down_by_demand)
		{
		   for(links = 0 ; links < mlppp.dod_enabled_bundle[port_number].number_of_links ; ++links)
			{
		      link_port_number = mlppp.dod_enabled_bundle[port_number].link_port_number[links];
				if (link_port_number == link)
					return port_number;
			}
			
		}
/* __Sudha__ 05 August 1998 */
   }
   return(NOT_A_MEMBER_OF_ANY_BUNDLE);
}

/* ...Added By Naveen */
#endif

/* __Sudha__ 24 Aug 1998 */
enum BOOLEAN if_mlppp()
{
	if (mlppp.enabled)
		return TRUE;
	else
		return FALSE;
}
/* __Sudha__ 24 Aug 1998 */
