#include	"defs.h"
/*	$Modname: pppatrx.c$  $version: 1.17$      $date: 12/13/94$   */
/*
* 	$lgb$
1.0 03/23/94 keyur Initial Release
1.1 03/23/94 keyur Added support for version control
1.2 04/04/94 keyur Cosmetic Changes while documenting
1.3 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.4 04/13/94 keyur Added support for NCP state machine
1.5 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.6 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.7 05/02/94 keyur took out memcheck header file.
1.8 06/15/94 keyur cosmetic changes.
1.9 06/23/94 ross put nak responses into groups.  Courtesy of John.
1.10 07/18/94 ross general cleanup with options, added header compression, accm features.
1.11 08/11/94 ross adding rfc1570 lcp support
1.12 08/24/94 ross cleanup for release
1.13 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.14 12/02/94 ross testing NT3.5 RAS
1.15 12/03/94 ross testing Windows 95 RAS
1.16 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.17 12/13/94 ross connected to NT RAS with Netbios
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ppp.h"
/****************************************************************************/
static void build_appletalk_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp);
/****************************************************************************/
void initialize_appletalk_ncp (USHORT real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;

#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_APPLETALK_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_APPLETALK_NCP_STACK_INDEX];
#endif

	strcpy (sptr_ncp->name,"AppleTalk Routing");

	sptr_ncp->type = APPLETALK_PROTOCOL_STACK;
	sptr_ncp->ppp_protocol_stack_type = APPLETALK_PROTOCOL;
	sptr_ncp->ncp_protocol_type = ATCP_PROTOCOL;
	sptr_ncp->state = PPP_INITIAL_STATE;
	sptr_ncp->old_state = PPP_INITIAL_STATE;
	sptr_ncp->protocol_stack_id = ILLEGAL_STACK_ID;
	sptr_ncp->real_port_number = real_port_number;

	sptr_ncp->fptr_protocol_stack_up = build_appletalk_ppp_accepted_parameters;

	sptr_ncp->receive.fptr_process_receive_options[APPLETALK_ADDRESS_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class))	ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[APPLETALK_ROUTING_PROTOCOL_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[APPLETALK_SUPPRESS_BROADCAST_OPTION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[APPLETALK_COMPRESSION_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[APPLETALK_SERVER_INFORMATION_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[APPLETALK_ZONE_INFORMATION_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[APPLETALK_DEFAULT_ROUTER_ADDRESS_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[APPLETALK_ADDRESS_OPTION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[APPLETALK_ROUTING_PROTOCOL_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[APPLETALK_SUPPRESS_BROADCAST_OPTION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[APPLETALK_COMPRESSION_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[APPLETALK_SERVER_INFORMATION_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[APPLETALK_ZONE_INFORMATION_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[APPLETALK_DEFAULT_ROUTER_ADDRESS_OPTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	copy_configuration_options_to_tx_accepted_options (&sptr_ncp->option_lists);
}
/****************************************************************************/
static void build_appletalk_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp)
{
	PARAMETER_NOT_USED (virtual_port_number);
	PARAMETER_NOT_USED (sptr_ncp);
}

