/****************************************************************************
File			:	pppdod.c	20/12/95
					Contains routines for Dial-On-Demand 
****************************************************************************/

#include	"defs.h"

#ifdef __DOD__

#include <stdlib.h>
#include <string.h>
#include "ppp.h"
#ifdef EVENT_LOG
#include	<logif.h>
#endif

#include <wanmgr.h>


/* Sachin, 3rd Oct. 1997 */
extern void ppp_port_down_by_no_demand (real_port_number) ;
/* Sachin, 3rd Oct. 1997 */
extern enum BOOLEAN is_remote_access_enabled_on_port (USHORT port_number);
USHORT is_the_link_member_of_some_bundle(USHORT link);


void ppp_link_idle (USHORT real_port_number)
{
   USHORT virtual_port_number, links, link_port_number;

	/* bring down the link cause there is no genuine traffic */

#ifdef __MLPPP__
   virtual_port_number = ppp.port[real_port_number].virtual_port_number; 
/*	virtual_port_number = real_port_number; */
/*	virtual_port_number = is_the_link_member_of_some_bundle(real_port_number);*/
   ppp_printf(PPP_MLPPP_PRINTF, "MLPPP:Bringing DOWN the Bundle %04X with %04X links by NO DEMAND...\n",
			virtual_port_number, mlppp.port[virtual_port_number].NoOfLinks);

   mlppp.dod_enabled_bundle[virtual_port_number].link_down_by_demand = TRUE;
   mlppp.dod_enabled_bundle[virtual_port_number].number_of_links = mlppp.port[virtual_port_number].NoOfLinks;

   for(links = 0 ; links < mlppp.port[virtual_port_number].NoOfLinks ; ++links)
   {
      link_port_number = mlppp.port[virtual_port_number].LinkInfo[links].port->port_number;
/* Introduced by Naveen 30/6/1998 */
/* printf("\n\r PPPDOD Idle : Members of bundle %d is %d",virtual_port_number,link_port_number);*/
		if (is_remote_access_enabled_on_port (link_port_number))
			mlppp.port[link_port_number].expecting_ras_link_coming_up = TRUE;
      mlppp.dod_enabled_bundle[virtual_port_number].link_port_number[links] = link_port_number;
	   ppp.port[link_port_number].connect_state = LINK_GOING_DOWN;
#ifdef EVENT_LOG
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "DOD port %d going down by no demand", link_port_number + 1);
	write_log(log_message);
}
#endif

	   if (ppp.port[link_port_number].serial_driver.fptr_control_routine != NULL)
	   {
		   (*ppp.port[link_port_number].serial_driver.fptr_control_routine) (PORT_DOWN_BY_DEMAND,
			   (ULONG) link_port_number,(ULONG) ppp.port[link_port_number].device_driver_id);
	   }

	   if (ppp.port[link_port_number].serial_driver.fptr_control_routine != NULL)
	   {
		   (*ppp.port[link_port_number].serial_driver.fptr_control_routine) (CLOSE_SERIAL_PORT,
			   (ULONG) link_port_number,(ULONG) ppp.port[link_port_number].device_driver_id);
	   }


	   /* Sachin's advivse for Naveen to add this ... */
   	ppp_port_down_by_no_demand (link_port_number+ppp.number_of_lan_ports) ;
   	/* ... Sachin's advivse for Naveen to add this */
   }
#else

	ppp.port[real_port_number].connect_state = LINK_GOING_DOWN;
#ifdef EVENT_LOG
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "DOD port %d going down by no demand", real_port_number + 1);
	write_log(log_message);
}
#endif


	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (PORT_DOWN_BY_DEMAND,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
	}

	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (CLOSE_SERIAL_PORT,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
	}

	/* Port is going down by no demand . We need inform this to proxy module .
	if Port is configured for dialing that will owned by proxy otherwise
	it will be owned by RAS.
	*/

	if (is_wan_port_answering (real_port_number) == FALSE)
	   ppp_port_down_by_no_demand (real_port_number+ppp.number_of_lan_ports) ;
					


#endif
	
}

void ppp_proxy_link_active (USHORT port_number)
{
	USHORT wan_port_owner,real_port_number;
/* Vidy / Sudha 18 Aug 1998. 
Since Proxy always triggers wan port 1 & port number is always 0, any 
bundle with wan 0 not as the member is not brought up & ppp_link_active
function is not at all called in some special cases of switching off or 
removing phone line in modem 1 connected to wan 1.So if it is mlppp, we 
are triggering all the physical wan ports irrespective of the port number 
passed in this function by proxy. */ 

#if 0
printf("\n\rPort %d Connect state is %d",port_number,	ppp.port[port_number].connect_state);
	if (ppp.port[port_number].connect_state == LINK_GOING_UP)
		return;
#else
	if (mlppp.enabled)
	{
		for (real_port_number = 0; real_port_number < ppp.number_of_ppp_ports; ++real_port_number)
		{
			wan_port_owner = get_wan_port_owner (real_port_number);
			if (wan_port_owner != OWNED_BY_NONE)
			{
				if (ppp.port[real_port_number].disconnect_other_clients == TRUE)
					ppp_hangup_and_redial_wan_port (real_port_number);
			}
			else
			{
				ppp_link_active (real_port_number);
			}
		}
	}
	else
	{
		wan_port_owner = get_wan_port_owner (port_number);
		if (wan_port_owner != OWNED_BY_NONE)
		{
			if (ppp.port[port_number].disconnect_other_clients == TRUE)
				ppp_hangup_and_redial_wan_port (port_number);
		}
		else
		{
			ppp_link_active (port_number);
		}
	}
#endif
}

void ppp_link_active (USHORT real_port_number)
{
   USHORT virtual_port_number, links, link_port_number;
	OPTION_LIST_ENTRY *sptr_option_list_entry;

/* sudha 30 Nov 1998... */

	if ( trigger_port_open[real_port_number] == INITIALLY_NOT_REQUIRED )
	{
		trigger_port_open[real_port_number] = REQUIRED_NOW; 		
		return ;
	}
/* ...sudha 30 Nov 1998 */

	if (ppp.port[real_port_number].connect_state == LINK_GOING_UP)
		return;


/* WE might have replaced Proxy IPCP ip address option in case if ras is 
	enabled. We have to replace this with configured IPCP ip address option
	for proxy */

#ifndef __MLPPP__
	 if (is_remote_access_enabled_on_port (real_port_number) == TRUE)
	 {
  	 	replace_configuration_option (&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
			ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_remote_address_option,
			OPTION_DEFAULT_STATE);
	  	replace_configuration_option (&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured,
			ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_local_address_option,
			OPTION_DEFAULT_STATE);
	}
#else
	
	 if (is_remote_access_enabled_on_port (real_port_number) == TRUE)
	 {
/* printf("1: %08x\n", &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_remote_address_option); */
	  	replace_configuration_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_remote_address_option,
			OPTION_DEFAULT_STATE);

/* printf("2: %08x\n", &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_local_address_option); */
		replace_configuration_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured,
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_local_address_option,
			OPTION_DEFAULT_STATE);

#if 0
		if (mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_dns_pri_server_remote_address_option)
		  	replace_configuration_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_dns_pri_server_remote_address_option,
				OPTION_DEFAULT_STATE);

		if (mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_dns_sec_server_remote_address_option)
		  	replace_configuration_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_dns_sec_server_remote_address_option,
				OPTION_DEFAULT_STATE);
#endif

		sptr_option_list_entry = 
				find_matching_option (&ppp.port[real_port_number].option_lists.configured, LCP_AUTHENTICATION_PROTOCOL); 
		
		if (sptr_option_list_entry)
		{
			delete_entry_from_option_list (&ppp.port[real_port_number].option_lists.configured, 
				sptr_option_list_entry);
		}
		add_new_lcp_option_to_list (&ppp.port[real_port_number].option_lists.remote_configured,
			ppp.port[real_port_number].sptr_proxy_remote_authentication);		

		remove_configuration_option (&ppp.port[real_port_number].option_lists.configured, LCP_AUTHENTICATION_PROTOCOL);
		remove_configuration_option (&ppp.port[real_port_number].option_lists.configured, LCP_AUTHENTICATION_PROTOCOL);

		free_ppp_option_list (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted);
	 	
		reset_ip_ncp_state_machine(real_port_number);
		initialize_ip_ncp_tx_accepted_option_list (real_port_number);

		free_ppp_option_list (&ppp.port[real_port_number].option_lists.tx_accepted);
		copy_configuration_options_to_tx_accepted_options (&ppp.port[real_port_number].option_lists);
	}
#endif

	
	/* bring up the link now that there is some traffic */
#ifdef __MLPPP__  
/* __Sudha__ 5 August 1998 */
	virtual_port_number = is_the_link_member_of_some_bundle(real_port_number);
/* __Sudha__ 5 August 1998 */

	if ( virtual_port_number == NOT_A_MEMBER_OF_ANY_BUNDLE && 
			mlppp.dod_enabled_bundle[real_port_number].link_down_by_demand == FALSE)
	{
		virtual_port_number = real_port_number;

	   if (ppp.port[virtual_port_number].serial_driver.fptr_control_routine != NULL)
	   {
		   (*ppp.port[virtual_port_number].serial_driver.fptr_control_routine) (PORT_DOWN_BY_DEMAND,
			   (ULONG) virtual_port_number,(ULONG) ppp.port[virtual_port_number].device_driver_id);
	   }

		mlppp.dod_enabled_bundle[virtual_port_number].number_of_links = 1;
		mlppp.dod_enabled_bundle[virtual_port_number].link_port_number[0] = virtual_port_number;

	}

   ppp_printf(PPP_MLPPP_PRINTF, "MLPPP: Bringing UP the bundle %04X by DEMAND...\n", virtual_port_number);
   mlppp.dod_enabled_bundle[virtual_port_number].link_down_by_demand = FALSE;

   /* Now it is reqd to bring up all the members of this bundle */
   for(links = 0 ; links < mlppp.dod_enabled_bundle[virtual_port_number].number_of_links ; ++links)
   {
      link_port_number = mlppp.dod_enabled_bundle[virtual_port_number].link_port_number[links];
/* Introduced by Naveen 30/6/1998 */
	 	mlppp.port[link_port_number].expecting_ras_link_coming_up = FALSE;
	   ppp.port[link_port_number].connect_state = LINK_GOING_UP;
#ifdef EVENT_LOG
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "DOD port %d coming up by demand", link_port_number + 1);
	write_log(log_message);
}
#endif

	   if (ppp.port[link_port_number].serial_driver.fptr_control_routine != NULL)
	   {
		   (*ppp.port[link_port_number].serial_driver.fptr_control_routine) (OPEN_SERIAL_PORT,
			   (ULONG) link_port_number,(ULONG) ppp.port[link_port_number].device_driver_id);
	   }
   }
#else


#ifdef EVENT_LOG
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "DOD port %d coming up by demand", real_port_number + 1);
	write_log(log_message);
}
#endif

	ppp.port[real_port_number].connect_state = LINK_GOING_UP;

	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (OPEN_SERIAL_PORT,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
	}
#endif
}


void	reset_ppp_idle_timer (USHORT real_port_number)
{
	ppp.port[real_port_number].idle_timer = ppp.port[real_port_number].idle_timeout;
}	

#endif /*__DOD__*/
