#include	"defs.h"
/*	$Modname: pppiprx.c$  $version: 1.23$      $date: 03/03/95$   */
/*
* 	$lgb$
1.0 03/23/94 keyur Initial Release.
1.1 03/23/94 keyur Added support for version control.
1.2 04/04/94 keyur Cosmetic Changes while documenting
1.3 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.4 04/13/94 keyur Added support for NCP state machine
1.5 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.6 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.7 05/02/94 keyur took out memcheck header file.
1.8 06/15/94 keyur cosmetic changes.
1.9 06/23/94 ross put nak responses into groups.  Courtesy of John.
1.10 07/18/94 ross general cleanup with options, added header compression, accm features.
1.11 08/11/94 ross adding rfc1570 lcp support
1.12 08/24/94 ross adding new ncps.
1.13 08/30/94 ross adding vj support.
1.14 09/06/94 ross added enum size support.
1.15 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.16 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.17 12/02/94 ross testing NT3.5 RAS
1.18 12/03/94 ross testing Windows 95 RAS
1.19 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.20 12/13/94 ross connected to NT RAS with Netbios
1.21 01/30/95 ross removing duplicate configuration options
1.22 02/27/95 ross dynamic load changes including lsl_control.
1.23 03/03/95 ross added up calls.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ppp.h"
/****************************************************************************/
void build_ip_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp);
/****************************************************************************/
void initialize_ip_ncp (USHORT real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;

#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX];
#endif

	strcpy (sptr_ncp->name,"IP Routing");

	sptr_ncp->type = IP_PROTOCOL_STACK;
	sptr_ncp->ppp_protocol_stack_type = IP_PROTOCOL;
	sptr_ncp->ncp_protocol_type = IPCP_PROTOCOL;
	sptr_ncp->state = PPP_INITIAL_STATE;
	sptr_ncp->old_state = PPP_INITIAL_STATE;
	sptr_ncp->protocol_stack_id = ILLEGAL_STACK_ID;
	sptr_ncp->real_port_number = real_port_number;

	/* Srikar, Mar 23, 1997. Added the initialization of the operational status of the IP protocol on this link. */

	sptr_ncp->mib.ipcp.pppIpOperStatus = SNMP_PPP_IP_LINK_NOT_OPENED;
	sptr_ncp->mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
	sptr_ncp->mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
	sptr_ncp->mib.ipcp.pppIpRemoteMaxSlotId = 0;
	sptr_ncp->mib.ipcp.pppIpLocalMaxSlotId = 0;

	/* Initialize the Admin status from the global configuration. */
	if (sptr_ncp->enabled)
		{
		sptr_ncp->mib.ipcp.pppIpConfigAdminStatus = SNMP_PPP_IP_LINK_OPENED;
		}
	else
		{
		sptr_ncp->mib.ipcp.pppIpConfigAdminStatus = SNMP_PPP_IP_LINK_NOT_OPENED;
		}

	/* Initialize the VJ compression to none. It is set for all the ports for */
	/* which it is enabled in ppp_register_vj_compression. */

	sptr_ncp->mib.ipcp.pppIpConfigCompression = SNMP_PPP_IP_COMPRESSION_NONE;

	sptr_ncp->receive.fptr_process_receive_options[IP_ADDRESSES_OPTION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[IP_COMPRESSION_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[IP_ADDRESS_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

/* sudhir 13/2/98 */
	sptr_ncp->receive.fptr_process_receive_options[IP_PRIMARY_DNS_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[IP_SECONDARY_DNS_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
/* sudhir 13/2/98 */


	sptr_ncp->receive_nak.fptr_process_receive_options[IP_ADDRESSES_OPTION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class))	ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[IP_COMPRESSION_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class))	ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[IP_ADDRESS_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class))	ppp_ncp_configure_nak_option_processor;

/* sudhir 13/2/98 */
	sptr_ncp->receive_nak.fptr_process_receive_options[IP_PRIMARY_DNS_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class))	ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[IP_SECONDARY_DNS_OPTION_TYPE] =
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class))	ppp_ncp_configure_nak_option_processor;
/* sudhir 13/2/98 */

	sptr_ncp->fptr_protocol_stack_up = build_ip_ppp_accepted_parameters;

	copy_configuration_options_to_tx_accepted_options (&sptr_ncp->option_lists);
}
/****************************************************************************/

BYTE updated_dns_server_address[MAXIMUM_NUMBER_OF_PPP_PORTS] = {FALSE, FALSE, FALSE};

void build_ip_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp)
{
	OPTION_LIST_ENTRY *sptr_option;
	ULONG primary_address=0x00L, secondary_address = 0x00L;
	
#if 1
	if (updated_dns_server_address[virtual_port_number] == FALSE)
	{
		updated_dns_server_address [virtual_port_number] = TRUE;
		printf ("PPP: Updating DNS Server Address for port %04x\n", virtual_port_number);
		sptr_option = find_matching_option (&sptr_ncp->option_lists.tx_accepted,IP_PRIMARY_DNS_OPTION_TYPE);
		if (sptr_option != NULL)
		{
			primary_address = sptr_option->uptr_data->_ulong;

			replace_data_field_in_option (sptr_ncp->sptr_ras_dns_pri_server_remote_address_option, &primary_address, 4); 
/*			sptr_ncp->sptr_ras_dns_pri_server_remote_address_option->uptr_data->_ulong = primary_address; */

/*			printf ("PPPDNS: Primary server address %08x\n",primary_address);*/
		}	

		sptr_option = find_matching_option (&sptr_ncp->option_lists.tx_accepted,IP_SECONDARY_DNS_OPTION_TYPE);
		if (sptr_option != NULL)
		{
			secondary_address = sptr_option->uptr_data->_ulong;
			replace_data_field_in_option (sptr_ncp->sptr_ras_dns_sec_server_remote_address_option, &secondary_address, 4); 

	/*		sptr_ncp->sptr_ras_dns_sec_server_remote_address_option->uptr_data->_ulong = secondary_address; */

	/*		printf ("PPPDNS: Secondary server address %08x\n",secondary_address);*/
		}	

		if (primary_address || secondary_address)
		{
			lsl_control (PROTOCOL_STACK_PORT,virtual_port_number,sptr_ncp->protocol_stack_id,UPDATE_DNS_SERVER_ADDRESS,
				primary_address, secondary_address);		
		}
	}
/* sudhir */
#endif

	
/*	sptr_option = find_matching_option (&sptr_ncp->option_lists.tx_accepted,IP_ADDRESS_OPTION_TYPE); */
	sptr_option = find_matching_option (&sptr_ncp->option_lists.rx_accepted,IP_ADDRESS_OPTION_TYPE);


	if (sptr_option != NULL)
		{
		lsl_control (PROTOCOL_STACK_PORT,virtual_port_number,sptr_ncp->protocol_stack_id,OPEN_VIRTUAL_PORT,
			sptr_option->uptr_data->_ulong,
         ppp.port[virtual_port_number - ppp.number_of_lan_ports].lcp_mibs.pppLinkStatusRemoteMRU) ;
		}
	else
		{
		lsl_control (PROTOCOL_STACK_PORT,virtual_port_number,sptr_ncp->protocol_stack_id,OPEN_VIRTUAL_PORT,
			(ULONG) NULL,
         ppp.port[virtual_port_number - ppp.number_of_lan_ports].lcp_mibs.pppLinkStatusRemoteMRU) ;
		}
}

/****************************************************************************/
void initialize_ip_ncp_tx_accepted_option_list(USHORT real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;

#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX];
#endif /* __MLPPP___ */

	copy_configuration_options_to_tx_accepted_options (&sptr_ncp->option_lists);
}

void	reset_ip_ncp_state_machine(real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;

#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX];
#endif /* __MLPPP__ */

	sptr_ncp->state = PPP_STARTING_STATE;
	sptr_ncp->old_state = PPP_INITIAL_STATE;

}


ULONG get_local_ip_address (USHORT port_number)
{
	OPTION_LIST_ENTRY *sptr_option;

	if ((port_number >= ppp.number_of_ppp_ports) || (ppp.port[port_number].enabled == FALSE))
		return 0L ;
#ifdef __MLPPP__
	sptr_option = find_matching_option (&mlppp.port[port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted, IP_ADDRESS_OPTION_TYPE);
#else
	sptr_option = find_matching_option (&ppp.port[port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted, IP_ADDRESS_OPTION_TYPE);
#endif
	if (sptr_option == NULL)
		return 0L ;

	return (sptr_option->uptr_data->_ulong) ;
}
