#include	"defs.h"
/*	$Modname: pppipxrx.c$  $version: 1.22$      $date: 03/10/95$   */
/*
* 	$lgb$
1.0 03/23/94 keyur Initial Release.
1.1 03/23/94 keyur Add support for version control.
1.2 04/04/94 keyur Cosmetic Changes while documenting
1.3 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.4 04/13/94 keyur Added support for NCP state machine
1.5 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.6 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.7 05/02/94 keyur took out memcheck header file.
1.8 08/08/94 ross working on adding version 2
1.9 08/11/94 ross adding rfc1570 lcp support
1.10 08/24/94 ross adding new ncps.
1.11 08/31/94 ross adding cipx.
1.12 09/06/94 ross cipx fix.
1.13 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.14 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.15 12/02/94 ross testing NT3.5 RAS
1.16 12/03/94 ross testing Windows 95 RAS
1.17 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.18 12/13/94 ross connected to NT RAS with Netbios
1.19 01/26/95 ross changes for rwutils
1.20 01/30/95 ross removing duplicate configuration options
1.21 02/27/95 ross dynamic load changes including lsl_control.
1.22 03/10/95 ross general fixes.  see change.doc
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ppp.h"
/****************************************************************************/
static void build_ipx_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp);
static void set_ipx_accepted_parameters (PPP_NCP_CLASS *sptr_ncp,BYTE type,void *vptr_parameter,USHORT size_of_parameter);
/****************************************************************************/
void initialize_ipx_ncp (USHORT real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;
#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#endif

	strcpy (sptr_ncp->name,"IPX Routing");

	sptr_ncp->type = IPX_PROTOCOL_STACK;
	sptr_ncp->ppp_protocol_stack_type = IPX_PROTOCOL;
	sptr_ncp->ncp_protocol_type = IPXCP_PROTOCOL;
	sptr_ncp->state = PPP_INITIAL_STATE;
	sptr_ncp->old_state = PPP_INITIAL_STATE;
	sptr_ncp->protocol_stack_id = ILLEGAL_STACK_ID;
	sptr_ncp->real_port_number = real_port_number;

	sptr_ncp->receive.fptr_process_receive_options[IPX_NETWORK_NUMBER] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[IPX_NODE_NUMBER] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[IPX_COMPRESSION_PROTOCOL] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[IPX_ROUTING_PROTOCOL] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[IPX_ROUTER_NAME] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[IPX_CONFIGURATION_COMPLETE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[IPX_NETWORK_NUMBER] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[IPX_NODE_NUMBER] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[IPX_COMPRESSION_PROTOCOL] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[IPX_ROUTING_PROTOCOL] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[IPX_ROUTER_NAME] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[IPX_CONFIGURATION_COMPLETE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->fptr_protocol_stack_up = build_ipx_ppp_accepted_parameters;

	copy_configuration_options_to_tx_accepted_options (&sptr_ncp->option_lists);
}
/****************************************************************************/
static void build_ipx_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp)
{
	IPX_PPP_ACCEPTED_PARAMETERS ipx_parameters;
	OPTION_LIST_ENTRY *sptr_option;

	memset (&ipx_parameters,(int) NULL,sizeof (ipx_parameters));

	set_ipx_accepted_parameters (sptr_ncp,IPX_NETWORK_NUMBER,
		&ipx_parameters.network_number,sizeof (ipx_parameters.network_number));

	set_ipx_accepted_parameters (sptr_ncp,IPX_NODE_NUMBER,&ipx_parameters.network_number,sizeof (ipx_parameters.node_number));

	set_ipx_accepted_parameters (sptr_ncp,IPX_COMPRESSION_PROTOCOL,
		&ipx_parameters.compression_protocol,sizeof (ipx_parameters.compression_protocol));

	set_ipx_accepted_parameters (sptr_ncp,IPX_ROUTING_PROTOCOL,
		&ipx_parameters.routing_protocol,sizeof (ipx_parameters.routing_protocol));

	set_ipx_accepted_parameters (sptr_ncp,IPX_ROUTER_NAME,&ipx_parameters.cptr_router_name,
		sizeof (ipx_parameters.cptr_router_name));

	sptr_option = find_matching_option (&sptr_ncp->option_lists.tx_accepted,IPX_CONFIGURATION_COMPLETE);

	if (sptr_option != NULL)
		{
		ipx_parameters.configuration_complete = TRUE;
		}

	lsl_control (PROTOCOL_STACK_PORT,virtual_port_number,sptr_ncp->protocol_stack_id,OPEN_VIRTUAL_PORT,(ULONG) &ipx_parameters, NULL);
}
/****************************************************************************/
static void set_ipx_accepted_parameters (PPP_NCP_CLASS *sptr_ncp,BYTE type,void *vptr_parameter,USHORT size_of_parameter)
{
	OPTION_LIST_ENTRY *sptr_option;

	sptr_option = find_matching_option (&sptr_ncp->option_lists.tx_accepted,type);

	if (sptr_option != NULL)
		{
		memcpy (vptr_parameter,sptr_option->uptr_data,size_of_parameter);
		}
}

void initialize_ipx_ncp_tx_accepted_option_list(USHORT real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;
#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#endif
	copy_configuration_options_to_tx_accepted_options (&sptr_ncp->option_lists);
}

void	reset_ipx_ncp_state_machine(real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;
#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#endif


	sptr_ncp->state = PPP_STARTING_STATE;
	sptr_ncp->old_state = PPP_INITIAL_STATE;

}


