#include	"defs.h"
/*	$Modname: ppplcptx.c$  $version: 1.35$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 01/05/94 keyur Initial release
1.1 01/05/94 keyur Added version control support.
1.2 01/05/94 keyur Reshuffled all the ppp statistics.
1.3 01/20/94 keyur Added support for sending all the LCP options, depending upon ini file.
1.4 01/28/94 keyur Added support for resetting the link by callig routine.
1.5 02/01/94 keyur This is the PPP from 121093, before Ross' remarks
1.6 02/02/94 keyur Added some more support for LCP two way handshake as per rfc1332.
1.7 02/02/94 keyur Fixed a small problem in the above version for LCP two way handshake.
1.8 02/22/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Th
1.9 03/23/94 keyur Cosmetic Changes.
1.10 03/26/94 keyur Added and tested Asynchronous Support and ATCP for Appletalk Support
1.11 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.12 04/13/94 keyur Added support for NCP state machine
1.13 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.14 05/02/94 keyur
1.15 05/02/94 keyur took out memcheck header file.
1.16 05/02/94 keyur took out memcheck header file.
1.17 06/15/94 keyur cosmetic changes.
1.18 06/23/94 ross added mru check in protocol and code reject.  Courtesy of John.
1.19 06/23/94 ross Changed echo reply to compensate for larget echo requests.  Courtesy of John.
1.20 07/18/94 ross general cleanup with options, added header compression, accm features.
1.21 08/11/94 ross adding rfc1570 lcp support
1.22 08/24/94 ross adding new ncps.
1.23 09/06/94 ross enum sizing bug.  Courtesy of Danny.
1.24 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.25 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.26 12/03/94 ross testing Windows 95 RAS
1.27 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.28 12/13/94 ross connected to NT RAS with Netbios
1.29 01/30/95 ross removing duplicate configuration options
1.30 02/27/95 ross dynamic load changes including lsl_control.
1.31 03/03/95 ross added up calls.
1.32 03/10/95 ross general fixes.  see change.doc
1.33 03/11/95 ross cleanup.
1.34 05/15/95 ross fixed echo reply rx_accept tx_accept list problem.
1.35 10/19/95 biao got rid of Microsoft Visual C++ 2.2 level 4 warnings.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ppp.h"
/****************************************************************************/
static void send_lcp_packet (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT number_of_bytes_to_send,enum PPP_CONTROL_CODE code,BYTE id);
/****************************************************************************/
void send_lcp_configuration_request (USHORT real_port_number)
{
	USHORT number_of_bytes_to_send;
	LCP_CONFIGURE_REQUEST_PACKET *sptr_configuration_request_packet;

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (LCP_HEADER);
	
	number_of_bytes_to_send = 
		(USHORT) (number_of_bytes_to_send + get_size_of_ppp_options (&ppp.port[real_port_number].option_lists.tx_accepted));

	sptr_configuration_request_packet = (LCP_CONFIGURE_REQUEST_PACKET *) ppp_get_a_send_packet (real_port_number,
		number_of_bytes_to_send);

	if (sptr_configuration_request_packet == NULL)
		{
		return;
		}

	store_ppp_options_in_packet (&ppp.port[real_port_number].option_lists.tx_accepted,
		(PPP_OPTION *) &sptr_configuration_request_packet->options);

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	ppp.port[real_port_number].last_id_of_lcp_packet_sent = ppp.port[real_port_number].id_sequence_number;
	ppp.port[real_port_number].length_of_last_txed_lcp_packet = number_of_bytes_to_send;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Configure Request Tx on port: %04x, ID %02x\r\n",real_port_number,
		ppp.port[real_port_number].id_sequence_number);

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_configuration_request_packet,number_of_bytes_to_send,
		CONFIGURE_REQUEST,ppp.port[real_port_number].id_sequence_number);

	/* printf ("PPP :Sent LCP configuration request\n") ; */
}
/****************************************************************************/
static void send_lcp_packet (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,USHORT number_of_bytes_to_send,
	enum PPP_CONTROL_CODE code,BYTE id)
{
	sptr_tx_packet->code = (BYTE_ENUM (PPP_CONTROL_CODE)) code;
	sptr_tx_packet->id = id;
	sptr_tx_packet->length = swap ((USHORT) (number_of_bytes_to_send - sizeof (PPP_HEADER)));

	sptr_tx_packet->header.protocol_type = LCP_PROTOCOL;

	ppp.port[real_port_number].lcp_statistics.number_of_tx_bytes += number_of_bytes_to_send;

	++ppp.port[real_port_number].lcp_statistics.number_of_tx_packets;
	++ppp.port[real_port_number].lcp_statistics.number_of_control_tx_packets[sptr_tx_packet->code];

	if (code == CONFIGURE_REQUEST)
		{
		sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
		sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

		if (memcmp (&ppp.port[real_port_number].last_txed_lcp_configuration_request_packet,sptr_tx_packet,
			number_of_bytes_to_send) == (int) NULL)
			{
			ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number - 1);

			ppp.port[real_port_number].last_id_of_lcp_packet_sent = ppp.port[real_port_number].id_sequence_number;
			}

		memcpy (&ppp.port[real_port_number].last_txed_lcp_configuration_request_packet,sptr_tx_packet,number_of_bytes_to_send);
		}

	send_native_ppp_packet (real_port_number,sptr_tx_packet,number_of_bytes_to_send,ppp_send_completion);
}
/****************************************************************************/
void send_lcp_configuration_ack (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	CONFIGURE_ACK_PACKET *sptr_configuration_ack_packet;

	ppp.port[real_port_number].length_of_last_rxed_lcp_configuration_packet = number_of_bytes_rxed;

	sptr_configuration_ack_packet = (CONFIGURE_ACK_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_rxed);

	if (sptr_configuration_ack_packet == NULL)
		{
		return;
		}

	memcpy (sptr_configuration_ack_packet,sptr_lcp_rx_packet,number_of_bytes_rxed);

	sptr_configuration_ack_packet->code = CONFIGURE_ACK;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Configure Ack Tx on port: %04x\r\n",real_port_number);

	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_configuration_ack_packet,
		number_of_bytes_rxed,ppp_send_completion);
}
/****************************************************************************/
void send_lcp_configuration_nak (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet)
{
	USHORT number_of_bytes_to_send;
	CONFIGURE_NAK_PACKET *sptr_configuration_nak_packet;

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (LCP_HEADER);

	number_of_bytes_to_send = 
		(USHORT) (number_of_bytes_to_send + get_size_of_ppp_options (&ppp.port[real_port_number].option_lists.tx_nak));

	sptr_configuration_nak_packet = (CONFIGURE_NAK_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_to_send);

	if (sptr_configuration_nak_packet == NULL)
		{
		return;
		}

	store_ppp_options_in_packet (&ppp.port[real_port_number].option_lists.tx_nak,
		(PPP_OPTION *) &sptr_configuration_nak_packet->options);

	ppp_printf (PPP_LCP_PRINTF,"PPP:Configure NAK Tx on port: %04x\r\n",real_port_number);

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_configuration_nak_packet,number_of_bytes_to_send,
		CONFIGURE_NAK,sptr_lcp_rx_packet->lcp_header.id);
}
/****************************************************************************/
void send_lcp_configuration_reject (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet)
{
	USHORT number_of_bytes_to_send;
	CONFIGURE_REJECT_PACKET *sptr_configuration_reject_packet;

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (LCP_HEADER);

	number_of_bytes_to_send = 
		(USHORT) (number_of_bytes_to_send + get_size_of_ppp_options (&ppp.port[real_port_number].option_lists.tx_reject));

	sptr_configuration_reject_packet = (CONFIGURE_REJECT_PACKET *) ppp_get_a_send_packet (real_port_number,
		number_of_bytes_to_send);

	if (sptr_configuration_reject_packet == NULL)
		{
		return;
		}

	ppp_printf (PPP_LCP_PRINTF,"PPP:Configure REJECT Tx on port: %04x\r\n",real_port_number);

	store_ppp_options_in_packet (&ppp.port[real_port_number].option_lists.tx_reject,
		(PPP_OPTION *) &sptr_configuration_reject_packet->options);

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_configuration_reject_packet,number_of_bytes_to_send,
		CONFIGURE_REJECT,sptr_lcp_rx_packet->lcp_header.id);
}
/****************************************************************************/
void send_lcp_echo_request (USHORT real_port_number)
{
	ECHO_REQUEST_PACKET *sptr_echo_request_packet;

	sptr_echo_request_packet = &ppp.port[real_port_number].echo_request_packet;

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	sptr_echo_request_packet->code = PPP_ECHO_REQUEST;
	sptr_echo_request_packet->id = ppp.port[real_port_number].id_sequence_number;
	sptr_echo_request_packet->length = swap (sizeof (ECHO_REQUEST_PACKET) - sizeof (PPP_HEADER));

	if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_MAGIC_NUMBER,
		&sptr_echo_request_packet->magic_number,sizeof (sptr_echo_request_packet->magic_number)) == FAIL)
		{
		sptr_echo_request_packet->magic_number = DEFAULT_MAGIC_NUMBER;
		}

	sptr_echo_request_packet->header.protocol_type = LCP_PROTOCOL;

	++ppp.port[real_port_number].number_of_echo_requests;

	ppp.port[real_port_number].last_id_of_lcp_packet_sent = sptr_echo_request_packet->id;

	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_echo_request_packet,
		sizeof (ECHO_REQUEST_PACKET),NULL);
}
/******************************************************************************/
void send_lcp_echo_reply (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	ECHO_REPLY_PACKET *sptr_echo_reply_packet;

	if (number_of_bytes_rxed == sizeof (ECHO_REQUEST_PACKET))
		{
		sptr_echo_reply_packet = &ppp.port[real_port_number].echo_reply_packet;

		sptr_echo_reply_packet->code = PPP_ECHO_REPLY;
		sptr_echo_reply_packet->id = sptr_lcp_rx_packet->lcp_header.id;
		sptr_echo_reply_packet->length = swap (sizeof (ECHO_REPLY_PACKET) - sizeof (PPP_HEADER));

		if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_MAGIC_NUMBER,
			&sptr_echo_reply_packet->magic_number,sizeof (sptr_echo_reply_packet->magic_number)) == FAIL)
			{
			sptr_echo_reply_packet->magic_number = DEFAULT_MAGIC_NUMBER;
			}

		sptr_echo_reply_packet->header.protocol_type = LCP_PROTOCOL;

		send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_echo_reply_packet,sizeof (ECHO_REPLY_PACKET),NULL);
		}
	else
		{
		sptr_echo_reply_packet = (ECHO_REPLY_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_rxed);

		if (sptr_echo_reply_packet == NULL)
			{
			return;
			}

		memcpy (sptr_echo_reply_packet,sptr_lcp_rx_packet,number_of_bytes_rxed);

		if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_MAGIC_NUMBER,
			&sptr_echo_reply_packet->magic_number,sizeof (sptr_echo_reply_packet->magic_number)) == FAIL)
			{
			sptr_echo_reply_packet->magic_number = DEFAULT_MAGIC_NUMBER;
			}

		sptr_echo_reply_packet->header.protocol_type = LCP_PROTOCOL;

		if (number_of_bytes_rxed > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU)
			{
			number_of_bytes_rxed = (USHORT) ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU;
			}

		send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_echo_reply_packet,number_of_bytes_rxed,
			PPP_ECHO_REPLY,sptr_lcp_rx_packet->lcp_header.id);
		}
}
/****************************************************************************/
void send_lcp_termination_request (USHORT real_port_number)
{
	TERMINATE_REQUEST *sptr_termination_request_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Termination Request Tx on port: %04x\r\n",real_port_number);

	sptr_termination_request_packet = (TERMINATE_REQUEST *) ppp_get_a_send_packet (real_port_number,sizeof (TERMINATE_REQUEST));

	if (sptr_termination_request_packet == NULL)
		{
		return;
		}

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	++ppp.port[real_port_number].number_of_lcp_termination_requests;

	ppp.port[real_port_number].last_id_of_lcp_packet_sent = ppp.port[real_port_number].id_sequence_number;

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_LCP_TERMINATION_REQUEST,real_port_number);
		}

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_termination_request_packet,sizeof (TERMINATE_REQUEST),
		TERMINATION_REQUEST,ppp.port[real_port_number].id_sequence_number);
}
/******************************************************************************/
void send_lcp_termination_ack (USHORT real_port_number, LCP_PACKET *sptr_lcp_rx_packet)
{
	TERMINATE_ACK *sptr_termination_ack_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Termination ACK Tx on port: %04x\r\n",real_port_number);

	sptr_termination_ack_packet = (TERMINATE_ACK *) ppp_get_a_send_packet (real_port_number,sizeof (TERMINATE_ACK));

	if (sptr_termination_ack_packet == NULL)
		{
		return;
		}

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_termination_ack_packet,sizeof (TERMINATE_ACK),
		TERMINATION_ACK,sptr_lcp_rx_packet->lcp_header.id);
}
/*************************************************************************************************/
void send_lcp_protocol_reject (USHORT real_port_number, LCP_PACKET *sptr_bad_rx_protocol_packet,USHORT number_of_bytes_rxed)
{
	PROTOCOL_REJECT_PACKET *sptr_protocol_reject_packet;
	USHORT number_of_bytes_in_tx_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Protocol Reject Tx on port: %04x\r\n",real_port_number);

	number_of_bytes_in_tx_packet = (USHORT) (sizeof (PPP_HEADER) + sizeof (LCP_HEADER) + sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)) +
		number_of_bytes_rxed);

	sptr_protocol_reject_packet = (PROTOCOL_REJECT_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_in_tx_packet);

	if (sptr_protocol_reject_packet == NULL)
		{
		return;
		}

	sptr_protocol_reject_packet->rejected_protocol_and_information.protocol =
		sptr_bad_rx_protocol_packet->ppp_header.protocol_type;

	memcpy (sptr_protocol_reject_packet->rejected_protocol_and_information.information,
		sptr_bad_rx_protocol_packet,number_of_bytes_rxed);

	if (number_of_bytes_in_tx_packet > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU)
		{
		number_of_bytes_in_tx_packet = (USHORT) ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU;
		}

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_protocol_reject_packet,number_of_bytes_in_tx_packet,
		PROTOCOL_REJECT,ppp.port[real_port_number].id_sequence_number);
}
/*************************************************************************************************/
void send_lcp_code_reject (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	CODE_REJECT_PACKET *sptr_code_reject_packet;
	USHORT number_of_bytes_in_tx_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Code Reject Tx on port: %04x\r\n",real_port_number);

	number_of_bytes_in_tx_packet = (USHORT) (sizeof (PPP_HEADER) + sizeof (LCP_HEADER) + number_of_bytes_rxed);

	sptr_code_reject_packet = (CODE_REJECT_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_in_tx_packet);

	if (sptr_code_reject_packet == NULL)
		{
		return;
		}

	memcpy (&sptr_code_reject_packet->rejected_packet,sptr_lcp_rx_packet,number_of_bytes_rxed);

	if (number_of_bytes_in_tx_packet > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU)
		{
		number_of_bytes_in_tx_packet = (USHORT) ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU;
		}

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_code_reject_packet,number_of_bytes_in_tx_packet,
		CODE_REJECT,sptr_lcp_rx_packet->lcp_header.id);
}
/****************************************************************************/
void send_lcp_discard_request (USHORT real_port_number)
{
	DISCARD_REQUEST_PACKET *sptr_discard_request_packet;

	sptr_discard_request_packet = (DISCARD_REQUEST_PACKET *) ppp_get_a_send_packet (real_port_number,
		sizeof (DISCARD_REQUEST_PACKET));

	if (sptr_discard_request_packet == NULL)
		{
		return;
		}

	if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_MAGIC_NUMBER,
		&sptr_discard_request_packet->magic_number,sizeof (sptr_discard_request_packet->magic_number)) == FAIL)
		{
		sptr_discard_request_packet->magic_number = DEFAULT_MAGIC_NUMBER;
		}

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_discard_request_packet,sizeof (DISCARD_REQUEST_PACKET),
		DISCARD_REQUEST,ppp.port[real_port_number].id_sequence_number);
}
/*************************************************************************************************/
void send_lcp_link_quality_report (USHORT real_port_number)
{
	LINK_QUALITY_REPORT *sptr_link_quality_report_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Link Quality Tx on port: %04x\r\n",real_port_number);

	sptr_link_quality_report_packet = ppp_get_a_send_packet (real_port_number,sizeof (LINK_QUALITY_REPORT));
	
	if (sptr_link_quality_report_packet == NULL)
		{
		return;
		}

	if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_MAGIC_NUMBER,
		&sptr_link_quality_report_packet->magic_number,sizeof (sptr_link_quality_report_packet->magic_number)) == FAIL)
		{
		sptr_link_quality_report_packet->magic_number = DEFAULT_MAGIC_NUMBER;
		}

	sptr_link_quality_report_packet->LastOutLQRs = ppp.port[real_port_number].most_recently_received_LQR.PeerOutLQRs;
	sptr_link_quality_report_packet->LastOutPackets = ppp.port[real_port_number].most_recently_received_LQR.PeerOutPackets;
	sptr_link_quality_report_packet->LastOutOctets = ppp.port[real_port_number].most_recently_received_LQR.PeerOutOctets;
	sptr_link_quality_report_packet->PeerInLQRs = ppp.port[real_port_number].most_recently_received_LQR.SaveInLQRs;
	sptr_link_quality_report_packet->PeerInPackets = ppp.port[real_port_number].most_recently_received_LQR.SaveInPackets;
	sptr_link_quality_report_packet->PeerInDiscards = ppp.port[real_port_number].most_recently_received_LQR.SaveInDiscards;
	sptr_link_quality_report_packet->PeerInErrors = ppp.port[real_port_number].most_recently_received_LQR.SaveInErrors;
	sptr_link_quality_report_packet->PeerInOctets = ppp.port[real_port_number].most_recently_received_LQR.SaveInOctets;
	sptr_link_quality_report_packet->PeerOutLQRs = ppp.port[real_port_number].link_quality_counters.OutLQRs;
	sptr_link_quality_report_packet->PeerOutPackets = ppp.port[real_port_number].link_quality_counters.ifOutUniPackets;
	sptr_link_quality_report_packet->PeerOutOctets = ppp.port[real_port_number].link_quality_counters.ifOutOctets;

	++ppp.port[real_port_number].link_quality_counters.OutLQRs;
	++ppp.port[real_port_number].lcp_mibs.pppLqrOutLQRs;

	ppp.port[real_port_number].time_to_send_LQR = 0x00000000L;

	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_link_quality_report_packet,sizeof (LINK_QUALITY_REPORT),
		ppp_send_completion);
}
/****************************************************************************/
void send_lcp_id_packet (USHORT real_port_number)
{
	USHORT number_of_bytes_to_send;
	IDENTIFICATION_PACKET *sptr_id_packet;
	ULONG magic_number;
	BYTE length_of_string;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Send ID on port: %04x\r\n",real_port_number);

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (LCP_HEADER);
	
	length_of_string = (BYTE) strlen (ppp.port[real_port_number].configuration.tx_identification_message);

	number_of_bytes_to_send = (USHORT) (number_of_bytes_to_send + length_of_string);

	/* if (copy_option (&ppp.port[real_port_number].option_lists.configured,LCP_MAGIC_NUMBER, */

	/* LCP has been negotiated, so tx_accepted list has the final values */
	if (ppp.port[real_port_number].state == PPP_ACK_RECEIVED_STATE ||
			ppp.port[real_port_number].state == PPP_OPENED_STATE)
	{
		if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_MAGIC_NUMBER,
			&magic_number,sizeof (sptr_id_packet->magic_number)) == FAIL)
			{
			magic_number = DEFAULT_MAGIC_NUMBER;
			}
	}
	else
		magic_number = DEFAULT_MAGIC_NUMBER;

	number_of_bytes_to_send +=	(BYTE) sizeof (sptr_id_packet->magic_number);

	sptr_id_packet = (IDENTIFICATION_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_to_send);

	if (sptr_id_packet == NULL)
		{
		return;
		}

	sptr_id_packet->magic_number = magic_number;

	memcpy (&sptr_id_packet->message[0],ppp.port[real_port_number].configuration.tx_identification_message,length_of_string);

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_LCP_ID_REQUEST,real_port_number,&sptr_id_packet->message[0]);
		}

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_id_packet,number_of_bytes_to_send,IDENTIFICATION,
		ppp.port[real_port_number].id_sequence_number);
}
/****************************************************************************/
void send_lcp_time_remaining_packet (USHORT real_port_number)
{
	USHORT number_of_bytes_to_send;
	TIME_REMAINING_PACKET *sptr_time_remaining_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Send ID on port: %04x\r\n",real_port_number);

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (LCP_HEADER);
	
	number_of_bytes_to_send = (USHORT) (number_of_bytes_to_send + ppp.port[real_port_number].configuration.size_of_tx_message);

	sptr_time_remaining_packet = (TIME_REMAINING_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_to_send);

	if (sptr_time_remaining_packet == NULL)
		{
		return;
		}

	if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_MAGIC_NUMBER,
		&sptr_time_remaining_packet->magic_number,sizeof (sptr_time_remaining_packet->magic_number)) == FAIL)
		{
		sptr_time_remaining_packet->magic_number = DEFAULT_MAGIC_NUMBER;
		}

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_LCP_TIME_REMAINING_REQUEST,real_port_number,
			&sptr_time_remaining_packet->seconds_remaining);
		}

	send_lcp_packet (real_port_number,(PPP_PACKET *) sptr_time_remaining_packet,number_of_bytes_to_send,TIME_REMAINING,
		ppp.port[real_port_number].id_sequence_number);
}

